<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/
defined('SHOW_DEBUG_BACKTRACE') OR define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
defined('FILE_READ_MODE')  OR define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') OR define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE')   OR define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE')  OR define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/
defined('FOPEN_READ')                           OR define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE')                     OR define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE')       OR define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE')  OR define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE')                   OR define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE')              OR define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT')            OR define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT')       OR define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
defined('EXIT_SUCCESS')        OR define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          OR define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         OR define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   OR define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  OR define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') OR define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     OR define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       OR define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      OR define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      OR define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code


/* application Setting */

// define('URL','http://localhost/Reports/');
define('URL','https://gspos.in/NMH/');
define('IMG',URL.'public/');
define('CSS',URL.'public/');
define('JS',URL.'public/');

define('sms_authorize_test_numbers', '8123726659,9986015156');

define('CopyRights', 'Copyright@2021-22 Gravitysoft. All rights reserved.');
define('DevelopedBy', 'Developed: Gravitysoft');
// define('lonoMin', 'TM');
// define('lonoLarge', 'TaazaMithai');

define('master_url','https://gspos.in/TestSalesMaster/');

define ("Library_script_files", serialize (array ("js/jquery-3.2.1.min.js","js/angular.min.js","custom/js/jquery.chained.js","js/global.js", "js/popper.min.js","vendor/bootstrap-4.1.3/js/bootstrap.min.js", "vendor/cookie/jquery.cookie.js", "vendor/sparklines/jquery.sparkline.min.js", "vendor/circle-progress/circle-progress.min.js", "vendor/swiper/js/swiper.min.js", "vendor/chartjs/Chart.bundle.min.js", "vendor/chartjs/utils.js", "vendor/footable-bootstrap/js/footable.min.js", "vendor/dropzone-master/dropzone.js", "js/main.js", "js/jquery.dataTables.min.js", "js/dataTables.bootstrap4.min.js", "js/dataTables.buttons.min.js", "js/buttons.bootstrap4.min.js", "js/data-table.js", "js/jszip.min.js", "js/pdfmake.min.js", "js/vfs_fonts.js", "js/buttons.html5.min.js", "js/buttons.print.min.js", "js/buttons.colVis.min.js", "js/dataTables.rowGroup.min.js","vendor/dropzone-master/dropzone.js","js/jquery-ui.js","custom/js/custom-form-validation.js","custom/js/jquery.validate.min.js","js/moment.min.js","js/bootstrap-datetimepicker.min.js","js/bootstraptoggle.js","js/responsive_print.js")));  

//print_r($Library_script_files);

define ("Library_style_files", serialize (array ("vendor/materializeicon/material-icons.css", "vendor/swiper/css/swiper.min.css", "vendor/footable-bootstrap/css/footable.bootstrap.min.css", "vendor/bootstrap_tour/css/bootstrap-tour-standalone.css", "vendor/jquery-jvectormap/jquery-jvectormap-2.0.3.css", "css/purplesidebar.css", "css/dataTables.bootstrap4.css", "css/buttons.bootstrap4.css", "css/jquery-ui.css","css/bootstrap-datetimepicker.min.css","css/global.css","css/bootstraptoggle.css","css/w3.css"))); 