<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Client_Master_section extends CI_Controller 
{
	var $library_script;
	var $library_style;

	public function __construct()
	{
		parent::__construct();
		$this->load->model('master_model');
		$this->load->model('role_model');
		$this->load->model('user_model');
		$this->load->helper(array('form', 'url')); 
        //Only works in client db is connected 		
		$this->db = $this->load->database('client', TRUE);
	}
	
// Summary Details - clients 
    public function get_summary_details($current_date)
	{
	    $bills= array();
	    $query=$this->db->query("SELECT branch_slno,branch_synch as branch FROM outlet_deatils WHERE status='Active'");
		foreach ($query->result_array() as $brans) 
		{
			$branch_code = $brans['branch_slno'];
			$branches = $brans['branch'];
			
			$table1 = 'product_billdetail'.$branch_code;
			$table2 = 'billed_product'.$branch_code;
			$table3 = 'payments_details'.$branch_code;
			
			$query10 = $this->db->query("SELECT max(in_no) as counter_invoice FROM $table1 WHERE bno='0' and invoice_date >='2024-04-01'");
            $rows10 = $query10->row();
            if (isset($rows10))
            {
                $counter = $rows10->counter_invoice;
        	    $query1 = $this->db->query("SELECT bill_id, in_no,invoice_no,invoice_date,invoice_time,synch_date,synch_time,branch FROM $table1 WHERE in_no ='$counter'");
                $rows = $query1->row();
                if (isset($rows))
                {
    		        $bills[] = array(
    		            'bill_id' =>$rows->bill_id,
    		            'in_no' =>$rows->in_no,
    		            'invoice_no' =>$rows->invoice_no,
    		            'invoice_date' =>$rows->invoice_date,
    		            'invoice_time' =>$rows->invoice_time,
    		            'synch_date' =>$rows->synch_date,
    		            'synch_time' =>$rows->synch_time,
    		            'branch' =>$rows->branch
    		        );  
    		    }
            }
		}
        $data = array(
            'bills' =>$bills
        );
    	echo json_encode($data);
	}
	
	
	//Complete Configration 
	
	public function insertConfigData()
	{
	     header('Content-type: application/json');
         $row = json_decode(file_get_contents('php://input'),true);
        //$clientid = $decoded['clientid'];
        
        $s1 = $row['Roles'];
        if($s1 != null)
        {
            foreach ($s1 as $r1) 
            {
                $roles[] = array(
    			        'roleId' => $r1['roleId'],
    			        'role' => $r1['role']
    			    ); 
            }
            $resp1 = $this->db->insert_batch('roles',$roles);
        }
        else
        {
            $resp1 = 'Null Values from the Source';
        }
        
        $s2 = $row['Taxes'];
        if($s2 != null)
        {
            foreach ($s2 as $r2) 
            {
                $taxes[] = array(
    			        'taxId' => $r2['taxId'],
    			        'tax_percentage' => $r2['tax_percentage'],
    			        'status' => $r2['status']
    			    );
            }
            $resp2 = $this->db->insert_batch('tax_creation',$taxes);
        }
        else
        {
            $resp2 = 'Null Values from the Source';
        }
        
        $s3 = $row['Uoms'];
        if($s3 != null)
        {
            foreach ($s3 as $r3) 
            {
                $uoms[] = array(
    			        'uomId' => $r3['uomId'],
    			        'uom_name' => $r3['uom_name'],
    			        'description' => $r3['description'],
    			        'status' => $r3['status']
    			    );
            }
            $resp3 = $this->db->insert_batch('uom_creation',$uoms);
        }
        else
        {
            $resp3 = 'Null Values from the Source';
        }
        
        $s4 = $row['Masters'];
        if($s4 != null)
        {
            foreach ($s4 as $r4) 
            {
                $masters[] = array(
    			        'master_id' => $r4['master_id'],
    			        'master_type' => $r4['master_type'],
    			        'master_details' => $r4['master_details'],
    			    );
            }
            $resp4 = $this->db->insert_batch('master',$masters);
        }
        else
        {
            $resp4 = 'Null Values from the Source';
        }
        
        $s5 = $row['ModuleGroups'];
        if($s5 != null)
        {
            foreach ($s5 as $r5) 
            {
                $modulegroups[] = array(
    			        'module_group_id' => $r5['module_group_id'],
    			        'module_group_name' => $r5['module_group_name'],
    			        'sort_id' => $r5['sort_id'],
    			        'icon' => $r5['icon']
    			    ); 
            }
            $resp5 = $this->db->insert_batch('module_groups',$modulegroups);
        }
        else
        {
            $resp5 = 'Null Values from the Source';
        }
        
        $s6 = $row['Modules'];
        if($s6 != null)
        {
            foreach ($s6 as $r6) 
            {
                $modules[] = array(
    			        'module_master_id' => $r6['module_master_id'],
    			        'module_name' => $r6['module_name'],
    			        'module_group_id' => $r6['module_group_id'],
    			        'sections' => $r6['sections'],
    			        'link' => $r6['link'],
    			        'icon' => $r6['icon']
    			    );
            }
            $resp6 = $this->db->insert_batch('modules',$modules);
        }
        else
        {
            $resp6 = 'Null Values from the Source';
        }
        
        
        $s7 = $row['Permissions'];
        if($s7 != null)
        {
            foreach ($s7 as $r7) 
            {
                $permissions[] = array(
    			        'permission_master_id' => $r7['permission_master_id'],
    			        'permission_name' => $r7['permission_name'],
    			        'icon' => $r7['icon']
    			    ); 
            }
            $resp7 = $this->db->insert_batch('permission',$permissions);
        }
        else
        {
            $resp7 = 'Null Values from the Source';
        }


        $s71 = $row['MessageType'];
        if($s71 != null)
        {
            foreach ($s71 as $r71) 
            {
                $messagetype[] = array(
    			        'message_type_id' => $r71['message_type_id'],
    			        'message_type' => $r71['message_type'],
    			        'status' => $r71['status']
    			    ); 
            }
            $resp71 = $this->db->insert_batch('message_type',$messagetype);
        }
        else
        {
            $resp71 = 'Null Values from the Source';
        }
        
        
        $s8 = $row['Settings'];
        if($s8 != null)
        {
            foreach ($s8 as $r8) 
            {
                $settings[] = array(
    			        'setting_id' => $r8['setting_id'],
    			        'setting_name' => $r8['setting_name'],
    			        'setting_type' => $r8['setting_type'],
    			        'setting_title' => $r8['setting_title']
    			    ); 
            }
            $resp8 = $this->db->insert_batch('setting',$settings);
        }
        else
        {
            $resp8 = 'Null Values from the Source';
        }
        
        
        $s9 = $row['Client'];
        if($s9 != null)
        {
            foreach ($s9 as $r9) 
            {
                $client[] = array(
    			        'client_id' => $r9['client_id'],
    			        'client_name' => $r9['client_name'],
    			        'role' => $r9['role'],
    			        'no_of_branches' => $r9['no_of_branches'],
    			        'branch_prefix' => $r9['branch_prefix'],
    			        'status' => $r9['status'],
    			        'client_url' => $r9['client_url'],
    			    ); 
            }
            $resp9 = $this->db->insert_batch('client_creation',$client);
        }
        else
        {
            $resp9 = 'Null Values from the Source';
        }
        
        $s10 = $row['Branches'];
        if($s10 != null)
        {
            foreach ($s10 as $r10) 
            {
                $branches[] = array(
    			        'branch_id' => $r10['branch_id'],
    			        'client_id' => $r10['client_id'],
    			        'branch_name' => $r10['branch_name'],
    			        'branch_title' => $r10['branch_title'],
    			        'branch_slno' => $r10['branch_slno'],
    			        'status' => $r10['status'],
    			        'social_order_percentage' =>$r10['social_order_percentage'],
    			    );
            }
            $resp10 = $this->db->insert_batch('branch_creation',$branches);
        }
        else
        {
            $resp10 = 'Null Values from the Source';
        }
        
        
        $s11 = $row['Users'];
        if($s11 != null)
        {
            foreach ($s11 as $r11) 
            {
                $users[] = array(
    			        'userId' => $r11['userId'],
    			        'email' => $r11['email'],
    			        'password' => $r11['password'],
    			        'name' => $r11['name'],
    			        'mobile' => $r11['mobile'],
    			        'roleId' => $r11['roleId'],
    			        'isDeleted' => $r11['isDeleted'],
    			        'createdBy' => $r11['createdBy'],
    			        'createdDtm' => $r11['createdDtm'],
    			        'updatedBy' => $r11['updatedBy'],
    			        'updatedDtm' => $r11['updatedDtm'],
    			        'branch' => $r11['branch'],
    			        'branch_id' => $r11['branch_id'],
    			        'santhe_branch' => $r11['santhe_branch'],
    			        'prime_id' => $r11['prime_id'],
    			        'effective_from' => $r11['effective_from'],
    			        'data_transfer' => $r11['data_transfer'],
    			        'status' => $r11['status'],
    			        'client_id' => $r11['client_id'],
    			    ); 
            }
            $resp11 = $this->db->insert_batch('users',$users);
        }
        else
        {
            $resp11 = 'Null Values from the Source';
        }
 		
 		
 		$s12 = $row['ModuleCreation'];
 		if($s12 != null)
 		{
            foreach ($s12 as $r12) 
            {
                $modulecreation[] = array(
    			        'module_id' => $r12['module_id'],
    			        'module_master_id' => $r12['module_master_id'],
    			        'role_id' => $r12['role_id'],
    			        'status' => $r12['status'],
    			        'branch' => $r12['branch'],
    			        'client_id' => $r12['client_id'],
    			    ); 
            }
            $resp12 = $this->db->insert_batch('module_creation',$modulecreation);
 		}
        else
        {
            $resp12 = 'Null Values from the Source';
        }
        
        
        $s13 = $row['PermissionCreation'];
        if($s13 != null)
        {
            foreach ($s13 as $r13) 
            {
                $permissioncreation[] = array(
    			        'permission_id' => $r13['permission_id'],
    			        'permission_master_id' => $r13['permission_master_id'],
    			        'module_creation_id' => $r13['module_creation_id'],
    			        'role_id' => $r13['role_id'],
    			        'status' => $r13['status'],
    			        'branch' => $r13['branch'],
    			        'client_id' => $r13['client_id'],
    			    ); 
            }
            $resp13 = $this->db->insert_batch('permission_creation',$permissioncreation);
        }
        else
        {
            $resp13 = 'Null Values from the Source';
        }
        
        
        $s14 = $row['MastersCreation'];
        if($s14 != null)
        {
            foreach ($s14 as $r14) 
            {
                $masterscreation[] = array(
    			        'masterId' => $r14['masterId'],
    			        'masters_status' => $r14['masters_status'],
    			        'master_details' => $r14['master_details'],
    			        'effective_from' => $r14['effective_from'],
    			        'data_transfer' => $r14['data_transfer'],
    			        'status' => $r14['status'],
    			        'branch' => $r14['branch'],
    			        'client_id' => $r14['client_id'],
    			        'master_id' => $r14['master_id'],
    			        'master_image_path' => $r14['master_image_path']
    			    ); 
            }
            $resp14 = $this->db->insert_batch('masters_creation',$masterscreation);
        }
        else
        {
            $resp14 = 'Null Values from the Source';
        }
        
        
        $s15 = $row['CategoryMaster'];
        if($s15 != null)
        {
            foreach ($s15 as $r15) 
            {
                $categorymaster[] = array(
    			        'category_master_id' => $r15['category_master_id'],
    			        'category_name' => $r15['category_name'],
    			        'client_id' => $r15['client_id']
    			    ); 
            }
            $resp15 = $this->db->insert_batch('category_master',$categorymaster);
        }
        else
        {
            $resp15 = 'Null Values from the Source';
        }
        
        $s16 = $row['ProductCategory'];
        if($s16 != null)
        {
            foreach ($s16 as $r16) 
            {
                $productcategory[] = array(
    			        'pr_cat_id' => $r16['pr_cat_id'],
    			        'pr_cat_name' => $r16['pr_cat_name'],
    			        'discount' => $r16['discount'],
    			        'cr_discount' => $r16['cr_discount'],
    			        'status' => $r16['status'],
    			        'effective_from' => $r16['effective_from'],
    			        'data_transfer' => $r16['data_transfer'],
    			        'branch' => $r16['branch'],
    			        'branch_id' => $r16['branch_id'],
    			        'pr_cat_code' => $r16['pr_cat_code'],
    			        'combination' => $r16['combination'],
    			        'combo_qty_limit' => $r16['combo_qty_limit'],
    			        'client_id' => $r16['client_id'],
    			        'social_order' => $r16['social_order'],
    			        'catalouge_reference' => $r16['catalouge_reference'],
    			        'catalouge_status' => $r16['catalouge_status'],
    			        'cat_ref' => $r16['cat_ref'],
    			    );
            }
            $resp16 = $this->db->insert_batch('product_category',$productcategory);
        }
        else
        {
            $resp16 = 'Null Values from the Source';
        }
        
        $s17 = $row['Products'];
        if($s17 != null)
        {
            foreach ($s17 as $r17) 
            {
                $products[] = array(
    			        'pr_id' => $r17['pr_id'],
    			        'product_name' => $r17['product_name'],
    			        'hsn_code' => $r17['hsn_code'],
    			        'product_no' => $r17['product_no'],
    			        'product_code' => $r17['product_code'],
    			        'sorting_order' => $r17['sorting_order'],
    			        'uom' => $r17['uom'],
    			        'basic_rate' => $r17['basic_rate'],
    			        'basic_tax_percent' => $r17['basic_tax_percent'],
    			        'basic_tax_amount' => $r17['basic_tax_amount'],
    			        'sgst_tax' => $r17['sgst_tax'],
    			        'sgst_tax_amount' => $r17['sgst_tax_amount'],
    			        'cgst_tax' => $r17['cgst_tax'],
    			        'cgst_tax_amount' => $r17['cgst_tax_amount'],
    			        'price' => $r17['price'],
    			        'discount_perc' => $r17['discount_perc'],
    			        'product_stock' => $r17['product_stock'],
    			        'product_status' => $r17['product_status'],
    			        'pr_cat_id' => $r17['pr_cat_id'],
    			        'effective_from' => $r17['effective_from'],
    			        'branch' => $r17['branch'],
    			        'branch_id' => $r17['branch_id'],
    			        'data_transfer' => $r17['data_transfer'],
    			        'token' => $r17['token'],
    			        'tokengroup' => $r17['tokengroup'],
    			        'social_order' => $r17['social_order'],
    			        'sales_item_type' => $r17['sales_item_type'],
    			        'combination' => $r17['combination'],
    			        'product_type' => $r17['product_type'],
    			        'qty_sales_type' => $r17['qty_sales_type'],
    			        'stock_status' => $r17['stock_status'],
    			        'stock_limit' => $r17['stock_limit'],
    			        'catalouge_refrence' => $r17['catalouge_refrence'],
    			        'catalogue_status' => $r17['catalogue_status'],
    			        'item_reference_id' => $r17['item_reference_id'],
    			        'item_action_status' => $r17['item_action_status'],
    			        'product_image' => $r17['product_image'],
    			        'client_id' => $r17['client_id'],
    			        'cat_id' => $r17['cat_id'],
    			        'product_image_path' => $r17['product_image_path'],
    			        'location_ref_id' => $r17['location_ref_id'],
                        'newyear_sale' => $r17['newyear_sale'],
                        'fd_status' => $r17['fd_status'],
                        'barcode_number' => $r17['barcode_number'],
    			    );
            }
            $resp17 = $this->db->insert_batch('product',$products);
        }
        else
        {
            $resp17 = 'Null Values from the Source';
        }
    
        
        $s18 = $row['ApplicationSetting'];
        if($s18 != null)
        {
            foreach ($s18 as $r18) 
            {
                $applicationsetting[] = array(
    			        'app_setting_id' => $r18['app_setting_id'],
    			        'setting_name' => $r18['setting_name'],
    			        'setting_access' => $r18['setting_access'],
    			        'setting_type' => $r18['setting_type'],
    			        'setting_title' => $r18['setting_title'],
    			        'status' => $r18['status'],
    			        'effective_from' => $r18['effective_from'],
    			        'data_transfer' => $r18['data_transfer'],
    			        'branch' => $r18['branch'],
    			        'client_id' => $r18['client_id'],
    			        'setting_id' => $r18['setting_id']
    			    );
            }
            $resp18 = $this->db->insert_batch('application_setting',$applicationsetting);
        }
        else
        {
            $resp18 = 'Null Values from the Source';
        }
        
        $s19 = $row['CreditCustomer'];
        if($s19 != null)
        {
            foreach ($s19 as $r19) 
            {
                $creditcustomer[] = array(
    			        'cust_id' => $r19['cust_id'],
    			        'cust_name' => $r19['cust_name'],
    			        'phone_number' => $r19['phone_number'],
    			        'gst_no' => $r19['gst_no'],
    			        'cust_address' => $r19['cust_address'],
    			        'status' => $r19['status'],
    			        'effective_from' => $r19['effective_from'],
    			        'branch' => $r19['branch'],
    			        'data_transfer' => $r19['data_transfer'],
    			        'client_id' => $r19['client_id'],
    			    );
            }
            $resp19 = $this->db->insert_batch('credit_customer',$creditcustomer);
        }
        else
        {
            $resp19 = 'Null Values from the Source';
        }
        
        
        $s20 = $row['OutletDeatils'];
        if($s20 != null)
        {
            foreach ($s20 as $r20) 
            {
                $outletdeatils[] = array(
    			        'outId' => $r20['outId'],
    			        'branch_title' => $r20['branch_title'],
    			        'branch_slno' => $r20['branch_slno'],
    			        'invoice_prefix' => $r20['invoice_prefix'],
    			        'org_name' => $r20['org_name'],
    			        'land_no' => $r20['land_no'],
    			        'mobile' => $r20['mobile'],
    			        'email_id' => $r20['email_id'],
    			        'gstin_no' => $r20['gstin_no'],
    			        'address1' => $r20['address1'],
    			        'address2' => $r20['address2'],
    			        'website_name' => $r20['website_name'],
    			        'branch' => $r20['branch'],
    			        'userId' => $r20['userId'],
    			        'status' => $r20['status'],
    			        'effective_from' => $r20['effective_from'],
    			        'data_transfer' => $r20['data_transfer'],
    			        'client_id' => $r20['client_id'],
    			        'cin_no' => $r20['cin_no']
    			    );
            }
            $resp20 = $this->db->insert_batch('outlet_deatils',$outletdeatils);
        }
        else
        {
            $resp20 = 'Null Values from the Source';
        }


        $s201 = $row['SmsAuthorize'];
        if($s201 != null)
        {
            foreach ($s201 as $r201) 
            {
                $smsauthorize[] = array(
    			        'auth_id' => $r201['auth_id'],
    			        'api_key' => $r201['api_key'],
    			        'sender_id' => $r201['sender_id'],
    			        'mobile_no' => $r201['mobile_no'],
    			        'branch' => $r201['branch'],
    			        'branch_title' => $r201['branch_title'],
    			        'location' => $r201['location'],
    			        'status' => $r201['status'],
    			        'owner_num' => $r201['owner_num'],
    			        'service' => $r201['service'],
    			        'email_id' => $r201['email_id'],
			            'adminstrative_email' => $r201['adminstrative_email'],
    			        'template_id' => $r201['template_id'],
    			        'message_type_id' => $r201['message_type_id'],
    			        'client_id' => $r201['client_id'],
    			    );
            }
            $resp201 = $this->db->insert_batch('sms_authorize',$smsauthorize);
        }
        else
        {
            $resp201 = 'Null Values from the Source';
        }
        
        $responsedata = array(
            'Roles' => $resp1, 
            'Tax' => $resp2, 
            'Uom' => $resp3,
            'Masters' => $resp4, 
            'ModuleGroups' => $resp5, 
            'Modules' => $resp6, 
            'Permissions'=> $resp7,
            'MessageType'=> $resp71, 
            'Settings' => $resp8,
            'Client' => $resp9,
            'Branches' => $resp10,
            'Users' => $resp11,
            'ModuleCreation' => $resp12,
            'PermissionCreation' => $resp13,
            'MastersCreation' => $resp14,
            'CategoryMaster' => $resp15,
            'ProductCategory' => $resp16,
            'Products' => $resp17,
            'ApplicationSetting' => $resp18,
            'CreditCustomer' => $resp19,
            'OutletDeatils' => $resp20,
            'SmsAuthorize'=> $resp201, 
        );
        
        echo json_encode($responsedata);
	}
	
	//API for Adding Zipcode
	public function addZipcode()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $zip_id = $row['zip_id'];
	    $store_id = $row['store_id'];
	    $zip_code = $row['zip_code'];
		$status = $row['status'];
		
		date_default_timezone_set("Asia/Kolkata");
		$created = date("Y-m-d H:i:s");
		
		$postdata = array(
		                'zip_id' => $zip_id ,
		                'store_id' => $store_id,
		                'zip_code' => $zip_code,
		                'status' => $status, 
		                'created' => $created
		                );
		
		
		$q=$this->db->query("SELECT * from store a, zipcode b where a.store_id = b.store_id and b.store_id = $store_id and b.zip_code = '$zip_code'");
		
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Zipcode Created Successfully.");
    		echo json_encode($JSON);
		}
		else
		{
			$res = $this->db->insert('zipcode',$postdata);

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Zipcode Created Successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSZA01 Store Zipcode Creation failed!!!");
    			echo json_encode($JSON);
			}
		}
		
	}
	
	//API for Updating Zipcode
	public function updateZipcode()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");
	    
	    $zip_id = $row['zip_id'];
	    $store_id = $row['store_id'];
	    $zip_code = $row['zip_code'];
		$status = $row['status'];
		$old_store_id = $row['old_store_id'];
		$old_zipcode = $row['old_zipcode'];
		
		$postdata = array(
		                'zip_id' => $zip_id ,
		                'store_id' => $store_id,
		                'zip_code' => $zip_code,
		                'status' => $status, 
		                'updated' => $updated
		                );
		
		if(($store_id == $old_store_id) && ($zip_code == $old_zipcode))
		{
            $this->db->where('zip_id',$zip_id);
			$result = $this->db->update('zipcode',$postdata);
		}
		else
		{
		    $q=$this->db->query("SELECT * from store a, zipcode b where a.store_id = b.store_id and b.store_id = $store_id and b.zip_code = '$zip_code'");
		    
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Zip Code Updation successful.");
    			echo json_encode($JSON);
			}
			else
			{
			    $this->db->where('zip_id',$zip_id);
			    $result = $this->db->update('zipcode',$postdata);
			}
		}

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Zip Code Updation successful");
			echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSZU01 Store Zip Code Updation failed!!!");
			echo json_encode($JSON);
		}
	}
	
	//API for Adding Notification Phone
	public function addNotificationPhone()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $phone_id = $row['phone_id'];
	    $store_id = $row['store_id'];
	    $phone_no = $row['phone_no'];
		$status = $row['status'];
		
		date_default_timezone_set("Asia/Kolkata");
		$created = date("Y-m-d H:i:s");
		
		
		$postdata = array(
		                'phone_id' => $phone_id ,
		                'store_id' => $store_id,
		                'phone_no' => $phone_no,
		                'status' => $status, 
		                'created' => $created
		                );
		
		
		$q=$this->db->query("SELECT * from store a, notification_phones b where a.store_id = b.store_id and b.store_id = $store_id and b.phone_no = '$phone_no'");
		
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Notification Phone Created Successfully.");
    		echo json_encode($JSON);
		}
		else
		{
			$res = $this->db->insert('notification_phones',$postdata);

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Notification Phone Created Successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSNEA01 Store Notification Phone Creation failed!!!");
    			echo json_encode($JSON);
			}
		}
		
	}
	
	//API for Updating Notification Phone
	public function updateNotificationPhone()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");
	    
	    $phone_id = $row['phone_id'];
	    $store_id = $row['store_id'];
	    $phone_no = $row['phone_no'];
		$status = $row['status'];
		$old_store_id = $row['old_store_id'];
		$old_phone = $row['old_phone'];
		
		$postdata = array(
		                'phone_id' => $phone_id ,
		                'store_id' => $store_id,
		                'phone_no' => $phone_no,
		                'status' => $status, 
		                'updated' => $updated
		                );
		
		if(($store_id == $old_store_id) && (strcasecmp($phone_no, $old_phone) == 0))
		{
            $this->db->where('phone_id',$phone_id);
			$result = $this->db->update('notification_phones',$postdata);
		}
		else
		{
		    $q=$this->db->query("SELECT * from store a, notification_phones b where a.store_id = b.store_id and b.store_id = $store_id and b.phone_no = '$phone_no'");
		    
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Notification Phone Updation successful.");
    			echo json_encode($JSON);
			}
			else
			{
			    $this->db->where('phone_id',$phone_id);
			    $result = $this->db->update('notification_phones',$postdata);
			}
		}

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Notification Phone Updation successful");
			echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSNPU01 Store Notification Phone Updation failed!!!");
			echo json_encode($JSON);
		}
	}
	
	//API for Adding Notification Email
	public function addNotificationEmail()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $email_id = $row['email_id'];
	    $store_id = $row['store_id'];
	    $email = $row['email'];
		$status = $row['status'];
		
		date_default_timezone_set("Asia/Kolkata");
		$created = date("Y-m-d H:i:s");
		
		
		$postdata = array(
		                'email_id' => $email_id ,
		                'store_id' => $store_id,
		                'email' => $email,
		                'status' => $status, 
		                'created' => $created
		                );
		
		
		$q=$this->db->query("SELECT * from store a, notification_emails b where a.store_id = b.store_id and b.store_id = $store_id and b.email = '$email'");
		
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Notification Email Created Successfully.");
    		echo json_encode($JSON);
		}
		else
		{
			$res = $this->db->insert('notification_emails',$postdata);

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Notification Email Created Successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSNEA01 Store Notification Email Creation failed!!!");
    			echo json_encode($JSON);
			}
		}
		
	}
	
	//API for Updating Notification Email
	public function updateNotificationEmail()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");
	    
	    $email_id = $row['email_id'];
	    $store_id = $row['store_id'];
	    $email = $row['email'];
		$status = $row['status'];
		$old_store_id = $row['old_store_id'];
		$old_email = $row['old_email'];
		
		$postdata = array(
		                'email_id' => $email_id,
		                'store_id' => $store_id, 
		                'email' => $email,
		                'status' => $status,
		                'updated' => $updated
		                );
		
		if(($store_id == $old_store_id) && (strcasecmp($email, $old_email) == 0))
		{
			$this->db->where('email_id',$email_id);
			$result = $this->db->update('notification_emails',$postdata);
		}
		else
		{
		    $q=$this->db->query("SELECT * from store a, notification_emails b where a.store_id = b.store_id and b.store_id = $store_id and b.email = '$email'");
		    
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Notification Email Updation successful.");
    			echo json_encode($JSON);
			}
			else
			{
			    $this->db->where('email_id',$email_id);
			    $result = $this->db->update('notification_emails',$postdata);
			}
		}

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Notification Email Updation successful");
			echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSNEU01 Store Notification Email Updation failed!!!");
			echo json_encode($JSON);
		}
	}
	
    //API for Adding a store action
	public function addStoreAction()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $storeaction_id = $row['storeaction_id'];
	    $action = $row['action'];
	    $location_ref_id = $row['location_ref_id'];
		$platform = $row['platform'];
		$platform_url = $row['platform_url'];
		$platform_store_id = $row['platform_store_id'];
		$status = $row['status'];
		$store_id = $row['store_id'];
		$str_action_status = $row['str_action_status'];
		
		date_default_timezone_set("Asia/Kolkata");
		$created = date("Y-m-d H:i:s");
		
		$postdata = array(
		                'storeaction_id' => $storeaction_id ,
		                'action' => $action,
		                'location_ref_id' => $location_ref_id,
		                'platform' => $platform,
		                'platform_url' => $platform_url, 
		                'platform_store_id' => $platform_store_id,
		                'status' => $status, 
		                'store_id' => $store_id,
		                'str_action_status' => $str_action_status,
		                'created' => $created
		                );
		
		
		$q=$this->db->query("select * from store_actions where platform = '$platform' and store_id = $store_id");
		
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Action Created Successfully.");
    		echo json_encode($JSON);
		}
		else
		{
			$res = $this->db->insert('store_actions',$postdata);

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Action Created Successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSA01 Store creation failed!!!");
    			echo json_encode($JSON);
			}
		}
		
	}
	
	//API for Updating a store action
	public function updateStoreAction()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");
	    
	    $storeaction_id = $row['storeaction_id'];
	    $action = $row['action'];
	    $location_ref_id = $row['location_ref_id'];
		$platform = $row['platform'];
		$platform_url = $row['platform_url'];
		$platform_store_id = $row['platform_store_id'];
		$status = $row['status'];
		$store_id = $row['store_id'];
		$old_store_id = $row['old_store_id'];
		$old_platform = $row['old_platform'];
		
		$postdata = array(
		                'action' => $action, 
		                'location_ref_id' => $location_ref_id,
		                'platform' => $platform,
		                'platform_url' => $platform_url,
		                'platform_store_id' => $platform_store_id, 
		                'status' => $status,
		                'store_id'=> $store_id, 
		                'updated' => $updated
		                );
		
		if(($store_id == $old_store_id) && (strcasecmp($platform, $old_platform) == 0))
		{
			$this->db->where('storeaction_id',$storeaction_id);
			$result = $this->db->update('store_actions',$postdata);
		}
		else
		{
		    $q=$this->db->query("select * from store_actions where platform = '$platform' and store_id = $store_id");
		    
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Action updation successful.");
    			echo json_encode($JSON);
			}
			else
			{
				$this->db->where('storeaction_id',$storeaction_id);
			    $result = $this->db->update('store_actions',$postdata);
			}
		}

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Action updation successful");
			echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSU01 Store Action updation failed!!!");
			echo json_encode($JSON);
		}
	}
	
	//API for Adding a store
	public function addStore()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $store_id = $row['store_id'];
	    $store_ref_id = $row['store_ref_id'];
	    $city = $row['city'];
		$name = $row['name'];
		$min_pickup_time = $row['min_pickup_time'];
		$min_delivery_time = $row['min_delivery_time'];
		$contact_phone = $row['contact_phone'];
		$min_order_value = $row['min_order_value'];
		$hide_from_ui = $row['hide_from_ui'];
		$address = $row['address'];
		$geo_latitude = $row['geo_latitude'];
		$geo_longitude = $row['geo_longitude'];
		$active = $row['active'];
		$ordering_enabled = $row['ordering_enabled'];
		$branch = $row['branch'];
		$client_id = $row['client_id'];
		
		date_default_timezone_set("Asia/Kolkata");
		$created = date("Y-m-d H:i:s");
		
		$posdata = array(
		            'store_id' => $store_id,
		            'store_ref_id' => $store_ref_id,
		            'city' => $city,
		            'name' => $name,
		            'min_pickup_time' => $min_pickup_time,
		            'min_delivery_time' => $min_delivery_time,
		            'contact_phone' => $contact_phone,
		            'min_order_value' => $min_order_value,
            		'hide_from_ui' => $hide_from_ui,
            		'address' => $address,
            		'geo_latitude' => $geo_latitude,
            		'geo_longitude' => $geo_longitude,
            		'active' => $active,
            		'ordering_enabled' => $ordering_enabled,
            		'branch' => $branch,
            		'client_id' => $client_id,
            		'created' => $created
		    );
		
		$q=$this->db->query("select * from store where client_id = $client_id and branch = '$branch'");
		
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Created Successfully.");
    		echo json_encode($JSON);
		}
		else
		{
			$res = $this->db->insert('store', $posdata);

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store Created Successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSA01 Store creation failed!!!");
    			echo json_encode($JSON);
			}
		}
		
	}
	
	//API for Updating Store
	public function updateStore()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");
	    
	    $store_id = $row['store_id'];
	    $store_ref_id = $row['store_ref_id'];
	    $city = $row['city'];
		$name = $row['name'];
		$min_pickup_time = $row['min_pickup_time'];
		$min_delivery_time = $row['min_delivery_time'];
		$contact_phone = $row['contact_phone'];
		$min_order_value = $row['min_order_value'];
		$hide_from_ui = $row['hide_from_ui'];
		$address = $row['address'];
		$geo_latitude = $row['geo_latitude'];
		$geo_longitude = $row['geo_longitude'];
		$active = $row['active'];
		$ordering_enabled = $row['ordering_enabled'];
		$branch = $row['branch'];
		$client_id = $row['client_id'];
		$old_client_id = $row['old_client_id'];
        $old_branch = $row['old_branch'];
		
		$postdata = array(
		                'store_ref_id' => $store_ref_id,
		                'city' => $city, 
		                'name' => $name,
		                'min_pickup_time' => $min_pickup_time,
		                'min_delivery_time' => $min_delivery_time,
		                'contact_phone' => $contact_phone, 
		                'min_order_value' => $min_order_value,
		                'hide_from_ui'=> $hide_from_ui, 
		                'address' => $address,
		                'geo_latitude' => $geo_latitude,
		                'geo_longitude' => $geo_longitude,
		                'active' => $active,
		                'ordering_enabled' => $ordering_enabled,
		                'branch' => $branch, 
		                'client_id' => $client_id,
		                'updated' => $updated
		                );
		
		if(($client_id == $old_client_id) && (strcasecmp($branch, $old_branch) == 0))
		{
			$this->db->where('store_id',$store_id);
			$result = $this->db->update('store',$postdata);
		}
		else
		{
		    $q=$this->db->query("select * from store where client_id = $client_id and branch = '$branch'");
		    
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store updation successful.");
    			echo json_encode($JSON);
			}
			else
			{
				$this->db->where('store_id',$store_id);
			    $result = $this->db->update('store',$postdata);
			}
		}

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Store updation successful");
			echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSU01 Store updation failed!!!");
			echo json_encode($JSON);
		}
	}
	
	//API for Product Multi Update
	public function updateProductbyProductCodeMulti()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $product_name = $row['Product Name'];
        $product_code = $row['Product Code'];
        $s1 = $row['Products'];
        if($s1 != null)
        {
            foreach ($s1 as $r1) 
            {
				$Allprod[] = array("pr_id" => $r1['pr_id'],
                                "price" => $r1['price'],
                                 "basic_rate" => $r1['basic_rate'],
                                 "basic_tax_percent" => $r1['basic_tax_percent'],
                                 "basic_tax_amount" => $r1['basic_tax_amount'],
                                 "cgst_tax_amount" => $r1['cgst_tax_amount'],
                                 "sgst_tax_amount" => $r1['sgst_tax_amount'],
                                 "cgst_tax" => $r1['cgst_tax'],
                                 "sgst_tax" => $r1['sgst_tax'],
                                 "product_status" => $r1['product_status'],
                                 "effective_from" => $r1['effective_from'],
                                 "data_transfer" => $r1['data_transfer']
                        );
            }
            
            $response = $this->db->update_batch('product', $Allprod, 'pr_id');
            if($response > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "<b>$product_name</b> updated to all branches");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "300", "status" => "failed", "response" => "ERR-CMSP01 Failed to Add New Products!!!");
    			echo json_encode($JSON);
			}
        }
        else
        {
            $JSON = array("statuscode" => "400", "status" => "failed", "response" => "Null Values from the Source");
    		echo json_encode($JSON);
        }
	}
	
	// API for Update Product Category Status
	public function updateProductCategoryStatus()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        
		$category_id = $decoded['category_id'];
		$category_status = $decoded['status'];
		$data_transfer = $decoded['data_transfer'];
		$effective_from = $decoded['effective_from'];

		$data = array(
		    'status'=>$category_status,
		    'data_transfer' => $data_transfer,
	        'effective_from' => $effective_from
		    );

		$this->db->where('pr_cat_id ',$category_id);
		$this->db->update('product_category',$data);
		
		$total = $this->db->affected_rows();
    	if($total>0)
    	{
        	$result = 'true';
    	}
    	else
    	{
        	$result = 'false';
    	}

		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Product Category Status Changed Successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "CMERR-Failed to Change Product Category Status!");
    		echo json_encode($JSON);
		}
	}
	
	// API for Update Product Status
	public function updateProductStatus()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        
		$product_id = $decoded['product_id'];
		$product_status = $decoded['product_status'];
		$data_transfer = $decoded['data_transfer'];
		$effective_from = $decoded['effective_from'];

		$data = array(
		    'product_status'=>$product_status,
		    'data_transfer' => $data_transfer,
	        'effective_from' => $effective_from
		    );

		$this->db->where('pr_id', $product_id);
		$this->db->update('product', $data);
		
		$total = $this->db->affected_rows();
    	if($total>0)
    	{
        	$result = 'true';
    	}
    	else
    	{
        	$result = 'false';
    	}

		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Product Status Changed Successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "CMERR-Failed to Change Product Status!");
    		echo json_encode($JSON);
		}
	}

    // API to Update SMS Authorize
	public function updateSmsAuthorize()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
	    
	    $auth_id = $row['auth_id'];
	    $clientid = $row['client_id'];
		$branch = $row['branch'];
		$btitle = $row['branch_title'];
		$mobile = $row['mobile_no'];
		$apikey = $row['api_key'];
		$senderid = $row['sender_id'];
		$status = $row['status'];
		$ownernum = $row['owner_num'];
		$service = $row['service'];
		$template_id = $row['template_id'];
		$email = $row['email_id'];
		$admemail = $row['adminstrative_email'];
		$message_type_id = $row['message_type_id'];
		$location = $row['location'];
		$updated = $row['updated'];
		
		$old_client_id = $row['old_client_id'];
        $old_branch = $row['old_branch'];
        $old_message_type_id = $row['old_message_type_id'];
		
		$posdata = array('auth_id' => $auth_id,'client_id'=>$clientid, 'branch'=>$branch, 'branch_title' => $btitle, 'mobile_no' => $mobile, 'api_key' => $apikey, 'sender_id' => $senderid, 'owner_num' => $ownernum, 'service' => $service, 'template_id' => $template_id, 'email_id' => $email, 'adminstrative_email' => $admemail, 'message_type_id' => $message_type_id, 'location' => $location, 'status' => $status, 'updated'=> $updated);
		
		if(($clientid == $old_client_id) && (strcasecmp($branch, $old_branch) == 0) && ($message_type_id == $old_message_type_id))
		{
			$this->db->where('auth_id',$auth_id);
			$result = $this->db->update('sms_authorize',$posdata);
		}
		else
		{
		    $q=$this->db->query("select * from sms_authorize where client_id = $clientid and branch = '$branch' and message_type_id = $message_type_id");
		    
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "SMS Authorization updation successful.");
    			echo json_encode($JSON);
			}
			else
			{
				$this->db->where('auth_id',$auth_id);
			    $result = $this->db->update('sms_authorize',$posdata);
			}
		}

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "SMS Authorization updation successful");
			echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSAU01 SMS Authorization updation failed!!!");
			echo json_encode($JSON);
		}
	}
	
	// API to Add SMS Authorize
	public function addSmsAuthorize()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
	    
	    $auth_id = $row['auth_id'];
	    $clientid = $row['client_id'];
		$branch = $row['branch'];
		$btitle = $row['branch_title'];
		$mobile = $row['mobile_no'];
		$apikey = $row['api_key'];
		$senderid = $row['sender_id'];
		$status = $row['status'];
		$ownernum = $row['owner_num'];
		$service = $row['service'];
		$template_id = $row['template_id'];
		$email = $row['email_id'];
		$admemail = $row['adminstrative_email'];
		$message_type_id = $row['message_type_id'];
		$location = $row['location'];
		$created = $row['created'];
		
		$posdata = array('auth_id' => $auth_id,'client_id'=>$clientid, 'branch'=>$branch, 'branch_title' => $btitle, 'mobile_no' => $mobile, 'api_key' => $apikey, 'sender_id' => $senderid, 'owner_num' => $ownernum, 'service' => $service, 'template_id' => $template_id, 'email_id' => $email, 'adminstrative_email' => $admemail, 'message_type_id' => $message_type_id, 'location' => $location, 'status' => $status, 'created'=> $created);
		
		$q=$this->db->query("select * from sms_authorize where client_id = $clientid and branch = '$branch' and message_type_id = $message_type_id");
		
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "SMS Authorization Created Successfully.");
    		echo json_encode($JSON);
		}
		else
		{
			$res = $this->db->insert('sms_authorize', $posdata);

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "SMS Authorization Created Successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSSA01 Credit Customer creation failed!!!");
    			echo json_encode($JSON);
			}
		}
		
	}
	
	// API to update credit customer
	public function updateCreditCustomer()
	{
		header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
	    
	    $cust_id = $row['cust_id'];
	    $cust_name = $row['cust_name'];
		$phone_number = $row['phone_number'];
		$gst_no = $row['gst_no'];
		$cust_address = $row['cust_address'];
		$status = $row['status'];
		$clientid = $row['client_id'];
		$branch = $row['branch'];
		$effective_from = $row['effective_from'];
		$data_transfer = $row['data_transfer'];
		$cust_type = $row['customer_type'];
		$old_clientid = $row['old_clientid'];
		$old_branch = $row['old_branch'];
		$old_gst_no = $row['old_gst_no'];

		$userInfo = array(
		    'cust_id' => $cust_id,
		    'cust_name'=> $cust_name,
		    'phone_number'=>$phone_number,
		    'gst_no'=>$gst_no,
		    'cust_address'=>$cust_address,
		    'customer_type'=>$cust_type,
		    'status'=>$status,
		    'branch'=>$branch, 
		    'client_id' => $clientid,
		    'effective_from' => $effective_from,
		    'data_transfer' => $data_transfer
		);

		if(($clientid == $old_clientid) && (strcasecmp($branch, $old_branch) == 0) && (strcasecmp($gst_no, $gst_no) == 0))
		{
			$this->db->where('cust_id', $cust_id);
		    $result = $this->db->update('credit_customer', $userInfo);
		}
		else
		{
		    $q=$this->db->query("SELECT a.* from credit_customer a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch = '$branch' and a.gst_no = '$gst_no'");
		    
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "New Credit Customer $cust_name created successfully.");
    			echo json_encode($JSON);
			}
			else
			{
				$this->db->where('cust_id', $cust_id);
		        $result = $this->db->update('credit_customer', $userInfo);
			}
		}

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Credit Customer $cust_name updated successfully");
			echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSCCU01 Credit Customer Updation failed!!!");
			echo json_encode($JSON);
		}
	}
	
	// API to Add credit customers 
	public function addCreditCustomer()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
	    
	    $cust_id = $row['cust_id'];
	    $cust_name = $row['cust_name'];
		$phone_number = $row['phone_number'];
		$gst_no = $row['gst_no'];
		$cust_address = $row['cust_address'];
		$status = $row['status'];
		$clientid = $row['client_id'];
		$branch = $row['branch'];
		$effective_from = $row['effective_from'];
		$data_transfer = $row['data_transfer'];

		$userInfo = array(
		    'cust_id' => $cust_id,
		    'cust_name'=> $cust_name,
		    'phone_number'=>$phone_number,
		    'gst_no'=>$gst_no,
		    'cust_address'=> $cust_address,
		    'status'=>$status,
		    'branch'=>$branch, 
		    'client_id' => $clientid,
		    'effective_from' => $effective_from,
		    'data_transfer' => $data_transfer
		);
		
		$q=$this->db->query("SELECT a.* from credit_customer a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch = '$branch' and a.gst_no = '$gst_no'");
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "New Credit Customer $cust_name created successfully.");
    		echo json_encode($JSON);
		}
		else
		{
			$res = $this->db->insert('credit_customer', $userInfo);

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "New Credit Customer $cust_name created successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSCCA01 Credit Customer creation failed!!!");
    			echo json_encode($JSON);
			}
		}
	}
	
	//Api to Update Permission Creation
	public function updatePermissionCreation()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $clientid = $row['client_id'];
        $client_name = $row['client_name'];
		$branch = $row['branch'];
		$moduleid = $row['module_creation_id'];
		$roleid = $row['role_id'];
		$permissionid = $row['permission_id'];
		$permissionmasterid = $row['permission_master_id'];
		$status = $row['status'];
		
		$client_name = $row['client_name'];
		$user_name = $row['user_name'];
        $module_name = $row['module_name'];
        $permission_name = $row['permission_name'];
		$updated = $row['updated'];
		
          $updatedata = array(
          	'permission_id' => $permissionid,
          	'permission_master_id' => $permissionmasterid,
          	'module_creation_id'=> $moduleid,
          	'role_id'=> $roleid,
          	'status' => $status,
          	'branch' => $branch,
          	'client_id' => $clientid,
          	'updated' => $updated,
      		);
    
        // print_r($updatedata);
        
        $this->db->where('permission_id',$permissionid);
		$result = $this->db->update('permission_creation',$updatedata);

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => " Permission updated successfully for <b> Permission : $permission_name , Module : $module_name , Role : $user_name , Client : $client_name</b>");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSPCE01 Permission Creation updation Failed!!!");
    		echo json_encode($JSON);
		}
	}
	
	//API to add Application Settings
	public function addApplicationSetting()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);   
        
        $client_id = $row['client_id'];
		$branch = $row['branch'];
		
		$m = $row['application_setting'];
        
        foreach ($m as $r) 
        {
            $appsetdata[] = array(
                'app_setting_id' => $r['app_setting_id'],
	            'setting_id' => $r['setting_id'],
               	'setting_name'=> $r['setting_name'],
               	'setting_access' => $r['setting_access'],
               	'setting_type' => $r['setting_type'],
               	'setting_title' => $r['setting_title'],
               	'status' => $r['status'],
               	'effective_from' => $r['effective_from'],
               	'data_transfer' => $r['data_transfer'],
               	'branch' => $r['branch'],
               	'client_id' => $r['client_id'],
               	'created' => $r['created'],
       		);   
        }
        
        // print_r($appsetdata);
			
	    $res = $this->db->insert_batch('application_setting', $appsetdata);

	    if($res > 0)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Application Settings are added for $branch");
			echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSASA01 Application Settings failed to add for $branch!!!");
			echo json_encode($JSON);
		}
	}
	
	// API to add Module Creation
	public function addModuleCreation()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);   
        
        $client_id = $row['client_id'];
		$role_id = $row['role_id'];
		
		$m = $row['module_creation'];
        
        foreach ($m as $r) 
        {
            $modulecreate[] = array(
	            'module_id' => $r['module_id'],
	           	'module_master_id' => $r['module_master_id'],
	           	'role_id'=> $r['role_id'],
	           	'status' => $r['status'],
	           	'branch' => $r['branch'],
	           	'client_id' => $r['client_id'],
	           	'created' => $r['created'],
	       	);   
        }
        
        // print_r($modulecreate);
			
	    $res = $this->db->insert_batch('module_creation', $modulecreate);

	    if($res > 0)
		{
		    $q=$this->db->query("SELECT a.*, b.client_name, c.role from module_creation a, client_creation b, roles c where a.client_id = b.client_id and a.role_id = c.roleId and a.client_id = $client_id and a.role_id = $role_id");
			if ($q->num_rows() > 0)
    		{
    		    $resp = $q->result();
    		    foreach($resp as $r1)
    		    {
    		        $clientname = $r1->client_name;
    		        $rolename = $r1->role;
    		    }
    		}
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Module Creation is Added for $rolename of $clientname");
			echo json_encode($JSON);
		}
		else
		{
		    $q=$this->db->query("SELECT a.client_name, b.role from client_creation a, roles b where a.client_id = $client_id and b.roleId = $role_id");
			if ($q->num_rows() > 0)
    		{
    		    $resp = $q->result();
    		    foreach($resp as $r1)
    		    {
    		        $clientname = $r1->client_name;
    		        $rolename = $r1->role;
    		    }
    		}
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSMCA01 Module creation failed to add for $rolename of $clientname!!!");
			echo json_encode($JSON);
		}
	}
	
	//API for Update Client
	public function updateClient()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $clientid = $row['client_info']['client_id'];
        $client_name = $row['client_info']['client_name'];
        $role = $row['client_info']['role'];
        $branches = $row['client_info']['no_of_branches'];
        $branch_prefix = $row['client_info']['branch_prefix'];
        $updated = $row['client_info']['updated'];
        $client_url = $row['client_info']['client_url'];
        
        $cusername = $row['ceoinfo']['email'];
        $cpassword = $row['ceoinfo']['password'];
        $cname = $row['ceoinfo']['name'];
        $crole = $row['ceoinfo']['roleId'];
        $ccreatedBy = $row['ceoinfo']['createdBy'];
        $cprime_id = $row['ceoinfo']['prime_id'];
        $cupdated = $row['ceoinfo']['updated'];
        $ceffective_from = $row['ceoinfo']['effective_from'];
        
        $cmusername = $row['cminfo']['email'];
        $cmpassword = $row['cminfo']['password'];
        $cmname = $row['cminfo']['name'];
        $cmrole = $row['cminfo']['roleId'];
        $cmcreatedBy = $row['cminfo']['createdBy'];
        $cmprime_id = $row['cminfo']['prime_id'];
        $cmupdated = $row['cminfo']['updated'];
        $cmeffective_from = $row['cminfo']['effective_from'];
        
        $old_name = $row['old_name'];
        $old_username = $row['old_username'];
        
		

		if(empty($cprime_id))
		{
			// Client Info
			$userInfo = array('client_id'=>$clientid ,'client_name'=> $client_name,'role'=>$role,'no_of_branches'=>$branches,'branch_prefix'=>$branch_prefix,'updated'=>$updated, 'client_url' => $client_url);

			// Ceo Info
			$logininfo1 = array('email'=>$cusername,'name'=>$cname,'roleId'=>$crole,'createdBy'=>$ccreatedBy,'updated'=>$cupdated, 'effective_from'=>$ceffective_from);

			// Client Master Info
			$logininfo2 = array('email'=>$cmusername,'name'=>$cmname,'roleId'=>$cmrole,'createdBy'=>$cmcreatedBy,'updated'=>$cmupdated, 'effective_from'=>$cmeffective_from);
		}
		else
		{
			// Client Info
			$userInfo = array('client_id'=>$clientid ,'client_name'=> $client_name,'role'=>$role,'no_of_branches'=>$branches,'branch_prefix'=>$branch_prefix,'updated'=>$updated, 'client_url' => $client_url);

			// Ceo Info
			$logininfo1 = array('email'=>$cusername,'password'=>$cpassword,'name'=>$cname,'roleId'=>$crole,'createdBy'=>$ccreatedBy,'prime_id'=>$cprime_id,'updated'=>$cupdated, 'effective_from'=>$ceffective_from);

			// Client Master Info
			$logininfo2 = array('email'=>$cmusername,'password'=>$cmpassword,'name'=>$cmname,'roleId'=>$cmrole,'createdBy'=>$cmcreatedBy,'prime_id'=>$cmprime_id,'updated'=>$cmupdated, 'effective_from'=>$cmeffective_from);
		}

		if((strcasecmp($client_name, $old_name) == 0) && (strcasecmp($cusername, $old_username) == 0))
		{
			$this->db->where('client_id', $clientid);
	        $this->db->update('client_creation', $userInfo);
	        
	        $ceoarray = array('client_id' => $clientid, 'roleId' => $crole);
	        $this->db->where($ceoarray); 
	        $this->db->update('users', $logininfo1);
	        
	        $cmarray = array('client_id' => $clientid, 'roleId' => $cmrole);
	        $this->db->where($cmarray); 
	        $this->db->update('users', $logininfo2);
	        
	        $result = TRUE;
		}
		else
		{
		    $query=$this->db->query("SELECT COUNT(*) as CNT from (SELECT a.client_name as name from client_creation a where a.client_name = '$client_name' UNION SELECT b.email as name FROM users b where b.email = '$cusername') x");
		    $rw = $query->row_array();
		    $resp = $rw['CNT'];
		    
		  //  echo "Response ".$resp; 
    		if ($resp > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Client updated successfully.");
    			echo json_encode($JSON);
			}
			else
			{
		        $this->db->where('client_id', $clientid);
    	        $this->db->update('client_creation', $userInfo);
    	        
    	        $ceoarray = array('client_id' => $clientid, 'roleId' => $crole);
    	        $this->db->where($ceoarray); 
    	        $this->db->update('users', $logininfo1);
    	        
    	        $cmarray = array('client_id' => $clientid, 'roleId' => $cmrole);
    	        $this->db->where($cmarray); 
    	        $this->db->update('users', $logininfo2);
    	        
    	        $result = TRUE;
			}
		}
		
		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Client updated successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSCU01 Client updation Failed!!!");
    		echo json_encode($JSON);
		}
	}
	
	//API for Approving Branch
	public function approveBranch()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        $client_id = $decoded['client_id'];
		$branch_id = $decoded['branch_id'];

		$total1 = $this->db->query('UPDATE branch_creation SET status = "Active"  WHERE branch_id = '.$branch_id.' and client_id = '.$client_id);	
		
		$total = $this->db->affected_rows();
    	if($total>0)
    	{
        	$result = 'true';
    	}
    	else
    	{
        	$result = 'false';
    	}

		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Branch has been Approved");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSBA01 Branch Approval Failed!!!");
    		echo json_encode($JSON);
		}
	}
	
	//API for Adding New Branch
	public function addBranch()
	{			
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        
		$branchid = $decoded['branch_id'];
		$clientid = $decoded['client_id'];
		$bname = $decoded['branch_name'];
		$bslno = $decoded['branch_slno'];
		$btitle = $decoded['branch_title'];
		$status = $decoded['status'];
		$created = $decoded['created'];
		$social_order_percentage = $decoded['social_order_percentage'];
		
		$data = array(
            'branch_id' => $branchid,
            'client_id'=> $clientid,
            'branch_name'=>$bname,
            'branch_title'=>$btitle,
            'branch_slno'=>$bslno,
            'social_order_percentage' => $social_order_percentage,
            'status'=>$status,
            'created'=>$created,
        );
		
		$q=$this->db->query("select a.*, b.client_name from branch_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch_name = '$bname'");
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "New Branch $bname added successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$res = $this->db->insert('branch_creation', $data);

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "New Branch $bname added successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSBCA01 Branch creation failed!!!");
    			echo json_encode($JSON);
			}
		}
	}
	
	// API for Updating Branch Creation
	public function updateBranch()
	{
	    $content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        
		$branchid = $decoded['branch_id'];
		$clientid = $decoded['client_id'];
		$bname = $decoded['branch_name'];
		$btitle = $decoded['branch_title'];
		$bslno = $decoded['branch_slno'];
		$social_order_percentage = $decoded['social_order_percentage'];
		$old_bname = $decoded['old_bname'];
		$updated = $decoded['updated'];
		$old_clientid = $decoded['old_clientid'];
	    
		$userInfo = array(
		    'branch_id' => $branchid,
		    'client_id'=> $clientid,
		    'branch_name'=>$bname,
		    'branch_title'=>$btitle,
		    'branch_slno'=>$bslno,
		    'social_order_percentage' => $social_order_percentage,
		    'updated'=>$updated, 
        );
            
        // print_r($userInfo);

		if(($clientid == $old_clientid) && (strcasecmp($bname, $old_bname) == 0))
		{
			$this->db->where('branch_id', $branchid);
		    $result = $this->db->update('branch_creation', $userInfo);
		}
		else
		{
			$q=$this->db->query("select * from branch_creation where client_id = ".$clientid." and branch_name = '".$bname."'");
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Branch updated successfully.");
    			echo json_encode($JSON);
			}
			else
			{
				$this->db->where('branch_id', $branchid);
		        $result = $this->db->update('branch_creation', $userInfo);
			}
		}
        
		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Branch updated successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSBU01 Branch updation Failed!!!");
    		echo json_encode($JSON);
		}
	}
	
	// API for Adding Master Creation
	public function addMasterCreation()
	{
	    $content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        
		$client_id = $decoded['client_id'];
		$branchname = $decoded['branch'];
		$masterId = $decoded['masterId'];
		$master_type = $decoded['masters_type'];
		$master_details = $decoded['master_details'];
		$status = $decoded['status'];
		$effective_from = $decoded['effective_from'];
		$master_id = $decoded['master_id'];
		$data_transfer = $decoded['data_transfer'];
		$created = $decoded['created'];
		
		$masterInfo = array(
		    "masterId" => $masterId,
		    "masters_status" => $master_type,
		    "master_details" => $master_details,
		    "effective_from" => $effective_from,
		    "status" => $status,
		    "data_transfer" => $data_transfer,
		    "branch" => $branchname,
		    "client_id" => $client_id,
		    "master_id" => $master_id,
		    "created" => $created
		);
		
        $q=$this->db->query("SELECT a.* from masters_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $client_id and a.branch = '$branchname' and a.masters_status = '$master_type' and a.master_details = '$master_details'");
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Master Creation is added for $branchname.");
    		echo json_encode($JSON);
		}
		else
		{
			$res = $this->db->insert('masters_creation', $masterInfo);
		  //  $insert_id = $this->db->insert_id();

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Master Creation is added for $branchname");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSMACA01 Failed to Add Master Creation!!!");
    			echo json_encode($JSON);
			}
		}
	}
	
	// API Update for Master Creation
	public function updateMasterCreation()
	{
	    $content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        
		$client_id = $decoded['client_id'];
		$branchname = $decoded['branch'];
		$masterId = $decoded['masterId'];
		$master_type = $decoded['masters_type'];
		$master_details = $decoded['master_details'];
		$status = $decoded['status'];
		$effective_from = $decoded['effective_from'];
		$master_id = $decoded['master_id'];
		$updated = $decoded['updated'];
		$data_transfer = $decoded['data_transfer'];
		$old_client_id = $decoded['old_client_id'];
		$old_branchname = $decoded['old_branchname'];
		$old_master_type = $decoded['old_master_type'];
		$old_master_details = $decoded['old_master_details'];
		
		$masterInfo = array(
		    "masterId" => $masterId,
		    "masters_status" => $master_type,
		    "master_details" => $master_details,
		    "effective_from" => $effective_from,
		    "status" => $status,
		    "data_transfer" => $data_transfer,
		    "branch" => $branchname,
		    "client_id" => $client_id,
		    "master_id" => $master_id,
		    "updated" => $updated
		);


		if(($client_id == $old_client_id) && (strcasecmp($branchname, $old_branchname) == 0) && (strcasecmp($master_type, $old_master_type) == 0) && (strcasecmp($master_details, $old_master_details) == 0))
		{
			$this->db->where('masterId', $masterId);
		    $result = $this->db->update('masters_creation', $masterInfo);
		}
		else
		{
			$q=$this->db->query("SELECT a.* from masters_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $client_id and a.branch = '$branchname' and a.masters_status = '$master_type' and a.master_details = '$master_details'");
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Master Creation updated successfully for $branchname.");
    			echo json_encode($JSON);
			}
	       	else
	       	{
	       		$this->db->where('masterId', $masterId);
		        $result = $this->db->update('masters_creation', $masterInfo);
	       	}
		}

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Master Creation updated successfully for $branchname.");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSMACU01 Master Creation updation Failed!!!");
    		echo json_encode($JSON);
		}
	}
	
	// API Update for Application Setting
	public function updateApplicationSetting()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
		$client_id = $row['client_id'];
		$branchname = $row['branch'];
		$old_client_id = $row['old_client_id'];
		$old_branchname = $row['old_branch'];
		
		$m = $row['application_setting'];
        
        foreach ($m as $r) 
        {
            $updatedata[] = array(
               	'app_setting_id' => $r['app_setting_id'],
               	'setting_id' => $r['setting_id'],
               	'setting_name'=> $r['setting_name'],
               	'setting_access' => $r['setting_access'],
               	'setting_type' => $r['setting_type'],
               	'setting_title' => $r['setting_title'],
               	'status' => $r['status'],
               	'effective_from' => $r['effective_from'],
               	'data_transfer' => $r['data_transfer'],
               	'branch' => $r['branch'],
               	'client_id' => $r['client_id'],
               	'updated' =>$r['module_id'],
               );   
        }
        
        $res = array();
		$count = 0;
       	
       	// print_r($updatedata);

      	if(($client_id == $old_client_id) && (strcasecmp($branchname, $old_branchname) == 0))
		{
		    foreach($updatedata as $d)
		    {
		        $app_setting_id = $d['app_setting_id'];
		        
		        $data = array(
                   	'app_setting_id' => $d['app_setting_id'],
                   	'setting_id' => $d['setting_id'],
                   	'setting_name'=> $d['setting_name'],
                   	'setting_access' => $d['setting_access'],
                   	'setting_type' => $d['setting_type'],
                   	'setting_title' => $d['setting_title'],
                   	'status' => $d['status'],
                   	'effective_from' => $d['effective_from'],
                   	'data_transfer' => $d['data_transfer'],
                   	'branch' => $d['branch'],
                   	'client_id' => $d['client_id'],
                );  
		        
		      //  print_r($data);
		        
		        $q=$this->db->query("select * from application_setting where app_setting_id = $app_setting_id");
		        if($q->num_rows() > 0)
		        {
		            $this->db->where('app_setting_id',$app_setting_id);
		            $result = $this->db->update('application_setting',$data);
		            if($result == TRUE)
		            {
		                $res[] = $result;
		            }
		            else
		            {
		                $response = array(
    		                'id' => $app_setting_id,
    		                'response' => $result,
		                );
		            }
		        }
		        else
		        {
		            $result = $this->db->insert('application_setting',$data);
		            if($result > 0)
		            {
		                $res[] = $result;
		            }
		            else
		            {
		                $response = array(
    		                'id' => $app_setting_id,
    		                'response' => $result,
		                );
		            }
		        }
		        
		        $count = $count + 1;
		    }
		    
// 			$result = $this->db->update_batch('application_setting', $updatedata, 'app_setting_id');
		}
		else
		{
			$q=$this->db->query("SELECT a.* from application_setting a, client_creation b where a.client_id = b.client_id and a.client_id = $client_id and a.branch = '$branchname'");
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Application Setting updated successfully for $branchname.");
    			echo json_encode($JSON);
			}
			else
			{
			    foreach($updatedata as $d)
    		    {
    		        $app_setting_id = $d['app_setting_id'];
    		        
    		        $data = array(
                       	'app_setting_id' => $d['app_setting_id'],
                       	'setting_id' => $d['setting_id'],
                       	'setting_name'=> $d['setting_name'],
                       	'setting_access' => $d['setting_access'],
                       	'setting_type' => $d['setting_type'],
                       	'setting_title' => $d['setting_title'],
                       	'status' => $d['status'],
                       	'effective_from' => $d['effective_from'],
                       	'data_transfer' => $d['data_transfer'],
                       	'branch' => $d['branch'],
                       	'client_id' => $d['client_id'],
                    );  
    		        
    		      //  print_r($data);
    		        
    		        $q=$this->db->query("select * from application_setting where app_setting_id = $app_setting_id");
    		        if($q->num_rows() > 0)
    		        {
    		            $this->db->where('app_setting_id',$app_setting_id);
    		            $result = $this->db->update('application_setting',$data);
    		            if($result == TRUE)
    		            {
    		                $res[] = $result;
    		            }
    		            else
    		            {
    		                $response[] = array(
        		                'id' => $app_setting_id,
        		                'response' => $result,
    		                );
    		            }
    		        }
    		        else
    		        {
    		            $result = $this->db->insert('application_setting',$data);
    		            if($result > 0)
    		            {
    		                $res[] = $result;
    		            }
    		            else
    		            {
    		                $response[] = array(
        		                'id' => $app_setting_id,
        		                'response' => $result,
    		                );
    		            }
    		        }
    		        
    		        $count = $count + 1;
    		    }
    		    
				// $result = $this->db->update_batch('application_setting', $updatedata, 'app_setting_id');
			}
		}
		
// 		print_r($res);
// 		echo " : ".$count;
		
		if($count == count($res))
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Application Setting updated successfully for $branchname");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSEASU01 Application Setting updation Failed!!!", "data" => $response);
    		echo json_encode($JSON);
		}
	}
	
	// API Update for Module Creation
	public function updateModuleCreation()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $m = $row['module_creation'];
        
        foreach ($m as $r) 
        {
			$updatedata[] = array(
                       	'module_id' => $r['module_id'],
                       	'module_master_id' => $r['module_master_id'],
                       	'role_id'=> $r['role_id'],
                       	'status' => $r['status'],
                       	'branch' => $r['branch'],
                       	'client_id' => $r['client_id'],
                       	'updated' => $r['updated'],
                   		);
        }

        $old_clientid = $row['old_clientid'];
		$old_roleid = $row['old_roleid'];
       	$clientid = $row['clientid'];
		$roleid = $row['roleid'];
		
		$res = array();
		$count = 0;

		if(($clientid == $old_clientid) && ($roleid == $old_roleid))
		{
		    foreach($updatedata as $d)
		    {
		        $module_id = $d['module_id'];
		        
		        $data = array(
                   	'module_id' => $d['module_id'],
                   	'module_master_id' => $d['module_master_id'],
                   	'role_id'=> $d['role_id'],
                   	'status' => $d['status'],
                   	'branch' => $d['branch'],
                   	'client_id' => $d['client_id'],
                );
		        
		      //  print_r($data);
		        
		        $q=$this->db->query("select * from module_creation where module_id = $module_id");
		        if($q->num_rows() > 0)
		        {
		            $this->db->where('module_id',$module_id);
		            $result = $this->db->update('module_creation',$data);
		            if($result == TRUE)
		            {
		                $res[] = $result;
		            }
		            else
		            {
		                $response = array(
    		                'id' => $module_id,
    		                'response' => $result,
		                );
		            }
		        }
		        else
		        {
		            $result = $this->db->insert('module_creation',$data);
		            if($result > 0)
		            {
		                $res[] = $result;
		            }
		            else
		            {
		                $response = array(
    		                'id' => $module_id,
    		                'response' => $result,
		                );
		            }
		        }
		        
		        $count = $count + 1;
		    }
		    
// 			$result = $this->db->update_batch('module_creation', $updatedata, 'module_id');
			
			$q=$this->db->query("SELECT a.*, b.client_name, c.role from module_creation a, client_creation b, roles c where a.client_id = b.client_id and a.role_id = c.roleId and a.client_id = $clientid and a.role_id = $roleid");
			if ($q->num_rows() > 0)
    		{
    		    $resp = $q->result();
    		    foreach($resp as $r1)
    		    {
    		        $clientname = $r1->client_name;
    		        $rolename = $r1->role;
    		    }
    		}
		}
		else
		{
		    $q=$this->db->query("SELECT a.*, b.client_name, c.role from module_creation a, client_creation b, roles c where a.client_id = b.client_id and a.role_id = c.roleId and a.client_id = $clientid and a.role_id = $roleid");
    		if ($q->num_rows() > 0)
    		{
    		    $resp = $q->result();
    		    foreach($resp as $r1)
    		    {
    		        $clientname = $r1->client_name;
    		        $rolename = $r1->role;
    		    }
    		    
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Module Creation Updated Successfully for $rolename of $clientname");
    			echo json_encode($JSON);
			}
			else
			{
			    foreach($updatedata as $d)
    		    {
    		        $module_id = $d['module_id'];
    		        
    		        $data = array(
                       	'module_id' => $d['module_id'],
                       	'module_master_id' => $d['module_master_id'],
                       	'role_id'=> $d['role_id'],
                       	'status' => $d['status'],
                       	'branch' => $d['branch'],
                       	'client_id' => $d['client_id'],
                    );
    		        
    		      //  print_r($data);
    		        
    		        $q=$this->db->query("select * from module_creation where module_id = $module_id");
    		        if($q->num_rows() > 0)
    		        {
    		            $this->db->where('module_id',$module_id);
    		            $result = $this->db->update('module_creation',$data);
    		            if($result == TRUE)
    		            {
    		                $res[] = $result;
    		            }
    		            else
    		            {
    		                $response = array(
        		                'id' => $module_id,
        		                'response' => $result,
    		                );
    		            }
    		        }
    		        else
    		        {
    		            $result = $this->db->insert('module_creation',$data);
    		            if($result > 0)
    		            {
    		                $res[] = $result;
    		            }
    		            else
    		            {
    		                $response = array(
        		                'id' => $module_id,
        		                'response' => $result,
    		                );
    		            }
    		        }
    		        
    		        $count = $count + 1;
    		    }
    		    
				// $result = $this->db->update_batch('module_creation', $updatedata, 'module_id');
			}
		}

		if($result == TRUE)
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Module Creation Updated Successfully for $rolename of $clientname.");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSMCU01 Module Creation Updation Failed!!!");
    		echo json_encode($JSON);
		}
	}
	
	// Add new outlet
	public function addNewOutlet() 
	{
	    $content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        
        $outId = $decoded['outId'];
		$client_id = $decoded['client_id'];
		$branch = $decoded['branch'];
		$branch_title = $decoded['branch_title'];
		$brslno = $decoded['branch_slno'];
		$invoice_prefix = $decoded['invoice_prefix'];
		$org_name = $decoded['org_name'];
		$land_no = $decoded['land_no'];
		$mobile = $decoded['mobile'];
		$email_id = $decoded['email_id'];
		$gstin_no = $decoded['gstin_no'];
		$address1 = $decoded['address1'];
		$address2 = $decoded['address2'];
		$website_name = $decoded['website_name'];
					
		$effective_from = $decoded['effective_from'];
		$status = $decoded['status'];
		$cin_no = $decoded['cin_no'];
		$data_transfer = $decoded['data_transfer'];
		
		$userInfo = array('outId'=>$outId ,'branch_title'=>$branch_title,'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client_id, 'land_no'=>$land_no, 'mobile'=> $mobile,
		'email_id'=>$email_id, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'status'=>$status, 'data_transfer' => $data_transfer,'cin_no' => $cin_no);
		
		
		$q=$this->db->query("SELECT * FROM outlet_deatils a, client_creation b where a.client_id = b.client_id and a.client_id = $client_id and a.branch = '$branch'");
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Outlet Creation Successful");
    		echo json_encode($JSON);
		}
		else
		{
            $res = $this->db->insert('outlet_deatils', $userInfo);

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Outlet Creation Successful");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSAO01 Failed to Create Outlet!");
    			echo json_encode($JSON);
			}
		}
	}
	
	// update Outlet Details
	public function updateOutletDetails() 
	{
	    $content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);

		$outid = $decoded['outid'];
		$client = $decoded['client_id'];
		$branch = $decoded['branch'];		
		$branch_title = $decoded['branch_title'];
		$brslno = $decoded['branch_slno'];
		$invoice_prefix = $decoded['invoice_prefix'];
		$org_name = $decoded['org_name'];
		$land_no = $decoded['land_no'];
		$mobile_no = $decoded['mobile'];
		$branch_email = $decoded['email_id'];
		$gstin_no = $decoded['gstin_no'];
		$address1 = $decoded['address1'];
		$address2 = $decoded['address2'];
		$website_name = $decoded['website_name'];
		
		date_default_timezone_set('Asia/Kolkata');			
		$effective_from = $decoded['effective_from'];
		$status = $decoded['status'];
		$data_transfer = $decoded['data_transfer'];
		$cin_no = $decoded['cin_no'];

		$old_client = $decoded['old_client'];
		$old_branch = $decoded['old_branch'];	
		
		if(empty($status))
		{
			if($data_transfer == 'inactive')
			{
				$userInfo = array('branch_title'=>$branch_title,'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no,
			'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'data_transfer' => 'inactive','cin_no' => $cin_no);
			}
			else
			{
				$userInfo = array('branch_title'=>$branch_title,'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no,
			'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'data_transfer' => 'pending','cin_no' => $cin_no);
			}
		}
		else
		{
			if($data_transfer == 'inactive')
			{
				$userInfo = array('branch_title'=>$branch_title,'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no,
			'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'status'=>$status, 'data_transfer' => 'inactive','cin_no' => $cin_no);
			}
			else
			{
				$userInfo = array('branch_title'=>$branch_title,'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no,
			'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'status'=>$status, 'data_transfer' => 'pending', 'cin_no' => $cin_no);
			}	
		}

		if(($client == $old_client) && (strcasecmp($branch, $old_branch) == 0))
		{
			$this->db->where('outId', $outid);
		    $this->db->update('outlet_deatils', $userInfo);
		    $total = $this->db->affected_rows();
        	if($total>0)
        	{
        	    $result = 'true';
        	}
        	else
        	{
        	    $result = 'false';
        	}
		}
		else
		{
			$q=$this->db->query("SELECT * FROM outlet_deatils a, client_creation b where a.client_id = b.client_id and a.client_id = $client and a.branch = '$branch'");
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Outlet updated successfully.");
    			echo json_encode($JSON);
			}
			else
			{
				$this->db->where('outId', $outid);
    		    $this->db->update('outlet_deatils', $userInfo);
    		    $total = $this->db->affected_rows();
            	if($total>0)
            	{
            	    $result = 'true';
            	}
            	else
            	{
            	    $result = 'false';
            	}
			}
		}
		
		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Outlet updated Successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSUO01 Outlet Updation Failed!!!");
    		echo json_encode($JSON);
		}
	}
	
	//API for Approve Outlet
	public function approveOutlet()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        $clientid = $decoded['clientid'];
		$outId = $decoded['outId'];

		$total = $this->db->query('update outlet_deatils set status = "Active", data_transfer = "pending" where outId ='.$outId.' and client_id ='.$clientid);	
		
		$total = $this->db->affected_rows();
    	if($total>0)
    	{
        	$result = 'true';
    	}
    	else
    	{
        	$result = 'false';
    	}

		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => " Outlet has been Approved");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSOA01 Outlet Approval Failed!!!");
    		echo json_encode($JSON);
		}
	}
	
	// API for Update User Details
	public function updateUserInfo()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);

        $userId = $decoded['userid'];
		$email = $decoded['email'];
		$password = $decoded['password'];
		$mobile = $decoded['mobile'];
		$updatedBy = $decoded['updatedBy'];

		$updatedDtm = $decoded['updatedDtm'];
		$prime_id = $decoded['prime_id'];

		date_default_timezone_set('Asia/Kolkata');
		$updated = date("Y-m-d H:i:s");
		
		if(empty($password))
		{
			$userInfo = array('email'=>$email,'mobile'=>$mobile,'updatedBy'=>$this->vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'));
		}
		else
		{
			$userInfo = array('email'=>$email, 'password'=>$password, 'mobile'=>$mobile, 'updatedBy'=>$vendorId, 
			'updatedDtm'=>date('Y-m-d H:i:s'), 'prime_id'=>$prime_id);
		}

		$this->db->where('userId', $userId);
		$this->db->update('users', $userInfo);
	    $total = $this->db->affected_rows();
    	if($total>0)
    	{
    	    $result = 'true';
    	}
    	else
    	{
    	    $result = 'false';
    	}
		
		
		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Profile Updated Successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CUSUP01 Profile Updation Failed!!!");
    		echo json_encode($JSON);
		}
	}

	// API for Add New Category Master
	public function addnewcategorymaster()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        $client = $decoded['client_id'];
        $category_name = $decoded['category_name'];
        $category_master_id = $decoded['category_master_id'];
        
        $q=$this->db->query("select * from category_master where category_name = '$category_name' and client_id = $client");
		if ($q->num_rows() > 0)
		{
		    $exist = 'true';
		}
		else
		{
		    $exist = 'false';   
		}
        
		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Category is Added.");
    		echo json_encode($JSON);
		}
		else
		{
			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");

			$data = array('category_master_id' => $category_master_id,'category_name'=>$category_name, 'client_id'=>$client, 'created'=> $created);

			// print_r($data);

// 			$res = $this->master_model->addCategoryMaster($data);
            $res = $this->db->insert('category_master', $data);
    		$insert_id = $this->db->insert_id();

		    if($res > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Category is Added");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSCM01 Failed to Add Category!");
    			echo json_encode($JSON);
			}
		}
	}

	// API for Update Category Master
	public function editCategoryMasterDetails()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);

		$categorymasterid = $decoded['category_master_id'];
		$client = $decoded['client_id'];
		$category_name = $decoded['category_name'];
		$category_master_id = $decoded['category_master_id'];

		$old_category_name = $decoded['old_category_name'];
		$old_client = $decoded['old_client'];

		date_default_timezone_set('Asia/Kolkata');
		$updated = date("Y-m-d H:i:s");

		$data = array('category_master_id' => $category_master_id, 'category_name'=>$category_name, 'client_id'=>$client, 'updated'=> $updated);

		if(($client == $old_client) && (strcasecmp($category_name, $old_category_name) == 0))
		{
			$this->db->where('category_master_id', $categorymasterid);
		    $this->db->update('category_master', $data);
		    $total = $this->db->affected_rows();
        	if($total>0)
        	{
        	    $result = 'true';
        	}
        	else
        	{
        	    $result = 'false';
        	}
		}
		else
		{
		    $q=$this->db->query("select * from category_master where category_name = '$category_name' and client_id = $client");
    		if ($q->num_rows() > 0)
    		{
    		    $exist = 'true';
    		}
    		else
    		{
    		    $exist = 'false';   
    		}
            
    		if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "Category updated successfully.");
    			echo json_encode($JSON);
			}
			else
			{
				$this->db->where('category_master_id', $categorymasterid);
    		    $this->db->update('category_master', $data);
    		    $total = $this->db->affected_rows();
            	if($total>0)
            	{
            	    $result = 'true';
            	}
            	else
            	{
            	    $result = 'false';
            	}
			}
		}
		
		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Category updated successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSCM02 Category updation failed!!!");
    		echo json_encode($JSON);
		}
	}


	// API for Add New Category
	public function insertNewCategory()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
		$clientid = $decoded['client_id'];
		$branch = $decoded['branch'];
		$category = $decoded['pr_cat_code'];
		$cat_name = $decoded['pr_cat_name'];

		$effect_date = $decoded['effective_from'];
		$discount = $decoded['discount'];
		$status = $decoded['status'];
		$pr_cat_id = $decoded['pr_cat_id'];

		$effectdate = date('Y-m-d',strtotime($effect_date));
		$date = date('Y-m-d');
		$data = array('pr_cat_id' => $pr_cat_id,
					'pr_cat_name'=> $cat_name,
					  'discount' => $discount,
					  'cr_discount' => '0',
					  'status' => $status,
					  'effective_from' => $effectdate,
					  'created' =>$date,
					  'data_transfer'=>'pending',
					  'client_id' =>$clientid,
					  'branch' =>$branch,
					  'pr_cat_code'=>$category
					);

		$q=$this->db->query("SELECT a.*, b.* from product_category a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch = '$branch' and a.pr_cat_name = '$cat_name'");
		if ($q->num_rows() > 0)
		{
			$exist = 'true';
		}
        else
        {
        	$exist = 'false';
        }
        

		if($exist == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "New Category created successfully.");
    		echo json_encode($JSON);
		}
		else
		{

			$result = $this->db->insert('product_category',$data);

			if($result > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "New Category created successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSC01 Category creation failed!!!");
    			echo json_encode($JSON);
			}
		}
	}


	// API for Edit Category
	public function updateCategoryDetails()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
		
		$clientid = $decoded['client_id'];
		$branch = $decoded['branch'];
		$category = $decoded['pr_cat_code'];
		$cat_name = $decoded['pr_cat_name'];
		$categoryId = $decoded['pr_cat_id'];

		$old_clientid = $decoded['old_clientid'];
		$old_branch = $decoded['old_branch'];
		$old_category = $decoded['old_category'];

		$effect_date = $decoded['effective_from'];
		$discount = $decoded['discount'];
		$status = $decoded['status'];
		$cr_discount = $decoded['cr_discount'];

		$effectdate = date('Y-m-d',strtotime($effect_date));
		$date = date('Y-m-d');

		$data = array('pr_cat_id' => $categoryId,
						'pr_cat_name'=> $cat_name,
					  'discount' => $discount,
					  'cr_discount' => $cr_discount,
					  'status' => $status,
					  'effective_from' => $effectdate,
					  'updated' =>$date,
					  'data_transfer'=>'pending',
					  'client_id' =>$clientid,
					  'branch' =>$branch,
					  'pr_cat_code'=>$category
					);


		if(($clientid == $old_clientid) && (strcasecmp($branch, $old_branch) == 0) && (strcasecmp($cat_name, $old_category) == 0))
		{
			$this->db->where('pr_cat_id', $categoryId);
			$this->db->update('product_category', $data);
			$total = $this->db->affected_rows();
	    	if($total>0)
	    	{
	        	$result = 'true';
	    	}
	    	else
	    	{
	        	$result = 'false';
	    	}
		}
		else
		{
			$q=$this->db->query("SELECT a.*, b.* from product_category a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch = '$branch' and a.pr_cat_name = '$cat_name'");
			if ($q->num_rows() > 0)
			{
				$exist = 'true';
			}
	        else
	        {
	        	$exist = 'false';
	        }
	        

			if($exist == 'true')
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => " Category updated successfully.");
    			echo json_encode($JSON);
			}
			else
			{
				$this->db->where('pr_cat_id', $categoryId);
				$this->db->update('product_category', $data);
				$total = $this->db->affected_rows();
		    	if($total>0)
		    	{
		        	$result = 'true';
		    	}
		    	else
		    	{
		        	$result = 'false';
		    	}
			}			
		}
		
		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => " Category updated successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSC02 Category updation failed!!!");
    		echo json_encode($JSON);
		}
	}

	// API for Add New Product
// 	public function insertNewProductsOld()
// 	{
// 		$content = trim(file_get_contents("php://input"));
//         $decoded = json_decode($content, true);
// 		$clientid = $decoded['client_id'];
// 		$branch = $decoded['branch'];
// 		$categoryId = $decoded['pr_cat_id'];
// 		$product_name = $decoded['product_name'];
// 		$product_code = $decoded['product_code'];
// 		$product_uom = $decoded['uom'];
// 		$product_price = $decoded['price'];
// 		$basic_product_price = $decoded['basic_rate'];
// 		$tax_pecentage = $decoded['basic_tax_percent'];
// 		$basic_tax_amount = $decoded['basic_tax_amount'];
// 		$cgst_price = $decoded['cgst_tax_amount'];
// 		$sgst_price = $decoded['sgst_tax_amount'];
// 		$cgst_tax = $decoded['cgst_tax'];
// 		$sgst_tax = $decoded['sgst_tax'];

// 		$product_stock = $decoded['product_stock'];
// 		$product_status = $decoded['product_status'];
// 		$product_hsn = $decoded['hsn_code'];
// 		$effective = $decoded['effective_from'];
// 		$cat_token = $decoded['token'];
// 		$token_group = $decoded['tokengroup'];

// 		$social_order = $decoded['social_order'];
// 		$sales_item_type = $decoded['sales_item_type'];
// 		$product_type = $decoded['product_type'];
// 		$combination = $decoded['combination'];
// 		$stock_status = $decoded['stock_status'];
// 		$stock_limit = $decoded['stock_limit'];

// 		$effectdate = date('Y-m-d',strtotime($effective));
// 		$sorting_order = $decoded['sorting_order'];
		
// 		$date = date('Y-m-d');

// 		$cat_discount = $decoded['cat_discount'];
// 		$cat_id = $decoded['cat_id'];
// 		$pr_id = $decoded['pr_id'];
		
// 		// $cat_discount = $this->input->post('cat_discount');

// 		$data = array('pr_id' => $pr_id,
// 						'product_name'=> $product_name,
// 						  'hsn_code' => $product_hsn,
// 							  'product_no' => $product_code,
// 						  'product_code'=>$product_code,
// 						  'uom'=> $product_uom,
// 						  'basic_rate'=>$basic_product_price,
// 						  'basic_tax_percent'=>$tax_pecentage,
// 						  'basic_tax_amount'=>$basic_tax_amount, 
// 						  'sgst_tax'=>$sgst_tax,
// 						  'sgst_tax_amount'=>$sgst_price,
// 						  'cgst_tax'=>$cgst_tax,
// 						  'cgst_tax_amount'=>$cgst_price,
// 						  'price'=>$product_price,
// 						  'discount_perc'=>$cat_discount,
// 						  'product_stock'=> $product_stock,
// 						  'product_status'=>$product_status,
// 						  'pr_cat_id'=>$categoryId,
// 						  'effective_from' =>$effectdate,
// 						  'created'=> $date,
// 						  'client_id'=>$clientid,
// 						  'branch' => $branch,
// 						  'data_transfer' =>'pending',
// 						  'token' =>$cat_token,
// 						  'tokengroup' =>$token_group,
// 						  'social_order' => $social_order,
// 						  'sales_item_type' => $sales_item_type,
// 						  'product_type' => $product_type,
// 						  'combination' => $combination,
// 						  'stock_status' => $stock_status,
// 						  'stock_limit' => $stock_limit,
// 						  'sorting_order' => $sorting_order,
// 						  'cat_id' => $cat_id
// 						);

// 		$q=$this->db->query("SELECT * from product a, client_creation b, product_category c where a.client_id = b.client_id and a.pr_cat_id = c.pr_cat_id and a.client_id = $clientid and a.branch = '$branch' and a.pr_cat_id = $categoryId and a.product_name = '$product_name' and a.social_order = $social_order");
// 		if ($q->num_rows() > 0)
// 		{
// 			$exist = 'true';
// 		}
//         else
//         {
//         	$exist = 'false';
//         }
	        

// 		if($exist == 'true')
// 		{
// 			$JSON = array("statuscode" => "200", "status" => "success", "response" => " New Products created successfully.");
//     		echo json_encode($JSON);
// 		}
// 		else
// 		{
// 		// print_r($data);
// 			$result = $this->db->insert('product',$data);

// 			if($result > 0)
// 			{
// 				$JSON = array("statuscode" => "200", "status" => "success", "response" => " New Products created successfully");
//     			echo json_encode($JSON);
// 			}
// 			else
// 			{
// 				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSP01 Products creation failed!!!");
//     			echo json_encode($JSON);
// 			}
// 		}
// 	}

    public function insertNewProducts()
	{
		header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $s1 = $row['Products'];
        if($s1 != null)
        {
            foreach ($s1 as $r1) 
            {
    			$data[] =  array('pr_id' => $r1['pr_id'],
						  'product_name'=> $r1['product_name'],
						  'hsn_code' => $r1['hsn_code'],
						  'product_no' => $r1['product_no'],
						  'product_code'=>$r1['product_code'],
						  'uom'=> $r1['uom'],
						  'basic_rate'=>$r1['basic_rate'],
						  'basic_tax_percent'=>$r1['basic_tax_percent'],
						  'basic_tax_amount'=>$r1['basic_tax_amount'], 
						  'sgst_tax'=>$r1['sgst_tax'],
						  'sgst_tax_amount'=>$r1['sgst_tax_amount'],
						  'cgst_tax'=>$r1['cgst_tax'],
						  'cgst_tax_amount'=>$r1['cgst_tax_amount'],
						  'price'=>$r1['price'],
						  'discount_perc'=>$r1['discount_perc'],
						  'product_stock'=> $r1['product_stock'],
						  'product_status'=>$r1['product_status'],
						  'pr_cat_id'=>$r1['pr_cat_id'],
						  'effective_from' =>$r1['effective_from'],
						  'created'=> $r1['created'],
						  'client_id'=>$r1['client_id'],
						  'branch' => $r1['branch'],
						  'data_transfer' =>'pending',
						  'token' =>$r1['token'],
						  'tokengroup' =>$r1['tokengroup'],
						  'social_order' => $r1['social_order'],
						  'sales_item_type' => $r1['sales_item_type'],
						  'product_type' => $r1['product_type'],
						  'combination' => $r1['combination'],
						  'stock_status' => $r1['stock_status'],
						  'stock_limit' => $r1['stock_limit'],
						  'sorting_order' => $r1['sorting_order'],
						  'barcode_number' => $r1['barcode_number'],
						  'cat_id' => $r1['cat_id']
						);
						
					$clientid = $r1['client_id'];
					$branch = $r1['branch'];
					$categoryId = $r1['pr_cat_id'];
					$product_name = $r1['product_name'];
					$social_order = $r1['social_order'];
					
				// 	print_r($data);
						
            }
            
            $response = $this->db->insert_batch('product',$data);
            if($response > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => " New Products <b>".$product_name."</b> Added successfully");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "300", "status" => "failed", "response" => "ERR-CMSP01 Failed to Add New Products!!!");
    			echo json_encode($JSON);
			}
        }
        else
        {
            $JSON = array("statuscode" => "400", "status" => "failed", "response" => "Null Values from the Source");
    		echo json_encode($JSON);
        }
	}

    // API for Multi Add Product
	public function insertNewMultiProducts()
	{
		header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $s1 = $row['Multi_Products'];
        if($s1 != null)
        {
            foreach ($s1 as $r1) 
            {
    			$data[] =  array('pr_id' => $r1['pr_id'],
						  'product_name'=> $r1['product_name'],
						  'hsn_code' => $r1['hsn_code'],
						  'product_no' => $r1['product_no'],
						  'product_code'=>$r1['product_code'],
						  'uom'=> $r1['uom'],
						  'basic_rate'=>$r1['basic_rate'],
						  'basic_tax_percent'=>$r1['basic_tax_percent'],
						  'basic_tax_amount'=>$r1['basic_tax_amount'], 
						  'sgst_tax'=>$r1['sgst_tax'],
						  'sgst_tax_amount'=>$r1['sgst_tax_amount'],
						  'cgst_tax'=>$r1['cgst_tax'],
						  'cgst_tax_amount'=>$r1['cgst_tax_amount'],
						  'price'=>$r1['price'],
						  'discount_perc'=>$r1['discount_perc'],
						  'product_stock'=> $r1['product_stock'],
						  'product_status'=>$r1['product_status'],
						  'pr_cat_id'=>$r1['pr_cat_id'],
						  'effective_from' =>$r1['effective_from'],
						  'created'=> $r1['created'],
						  'client_id'=>$r1['client_id'],
						  'branch' => $r1['branch'],
						  'data_transfer' =>'pending',
						  'token' =>$r1['token'],
						  'tokengroup' =>$r1['tokengroup'],
						  'social_order' => $r1['social_order'],
						  'sales_item_type' => $r1['sales_item_type'],
						  'product_type' => $r1['product_type'],
						  'combination' => $r1['combination'],
						  'stock_status' => $r1['stock_status'],
						  'stock_limit' => $r1['stock_limit'],
						  'sorting_order' => $r1['sorting_order'],
						  'barcode_number' => $r1['barcode_number'],
						  'cat_id' => $r1['cat_id']
						);
						
					$clientid = $r1['client_id'];
					$branch = $r1['branch'];
					$categoryId = $r1['pr_cat_id'];
					$product_name = $r1['product_name'];
					$social_order = $r1['social_order'];
					
				// 	print_r($data);
						
            }
            
            $response = $this->db->insert_batch('product',$data);
            if($response > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => " New Products <b>".$product_name."</b> Added successfully for All Branches");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "300", "status" => "failed", "response" => "ERR-CMSP01 Failed to Add New Products to All Branches!!!");
    			echo json_encode($JSON);
			}
        }
        else
        {
            $JSON = array("statuscode" => "400", "status" => "failed", "response" => "Null Values from the Source");
    		echo json_encode($JSON);
        }
	}

	// API for Update Product
// 	public function updateProductsDetailsOld()
// 	{
// 		$content = trim(file_get_contents("php://input"));
//         $decoded = json_decode($content, true);
// 		$clientid = $decoded['client_id'];
// 		$branch = $decoded['branch'];
// 		$produtsId = $decoded['pr_id'];
// 		$categoryId = $decoded['pr_cat_id'];
// 		$product_name = $decoded['product_name'];
// 		$product_code = $decoded['product_code'];
// 		$product_uom = $decoded['uom'];
// 		$product_price = $decoded['price'];
// 		$basic_product_price = $decoded['basic_rate'];
// 		$tax_pecentage = $decoded['basic_tax_percent'];
// 		$basic_tax_amount = $decoded['basic_tax_amount'];
// 		$cgst_price = $decoded['cgst_tax_amount'];
// 		$sgst_price = $decoded['sgst_tax_amount'];
// 		$cgst_tax = $decoded['cgst_tax'];
// 		$sgst_tax = $decoded['sgst_tax'];

// 		$product_stock = $decoded['product_stock'];
// 		$product_status = $decoded['product_status'];
// 		$product_hsn = $decoded['hsn_code'];
// 		$effective = $decoded['effective_from'];
// 		$cat_token = $decoded['token'];
// 		$token_group = $decoded['tokengroup'];

// 		$social_order = $decoded['social_order'];
// 		$sales_item_type = $decoded['sales_item_type'];
// 		$product_type = $decoded['product_type'];
// 		$combination = $decoded['combination'];
// 		$stock_status = $decoded['stock_status'];
// 		$stock_limit = $decoded['stock_limit'];

// 		$old_clientid = $decoded['old_clientid'];
// 		$old_branch = $decoded['old_branch'];
// 		$old_categoryId = $decoded['old_categoryId'];
// 		$old_product_name = $decoded['old_product_name'];
// 		$old_social_order = $decoded['old_social_order'];

// 		$effectdate = date('Y-m-d',strtotime($effective));
// 		$sorting_order = $decoded['sorting_order'];
// 		$date = date('Y-m-d');

		
// 		$cat_discount = $decoded['cat_discount'];
// 		$cat_id = $decoded['cat_id'];

// 		$pr_id = $decoded['pr_id'];

// 		$data = array('pr_id' => $pr_id,
// 						'product_name'=> $product_name,
// 						  'hsn_code' => $product_hsn,
// 							  'product_no' => $product_code,
// 						  'product_code'=>$product_code,
// 						  'uom'=> $product_uom,
// 						  'basic_rate'=>$product_price,
// 						  'basic_tax_percent'=>$tax_pecentage,
// 						  'basic_tax_amount'=>$basic_tax_amount, 
// 						  'sgst_tax'=>$sgst_tax,
// 						  'sgst_tax_amount'=>$sgst_price,
// 						  'cgst_tax'=>$cgst_tax,
// 						  'cgst_tax_amount'=>$cgst_price,
// 						  'price'=>$basic_product_price,
// 						  'discount_perc'=>$cat_discount,
// 						  'product_stock'=> $product_stock,
// 						  'product_status'=>$product_status,
// 						  'pr_cat_id'=>$categoryId,
// 						  'effective_from' =>$effectdate,
// 						  'created'=> $date,
// 						  'updated' =>$date,
// 						  'branch' => $branch,
// 						  'client_id'=>$clientid,
// 						  'data_transfer' =>'pending',
// 						  'token' =>$cat_token,
// 						  'tokengroup' =>$token_group,
// 						  'social_order' => $social_order,
// 						  'sales_item_type' => $sales_item_type,
// 						  'product_type' => $product_type,
// 						  'combination' => $combination,
// 						  'stock_status' => $stock_status,
// 						  'stock_limit' => $stock_limit,
// 						  'sorting_order' => $sorting_order,
// 						  'cat_id' => $cat_id
// 						);

// 		// echo $clientid." : ".$old_clientid." - ";
// 		// echo $categoryId." : ".$old_categoryId." - ";
// 		// echo $branch." : ".$old_branch." - ";
// 		// echo $product_name." : ".$old_product_name." - ";
// 		if(($clientid == $old_clientid) && ($categoryId == $old_categoryId) && (strcasecmp($branch, $old_branch) == 0) && (strcasecmp($product_name, $old_product_name) == 0) && ($social_order == $old_social_order))
// 		{
// 			$this->db->where('pr_id', $produtsId);
// 			$this->db->update('product', $data);
// 			$total = $this->db->affected_rows();
// 	    	if($total>0)
// 	    	{
// 	        	$result = 'true';
// 	    	}
// 	    	else
// 	    	{
// 	        	$result = 'false';
// 	    	}
// 		}
// 		else
// 		{
// 			$q=$this->db->query("SELECT * from product a, client_creation b, product_category c where a.client_id = b.client_id and a.pr_cat_id = c.pr_cat_id and a.client_id = $clientid and a.branch = '$branch' and a.pr_cat_id = $categoryId and a.product_name = '$product_name' and a.social_order = $social_order");
// 			if ($q->num_rows() > 0)
// 			{
// 				$exist = 'true';
// 			}
// 	        else
// 	        {
// 	        	$exist = 'false';
// 	        }
	        

// 			if($exist == 'true')
// 			{
// 				$JSON = array("statuscode" => "200", "status" => "success", "response" => "  Product updated successfully.");
//     			echo json_encode($JSON);
// 			}
// 			else
// 			{
// 				$this->db->where('pr_id', $produtsId);
// 				$this->db->update('product', $data);
// 				$total = $this->db->affected_rows();
// 		    	if($total>0)
// 		    	{
// 		        	$result = 'true';
// 		    	}
// 		    	else
// 		    	{
// 		        	$result = 'false';
// 		    	}
// 			}			
// 		}

// 		if($result == 'true')
// 		{
// 			$JSON = array("statuscode" => "200", "status" => "success", "response" => "  Product updated successfully");
//     		echo json_encode($JSON);
// 		}
// 		else
// 		{
// 			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSP02 Product updation failed!!!");
//     		echo json_encode($JSON);
// 		}
// 	}

    public function updateProductsDetails()
	{
	    header('Content-type: application/json');
        $row = json_decode(file_get_contents('php://input'),true);
        
        $s1 = $row['Products'];
        if($s1 != null)
        {
            $no_of_products = 0;
            $total_updates = 0;
            foreach ($s1 as $r1) 
            {
                $no_of_products = $no_of_products + 1;
    			$data =  array('pr_id' => $r1['pr_id'],
						  'product_name'=> $r1['product_name'],
						  'hsn_code' => $r1['hsn_code'],
						  'product_code' => $r1['product_code'],
						  'uom'=> $r1['uom'],
						  'basic_rate'=>$r1['basic_rate'],
						  'basic_tax_percent'=>$r1['basic_tax_percent'],
						  'basic_tax_amount'=>$r1['basic_tax_amount'], 
						  'sgst_tax'=>$r1['sgst_tax'],
						  'sgst_tax_amount'=>$r1['sgst_tax_amount'],
						  'cgst_tax'=>$r1['cgst_tax'],
						  'cgst_tax_amount'=>$r1['cgst_tax_amount'],
						  'price'=>$r1['price'],
						  'discount_perc'=>$r1['discount_perc'],
						  'product_stock'=> $r1['product_stock'],
						  'product_status'=>$r1['product_status'],
						  'pr_cat_id'=>$r1['pr_cat_id'],
						  'effective_from' =>$r1['effective_from'],
						  'client_id'=>$r1['client_id'],
						  'branch' => $r1['branch'],
						  'data_transfer' =>'pending',
						  'token' =>$r1['token'],
						  'tokengroup' =>$r1['tokengroup'],
						  'social_order' => $r1['social_order'],
						  'sales_item_type' => $r1['sales_item_type'],
						  'product_type' => $r1['product_type'],
						  'combination' => $r1['combination'],
						  'stock_status' => $r1['stock_status'],
						  'stock_limit' => $r1['stock_limit'],
						  'sorting_order' => $r1['sorting_order'],
						  'barcode_number' => $r1['barcode_number'],
						  'cat_id' => $r1['cat_id'],
						  'pr_id' => $r1['pr_id']
						);
						
				$pr_id = $r1['pr_id'];
				$product_name = $r1['product_name'];
				
				// 	print_r($data);
				
				$query=$this->db->query("select * from product where pr_id = $pr_id");
        		if($query->num_rows() > 0)
        		{
        		    $this->db->where('pr_id', $pr_id);
            		$result = $this->db->update('product', $data);
            		$total = $this->db->affected_rows();
            		if($total>0)
    		    	{
    		        	$total_updates = $total_updates + 1;
    		    	}
        		}
        		else
        		{
        		    $this->db->insert('product', $data);
        		    $total = $this->db->affected_rows();
            		if($total>0)
    		    	{
    		        	$total_updates = $total_updates + 1;
    		    	}
        		}
            }
            
            if($no_of_products == $total_updates)
            {
                $resp = "true";    
            }
            else
            {
                $resp = "false";
            }
            
            // echo "Resp :".$resp." last id : ".$lastid." no of prods : ".$no_of_products." total updates : ".$total_updates;
            
            if($resp == "true")
    		{
    			$JSON = array("statuscode" => "200", "status" => "success", "response" => "Product <b>".$product_name."</b> updated successfully");
        		echo json_encode($JSON);
    		}
    		else
    		{
    			$JSON = array("statuscode" => "300", "status" => "failed", "response" => "ERR-CMSP02 Product updation failed!!!");
        		echo json_encode($JSON);
    		}
        }
        else
        {
            $JSON = array("statuscode" => "400", "status" => "failed", "response" => "Null Values from the Source");
    		echo json_encode($JSON);
        }
	}

	// API for Add New User
	public function addNewUser()
	{
		// $name = ucwords(strtolower($this->input->post('fname')));
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
		$name = $decoded['name'];
		$email = $decoded['email'];
		$prime_id = $decoded['prime_id'];
		$password = $decoded['password'];
		$mobile = $decoded['mobile'];
		$clientid = $decoded['client_id'];
		$branch = $decoded['branch'];
		$roleId = $decoded['roleId'];
		date_default_timezone_set('Asia/Kolkata');
		$effective_from = date("Y-m-d", strtotime($decoded['effective_from']));
		$userId = $decoded['userId'];
		//$pSalt1="2345#$%@3e";
		//$pSalt2="taesa%#@2%^#";
		//$hashPassword = sha1(md5($pSalt2 . $password . $pSalt1));
		
		$vendorId = $decoded['createdBy'];
		$userInfo = array('userId' => $userId,'email'=>$email, 'password'=>$password, 'roleId'=>$roleId, 'name'=> $name,
		'mobile'=>$mobile, 'createdBy'=>$vendorId, 'createdDtm'=>date('Y-m-d H:i:s'), 'client_id'=>$clientid, 'branch'=>$branch, 'prime_id'=>$prime_id,'status'=>'Pending', 'effective_from'=>$effective_from,'data_transfer' => 'inactive');
		$this->load->model('master_model');


		if($roleId == '3')
		{
			$q = $this->db->query("select * from users a where email = '$email' and client_id = $clientid and branch = '$branch'");
	        if ($q->num_rows() > 0)
			{
				$exist = 'true';
			}
	        else
	        {
	        	$exist = 'false';
	        }
		}
		else
		{
			$q = $this->db->query("select * from users a where email ='".$email."'");
	        if ($q->num_rows() > 0)
			{
				$exist = 'true';
			}
	        else
	        {
	        	$exist = 'false';
	        }
		} 
		

		if($exist == 'true')	
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => "  New User ".$name." created.");
    		echo json_encode($JSON);
		}	
		else
		{
			$result = $this->db->insert('users', $userInfo);
			if($result > 0)
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => "  New User ".$name." created");
    			echo json_encode($JSON);
			}
			else
			{
				$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSU01 User creation failed!!!");
    			echo json_encode($JSON);
			}
		}
	}

	//API for edit user
	public function editUser()
	{
		// $name = ucwords(strtolower($this->input->post('fname')));
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        $userId = $decoded['userId'];
		$name = $decoded['name'];
		$email = $decoded['email'];
		$prime_id = $decoded['prime_id'];
		$password = $decoded['password'];
		$mobile = $decoded['mobile'];
		$clientid = $decoded['client_id'];
		$branch = $decoded['branch'];
		$roleId = $decoded['roleId'];
		$data_transfer = $decoded['data_transfer'];
		date_default_timezone_set('Asia/Kolkata');
		$effective_from = date("Y-m-d", strtotime($decoded['effective_from']));
		//$pSalt1="2345#$%@3e";
		//$pSalt2="taesa%#@2%^#";
		//$hashPassword = sha1(md5($pSalt2 . $password . $pSalt1));
		$vendorId = $decoded['updatedBy'];
		$old_email = $decoded['old_email'];
		$old_clientid = $decoded['old_clientid'];
		$old_branch = $decoded['old_branch'];
		$status = $decoded['status'];
		$userInfo = array();
		if(empty($prime_id))
		{
			if(empty($status))
			{
				if($data_transfer == 'inactive')
				{
					$userInfo = array('email'=>$email, 'roleId'=>$roleId, 'name'=>$name,
			'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'),'client_id' => $clientid, 'branch' => $branch, 'effective_from' => $effective_from, 'data_transfer' => 'inactive', 'updated' => date('Y-m-d'));	
				}
				else
				{
					$userInfo = array('email'=>$email, 'roleId'=>$roleId, 'name'=>$name,
			'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'),'client_id' => $clientid, 'branch' => $branch, 'effective_from' => $effective_from,'data_transfer' => 'pending', 'updated' => date('Y-m-d'));	
				}
			}
			else
			{
				if($data_transfer == 'inactive')
				{
					$userInfo = array('email'=>$email, 'roleId'=>$roleId, 'name'=>$name,
			'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'), 'status'=>$status, 'client_id' => $clientid, 'branch' => $branch, 'effective_from' => $effective_from, 'data_transfer' => 'inactive', 'updated' => date('Y-m-d'));	
				}
				else
				{
					$userInfo = array('email'=>$email, 'roleId'=>$roleId, 'name'=>$name,
			'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'), 'status'=>$status, 'client_id' => $clientid, 'branch' => $branch, 'effective_from' => $effective_from, 'data_transfer' => 'pending', 'updated' => date('Y-m-d'));
				}
			}	
		}
		else
		{
			if(empty($status))
			{
				if($data_transfer == 'inactive')
				{
					$userInfo = array('email'=>$email, 'password'=>$password, 'roleId'=>$roleId,
				'name'=>$name, 'mobile'=>$mobile, 'updatedBy'=>$vendorId, 
				'updatedDtm'=>date('Y-m-d H:i:s'),'client_id'=>$clientid , 'branch'=>$branch, 'prime_id'=>$prime_id, 'effective_from' => $effective_from, 'data_transfer' => 'inactive', 'updated' => date('Y-m-d'));
				}
				else
				{
					$userInfo = array('email'=>$email, 'password'=>$password, 'roleId'=>$roleId,
			'name'=>$name, 'mobile'=>$mobile, 'updatedBy'=>$vendorId, 
			'updatedDtm'=>date('Y-m-d H:i:s'),'client_id'=>$clientid , 'branch'=>$branch, 'prime_id'=>$prime_id, 'effective_from' => $effective_from, 'data_transfer' => 'pending', 'updated' => date('Y-m-d'));	
				}
			}
			else
			{
				if($data_transfer == 'inactive')
				{
					$userInfo = array('email'=>$email, 'password'=>$password, 'roleId'=>$roleId,
				'name'=>$name, 'mobile'=>$mobile, 'updatedBy'=>$vendorId, 
				'updatedDtm'=>date('Y-m-d H:i:s'),'client_id'=>$clientid , 'branch'=>$branch, 'prime_id'=>$prime_id, 'status'=>$status, 'effective_from' => $effective_from, 'data_transfer' => 'inactive', 'updated' => date('Y-m-d'));
				}
				else
				{
					$userInfo = array('email'=>$email, 'password'=>$password, 'roleId'=>$roleId,
				'name'=>$name, 'mobile'=>$mobile, 'updatedBy'=>$vendorId, 
				'updatedDtm'=>date('Y-m-d H:i:s'),'client_id'=>$clientid , 'branch'=>$branch, 'prime_id'=>$prime_id, 'status'=>$status, 'effective_from' => $effective_from, 'data_transfer' => 'pending', 'updated' => date('Y-m-d'));	
				}
			}
		}		

		if(($clientid == $old_clientid) && (strcasecmp($branch, $old_branch) == 0) && (strcasecmp($email, $old_email) == 0))
		{
			$this->db->where('userId', $userId);
			$this->db->update('users', $userInfo);
	    	$total = $this->db->affected_rows();
	    	if($total>0)
	    	{
	        	$result = 'true';
	    	}
	    	else
	    	{
	        	$result = 'false';
	    	}
		}
		else
		{
			if($roleId == '3')
			{
				$q = $this->db->query("select * from users a where email = '$email' and client_id = $clientid and branch = '$branch'");
		        if ($q->num_rows() > 0)
				{
					$exist = 'true';
				}
		        else
		        {
		        	$exist = 'false';
		        }
			}
			else
			{
				$q = $this->db->query("select * from users a where email ='".$email."'");
		        if ($q->num_rows() > 0)
				{
					$exist = 'true';
				}
		        else
		        {
		        	$exist = 'false';
		        }
			}
	        

			if($exist == 'true')	
			{
				$JSON = array("statuscode" => "200", "status" => "success", "response" => " User updated successfully.");
    			echo json_encode($JSON);
			}	
			else
			{
				$this->db->where('userId', $userId);
				$this->db->update('users', $userInfo);
		    	$total = $this->db->affected_rows();
		    	if($total>0)
		    	{
		        	$result = 'true';
		    	}
		    	else
		    	{
		        	$result = 'false';
		    	}	
			}
		}

		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => " User updated successfully");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSU02 User updation failed!!!");
    		echo json_encode($JSON);
		}
	}

	//API for Approve User
	public function approveUser()
	{
		$content = trim(file_get_contents("php://input"));
        $decoded = json_decode($content, true);
        $clientid = $decoded['clientid'];
		$userid = $decoded['userid'];

		$total = $this->db->query('update client_creation set status = "Active" where client_id ='.$clientid);

		$total = $this->db->query('update users set status = "Active", data_transfer = "pending" where userId ='.$userid);	
		
		$total = $this->db->affected_rows();
    	if($total>0)
    	{
        	$result = 'true';
    	}
    	else
    	{
        	$result = 'false';
    	}

		if($result == 'true')
		{
			$JSON = array("statuscode" => "200", "status" => "success", "response" => " User has been Approved");
    		echo json_encode($JSON);
		}
		else
		{
			$JSON = array("statuscode" => "400", "status" => "failed", "response" => "ERR-CMSU03 User Approval Failed!!!");
    		echo json_encode($JSON);
		}
	}


	// public function insertZipcode()
	// {
	// 	$content = trim(file_get_contents("php://input"));
 //        $decoded = json_decode($content, true);
 //        $storeid = $decoded['store_id'];
 //        $zipcode = $decoded['zip_code'];
 //        $status = $decoded['status'];

 //        $data = array(
 //        	'store_id' => $storeid, 
 //        	'zip_code' => $zipcode,
 //        	'status' => $status 
 //        );
		
	// 	// date_default_timezone_set("Asia/Kolkata");
	// 	// $created = date("Y-m-d H:i:s");

	// 	if($this->master_model->checkZipcodeExist($storeid,$zipcode))
	// 	{
	// 		$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Zipcode Already Exist!</div>');
	// 		redirect('Master_section/zipcode_list');
	// 		$JSON = array("statuscode" => "300", "status" => "exist", "response" => 'Store Zipcode Already Exist!');
 //    		echo json_encode($JSON);
	// 	}
	// 	else
	// 	{
	// 		$data = array('store_id' => $storeid, 'zip_code' => $zipcode, 'status' => $status);

	// 		// print_r($data);

	// 		$res = $this->db->insert('zipcode',$data);

	// 	    if($res > 0)
	// 		{
	// 			// $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Zip Code Added</div>');
	// 			$JSON = array("statuscode" => "200", "status" => "success", "response" => 'Store Zip Code Added');
 //    			echo json_encode($JSON);
	// 		}
	// 		else
	// 		{
	// 			// $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Store Zip Code!</div>');
	// 			$JSON = array("statuscode" => "400", "status" => "failed", "response" => 'Failed to Add Store Zip Code!');
 //    			echo json_encode($JSON);
	// 		}
	// 	}
	// }
	
    

}
?>
