<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	class Counter_billingapp_controller extends CI_Controller {
		public function __construct()
		{
			parent::__construct();
			$this->load->helper(array('form', 'url'));
			$this->load->model('santhe_model');
			$this->db2 = $this->load->database('master', TRUE);
		}
		// Get bills details
		public function get_billdetails($branch)
    	{
    
    	    $bills = array();
	        $query = $this->db->query("SELECT branch_slno FROM outlet_deatils WHERE status='Active' AND branch=?", [$branch]);
            
           foreach ($query->result_array() as $brans) {
    $branch_code = $brans['branch_slno'];
    $table1 = 'san_bill_detials' . $branch_code;
    $table2 = 'product_billdetail' . $branch_code;
    $table3 = 'billed_product' . $branch_code;
    $table4 = 'payments_details' . $branch_code;

    // CHECK IF TABLE EXISTS BEFORE QUERYING
    if ($this->db->table_exists($table1)) {
                
               
                
            
                // 2. Optimization: Use COALESCE to handle empty tables (returns 0 instead of NULL)
                // Removed the JOIN syntax in favor of comma-separated selects for simple aggregates
                $sql1 = "SELECT 
                            (SELECT COALESCE(MAX(bill_id), 0) FROM $table1) as santhe_id,
                            (SELECT COALESCE(MAX(bill_id), 0) FROM $table2) as counter_id,
                            (SELECT COALESCE(MAX(bill_pr_id), 0) FROM $table3) as items_id,
                            (SELECT COALESCE(MAX(payment_id), 0) FROM $table4) as payment_id";
                
                $query1 = $this->db->query($sql1);
                $row = $query1->row_array(); // row_array is better here as we only expect 1 row of MAX values
            
                if ($row) {
                    $bills[] = array(
                        'santhe_id'  => $row['santhe_id'],
                        'counter_id' => $row['counter_id'],
                        'item_id'    => $row['items_id'],
                        'payment_id' => $row['payment_id'],
                        'branch'     => $branch_code // Good practice to include which branch this belongs to
                    );
                }
            }else {
        // Log that the table is missing for this branch
        log_message('error', "Table $table1 missing for branch $branch_code");
    }
           }
    	    
            $data = array(
                'bills' =>$bills,
            );
        	echo json_encode($data);
    	}
    	public function counter_data_upload($branch)
		{
		    $billstatus = array();
		    $no_delete = array();
		    $current_date = date('Y-m-d');
		    $current_time = date("h:i A");
		    $total_Sales_amount=0;
		    header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
			$query = $this->db->query("SELECT branch_slno,branch FROM outlet_deatils WHERE status='Active' and  branch='$branch'");
            $rows = $query->row();
            if (isset($rows))
            {
              $branch_code = $rows->branch_slno;
              $branches = $rows->branch;
    			if ($branch == $branches)
    			{
    				$table1 = 'product_billdetail'.$branch_code;
    				$table2 = 'billed_product'.$branch_code;
    				$table3 = 'payments_details'.$branch_code;
                    $bills = $requestData['Order'];
                    foreach ($bills as $row) 
                    {
                        $bill_id = $row['bill_id'];
                        $bno = '0';
                        $bill_no = '0';
                        $bill_date = '0';
                        $bill_time = '0';
                        $in_no = $row['in_no'];
                        $invoice_no = $row['invoice_no'];
                        $invoice_date = date("Y-m-d", strtotime($row['invoice_date']));
                        $invoice_time =date("h:i A", strtotime($row['invoice_time']));
                        $edit_date = $row['edit_date'];
                        $edit_time = $row['edit_time'];
                        $cust_name = str_replace("'","\'", $row['cust_name']);
                        $cust_id = $cust_name;
                        $cust_phone = $row['cust_phone'];
                        $cust_gst = str_replace("'","\'", $row['cust_gst']); 
                        $cust_address = str_replace("'","\'", $row['cust_address']);
                        $album_no = str_replace("'","\'", $row['album_no']); 
                        $shape = str_replace("'","\'", $row['shape']);
                        $remarks = str_replace("'","\'", $row['remarks']);
                        $ord_taken_by = str_replace("'","\'", $row['ord_taken_by']);
                        $ord_edited_by = str_replace("'","\'", $row['ord_edited_by']);
                        $total_basic_price = $row['total_basic_price'];
                        $disc_total_amt = $row['disc_total_amt'];
                        $basic_aft_disc = $row['basic_aft_disc'];
                        $tax_aft_disc = $row['tax_aft_disc'];
                        $disc_given_by = str_replace("'","\'", $row['disc_given_by']);
                        $disc_given_to = str_replace("'","\'", $row['disc_given_to']); 
                        $total_amount = $row['total_amount'];
                        $advance_amount = $row['advance_amount'];
                        $balance_amount = $row['balance_amount'];
                        $paid_amt = $row['paid_amt'];
                        $total_paid_amount = $row['total_paid_amount'];
                        $total_Sales_amount = round($total_Sales_amount + $row['total_paid_amount']);
                        $refunded_amt = $row['refunded_amt'];
                        $mop = $row['mop'];
                        $final_mop = $row['final_mop'];
                        $multi_paytm = $row['multi_paytm'];
                        $multi_card = $row['multi_card'];
                        $multi_cash = $row['multi_cash'];
                        $multi_phonepay = $row['multi_phonepay'];
                        $nc_cust_name = str_replace("'","\'", $row['nc_cust_name']);
                        $nc_cust_phone = $row['nc_cust_phone'];
                        $nc_approved_by = str_replace("'","\'", $row['nc_approved_by']); 
                        $cheque_no = str_replace("'","\'", $row['cheque_no']); 
                        $cheque_date = $row['cheque_date'];
                        $cheque_bank = str_replace("'","\'", $row['cheque_bank']); 
                        $neft_trans_no = str_replace("'","\'", $row['neft_trans_no']); 
                        $neft_date = $row['neft_date'];
                        $neft_amount = $row['neft_amount'];
                        $credit_cust_name = str_replace("'","\'", $row['credit_cust_name']);  
                        $credit_cust_phone = $row['credit_cust_phone'];
                        $delivery_date = $row['delivery_date'];
                        $delivery_time = $row['delivery_time'];
                        $delivery_day = $row['delivery_day'];
                        $delivery_mode = str_replace("'","\'", $row['delivery_mode']); 
                        $picked_up_name = str_replace("'","\'", $row['picked_up_name']);  
                        $picked_up_id = str_replace("'","\'", $row['picked_up_id']); 
                        $msg = str_replace("'","\'", $row['msg']); 
                        $ord_remarks = str_replace("'","\'", $row['ord_remarks']);  
                        $cancelled_date = $row['cancelled_date'];
                        $refunded_date = $row['refunded_date'];
                        if($final_mop =='CREDIT')
                        {
                            $status = 'Dispatched';
                            $stlmnt_status = 'Dispatched';
                             $stlmnt_date = $row['stlmnt_date'];
                        } else {
                            $status = 'closed';
                            $stlmnt_status = '0';
                            $stlmnt_date = '0';
                        }
                        $main_status = $row['status'];
                        
                        if($main_status =='pending')
                        {
                            $sync_status = 'waiting';
                        } else {
                            $sync_status = 'synched';
                        }
                        $branch1 = $row['branch'];
                        $re_print = $row['re_print'];
                        $user_id = $row['user_id'];
                        $synch_date = date('Y-m-d');;
                        $synch_time = date('h:i A');
                        $order_type = $row['order_type'];
                        $datetime = date('H:i',strtotime($invoice_time));
                        $order_name = '0';
                        $sync_statuss = $row['sync_status'];
        			    $this->db->query("INSERT INTO $table1(bill_id,bno,bill_no,bill_date,bill_time,in_no,invoice_no,invoice_date,invoice_time,edit_date,edit_time,cust_name,cust_phone,cust_gst,cust_address,album_no,shape,remarks,ord_taken_by,ord_edited_by,total_basic_price,disc_total_amt,basic_aft_disc,tax_aft_disc,disc_given_by,disc_given_to,total_amount,advance_amount,balance_amount,paid_amt,total_paid_amount,refunded_amt,mop,final_mop,multi_paytm,multi_card,multi_cash,multi_phonepay,nc_cust_name,nc_cust_phone,nc_approved_by,cheque_no,cheque_date,cheque_bank,neft_trans_no,neft_date,neft_amount,credit_cust_name,credit_cust_phone,delivery_date,delivery_time,delivery_day,delivery_mode,picked_up_name,picked_up_id,msg,ord_remarks,cancelled_date,refunded_date,status,stlmnt_status,stlmnt_date,branch,re_print,sync_status,user_id,synch_date,synch_time,order_type,datetime,order_name,customername) VALUES ('$bill_id','$bno','$bill_no','$bill_date','$bill_time','$in_no','$invoice_no','$invoice_date','$invoice_time','$edit_date','$edit_time','$cust_id','$cust_phone','$cust_gst','$cust_address','$album_no','$shape','$remarks','$ord_taken_by','$ord_edited_by','$total_basic_price','$disc_total_amt','$basic_aft_disc','$tax_aft_disc','$disc_given_by','$disc_given_to','$total_amount','$advance_amount','$balance_amount','$paid_amt','$total_paid_amount','$refunded_amt','$mop','$final_mop','$multi_paytm','$multi_card','$multi_cash','$multi_phonepay','$nc_cust_name','$nc_cust_phone','$nc_approved_by','$cheque_no','$cheque_date','$cheque_bank','$neft_trans_no','$neft_date','$neft_amount','$credit_cust_name','$credit_cust_phone','$delivery_date','$delivery_time','$delivery_day','$delivery_mode','$picked_up_name','$picked_up_id','$msg','$ord_remarks','$cancelled_date','$refunded_date','$status','$stlmnt_status','$stlmnt_date','$branch1','$re_print','$sync_status','$user_id','$synch_date','$synch_time','$order_type','$datetime','$order_name','$cust_name') ON DUPLICATE KEY UPDATE bno='$bno',bill_no='$bill_no',bill_date='$bill_date',bill_time='$bill_time',in_no='$in_no',invoice_no='$invoice_no',invoice_date='$invoice_date',invoice_time='$invoice_time',edit_date='$edit_date',edit_time='$edit_time',cust_name='$cust_name',cust_phone='$cust_phone',cust_gst='$cust_gst',cust_address='$cust_address',album_no='$album_no',shape='$shape',remarks='$remarks',ord_taken_by='$ord_taken_by',ord_edited_by='$ord_edited_by',total_basic_price='$total_basic_price',disc_total_amt='$disc_total_amt',basic_aft_disc='$basic_aft_disc',tax_aft_disc='$tax_aft_disc',disc_given_by='$disc_given_by',disc_given_to='$disc_given_to',total_amount='$total_amount',advance_amount='$advance_amount',balance_amount='$balance_amount',paid_amt='$paid_amt',total_paid_amount='$total_paid_amount',refunded_amt='$refunded_amt',mop='$mop',final_mop='$final_mop',multi_paytm='$multi_paytm',multi_card='$multi_card',multi_cash='$multi_cash',multi_phonepay='$multi_phonepay',nc_cust_name='$nc_cust_name',nc_cust_phone='$nc_cust_phone',nc_approved_by='$nc_approved_by',cheque_no='$cheque_no',cheque_date='$cheque_date',cheque_bank='$cheque_bank',neft_trans_no='$neft_trans_no',neft_date='$neft_date',neft_amount='$neft_amount',credit_cust_name='$credit_cust_name',credit_cust_phone='$credit_cust_phone',delivery_date='$delivery_date',delivery_time='$delivery_time',delivery_day='$delivery_day',delivery_mode='$delivery_mode',picked_up_name='$picked_up_name',picked_up_id='$picked_up_id',msg='$msg',ord_remarks='$ord_remarks',cancelled_date='$cancelled_date',refunded_date='$refunded_date',status='$status',stlmnt_status='$stlmnt_status',stlmnt_date='$stlmnt_date',branch='$branch',re_print='$re_print',sync_status='$sync_status',user_id='$user_id',synch_date='$synch_date',synch_time='$synch_time',order_type='$order_type',datetime='$datetime',order_name='$order_name'");
                        $id1= $this->db->affected_rows();
                        $count=1;
                        foreach ($row['counter_items'] as $item) 
                        { 
                            $bill_pr_id = $item['item_id'];
                            $cat_name = $item['cat_name'];
                            $product_name = str_replace("'","\'", $item['product_name']);
                            $hsn_code = $item['hsn_code'];
                            $uom = $item['uom'];
                            $basic_rate = $item['basic_rate'];
                            $tax_percentage = $item['tax_percentage'];
                            $sgst_tax = $item['sgst_tax'];
                            $sgst_base_tax_amt = $item['sgst_base_tax_amt'];
                            $cgst_tax = $item['cgst_tax'];
                            $cgst_base_tax_amt = $item['cgst_base_tax_amt'];
                            $basic_price = $item['basic_price'];
                            $pc_qty = $item['pc_qty'];
                            $quantity = $item['quantity'];
                            $price = $item['price'];
                            $disc_per = $item['disc_per'];
                            $disc_amount = $item['disc_amount'];
                            $item_taxable_amt = $item['item_taxable_amt'];
                            $sgst_tax_amount = $item['sgst_tax_amount'];
                            $cgst_tax_amount = $item['cgst_tax_amount'];
                            $item_tax_amt = $item['item_tax_amt'];
                            $total_price = $item['total_price'];
                            $bill_status = $item['bill_status'];
                            $sd_status = $item['sd_status'];
                            $bill_id = $item['bill_id'];
                            $pr_id = $item['pr_id'];
                            $edit_status = $item['edit_status'];
                            $disc_type = $item['disc_type'];
                            $sales_type = $item['sales_type'];
                            $synch_date = date('Y-m-d');
                            $synch_time = date('h:i A');
                            $product_no = $item['product_no'];
                            $this->db->query("INSERT INTO $table2(bill_pr_id,cat_name,product_name,hsn_code,uom,basic_rate,tax_percentage,sgst_tax,sgst_base_tax_amt,cgst_tax,cgst_base_tax_amt,basic_price,pc_qty,quantity,price,disc_per,disc_amount,item_taxable_amt,sgst_tax_amount,cgst_tax_amount,item_tax_amt,total_price,bill_status,sd_status,bill_id,pr_id,edit_status,disc_type,sales_type,synch_date,synch_time,product_no) VALUES ('$bill_pr_id','$cat_name','$product_name','$hsn_code','$uom','$basic_rate','$tax_percentage','$sgst_tax','$sgst_base_tax_amt','$cgst_tax','$cgst_base_tax_amt','$basic_price','$pc_qty','$quantity','$price','$disc_per','$disc_amount','$item_taxable_amt','$sgst_tax_amount','$cgst_tax_amount','$item_tax_amt','$total_price','$bill_status','$sd_status','$bill_id','$pr_id','$edit_status','$disc_type','$sales_type','$synch_date','$synch_time','$product_no') ON DUPLICATE KEY UPDATE cat_name='$cat_name',product_name='$product_name',hsn_code='$hsn_code',uom='$uom',basic_rate='$basic_rate',tax_percentage='$tax_percentage',sgst_tax='$sgst_tax',sgst_base_tax_amt='$sgst_base_tax_amt',cgst_tax='$cgst_tax',cgst_base_tax_amt='$cgst_base_tax_amt',basic_price='$basic_price',pc_qty='$pc_qty',quantity='$quantity',price='$price',disc_per='$disc_per',disc_amount='$disc_amount',item_taxable_amt='$item_taxable_amt',sgst_tax_amount='$sgst_tax_amount',cgst_tax_amount='$cgst_tax_amount',item_tax_amt='$item_tax_amt',total_price='$total_price',bill_status='$bill_status',sd_status='$sd_status',bill_id='$bill_id',pr_id='$pr_id',edit_status='$edit_status',disc_type='$disc_type',sales_type='$sales_type',synch_date='$synch_date',synch_time='$synch_time',product_no='$product_no'");
                            $count++;
                        } 
                        // payment details
                        foreach ($row['counter_payments'] as $pay) 
                        {       
                            $payment_id = $pay['payment_id'];
                            $payment_date = date("Y-m-d", strtotime($pay['payment_date']));
                            $payment_types = $pay['payment_types'];
                            $multi_payment = $pay['multi_payment'];
                            $branch2 = $pay['branch'];
                            $bill_id = $pay['bill_id'];
                            $user_name = $pay['user_name'];
                            $payment_status = $pay['payment_status'];
                            $paid_amount = $pay['paid_amount'];
                            $cr_settle_date = '0';
                            $cr_settle_amt = '0';
                            $synch_date = date('Y-m-d');
                            $synch_time = date('h:i A');
                            $this->db->query("INSERT INTO $table3(payment_id,payment_date,payment_types,multi_payment,branch,bill_id,user_name,payment_status,paid_amount,cr_settle_date,cr_settle_amt,synch_date,synch_time,final_date) VALUES ('$payment_id','$payment_date','$payment_types','$multi_payment','$branch2','$bill_id','$user_name','$payment_status','$paid_amount','$cr_settle_date','$cr_settle_amt','$synch_date','$synch_time','$payment_date') ON DUPLICATE KEY UPDATE payment_date='$payment_date',payment_types='$payment_types',multi_payment='$multi_payment',branch='$branch2',bill_id='$bill_id',user_name='$user_name',payment_status='$payment_status',paid_amount='$paid_amount',cr_settle_date='$cr_settle_date',cr_settle_amt='$cr_settle_amt',synch_date='$synch_date',synch_time='$synch_time',final_date='$payment_date'");
                        }   
        	        }
        	        $query10 = $this->db->query("SELECT max(P.bill_id) as billid FROM $table1 P inner join $table2 B on P.bill_id=B.bill_id inner join $table3 D on P.bill_id=D.bill_id");
                    if($query10->num_rows() > 0)
                    {
                        $rows10 = $query10->row();
                        $billid = $rows10->billid;
                        $final_data = array (
                            "bill_id" => $billid,
                            "status" =>'success'
                        );
                    } else {
                        $final_data = array (
                            "bill_id" => $billid,
                            "status" =>'failed'
                        );
                    }
                }
            }
            echo json_encode($final_data);
		    
        }
        // SMS seding
        public function day_closebuttonclick($branch)
        {
            $data_array =array();
            $current_date = date('Y-m-d');
            $query=$this->db->query("SELECT branch_slno,branch FROM outlet_deatils WHERE status='Active' and branch='$branch'");
    		$total_branch = $query->result_array();
    		foreach ($total_branch as $brans) 
    		{
    			$branch_code = $brans['branch_slno'];
    			$branches = $brans['branch'];
    			if ($branch == $branches)
    			{
    				$table = 'product_billdetail'.$branch_code;
    				$table1 = 'billed_product'.$branch_code;
    				$table2 = 'payments_details'.$branch_code;
    				
    				$query1 = $this->db3->query("SELECT sum(total_paid_amount) as total_Sales_amount  FROM $table WHERE  invoice_date='$current_date'");
                    $rows1 = $query1->row();
                    $total_Sales_amount = $rows1->total_Sales_amount;
                    
        			$query = $this->db2->query("SELECT enitity_id,user_id,api_key,sender_id,mobile_no,location,template_id,branch_title,owner_num FROM sms_authorize_final WHERE message_type_id='1' and branch='$branch'");
                    $rows = $query->row();
                    if (isset($rows))
                    {
                        $sms_date = date('d-m-Y');
                        $mobile = $rows->mobile_no;
                        $enitity_id = $rows->enitity_id;
                        $user_id = $rows->user_id;
                        $authKey = $rows->api_key;
                        $senderId = $rows->sender_id;
                        $location1 = $rows->location;
                        $location = $rows->location.':Today-'.date("d-m-Y", strtotime($sms_date));
                        $templateId = $rows->template_id;
                        $branch_title = $rows->branch_title;
                        $sms_dates = date("d-m-Y", strtotime($sms_date));
                        $message = urlencode("GravitySoft $location, Closing Day Sales is: Rs. $total_Sales_amount");
                        $posting_data = 'user='.$user_id.'&key='.$authKey.'&senderid='.$senderId.'&accusage=1&responcetype=json&entityid='.$enitity_id.'&tempid='.$templateId.'&mobile='.$mobile.'&message='.$message;
                        $url1="http://redirect.ds3.in/submitsms.jsp?";
                        $ch1 = curl_init($url1);
            			curl_setopt($ch1, CURLOPT_SSL_VERIFYHOST, 0);
            			curl_setopt($ch1, CURLOPT_SSL_VERIFYPEER, 0);
            			curl_setopt($ch1, CURLOPT_POST, 1);
            			curl_setopt($ch1, CURLOPT_ENCODING, 'UTF-8');			
            			curl_setopt($ch1, CURLOPT_POSTFIELDS, "$posting_data");
            			curl_setopt($ch1, CURLOPT_RETURNTRANSFER, 1);
            			$output1 = curl_exec($ch1);
            			curl_close($ch1);
            			$data_array = array(
            			    'total_sales' =>$total_Sales_amount
            			);
                    }
    			}
    		}
    		echo json_encode($data_array);
        }
		// app data synch
		public function app_data_synching($branch)
		{
		    $billstatus = array();
		    $no_delete = array();
		    $current_date = date('Y-m-d');
		    $current_time = date("h:i A");
		    header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            
				$table1 = 'spl_product_billdetail';
				$table2 = 'spl_billed_product';
				$table3 = 'spl_payments_details';
    			
                $bills = $requestData['Order'];
                foreach ($bills as $row) 
                {
                    $query = $this->db->query("SELECT A.bill_id + 1 as bills_id,B.item_id as items_id,C.payment_id + 1 as paymet_ids FROM (SELECT IFNULL(max(bill_id),0) as bill_id FROM spl_product_billdetail) A join (SELECT IFNULL(max(bill_pr_id),0) as item_id FROM spl_billed_product) B join (SELECT IFNULL(max(payment_id),0) as payment_id FROM spl_payments_details) C");
                    $rows = $query->row();
                    if (isset($rows))
                    {
                        $max_bill_id= (int)$rows->bills_id;
                        $max_items_id= (int)$rows->items_id;
                        $max_payments_id= (int)$rows->paymet_ids;
                        $invoice_no = $branch."-2526-".$max_bill_id;
                        $bill_id = $max_bill_id;
                        $bno = '0';
                        $bill_no = '0';
                        $bill_date = '0';
                        $bill_time = '0';
                        $in_no = $max_bill_id;
                        $invoice_no = $invoice_no;
                        $invoice_date = date("Y-m-d", strtotime($row['invoice_date']));
                        $invoice_time =date("h:i A", strtotime($row['invoice_time']));
                        $edit_date = $row['edit_date'];
                        $edit_time = $row['edit_time'];
                        $cust_name = str_replace("'","\'", $row['cust_name']);
                        $cust_id = $row['cust_id'];
                        $cust_phone = $row['cust_phone'];
                        $cust_gst = str_replace("'","\'", $row['cust_gst']); 
                        $cust_address = str_replace("'","\'", $row['cust_address']);
                        $album_no = str_replace("'","\'", $row['album_no']); 
                        $shape = str_replace("'","\'", $row['shape']);
                        $remarks = str_replace("'","\'", $row['remarks']);
                        $ord_taken_by = str_replace("'","\'", $row['ord_taken_by']);
                        $ord_edited_by = str_replace("'","\'", $row['ord_edited_by']);
                        $total_basic_price = $row['total_basic_price'];
                        $disc_total_amt = $row['disc_total_amt'];
                        $basic_aft_disc = $row['basic_aft_disc'];
                        $tax_aft_disc = $row['tax_aft_disc'];
                        $disc_given_by = str_replace("'","\'", $row['disc_given_by']);
                        $disc_given_to = str_replace("'","\'", $row['disc_given_to']); 
                        $total_amount = $row['total_amount'];
                        $advance_amount = $row['advance_amount'];
                        $balance_amount = $row['balance_amount'];
                        $paid_amt = $row['paid_amt'];
                        $total_paid_amount = $row['total_paid_amount'];
                        $refunded_amt = $row['refunded_amt'];
                        $mop = $row['mop'];
                        $final_mop = $row['final_mop'];
                        $multi_paytm = $row['multi_paytm'];
                        $multi_card = $row['multi_card'];
                        $multi_cash = $row['multi_cash'];
                        $multi_phonepay = $row['multi_phonepay'];
                        $nc_cust_name = str_replace("'","\'", $row['nc_cust_name']);
                        $nc_cust_phone = $row['nc_cust_phone'];
                        $nc_approved_by = str_replace("'","\'", $row['nc_approved_by']); 
                        $cheque_no = str_replace("'","\'", $row['cheque_no']); 
                        $cheque_date = $row['cheque_date'];
                        $cheque_bank = str_replace("'","\'", $row['cheque_bank']); 
                        $neft_trans_no = str_replace("'","\'", $row['neft_trans_no']); 
                        $neft_date = $row['neft_date'];
                        $neft_amount = $row['neft_amount'];
                        $credit_cust_name = str_replace("'","\'", $row['credit_cust_name']);  
                        $credit_cust_phone = $row['credit_cust_phone'];
                        $delivery_date = $row['delivery_date'];
                        $delivery_time = $row['delivery_time'];
                        $delivery_day = $row['delivery_day'];
                        $delivery_mode = str_replace("'","\'", $row['delivery_mode']); 
                        $picked_up_name = str_replace("'","\'", $row['picked_up_name']);  
                        $picked_up_id = str_replace("'","\'", $row['picked_up_id']); 
                        $msg = str_replace("'","\'", $row['msg']); 
                        $ord_remarks = str_replace("'","\'", $row['ord_remarks']);  
                        $cancelled_date = $row['cancelled_date'];
                        $refunded_date = $row['refunded_date'];
                        if($final_mop =='CREDIT')
                        {
                            $status = 'Dispatched';
                            $stlmnt_status = 'Dispatched';
                             $stlmnt_date = $row['stlmnt_date'];
                        } else {
                            $status = 'settled';
                            $stlmnt_status = 'settled';
                            $stlmnt_date = date("Y-m-d", strtotime($row['invoice_date']));
                        }
                        
                        $main_status = $row['status'];
                        
                        if($main_status =='pending')
                        {
                            $sync_status = 'waiting';
                        } else {
                            $sync_status = 'synched';
                        }
                        
                       
                        $branch1 = $row['branch'];
                        $re_print = $row['re_print'];
                        $user_id = $row['user_id'];
                        $synch_date = date('Y-m-d');;
                        $synch_time = date('h:i A');
                        $order_type = $row['order_type'];
                        $datetime = date('H:i',strtotime($invoice_time));
                        $order_name = '0';
                        $sync_statuss = $row['sync_status'];
        			    $this->db->query("INSERT INTO $table1(bill_id,bno,bill_no,bill_date,bill_time,in_no,invoice_no,invoice_date,invoice_time,edit_date,edit_time,cust_name,cust_phone,cust_gst,cust_address,album_no,shape,remarks,ord_taken_by,ord_edited_by,total_basic_price,disc_total_amt,basic_aft_disc,tax_aft_disc,disc_given_by,disc_given_to,total_amount,advance_amount,balance_amount,paid_amt,total_paid_amount,refunded_amt,mop,final_mop,multi_paytm,multi_card,multi_cash,multi_phonepay,nc_cust_name,nc_cust_phone,nc_approved_by,cheque_no,cheque_date,cheque_bank,neft_trans_no,neft_date,neft_amount,credit_cust_name,credit_cust_phone,delivery_date,delivery_time,delivery_day,delivery_mode,picked_up_name,picked_up_id,msg,ord_remarks,cancelled_date,refunded_date,status,stlmnt_status,stlmnt_date,branch,re_print,sync_status,user_id,synch_date,synch_time,order_type,datetime,order_name,customername) VALUES ('$bill_id','$bno','$bill_no','$bill_date','$bill_time','$in_no','$invoice_no','$invoice_date','$invoice_time','$edit_date','$edit_time','$cust_id','$cust_phone','$cust_gst','$cust_address','$album_no','$shape','$remarks','$ord_taken_by','$ord_edited_by','$total_basic_price','$disc_total_amt','$basic_aft_disc','$tax_aft_disc','$disc_given_by','$disc_given_to','$total_amount','$advance_amount','$balance_amount','$paid_amt','$total_paid_amount','$refunded_amt','$mop','$final_mop','$multi_paytm','$multi_card','$multi_cash','$multi_phonepay','$nc_cust_name','$nc_cust_phone','$nc_approved_by','$cheque_no','$cheque_date','$cheque_bank','$neft_trans_no','$neft_date','$neft_amount','$credit_cust_name','$credit_cust_phone','$delivery_date','$delivery_time','$delivery_day','$delivery_mode','$picked_up_name','$picked_up_id','$msg','$ord_remarks','$cancelled_date','$refunded_date','$status','$stlmnt_status','$stlmnt_date','$branch1','$re_print','$sync_status','$user_id','$synch_date','$synch_time','$order_type','$datetime','$order_name','$cust_name') ON DUPLICATE KEY UPDATE bno='$bno',bill_no='$bill_no',bill_date='$bill_date',bill_time='$bill_time',in_no='$in_no',invoice_no='$invoice_no',invoice_date='$invoice_date',invoice_time='$invoice_time',edit_date='$edit_date',edit_time='$edit_time',cust_name='$cust_name',cust_phone='$cust_phone',cust_gst='$cust_gst',cust_address='$cust_address',album_no='$album_no',shape='$shape',remarks='$remarks',ord_taken_by='$ord_taken_by',ord_edited_by='$ord_edited_by',total_basic_price='$total_basic_price',disc_total_amt='$disc_total_amt',basic_aft_disc='$basic_aft_disc',tax_aft_disc='$tax_aft_disc',disc_given_by='$disc_given_by',disc_given_to='$disc_given_to',total_amount='$total_amount',advance_amount='$advance_amount',balance_amount='$balance_amount',paid_amt='$paid_amt',total_paid_amount='$total_paid_amount',refunded_amt='$refunded_amt',mop='$mop',final_mop='$final_mop',multi_paytm='$multi_paytm',multi_card='$multi_card',multi_cash='$multi_cash',multi_phonepay='$multi_phonepay',nc_cust_name='$nc_cust_name',nc_cust_phone='$nc_cust_phone',nc_approved_by='$nc_approved_by',cheque_no='$cheque_no',cheque_date='$cheque_date',cheque_bank='$cheque_bank',neft_trans_no='$neft_trans_no',neft_date='$neft_date',neft_amount='$neft_amount',credit_cust_name='$credit_cust_name',credit_cust_phone='$credit_cust_phone',delivery_date='$delivery_date',delivery_time='$delivery_time',delivery_day='$delivery_day',delivery_mode='$delivery_mode',picked_up_name='$picked_up_name',picked_up_id='$picked_up_id',msg='$msg',ord_remarks='$ord_remarks',cancelled_date='$cancelled_date',refunded_date='$refunded_date',status='$status',stlmnt_status='$stlmnt_status',stlmnt_date='$stlmnt_date',branch='$branch',re_print='$re_print',sync_status='$sync_status',user_id='$user_id',synch_date='$synch_date',synch_time='$synch_time',order_type='$order_type',datetime='$datetime',order_name='$order_name'");
                        $id1= $this->db->affected_rows();
                        $count=1;
                        foreach ($row['counter_items'] as $item) 
                        { 
                            $bill_pr_id = $max_items_id + $count;
                            $cat_name = $item['cat_name'];
                            $product_name = str_replace("'","\'", $item['product_name']);
                            $hsn_code = $item['hsn_code'];
                            $uom = $item['uom'];
                            $basic_rate = $item['basic_rate'];
                            $tax_percentage = $item['tax_percentage'];
                            $sgst_tax = $item['sgst_tax'];
                            $sgst_base_tax_amt = $item['sgst_base_tax_amt'];
                            $cgst_tax = $item['cgst_tax'];
                            $cgst_base_tax_amt = $item['cgst_base_tax_amt'];
                            $basic_price = $item['basic_price'];
                            $pc_qty = $item['pc_qty'];
                            $quantity = $item['quantity'];
                            $price = $item['price'];
                            $disc_per = $item['disc_per'];
                            $disc_amount = $item['disc_amount'];
                            $item_taxable_amt = $item['item_taxable_amt'];
                            $sgst_tax_amount = $item['sgst_tax_amount'];
                            $cgst_tax_amount = $item['cgst_tax_amount'];
                            $item_tax_amt = $item['item_tax_amt'];
                            $total_price = $item['total_price'];
                            $bill_status = $item['bill_status'];
                            $sd_status = $item['sd_status'];
                            $bill_id = $max_bill_id;
                            $pr_id = $item['pr_id'];
                            $edit_status = $item['edit_status'];
                            $disc_type = $item['disc_type'];
                            $sales_type = $item['sales_type'];
                            $synch_date = date('Y-m-d');
                            $synch_time = date('h:i A');
                            $product_no = $item['product_no'];
                            $this->db->query("INSERT INTO $table2(bill_pr_id,cat_name,product_name,hsn_code,uom,basic_rate,tax_percentage,sgst_tax,sgst_base_tax_amt,cgst_tax,cgst_base_tax_amt,basic_price,pc_qty,quantity,price,disc_per,disc_amount,item_taxable_amt,sgst_tax_amount,cgst_tax_amount,item_tax_amt,total_price,bill_status,sd_status,bill_id,pr_id,edit_status,disc_type,sales_type,synch_date,synch_time,product_no) VALUES ('$bill_pr_id','$cat_name','$product_name','$hsn_code','$uom','$basic_rate','$tax_percentage','$sgst_tax','$sgst_base_tax_amt','$cgst_tax','$cgst_base_tax_amt','$basic_price','$pc_qty','$quantity','$price','$disc_per','$disc_amount','$item_taxable_amt','$sgst_tax_amount','$cgst_tax_amount','$item_tax_amt','$total_price','$bill_status','$sd_status','$bill_id','$pr_id','$edit_status','$disc_type','$sales_type','$synch_date','$synch_time','$product_no') ON DUPLICATE KEY UPDATE cat_name='$cat_name',product_name='$product_name',hsn_code='$hsn_code',uom='$uom',basic_rate='$basic_rate',tax_percentage='$tax_percentage',sgst_tax='$sgst_tax',sgst_base_tax_amt='$sgst_base_tax_amt',cgst_tax='$cgst_tax',cgst_base_tax_amt='$cgst_base_tax_amt',basic_price='$basic_price',pc_qty='$pc_qty',quantity='$quantity',price='$price',disc_per='$disc_per',disc_amount='$disc_amount',item_taxable_amt='$item_taxable_amt',sgst_tax_amount='$sgst_tax_amount',cgst_tax_amount='$cgst_tax_amount',item_tax_amt='$item_tax_amt',total_price='$total_price',bill_status='$bill_status',sd_status='$sd_status',bill_id='$bill_id',pr_id='$pr_id',edit_status='$edit_status',disc_type='$disc_type',sales_type='$sales_type',synch_date='$synch_date',synch_time='$synch_time',product_no='$product_no'");
                            $count++;
                            
                        } 
                        // payment details
                        foreach ($row['counter_payments'] as $pay) 
                        {       
                            $payment_id = $max_payments_id;
                            $payment_date = date("Y-m-d", strtotime($pay['payment_date']));
                            $payment_types = $pay['payment_types'];
                            $multi_payment = $pay['multi_payment'];
                            $branch2 = $pay['branch'];
                            $bill_id = $max_bill_id;
                            $user_name = $pay['user_name'];
                            $payment_status = $pay['payment_status'];
                            $paid_amount = $pay['paid_amount'];
                            $cr_settle_date = '0';
                            $cr_settle_amt = '0';
                            $synch_date = date('Y-m-d');
                            $synch_time = date('h:i A');
                            $this->db->query("INSERT INTO $table3(payment_id,payment_date,payment_types,multi_payment,branch,bill_id,user_name,payment_status,paid_amount,cr_settle_date,cr_settle_amt,synch_date,synch_time) VALUES ('$payment_id','$payment_date','$payment_types','$multi_payment','$branch2','$bill_id','$user_name','$payment_status','$paid_amount','$cr_settle_date','$cr_settle_amt','$synch_date','$synch_time') ON DUPLICATE KEY UPDATE payment_date='$payment_date',payment_types='$payment_types',multi_payment='$multi_payment',branch='$branch2',bill_id='$bill_id',user_name='$user_name',payment_status='$payment_status',paid_amount='$paid_amount',cr_settle_date='$cr_settle_date',cr_settle_amt='$cr_settle_amt',synch_date='$synch_date',synch_time='$synch_time'");
                        }
                        
                        foreach ($row['photos'] as $pho) 
                        {       
                            $bill_id = $max_bill_id;
                            $filename = $pho['filename'];
                            $invoice_reference = $pho['invoice_reference'];
                            $this->db->query("UPDATE $table1  SET receipt_refno='$invoice_reference',receipt_image='$filename' where bill_id='$bill_id'");
                        }
                    
                        $query10 = $this->db->query("SELECT DISTINCT(P.bill_id) as billid FROM $table1 P inner join $table2 B on P.bill_id=B.bill_id inner join $table3 D on P.bill_id=D.bill_id where P.bill_id='$bill_id'");
                        if($query10->num_rows() > 0)
                        {
                            $final_data = array (
                                "bill_id" => $bill_id,
                                "status" =>'success'
                            );
                        } else {
                            $final_data = array (
                                "bill_id" => $bill_id,
                                "status" =>'failed'
                            );
                        }
                    }
                echo json_encode($final_data);
    	    }
        }
	    // Santhe Data Synching
		public function synch_data_santhe()
        {
           
            header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            $bills  = array();
            $items  = array();
            $data = array();
            $bills = $requestData['Order'];
            foreach ($bills as $row) 
            {
                $billid = $row['bill_id'];
                $billno = $row['bill_no'];
                $billdate = $row['bill_date'];
                $billtime = $row['bill_time'];
                $totalbasic = $row['total_basic'];
                $totalqty = $row['total_qty'];
                $discountamount = $row['discount_amount'];
                $taxableamount = $row['taxable_amount'];
                $taxamount = $row['tax_amount'];
                $cgstprice = $row['cgst_price'];
                $sgstprice = $row['sgst_price'];
                $grandtotal_amount = $row['grand_total_amount'];
                $paymenttype = $row['payment_type'];
                $branchname = $row['branch_name'];
                $sync_status = $row['sync_status'];
                $query = $this->db->query("SELECT branch_slno,branch FROM outlet_deatils WHERE status='Active' and  branch='$branchname'");
                $rows = $query->row();
                if (isset($rows))
                {
                   $branch_code = $rows->branch_slno;
                   $branches = $rows->branch;
        			if ($branchname == $branches)
        			{
              			$table1 = 'san_bill_detials'.$branch_code;
             			$table2 = 'san_bill_items'.$branch_code;
             			
                        $query20 = $this->db->query("select * from $table1 where bill_id='$billid'");
                        $total_count_db = $query20->num_rows();
                        if($total_count_db == "0") 
                        {
                            $query = $this->db->query("INSERT INTO $table1(bill_id, bill_no, bill_date, bill_time, total_basic, total_qty, discount_amount, taxable_amount, tax_amount, cgst_price, sgst_price, grand_total_amount, payment_type, branch_name,synch_status) VALUES ('$billid','$billno','$billdate','$billtime','$totalbasic','$totalqty','$discountamount','$taxableamount','$taxamount','$cgstprice','$sgstprice','$grandtotal_amount','$paymenttype','$branchname','updated')");
                            $last_id = $this->db->insert_id();
                            $bills[] = array(
                                  "bill_id" =>$last_id   
                            ); 
                            foreach ($row['counter_items']  as $r1) 
                            {
                               $itemid = $r1['item_id'];
                               $itemname = $r1['item_name'];
                               $itemtaxpercent = $r1['item_tax_percent'];
                               $itembasic = $r1['item_basic'];
                               $basictax = $r1['basic_tax'];
                               $itemqty = $r1['item_qty'];
                               $itemprice = $r1['item_price'];
                               $itemdiscount = $r1['item_discount'];
                               $itemtaxable = $r1['item_taxable'];
                               $itemdiscounttax_amount = $r1['item_discount_tax_amount'];
                               $freeprice = "0";
                               $saletype = "paid";
                               $paidqty = $itemqty;
                               $freeqty = "0";
                               $billid = $r1['bill_id'];
                               $billdate = $r1['bill_date'];
                               $branchname = $r1['branch_name'];
                               $cat_id = $r1['cat_id'];
                               $query1 = $this->db->query("INSERT INTO $table2(item_no, item_name, item_tax_percent, item_basic, basic_tax, item_qty, item_price, item_discount, item_taxable, item_discount_tax_amount, free_price, sale_type, paid_qty, free_qty, bill_id, bill_date, branch_name,cat_ids) VALUES ('$itemid','$itemname','$itemtaxpercent','$itembasic','$basictax','$itemqty','$itemprice','$itemdiscount','$itemtaxable','$itemdiscounttax_amount','$freeprice','$saletype','$paidqty','$freeqty','$billid','$billdate','$branchname','$cat_id')");
                            }
                            foreach ($row['discount'] as $d1) 
                            {
                                $itm_ids = $d1['item_id'];
                                $itm_qtys = $d1['item_qty'];
                                $itm_idbillid = $d1['bill_id'];
                                $itmbranchname = $d1['branch_name'];
                                $query3=$this->db->query("SELECT item_no,item_qty,item_tax_percent,item_basic,basic_tax,bill_id FROM $table2 WHERE item_no='$itm_ids' and bill_id='$itm_idbillid'");
                                $rowcount = $query3->num_rows();
                                if($rowcount > 0)
                                {
                                   foreach ($query3->result() as $items) 
                        		   { 
                        		         $id = $items->item_no;
                        		         $blid = $items->bill_id;
                        		         $remain_qty =  round($items->item_qty - $itm_qtys,2); //3-2=1 paid quantity
                        		         $itemprice =   round($remain_qty * $items->item_basic,2);
                        		         $discountamt = round($itm_qtys * $items->item_basic,2);
                        		         $taxable =     round($remain_qty * $items->item_basic,2);
                        		         $taxamount =   round($taxable * $items->item_tax_percent / 100,2);
                        		         $query4=$this->db->query("UPDATE $table2 set item_discount='$discountamt',item_taxable='$taxable',item_discount_tax_amount='$taxamount',free_price='$discountamt',sale_type='free',paid_qty='$remain_qty',free_qty='$itm_qtys' WHERE item_no='$id' and bill_id='$blid'");     
                        		   }
                                }
                            }
                        } 
                        else 
                        {
                            $data[] = array(
                              "bill_id" =>$billid,
                              "status" =>"failed"
                            );
                        } 
                    }
   			    }
            }
            
            $final_data[] =array(
                "error"=>$data,
                "bill_status" =>$bills,
                "items" =>$items
            );
            echo json_encode($final_data);
        }
        public function special_product_cust($branch,$cust_id)
		{
		    $products = array();
            $current_date = date('Y-m-d');
            $query=$this->db->query("SELECT pr_id,product_name,hsn_code,product_no,uom,basic_rate,basic_tax_percent,basic_tax_amount,sgst_tax,sgst_tax_amount,cgst_tax,cgst_tax_amount,price,product_status,pr_cat_id,branch FROM splproduct WHERE branch='$branch' and cust_id='$cust_id' and product_status='Active' order by product_name asc");
            $rowcount = $query->num_rows();
            if($rowcount > 0)
            {
                foreach ($query->result() as $prod) 
    		    { 
                    $products[] = array(
                        "pr_id" => $prod->pr_id,
                        "product_name" => $prod->product_name,
                        "hsn_code" => $prod->hsn_code,
                        "product_no" =>  $prod->product_no,
                        "product_code" => '0',
                        "sorting_order" =>'0',
                        "uom" => $prod->uom,
                        "basic_rate" => $prod->basic_rate,
                        "basic_tax_percent" => $prod->basic_tax_percent,
                        "basic_tax_amount" =>  $prod->basic_tax_amount,
                        "sgst_tax" => $prod->sgst_tax,
                        "sgst_tax_amount" =>$prod->sgst_tax_amount,
                        "cgst_tax" => $prod->cgst_tax,
                        "cgst_tax_amount" => $prod->cgst_tax_amount,
                        "price" => $prod->price,
                        "discount_perc" =>  '0',
                        "product_code" => '0',
                        "product_stock" =>'0',
                        "product_status" => $prod->product_status,
                        "pr_cat_id" => $prod->pr_cat_id,
                        "branch" =>  $prod->branch,
                        "token" => '0',
                        "tokengroup" =>'0',
                        "social_order" => '0',
                        "sales_item_type" => '0',
                        "combination" => '0',
                        "product_type" => '0',
                        "qty_sales_type" =>  '0',
                        "stock_limit" => '0',
                        "barcode_number" => '0',
                        "product_image_path" => '0'
                        
                    );  
        		 } 
            }
            $data = array(
            "count" => $rowcount,
            "data" =>$products
            );
        	echo $final = json_encode($data);
		}
		// image insert
		public function upload_image()
		{
		    header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'), true);
            $uri = $row['uri'];
            $name = $row['name'];
            $type = $row['type'];
            
            $targetDir = "assets/advanceorder_photo/";
            if (!file_exists($targetDir)) {
                mkdir($targetDir, 0777, true);
            }
            if (isset($_FILES['photo'])) {
                $file = $_FILES['photo'];
                $targetFile = $targetDir . basename($file["name"]);
            
                if (move_uploaded_file($file["tmp_name"], $targetFile)) {
                    echo json_encode(["status" => "success", "message" => "File uploaded", "filename" => $file["name"]]);
                } else {
                    echo json_encode(["status" => "error", "message" => "Failed to move uploaded file."]);
                }
            } else {
                echo json_encode(["status" => "error", "message" => "No file uploaded."]);
            }
		}
		public function get_customer_data($branch)
		{
		    $call_back_reponse = array();
		    $setting = $this->db2->query("SELECT app_setting_access FROM application_setting WHERE setting_name='CUSTOMER_DETAILS_COLLECTION' and branch='$branch'");
            $sets = $setting->row();
            if (isset($sets))
            {
                $customer_option = $sets->app_setting_access;
                if($customer_option =='2')
                {
                    $data_query = $this->db->query("SELECT company_id  as cust_id,company_name as customer_name,company_mobile as customer_mobile,customer_gst as gst_no FROM Company_details where branch='$branch'");
            		foreach ($data_query->result() as $final) 
            		{
                        $call_back_reponse[] = array(
                        "cust_id" => $final->cust_id,
                       "cust_name" => $final->customer_name,
                       "cust_phone" => $final->customer_mobile,
                       "cust_gst" => $final->gst_no
                        );
            		}
                } 
            }
            echo json_encode($call_back_reponse);
		}
		
		
	}