<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Master_section extends CI_Controller 
{
	var $library_script;
	var $library_style;
	public function __construct()
	{
		parent::__construct();
		$this->load->model('master_model');
		$this->load->model('client_master_model');
		$this->load->model('role_model');
		$this->load->helper(array('form', 'url')); 
		$this->db2 = $this->load->database('master', TRUE);
	}

	public function test()
	{
        echo sms_authorize_test_numbers;
	}

	// Role List View
	public function rolelist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
// 		$data['userRecords'] = $this->master_model->role_list();
        $role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$data['userRecords'] = $this->master_model->role_list();
		} else {
			$data['userRecords'] = $this->client_master_model->role_list();
		}
		$data['pageTitle'] = 'Role List';
		$data['Pagename'] = 'Role List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/role_list", $data);
	}

	//Add New Role Form
	public function addNewRole()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['pageTitle'] = 'Role Creation';
		$data['Pagename'] = 'Role Creation';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addRole", $data);
	}

	// New Role Insert
	public function addNewRolers()
	{
		$name = strtoupper($this->input->post('role_name'));
		if(!$this->master_model->checkRoleExist($name))
		{
			$userInfo = array('name'=> $name);
			$result = $this->master_model->addNewRolers($userInfo);
			if($result > 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Role created successfully</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Role creation failed!!!</div>');
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Role Already Exist!!!</div>');
		}
		redirect('Master_section/rolelist');
	}


	//Role Edit Form
	public function editRole($roleId)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getRoleInfo($roleId);
		$data['pageTitle'] = 'Role Edit';
		$data['Pagename'] = 'Role Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_role", $data);
	}

	// Role Edit 
	public function editRoleDetails()
	{
		$role = strtoupper($this->input->post('rolename'));
		$roleId = $this->input->post('roleId');
		$userInfo = array('role'=>$role);

		$old_rolename = $this->input->post('old_rolename');

		if(strcasecmp($role, $old_rolename) == 0)
		{
			$result = $this->master_model->editRoleDetails($userInfo, $roleId);
		}
		else
		{
			if($this->master_model->checkRoleExist($role))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Role Already Exist! Can\'t update!</div>');
				redirect('Master_section/rolelist');
			}
			else
			{
				$result = $this->master_model->editRoleDetails($userInfo, $roleId);
			}
		}
		if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Role updated successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Role updation failed!!!</div>');
		}
		redirect('Master_section/rolelist');
	}

	// Delete Role
	public function deleteRole($roleId,$name)
	{
		if(!$this->master_model->roleChildExist($roleId))
		{
			$this->data['deleterole'] = $this->master_model->deleteRole($roleId);
			if($this->data['deleterole'] == true)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> '.$name.' Deleted</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> No Data Found!!!</div>');
			}	
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Child Table Exits can\'t delete value!!</div>');
		}
		redirect('Master_section/rolelist');
	}

	// User List View
	public function userList($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->userList($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->userList($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		// $data['userRecords'] = $this->master_model->userList();
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	    $data['mid'] = $mid;
		$data['pageTitle'] = 'User List';
		$data['Pagename'] = 'User List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/users", $data);
	}

	// Filter User List View
	public function filteruserlist($mid)
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filter_user_list($clientid,$branch,$client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->filter_user_list($clientid,$branch,$client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Filter By Client User List';
		$data['Pagename'] = 'Filter By Client User List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/users", $data);
	}

	// New User Creation
	public function addNew()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['rolename'] = $this->master_model->get_role_by_name();
		// $data['branch_name'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'New User Creation';
		$data['Pagename'] = 'New User Creation';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addNew", $data);
	}

	// Add New User Insert Function
	public function addNewUser()
	{
	    $currentdatetime = date('Y-m-d H:i:s');
		$name = $this->input->post('fname');
		$email = $this->input->post('username');
		$prime_id = $this->input->post('password');
		$password = password_hash($prime_id, PASSWORD_DEFAULT);
		$mobile = $this->input->post('mobile');
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$roleId = $this->input->post('role');
		
		date_default_timezone_set('Asia/Kolkata');
		$effective_from = date("Y-m-d", strtotime($this->input->post('effective')));
		$vendorId = $this->session->userdata('uid');
		$role_id = $this->session->userdata('role');
		$response = $this->master_model->checkUsernameExistForUsers($email,$clientid,$branch);	
		if($response)
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Username / Email Already Exist !!!</div>');
		}	
		else
		{
			$this->db2->query("INSERT INTO users(email,password,name,mobile,roleId,isDeleted,createdBy,createdDtm,updatedBy,updatedDtm,branch,branch_id,santhe_branch,prime_id,effective_from,data_transfer,status,client_id,api_status,appusername,app_password,app_data_transfer) VALUES ('$email','$password','$name','$mobile','$roleId','0','$vendorId','$currentdatetime','$vendorId','$currentdatetime','$branch','0','0','$prime_id','$effective_from','pending','Active','$clientid','success','$email','$prime_id','pending')");
			$query = $this->db2->query("SELECT max(userId) as userId FROM `users` WHERE branch='$branch'");
            $rows = $query->row();
            if (isset($rows))
            {
                $insert_id = $rows->userId;
			    $this->db->query("INSERT INTO users(userId,email,password,name,mobile,roleId,isDeleted,createdBy,createdDtm,updatedBy,updatedDtm,branch,branch_id,santhe_branch,prime_id,effective_from,data_transfer,status,client_id,api_status) VALUES ('$insert_id','$email','$password','$name','$mobile','$roleId','0','$vendorId','$currentdatetime','$vendorId','$currentdatetime','$branch','0','0','$prime_id','$effective_from','pending','Active','$clientid','success')");
		        $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>User Created Success</div>');
		    }
		}
		redirect('Master_section/userList/1');
	}
	
	// Edit User Deatils 
	public function editOld($userId)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		$data['rolename'] = $this->master_model->get_role_by_name();
		$data['allrolename'] = $this->master_model->get_all_role_by_name();
		$data['userInfo'] = $this->master_model->getUserInfo($userId);
		$data['pageTitle'] = 'Edit User';
		$data['Pagename'] = 'Edit User';
		$data['HomePage'] = 'Home';
		$this->load->view("master/editOld", $data);
	}

	// Update Edited user info
	public function editUser()
	{
		$userId = $this->input->post('userId');
		$name = $this->input->post('fname');
		$email = $this->input->post('username');
		$prime_id = $this->input->post('password');
		$password = password_hash($prime_id, PASSWORD_DEFAULT);
		$clientid = $this->input->post('clientid');
		$roleId = $this->input->post('role');
		$mobile = $this->input->post('mobile');
		$branch = $this->input->post('branch');
		
		$status1 = $this->input->post('status');
		if($status1 == "true")
	    {
	        $status = "Active";
	    }
	    else
	    {
	        $status = "Inactive";
	    }
		$data_transfer = $this->input->post('data_transfer');
		date_default_timezone_set('Asia/Kolkata');
		$effective_from = date("Y-m-d", strtotime($this->input->post('effective')));
		$vendorId = $this->session->userdata('uid');
		$old_email = $this->input->post('old_username');
		$old_clientid = $this->input->post('old_clientid');
		$old_branch = $this->input->post('old_branch');
		$userInfo = array();
		if(empty($prime_id))
		{
			if(empty($status))
			{
				if($data_transfer == 'inactive')
				{
					$userInfo = array('email'=>$email, 'roleId'=>$roleId, 'name'=>$name,'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'),'client_id' => $clientid, 'branch' => $branch, 'effective_from' => $effective_from, 'data_transfer' => 'inactive', 'updated' => date('Y-m-d'));	
				}
				else
				{
					$userInfo = array('email'=>$email, 'roleId'=>$roleId, 'name'=>$name,'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'),'client_id' => $clientid, 'branch' => $branch, 'effective_from' => $effective_from,'data_transfer' => 'pending', 'updated' => date('Y-m-d'));	
				}
			}
			else
			{
				if($data_transfer == 'inactive')
				{
					$userInfo = array('email'=>$email, 'roleId'=>$roleId, 'name'=>$name,'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'), 'status'=>$status, 'client_id' => $clientid, 'branch' => $branch, 'effective_from' => $effective_from, 'data_transfer' => 'inactive', 'updated' => date('Y-m-d'));	
				}
				else
				{
					$userInfo = array('email'=>$email, 'roleId'=>$roleId, 'name'=>$name,'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'), 'status'=>$status, 'client_id' => $clientid, 'branch' => $branch, 'effective_from' => $effective_from, 'data_transfer' => 'pending', 'updated' => date('Y-m-d'));
				}
			}	
		}
		else
		{
			if(empty($status))
			{
				if($data_transfer == 'inactive')
				{
					$userInfo = array('appusername'=>$email,'app_password'=>$prime_id,'santhe_data_transfer'=>'pending','email'=>$email, 'password'=>$password, 'roleId'=>$roleId,'name'=>$name, 'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'),'client_id'=>$clientid , 'branch'=>$branch, 'prime_id'=>$prime_id, 'effective_from' => $effective_from, 'data_transfer' => 'inactive', 'updated' => date('Y-m-d'));
				}
				else
				{
					$userInfo = array('appusername'=>$email,'app_password'=>$prime_id,'santhe_data_transfer'=>'pending','email'=>$email, 'password'=>$password, 'roleId'=>$roleId,'name'=>$name, 'mobile'=>$mobile, 'updatedBy'=>$vendorId,'updatedDtm'=>date('Y-m-d H:i:s'),'client_id'=>$clientid , 'branch'=>$branch, 'prime_id'=>$prime_id, 'effective_from' => $effective_from, 'data_transfer' => 'pending', 'updated' => date('Y-m-d'));	
				}
			}
			else
			{
				if($data_transfer == 'inactive')
				{
					$userInfo = array('appusername'=>$email,'app_password'=>$prime_id,'santhe_data_transfer'=>'pending','email'=>$email, 'password'=>$password, 'roleId'=>$roleId,'name'=>$name, 'mobile'=>$mobile, 'updatedBy'=>$vendorId,'updatedDtm'=>date('Y-m-d H:i:s'),'client_id'=>$clientid , 'branch'=>$branch, 'prime_id'=>$prime_id, 'status'=>$status, 'effective_from' => $effective_from, 'data_transfer' => 'inactive', 'updated' => date('Y-m-d'));
				}
				else
				{
					$userInfo = array('appusername'=>$email,'app_password'=>$prime_id,'santhe_data_transfer'=>'pending','email'=>$email, 'password'=>$password, 'roleId'=>$roleId,'name'=>$name, 'mobile'=>$mobile, 'updatedBy'=>$vendorId, 'updatedDtm'=>date('Y-m-d H:i:s'),'client_id'=>$clientid , 'branch'=>$branch, 'prime_id'=>$prime_id, 'status'=>$status, 'effective_from' => $effective_from, 'data_transfer' => 'pending', 'updated' => date('Y-m-d'));	
				}
			}
		}
		if(($clientid == $old_clientid) && (strcasecmp($branch, $old_branch) == 0) && (strcasecmp($email, $old_email) == 0))
		{
			$result = $this->master_model->editUser($userInfo, $userId);
		}
		else
		{
			$response = $this->master_model->checkUsernameExistForUsers($email,$clientid,$branch);	
		
		} 
		if($response)
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSU04 Username / Email Already Exist!!!</div>');
			redirect('Master_section/userList/1');
		}	
		else
		{
		    $result = $this->master_model->editUser($userInfo, $userId);
    		if($result == true)
    		{
    			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>User updation Success</div>');	
    		}
    		else
    		{
    			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>User updation Success!!!</div>');
    		}
		}
		redirect('Master_section/userList/1');
	}

	/**************** Outlets Information *************/
	// Outlet List View
	public function outlet_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['OutletsDetails'] = $this->master_model->get_outlets_details($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['OutletsDetails'] = $this->master_model->get_outlets_details($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageId'] = '29';
		$data['pageTitle'] = 'Outlet List';
		$data['Pagename'] = 'Outlet List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/outlets_list", $data);
	}

	public function filteroutletlist()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['OutletsDetails'] = $this->master_model->filter_outlet_list($clientid,$branch);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['OutletsDetails'] = $this->master_model->filter_outlet_list($clientid,$branch);
		}
		
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Filter By Client Outlet List';
		$data['Pagename'] = 'Filter By Client Outlet List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/outlets_list", $data);
	}
	// new outlet creation form
	public function add_outlet()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		// $data['brancheslist'] = $this->master_model->get_all_branches();

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Add Outlet';
		$data['Pagename'] = 'Add Outlet';
		$data['HomePage'] = 'Home';
		$this->load->view("master/outlet_creation", $data);
	}
	
	public function getBranchSLNO()
	{
	    $client_id = $this->input->post('client_id');
	    $branch = $this->input->post('branch');
	    if((!empty($branch)) && (!empty($client_id)))
	    {
		    $query=$this->db->query("SELECT a.branch_slno FROM branch_creation a, client_creation b WHERE a.client_id = b.client_id and a.client_id = $client_id and a.branch_name = '$branch'");
		    $row = $query->row_array();
		    $branch_slno = $row['branch_slno'];
		    if($branch_slno != null)
		    {
		        $array = array('status_code'=>'200','branch_slno' => $branch_slno);
		    }
		    else
		    {
		        $array = array('status_code'=>'400');
		    }
	    }
	    else
	    {
	        $array = array('status_code'=>'400');
	    }
	    echo json_encode($array);
	}
	
	// outlet information insert
	public function addoutlet() 
	{
	    $role_id = $this->session->userdata('role');
	    
		$client = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$brslno = $this->input->post('brslno');
		$invoice_prefix = strtoupper($this->input->post('in_prefix'));
		$branch_title = $this->input->post('branch_title');
		$org_name = $this->input->post('org_name');
		$land_no = $this->input->post('land_no');
		$mobile_no = $this->input->post('mobile_no');
		$branch_email = $this->input->post('branch_email');
		$gstin_no = $this->input->post('gstin_no');
		$address1 = $this->input->post('address1');
		$address2 = $this->input->post('address2');
		$website_name = $this->input->post('website_name');
		date_default_timezone_set('Asia/Kolkata');			
		$effective_from = date('Y-m-d',strtotime($this->input->post('effective_from')));
		$status = $this->input->post('status');
		$cin_no = $this->input->post('cin_no');
		
		$userInfo = array('branch_title'=>$branch_title, 'branch_slno' => $brslno, 'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no,'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'status'=> 'Pending', 'data_transfer' => 'inactive','cin_no' => $cin_no, 'api_status' => 'processing');
		
		$this->load->model('master_model');
		
		if($this->master_model->checkOutletExist($client,$branch))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Outlet Already Exist in Client and Branch!!!</div>');			
		}
		else
		{
			$result = $this->master_model->outlet_creation($userInfo);
			$last_id = $result;

			if($result > 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSAO02 Outlet Creation Failed!!!</div>');
			}
		}
		redirect('Master_section/outlet_list');
	}

	// edit outlets record information
	public function Editoutlets($outId)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['userInfo'] = $this->master_model->getoutletInfo($outId);
		$data['userlist'] = $this->master_model->activeuserList();
		$data['pageTitle'] = 'Edit Outlets';
		$data['Pagename'] = 'Edit Outlets';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_outlets", $data);
	}
	
	// update Outlet Details
	public function updateoutlet() 
	{
		$outid = $this->input->post('outid');
		$client = $this->input->post('clientid');
		$branch = $this->input->post('branch');		
		$branch_title = $this->input->post('branch_title');
		$brslno = $this->input->post('brslno');
		$invoice_prefix = strtoupper($this->input->post('in_prefix'));
		$org_name = $this->input->post('org_name');
		$land_no = $this->input->post('land_no');
		$mobile_no = $this->input->post('mobile_no');
		$branch_email = $this->input->post('branch_email');
		$gstin_no = $this->input->post('gstin_no');
		$address1 = $this->input->post('address1');
		$address2 = $this->input->post('address2');
		$website_name = $this->input->post('website_name');
		
		date_default_timezone_set('Asia/Kolkata');			
		$effective_from = date('Y-m-d',strtotime($this->input->post('effective_from')));
		$status = $this->input->post('status');
		$data_transfer = $this->input->post('data_transfer');
		$cin_no = $this->input->post('cin_no');

		$old_client = $this->input->post('old_clientid');
		$old_branch = $this->input->post('old_branch');	
		
		if(empty($status))
		{
			if($data_transfer == 'inactive')
			{
				$userInfo = array('branch_title'=>$branch_title,'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no,
			'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'data_transfer' => 'inactive','cin_no' => $cin_no, 'api_status' => 'processing');
			}
			else
			{
				$userInfo = array('branch_title'=>$branch_title,'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no,
			'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'data_transfer' => 'pending','cin_no' => $cin_no, 'api_status' => 'processing');
			}
		}
		else
		{
			if($data_transfer == 'inactive')
			{
				$userInfo = array('branch_title'=>$branch_title,'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no,
			'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'status'=>$status, 'data_transfer' => 'inactive','cin_no' => $cin_no, 'api_status' => 'processing');
			}
			else
			{
				$userInfo = array('branch_title'=>$branch_title,'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no,
			'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'status'=>$status, 'data_transfer' => 'pending', 'cin_no' => $cin_no, 'api_status' => 'processing');
			}	
		}

		$this->load->model('master_model');

		if(($client == $old_client) && (strcasecmp($branch, $old_branch) == 0))
		{
			$result = $this->master_model->outlet_update($userInfo,$outid);
		}
		else
		{
			if($this->master_model->checkOutletExist($client,$branch))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Outlet Already Exist in Client and Branch, can\'t update!!!</div>');	
				redirect('Master_section/outlet_list');		
			}
			else
			{
				$result = $this->master_model->outlet_update($userInfo,$outid);
			}
		}
		
		if($result == TRUE)
		{
		    if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$client);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$client);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}

			$userInfo = array('outid' => $outid, 'branch_title'=>$branch_title, 'branch_slno' => $brslno,'invoice_prefix' => $invoice_prefix, 'org_name'=>$org_name, 'client_id'=>$client, 'land_no'=>$land_no, 'mobile'=> $mobile_no, 'email_id'=>$branch_email, 'gstin_no'=>$gstin_no, 'address1'=>$address1, 'address2'=>$address2,'website_name'=>$website_name, 'effective_from' => $effective_from, 'branch' => $branch, 'status'=>$status, 'data_transfer' => $data_transfer, 'cin_no' => $cin_no, 'old_client' => $old_client, 'old_branch' => $old_branch);

			$url = $client_url."updateOutletDetails";

			$jsondata = json_encode($userInfo);
			
// 			print_r($jsondata);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result = curl_exec($curl);
	        
	        // print_r($result);
	        
	        $json = json_decode($result, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSUO01 Outlet updation failed!!!</div>');	
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('outId',$outid);
				$result = $this->db->update('outlet_deatils',$udata);	
			} 
			else  
			{
				$this->db2->where('outId',$outid);
				$result = $this->db2->update('outlet_deatils',$udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSUO02 Outlet updation Failed!!!</div>');
		}
		redirect('Master_section/outlet_list');
	}

	/********** module *********/
	public function module_master_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['modulelist'] = $this->master_model->module_master_list();
		$data['pageTitle'] = 'Module Master List';
		$data['Pagename'] = 'Module Master List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/module_master_list", $data);
	}

	public function add_master_module()
	{
		$data['library_js'] = $library_script = unserialize (Library_script_files);
		$data['library_css'] = $library_style = unserialize (Library_style_files);
		$data['modulegroup'] = $this->master_model->module_group_list();
		$data['pageTitle'] = 'Add New Master Module';
		$data['Pagename'] = 'Add New Master Module';
		$data['HomePage'] = 'Home';
		$this->load->view("master/add_master_module", $data);
	}

	public function insertmastermodule()
	{
		$name = $this->input->post('name');
		if(!$this->master_model->checkModuleExistInMasterModules($name))
		{
			$link = $this->input->post('link');
			$icon = $this->input->post('icon');
			$modulegroup = $this->input->post('modulegroup');
			$sections = $this->input->post('sections');

			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");
			
	        $data = array(
	           	'module_name' => $name,
	           	'link' => $link,
	           	'icon' => $icon,
	           	'module_group_id' => $modulegroup,
	           	'sections' => $sections,
	           	'created' => $created,
	       		);
	       	
	        $result = $this->db->insert('modules', $data);
            $insert_id = $this->db->insert_id();
            
			if($result > 0)
			{
			    $q = $this->db->query("select DISTINCT(client_id) from outlet_deatils");
                if ($q->num_rows() > 0)
                {
                    foreach($q->result() as $row)
                    {
                        $client_id = $row->client_id;
                        
                        
                        $select = $this->db->query("SELECT DISTINCT(b.roleId) FROM roles a, users b where a.roleId = b.roleId and b.client_id = $client_id and a.roleId != 3 and a.roleId != 8 and a.roleId != 5 and a.roleId != 7");
                        
                        if($select->num_rows() > 0)
                        {
                            foreach($select->result() as $r)
                            {
                                $module_master_id1 = $insert_id;
                                $role_id1 = $r->roleId;
                                $client_id1 = $client_id;
                                
                                $data1 = array(
                                    'module_master_id' => $module_master_id1,
                                    'role_id' => $role_id1,
                                    'status' => "Inactive",
                                    'client_id' => $client_id1
                                );
                                
                                $this->db->insert('module_creation',$data1);
                                $module_creation_id1 = $this->db->insert_id();
                                
                                if($module_creation_id1 > 0)
                                {
                                    $selectper = $this->db->query("select * from permission");
                                    if($selectper->num_rows() > 0)
                                    {
                                        foreach($selectper->result() as $per)
                                        {
                                            $permission_master_id = $per->permission_master_id;
                                            
                                            $permdata = array(
                                                'permission_master_id' => $permission_master_id,
                                                'module_creation_id' => $module_creation_id1,
                                                'role_id' => $role_id1,
                                                'status' => "Inactive",
                                                'branch' => '',
                                                'client_id' => $client_id1,
                                            );
                                            
                                            $this->db->insert('permission_creation',$permdata);
                                        }//foreach
                                    }//if    
                                }//if
                            }//foreach
                        }//if
                    }//foreach
                }//if
                
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Module created successfully</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Module creation Failed!!!</div>');
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Module Already Exist!!!</div>');
		}
		
		redirect('Master_section/module_master_list');
	}

	public function Editmastermodule($moduleid)
	{
		// echo $moduleid;
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['modulelist'] = $this->master_model->getModuleMasterDetailsById($moduleid);
		$data['modulegroup'] = $this->master_model->module_group_list();
		$data['pageTitle'] = 'Module Master Edit';
		$data['Pagename'] = 'Module Master Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_master_module", $data);
	}

	// update Module
	public function updatemastermodule()
	{
		$module_master_id = $this->input->post('module_master_id');
		$name = $this->input->post('name');
		$link = $this->input->post('link');
		$icon = $this->input->post('icon');
		$modulegroup = $this->input->post('modulegroup');
		$sections = $this->input->post('sections');

		$old_name = $this->input->post('old_name');

		date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");

		$updatedata = array(
	           	'module_name' => $name,
	           	'link'=> $link,
	           	'icon' => $icon,
	           	'module_group_id' => $modulegroup,
	           	'sections' => $sections,
	           	'updated' => $updated,
	       		);

		if(strcasecmp($name, $old_name) == 0)
		{
			$this->db->where('module_master_id', $module_master_id);
			$result = $this->db->update('modules', $updatedata);
		}
		else
		{
			if($this->master_model->checkModuleExistInMasterModules($name))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Module Already Exist! Can\'t update!</div>');
				redirect('Master_section/module_master_list');
			}
			else
			{
				$this->db->where('module_master_id', $module_master_id);
				$result = $this->db->update('modules', $updatedata);
			}
		}

       	
		if($result == TRUE)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Module updated successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Module updated Failed!!!</div>');
		}

		redirect('Master_section/module_master_list');
	}

	// module list
	public function module_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['modulelist'] = $this->master_model->module_list($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['modulelist'] = $this->master_model->module_list($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Module Creation List';
		$data['Pagename'] = 'Module Creation List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/module_list", $data);
	}

	public function filter_module_list()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['modulelist'] = $this->master_model->filter_module_list($clientid,$branch);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['modulelist'] = $this->master_model->filter_module_list($clientid,$branch);
		}
		
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Filter By Client Module List';
		$data['Pagename'] = 'Filter By Client Module List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/module_list", $data);
	}

	// add new module
	public function Add_new_modules()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['rolename'] = $this->master_model->get_role_by_name();
		$data['userlist'] = $this->master_model->role_list_active_by_client();
		$data['modulelist'] = $this->master_model->module_master_list();
		$data['pageTitle'] = 'Add New Modules';
		$data['Pagename'] = 'Add New Modules';
		$data['HomePage'] = 'Home';
		$this->load->view("master/add_module", $data);
	}

	public function getModulesForUser()
	{
		$clientid = $this->input->post('clientid');
		$roleid = $this->input->post('user');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['modulelist'] = $this->master_model->getModulesForUser($clientid,$roleid);
		$data['userdetails'] = $this->master_model->getRoleNameandClientName($clientid,$roleid);
		$data['clientid'] = $clientid;
		$data['user'] = $roleid;
		$data['pageTitle'] = 'Add New Modules';
		$data['Pagename'] = 'Add New Modules';
		$data['HomePage'] = 'Home';
		$this->load->view("master/add_module", $data);
	}

	// insert module info 
	public function insertNewmodules()
	{
	    $role_id = $this->session->userdata('role');
		$roleid = $this->input->post('user');
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		// if(!$this->master_model->checkRoleIdExistInModule($clientid,$roleid))
		// {
			$moduleid = $this->input->post('module_master_id[]');
			$status = $this->input->post('status[]');

			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");
			
		    for($i = 0; $i < count($moduleid); $i++) 
	        {
	           $data = array(
	           	'module_master_id' => $moduleid[$i],
	           	'role_id'=> $roleid,
	           	'status' => $status[$i],
	           	'branch' => $branch,
	           	'client_id' => $clientid,
	           	'created' => $created,
	           	'api_status' => 'processing'
	       		);
	       		
	       		if($role_id == '5' || $role_id == '11')
	       		{
	       		    $this->db->insert('module_creation', $data);
	       		    $last_id = $this->db->insert_id();
	       		    $id[] = array(
                        'module_id' => $last_id
                    );
	       		    $idata[] = array(
        	            'module_id' => $last_id,
        	           	'module_master_id' => $moduleid[$i],
        	           	'role_id'=> $roleid,
        	           	'status' => $status[$i],
        	           	'branch' => $branch,
        	           	'client_id' => $clientid,
        	           	'created' => $created,
    	       		);
    	       		
    	       		if($last_id > 0)
                    {
                        $selectper = $this->db->query("select * from permission");
                        if($selectper->num_rows() > 0)
                        {
                            foreach($selectper->result() as $per)
                            {
                                $permission_master_id = $per->permission_master_id;
                                
                                $permdata = array(
                                    'permission_master_id' => $permission_master_id,
                                    'module_creation_id' => $last_id,
                                    'role_id' => $roleid,
                                    'status' => "Inactive",
                                    'branch' => $branch,
                                    'client_id' => $clientid,
                                );
                                
                                $this->db->insert('permission_creation',$permdata);
                            }//foreach
                        }//if    
                    }
	       		}
	       		else
	       		{
	       		    $result = $this->db2->insert('module_creation', $data);
	       		    $last_id = $this->db2->insert_id();
	       		    $id[] = array(
                        'module_id' => $last_id
                    );
	       		    $idata[] = array(
        	            'module_id' => $last_id,
        	           	'module_master_id' => $moduleid[$i],
        	           	'role_id'=> $roleid,
        	           	'status' => $status[$i],
        	           	'branch' => $branch,
        	           	'client_id' => $clientid,
        	           	'created' => $created,
    	       		);
    	       		
    	       		if($last_id > 0)
                    {
                        $selectper = $this->db->query("select * from permission");
                        if($selectper->num_rows() > 0)
                        {
                            foreach($selectper->result() as $per)
                            {
                                $permission_master_id = $per->permission_master_id;
                                
                                $permdata = array(
                                    'permission_master_id' => $permission_master_id,
                                    'module_creation_id' => $last_id,
                                    'role_id' => $roleid,
                                    'status' => "Inactive",
                                    'branch' => $branch,
                                    'client_id' => $clientid,
                                );
                                
                                $this->db->insert('permission_creation',$permdata);
                            }//foreach
                        }//if    
                    }
	       		}
	       	}
	        

			if($last_id > 0)
			{
			    if($role_id == '5' || $role_id == '11')
    			{
    				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
    				$row = $query->row_array();
    				$client_url = $row['client_url'];
    			}
    			else
    			{
    				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
    				$row = $query->row_array();
    				$client_url = $row['client_url'];
    			}
                
    			$data1 = array (
    			        "module_creation" => $idata,
    			        "client_id" => $clientid,
    			        "role_id" => $roleid
    			    );
    
    			$url = $client_url."addModuleCreation";
    
    			$jsondata = json_encode($data1);
    			
    // 			print_r($jsondata);
    			
    			$curl = curl_init($url);
    	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
    	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
    	        'Content-Type: application/json')
    	        );
    	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
    	        $result = curl_exec($curl);
    	        
    	       // print_r($result);
    	        
    	        $json = json_decode($result, true);
    	        curl_close($curl);
    
    	        $api_status = $json['status'];
    	        $statuscode = $json['statuscode'];
    	        $response = $json['response'];
    
    			if($statuscode == "200")
    			{
    			    foreach($id as $rw) 
                    {
                       $udata[] = array(
                           'module_id' => $rw['module_id'],
                           'api_status' => 'success',
                        );
                    }
    				
    				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
    			}
    			else
    			{
    				foreach($id as $rw) 
                    {
                       $udata[] = array(
                           'module_id' => $rw['module_id'],
                           'api_status' => 'failed',
                        );
                    }
        	       	
    				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSMCA01 Module creation failed to Add!!!</div>');	
    			}
    
    			if($role_id == '5' || $role_id == '11') 
    			{ 
				    $result = $this->db->update_batch('module_creation',$udata, 'module_id');
    			} 
    			else  
    			{
				    $result = $this->db2->update_batch('module_creation',$udata, 'module_id');
    			}
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>MSMCA02 Module creation failed to Add!!!</div>');
			}
		    redirect('Master_section/module_list');
	}

//     public function insertNewmodules()
// 	{
// 		$roleid = $this->input->post('user');
// 		$clientid = $this->input->post('clientid');
// 		$branch = $this->input->post('branch');
// 		// if(!$this->master_model->checkRoleIdExistInModule($clientid,$roleid))
// 		// {
// 			$moduleid = $this->input->post('module_master_id[]');
// 			$status = $this->input->post('status[]');

// 			date_default_timezone_set("Asia/Kolkata");
// 			$created = date("Y-m-d H:i:s");
			
// 		    for($i = 0; $i < count($moduleid); $i++) 
// 	        {
// 	           $data[] = array(
// 	           	'module_master_id' => $moduleid[$i],
// 	           	'role_id'=> $roleid,
// 	           	'status' => $status[$i],
// 	           	'branch' => $branch,
// 	           	'client_id' => $clientid,
// 	           	'created' => $created,
// 	       		);
// 	       	}

// 	        $result = $this->db->insert_batch('module_creation', $data);

// 			if($result > 0)
// 			{
// 				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Module created successfully</div>');
// 			}
// 			else
// 			{
// 				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Module creation Failed!!!</div>');
// 			}
// 		// }
// 		// else
// 		// {
// 		// 	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Module Already Exist For the User!!!</div>');
// 		// }
		
// 		redirect('Master_section/module_list');
// 	}

    

	// Get Edited module info
	public function Editmodule($role_id,$clientid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$roleid = $this->session->userdata('role');
		if($roleid == '5') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['userlist'] = $this->master_model->role_list_active_by_client();
		$data['modulelist'] = $this->master_model->getmoduleInfobyRoleid($role_id,$clientid);
		$data['pageTitle'] = 'Master Modules Edit';
		$data['Pagename'] = 'Master Modules Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_module", $data);
	}

	// update Module
	public function updatemodules()
	{
	    $role_id = $this->session->userdata('role');
		$moduleid = $this->input->post('module_id[]');
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$roleid = $this->input->post('user');
		$modulemasterid = $this->input->post('module_master_id[]');
		$status = $this->input->post('status[]');

		date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");
		
	    for($i = 0; $i < count($modulemasterid); $i++) 
        {
           $updatedata[] = array(
           	'module_id' => (int)$moduleid[$i],
           	'module_master_id' => $modulemasterid[$i],
           	'role_id'=> $roleid,
           	'status' => $status[$i],
           	'branch' => $branch,
           	'client_id' => $clientid,
           	'updated' => $updated,
           	'api_status' => 'processing'
       		);
       	}

       	$old_clientid = $this->input->post('old_clientid');
		// $old_branch = $this->input->post('old_branch');
		$old_roleid = $this->input->post('old_user');

		// && (strcasecmp($branch, $old_branch) == 0)
		if(($clientid == $old_clientid) && ($roleid == $old_roleid))
		{
			$result = $this->db->update_batch('module_creation', $updatedata, 'module_id');	
		}
		else
		{
			if($this->master_model->checkRoleIdExistInModule($clientid,$roleid))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Module Already Exist For the User, Can\'t Update!!!</div>');
				redirect('Master_section/module_list');
			}
			else
			{
				$result = $this->db->update_batch('module_creation', $updatedata, 'module_id');	
			}
		}

		if($result == TRUE)
		{
		    if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}

			$data = array(
			        "module_creation" => $updatedata,
			        "old_clientid" => (int)$old_clientid,
			        "old_roleid" => (int)$old_roleid,
			        "clientid" => (int)$clientid,
			        "roleid" => (int)$roleid
			    );

			$url = $client_url."updateModuleCreation";

			$jsondata = json_encode($data);
			
// 			print_r($jsondata);
			
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result = curl_exec($curl);
	        
	       // print_r($result);
	        
	        $json = json_decode($result, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
			    for($i = 0; $i < count($modulemasterid); $i++) 
                {
                   $udata[] = array(
                   	'module_id' => (int)$moduleid[$i],
                   	'api_status' => 'success'
               		);
               	}
				
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				for($i = 0; $i < count($modulemasterid); $i++) 
                {
                   $udata[] = array(
                   	'module_id' => (int)$moduleid[$i],
                   	'api_status' => 'failed'
               		);
               	}
               	
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSMCU01 Module Creation Updation Failed!!!</div>');	
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$result = $this->db->update_batch('module_creation', $udata, 'module_id');
			} 
			else  
			{
				$result = $this->db2->update_batch('module_creation', $udata, 'module_id');
			}
		}
		else
		{			
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSMCU02 Module Creation Updation Failed!!!</div>');
		}
		redirect('Master_section/module_list');
	}

	/**************** Access Permission **************/
	public function permission_master_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['permissionlist'] = $this->master_model->permission_master_list();
		$data['pageTitle'] = 'Permission Master List';
		$data['Pagename'] = 'Permission Master List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/permission_master_list", $data);
	}

	public function add_master_permission()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['pageTitle'] = 'Add New Master Permission';
		$data['Pagename'] = 'Add New Master Permission';
		$data['HomePage'] = 'Home';
		$this->load->view("master/add_permission_master", $data);
	}

	public function insertmasterpermission()
	{
		$name = $this->input->post('name');
		if(!$this->master_model->checkPermissionExistInMasterPermission($name))
		{
			$link = $this->input->post('link');
			$icon = $this->input->post('icon');

			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");
			
	        $data = array(
	           	'permission_name' => $name,
	           	'icon' => $icon,
	           	'created' => $created,
	       		);

	        $this->db->insert('permission', $data);
	        $last_id = $this->db->insert_id();

			if($last_id > 0)
			{
			    $modulecreationlist = $this->master_model->getModuleCreationForPermission();
		
        		if($modulecreationlist != null)
        		{
        		    foreach($modulecreationlist as $mr)
        		    {
        		        $module_creation_id = $mr->module_id;
        		        $roleid = $mr->role_id;
        		        $clientid = $mr->client_id;
        		        
        		        
                      $data1 = array(
                          	'permission_master_id' => $last_id,
                          	'module_creation_id'=> $module_creation_id,
                          	'role_id'=> $roleid,
                          	'status' => 'Inactive',
                          	'branch' => $branch,
                          	'client_id' => $clientid,
                          	'created' => $created,
                  		);
                   		
                  		$this->db->insert('permission_creation', $data1);
                  		$result = $this->db->insert_id();
                       	
        		    }
        		}

        		if($result > 0)
        		{
        			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Permission '.$name.' created successfully with Permission Creation</div>');
        		}
        		else
        		{
        			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Permission '.$name.' created successfully</div>');
        		}   
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Permission creation Failed to add!!!</div>');
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Permission Already Exist!!!</div>');
		}
		
		redirect('Master_section/permission_master_list');
	}

	public function Editmasterpermission($permissionid)
	{
		// echo $moduleid;
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['permissionlist'] = $this->master_model->getPermissionMasterDetailsById($permissionid);		
		$data['pageTitle'] = 'Permission Master Edit';
		$data['Pagename'] = 'Permission Master Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_permission_master", $data);
	}

	// update Module
	public function updatemasterpermission()
	{
		$permission_master_id = $this->input->post('permission_master_id');
		$name = $this->input->post('name');
		$icon = $this->input->post('icon');

		$old_name = $this->input->post('old_name');

		date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");

		$updatedata = array(
	           	'permission_name' => $name,
	           	'icon' => $icon,
	           	'updated' => $updated,
	       		);

		if(strcasecmp($name, $old_name) == 0)
		{
			$this->db->where('permission_master_id', $permission_master_id);
			$result = $this->db->update('permission', $updatedata);
		}
		else
		{
			if($this->master_model->checkPermissionExistInMasterPermission($name))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Permission Already Exist! Can\'t update!</div>');
				redirect('Master_section/permission_master_list');
			}
			else
			{
				$this->db->where('permission_master_id', $permission_master_id);
				$result = $this->db->update('permission', $updatedata);
			}
		}

		if($result == TRUE)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Permission updated successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Permission updated Failed!!!</div>');
		}

		redirect('Master_section/permission_master_list');
	}

	// Permissions list
	public function permissions_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['PermissionsDetails'] = $this->master_model->get_permissions_details($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['PermissionsDetails'] = $this->master_model->get_permissions_details($client_id);
			
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		
		$data['pageTitle'] = 'permissions List';
		$data['Pagename'] = 'Permissions List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/permission_list", $data);
	}

	public function filter_permissions_list()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['PermissionsDetails'] = $this->master_model->filter_permissions_list($clientid,$branch);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['PermissionsDetails'] = $this->master_model->filter_permissions_list($clientid,$branch);
			
		}
		
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Filter By Client Permission List';
		$data['Pagename'] = 'Filter By Client Permission List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/permission_list", $data);
	}
	
	public function add_new_permission()
	{
	    $data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['permissionlist'] = $this->master_model->permission_master_list();
		$data['permissioncreationexist'] = $this->master_model->permissioncreationexist();
		$data['pageTitle'] = 'Add New Permission Creation';
		$data['Pagename'] = 'Add New Permission Creation';
		$data['HomePage'] = 'Home';
		$this->load->view("master/add_permission", $data);
	}
	
    // insert new permission insert record
	public function insertNewpermission()
	{
		$permissionid = $this->input->post('permission_master_id[]');
		$status = $this->input->post('status[]');

		date_default_timezone_set("Asia/Kolkata");
		$created = date("Y-m-d H:i:s");
		
		$modulecreationlist = $this->master_model->getModuleCreationForPermissionCreation();
		
		if($modulecreationlist == null)
		{
		    $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> All Permission are Up To Date</div>');
		}
		else
		{
		    foreach($modulecreationlist as $mr)
		    {
		        $module_creation_id = $mr->module_id;
		        $roleid = $mr->role_id;
		        $clientid = $mr->client_id;
		        
		        
    		    for($i = 0; $i < count($permissionid); $i++) 
                {
                  $data = array(
                      	'permission_master_id' => $permissionid[$i],
                      	'module_creation_id'=> $module_creation_id,
                      	'role_id'=> $roleid,
                      	'status' => $status[$i],
                      	'branch' => $branch,
                      	'client_id' => $clientid,
                      	'created' => $created,
              		);
               		
              		$this->db->insert('permission_creation', $data);
              		$result = $this->db->insert_id();
              	}
               	
		    }
		    
		  //  echo "Result Value : ".$result;
    
            
    
    		if($result > 0)
    		{
    			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Permissions are added</div>');
    		}
    		else
    		{
    			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Permission creation Failed!!!</div>');
    		}   
		}
		redirect('Master_section/permissions_list');
	}

// 	public function insertNewpermission()
// 	{
// 		$permissionid = $this->input->post('permission_master_id[]');
// 		$status = $this->input->post('status[]');

// 		date_default_timezone_set("Asia/Kolkata");
// 		$created = date("Y-m-d H:i:s");
		
// 		$select = $this->db->query('SELECT DISTINCT(permission_master_id) from permission_creation');
// 		if($select->num_rows() > 0)
// 		{
// 		    foreach($select->result() as $p)
// 		    {
// 		        $dist_permission_master_id = $p->permission_master_id;
// 		        for($i = 0; $i < count($permissionid); $i++) 
// 		        {
// 		            $permission_master_id = $permissionid[$i];
// 		            $status =  $status[$i];
// 		            if($dist_permission_master_id == $permission_master_id)
// 		            {
// 		                $modulecreationlist = $this->master_model->getModuleCreationForPermissionCreation();
		                
// 		                if($modulecreationlist != null)
// 		                {
// 		                    foreach($modulecreationlist as $mr)
//                 		    {
//                 		        $module_creation_id = $mr->module_id;
//                 		        $roleid = $mr->role_id;
//                 		        $clientid = $mr->client_id;
                    		    
//                                 $data = array(
//                                   	'permission_master_id' => $permission_master_id,
//                                   	'module_creation_id'=> $module_creation_id,
//                                   	'role_id'=> $roleid,
//                                   	'status' => $status,
//                                   	'branch' => $branch,
//                                   	'client_id' => $clientid,
//                                   	'created' => $created,
//                           		);
                               		
//                               		$this->db->insert('permission_creation', $data);
//                               		$result = $this->db->insert_id();
//                 		    }
// 		                }
// 		                else
// 		                {
// 		                    $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>MSG-1: All Permission are Up To Date</div>');
// 		                }
// 		            }
// 		            else
// 		            {
// 		                $modulecreationlist = $this->master_model->getModuleCreationForPermission();
// 		                if($modulecreationlist != null)
// 		                {
// 		                    foreach($modulecreationlist as $mr)
//                 		    {
//                 		        $module_creation_id = $mr->module_id;
//                 		        $roleid = $mr->role_id;
//                 		        $clientid = $mr->client_id;
                		        
//                                 $data = array(
//                                   	'permission_master_id' => $permission_master_id,
//                                   	'module_creation_id'=> $module_creation_id,
//                                   	'role_id'=> $roleid,
//                                   	'status' => $status[$i],
//                                   	'branch' => $branch,
//                                   	'client_id' => $clientid,
//                                   	'created' => $created,
//                           		);
                           		
//                           		$this->db->insert('permission_creation', $data);
//                           		$result = $this->db->insert_id();
//                 		    }
// 		                }
// 		                else
// 		                {
// 		                    $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>MSG-2: All Permission are Up To Date</div>');
// 		                }
// 		            }
// 		        }
// 		    }
// 		}
// 		else
// 		{
// 		    $modulecreationlist = $this->master_model->getModuleCreationForPermission();
//             if($modulecreationlist != null)
//             {
//                 foreach($modulecreationlist as $mr)
//     		    {
//     		        $module_creation_id = $mr->module_id;
//     		        $roleid = $mr->role_id;
//     		        $clientid = $mr->client_id;
    		        
//                     $data = array(
//                       	'permission_master_id' => $permission_master_id,
//                       	'module_creation_id'=> $module_creation_id,
//                       	'role_id'=> $roleid,
//                       	'status' => $status[$i],
//                       	'branch' => $branch,
//                       	'client_id' => $clientid,
//                       	'created' => $created,
//               		);
               		
//               		$this->db->insert('permission_creation', $data);
//               		$result = $this->db->insert_id();
//     		    }
//             }
//             else
//             {
//                 $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>MSG-3: All Permission are Up To Date</div>');
//             }
// 		}
		
//         if($result > 0)
// 		{
// 			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Permissions are added</div>');
// 		}
// 		else
// 		{
// 			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Permission creation Failed!!!</div>');
// 		}
// 		redirect('Master_section/permissions_list');
// 	}



	// Edit Created customers
	public function Editpermission($permission_id)
	{		
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
// 		$data['userdetails'] = $this->master_model->getRoleNameandClientNameandModuleName($clientid,$roleid,$moduleid);
		$data['permissionlist'] = $this->master_model->getpermissionInfo($permission_id);
		$data['pageTitle'] = 'Permission Creation Edit';
		$data['Pagename'] = 'Permission Creation Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_permission", $data);
	}

	// update created customers details
	public function updatepermissions()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$moduleid = $this->input->post('module_creation_id');
		$roleid = $this->input->post('user');
		$permissionid = $this->input->post('permission_id');
		$permissionmasterid = $this->input->post('permission_master_id');
		$status = $this->input->post('status');
		
		$client_name = $this->input->post('client_name');
		$user_name = $this->input->post('user_name');
        $module_name = $this->input->post('module_name');
        $permission_name = $this->input->post('permission_name');

		date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");
		
          $updatedata = array(
          	'permission_id' => $permissionid,
          	'permission_master_id' => $permissionmasterid,
          	'module_creation_id'=> $moduleid,
          	'role_id'=> $roleid,
          	'status' => $status,
          	'branch' => $branch,
          	'client_id' => $clientid,
          	'updated' => $updated,
          	'api_status' => 'processing'
      		);
    
        // print_r($updatedata);
        
        $this->db->where('permission_id',$permissionid);
		$result = $this->db->update('permission_creation',$updatedata);
		

		if($result == TRUE)
		{
		    $role_id = $this->session->userdata('role');
			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}

            $data = array(
              	'permission_id' => $permissionid,
              	'permission_master_id' => $permissionmasterid,
              	'module_creation_id'=> $moduleid,
              	'role_id'=> $roleid,
              	'status' => $status,
              	'branch' => $branch,
              	'client_id' => $clientid,
              	'updated' => $updated,
              	'client_name' => $client_name,
                'user_name' => $user_name,
                'module_name' => $module_name,
                'permission_name' => $permission_name
      		);
            
			$url = $client_url."updatePermissionCreation";

			$jsondata = json_encode($data);
			
// 			print_r($jsondata);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result1 = curl_exec($curl);
	        
	       // print_r($result1);
	        
	        $json = json_decode($result1, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);

				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);

	        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSPCE01 Permission updation Failed <b> Permission : '.$permission_name.' , Module : '.$module_name.' , Role : '.$user_name.' , Client : '.$client_name.'</b>!!!</div>');
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('permission_id',$permissionid);
		        $result = $this->db->update('permission_creation',$udata);
			} 
			else  
			{
				$this->db2->where('permission_id',$permissionid);
		        $result = $this->db2->update('permission_creation',$udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSPCE02 Permission updation Failed <b> Permission : '.$permission_name.' , Module : '.$module_name.' , Role : '.$user_name.' , Client : '.$client_name.'</b>!!!</div>');
		}
		redirect('Master_section/permissions_list');
	}

	/********* Crdited customers ***************/
	// created customers creation
	public function Credit_customers_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['userRecords'] = $this->master_model->created_customers_list($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['userRecords'] = $this->master_model->created_customers_list($client_id);
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Credit Customers List';
		$data['Pagename'] = 'Credit Customers List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/Credit_customers_list",$data);
	}

	public function filtercreditcustomerlist()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['userRecords'] = $this->master_model->filter_credit_customer_list($clientid,$branch);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['userRecords'] = $this->master_model->filter_credit_customer_list($clientid,$branch);
		}
		
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Filter By Client Credit Customers List';
		$data['Pagename'] = 'Filter By Client Credit Customers List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/Credit_customers_list", $data);
	}

	// Add New Created Customers -form
	public function Add_new_credit_customers()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['brancheslist'] = $this->master_model->get_all_branches();
		$data['pageTitle'] = 'Credit Customers Creation';
		$data['Pagename'] = 'Credit Customers Creation';
		$data['HomePage'] = 'Home';
		$this->load->view("master/add_credit_customers", $data);
	}

	// insert new credit customers 
	public function insertNewCreditedcustomer()
	{
		$cust_name = $this->input->post('cust_name');
		$phone_number = $this->input->post('cust_phone');
		$gst_no = $this->input->post('cust_gst_no');
		$cust_address = $this->input->post('cust_address');
		$status = $this->input->post('cust_status');
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		date_default_timezone_set('Asia/Kolkata');			
		$effective_from = date('Y-m-d',strtotime($this->input->post('effective_from')));

		$userInfo = array('cust_name'=> $cust_name,'phone_number'=>$phone_number,'gst_no'=>$gst_no,'status'=>$status,'branch'=>$branch, 'client_id' => $clientid, 'effective_from' => $effective_from, 'data_transfer' => 'pending', 'api_status' => 'processing', 'cust_address' => $cust_address);
		
		if($this->master_model->checkCreditCustomerExist($clientid,$branch,$gst_no))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Customer Already Exist in Client and Branch!!!</div>');
		}
		else
		{
			$result = $this->master_model->insertNewCreditCustomer($userInfo);
			$last_id = $result;

			if($result > 0)
			{
			    $role_id = $this->session->userdata('role');
				if($role_id == '5' || $role_id == '11')
				{
					$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}
				else
				{
					$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}

                $data = array(
                    'cust_id' => $last_id, 
                    'cust_name'=> $cust_name,
                    'phone_number'=>$phone_number,
                    'gst_no'=>$gst_no,
                    'cust_address' => $cust_address,
                    'status'=>$status,
                    'branch'=>$branch,
                    'client_id' => $clientid,
                    'effective_from' => $effective_from, 
                    'data_transfer' => 'pending'
                );

				$url = $client_url."addCreditCustomer";

				$jsondata = json_encode($data);
				
				$curl = curl_init($url);
		        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
		        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
		        'Content-Type: application/json')
		        );
		        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
		        $result1 = curl_exec($curl);
		        
		      //  print_r($result1);
		        
		        $json = json_decode($result1, true);
		        curl_close($curl);

		        $api_status = $json['status'];
		        $statuscode = $json['statuscode'];
		        $response = $json['response'];

				if($statuscode == "200")
				{
					$udata = array(
		        	'api_status' => 'success', 
		        	);

					$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
				}
				else
				{
					$udata = array(
		        	'api_status' => 'failed', 
		        	);

		        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCCA01 Credit Customer creation failed!!!</div>');
				}

				if($role_id == '5' || $role_id == '11') 
				{ 
					$this->db->where('cust_id',$last_id);
					$result = $this->db->update('credit_customer',$udata);
				} 
				else  
				{
					$this->db2->where('cust_id',$last_id);
					$result = $this->db2->update('credit_customer',$udata);
				}
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCCA02 Credit Customer creation failed!!!</div>');
			}
		}
		redirect('Master_section/Credit_customers_list');
	}

	// Edit Created customers
	public function EditcreditCustomer($cust_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			
		}
		$data['userInfo'] = $this->master_model->getCreditedInfo($cust_id);
		$data['Status'] = $this->master_model->getstatusInfo($cust_id);
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['brancheslist'] = $this->master_model->get_all_branches();
		$data['pageTitle'] = 'Credit Customer Edit';
		$data['Pagename'] = 'Credit Customer Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_credit_customer", $data);
	}

	// update created customers details
	public function updateCreditedcustomers()
	{
		$cust_id = $this->input->post('customerid');
		$cust_name = $this->input->post('cust_name');
		$phone_number = $this->input->post('cust_phone');
		$cust_address = $this->input->post('cust_address');
		$gst_no = $this->input->post('cust_gst_no');
		$clientid = $this->input->post('clientid');
		$status = $this->input->post('cust_status');
		$branch = $this->input->post('branch');

		$old_clientid = $this->input->post('old_clientid');
		$old_branch = $this->input->post('old_branch');
		$old_gst_no = $this->input->post('old_cust_gst_no');

		date_default_timezone_set('Asia/Kolkata');			
		$effective_from = date('Y-m-d',strtotime($this->input->post('effective_from')));

		$userInfo = array('cust_name'=> $cust_name,'phone_number'=>$phone_number,'gst_no'=>$gst_no,'status'=>$status,'branch'=>$branch, 'client_id' => $clientid, 'effective_from' => $effective_from, 'data_transfer' => 'pending','api_status' => 'processing', 'cust_address'=>$cust_address);
		
// 		print_r($userInfo);

		if(($clientid == $old_clientid) && (strcasecmp($branch, $old_branch) == 0) && (strcasecmp($gst_no, $gst_no) == 0))
		{
			$result = $this->master_model->updatedcreditedCustomer($userInfo, $cust_id);
		}
		else
		{
			if($this->master_model->checkCreditCustomerExist($clientid,$branch,$gst_no))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Customer Already Exist in Client and Branch, Can\'t Update!!!</div>');
				redirect('Master_section/Credit_customers_list');
			}
			else
			{
				$result = $this->master_model->updatedcreditedCustomer($userInfo, $cust_id);
			}
		}

		if($result == true)
		{
		    $role_id = $this->session->userdata('role');
			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
            
            $data = array(
    		    'cust_id' => $cust_id,
    		    'cust_name'=> $cust_name,
    		    'phone_number'=>$phone_number,
    		    'gst_no'=>$gst_no,
    		    'cust_address'=>$cust_address,
    		    'status'=>$status,
    		    'branch'=>$branch, 
    		    'client_id' => $clientid,
    		    'effective_from' => $effective_from,
    		    'data_transfer' => 'pending',
    		    'old_clientid' => $old_clientid,
    		    'old_branch' =>$old_branch ,
    		    'old_gst_no' => $old_gst_no,
    		);
    		
			$url = $client_url."updateCreditCustomer";

			$jsondata = json_encode($data);
			
// 			print_r($jsondata);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result1 = curl_exec($curl);
	        
	       // print_r($result1);
	        
	        $json = json_decode($result1, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);

				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);

	        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-ERR-MSCCU01 Credit Customer Updation failed!!!</div>');
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('cust_id', $cust_id);
				$result = $this->db->update('credit_customer',$udata);
			} 
			else  
			{
				$this->db2->where('cust_id', $cust_id);
				$result = $this->db2->update('credit_customer',$udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCCU02 Credit Customer Updation failed!!!</div>');
		}
		redirect('Master_section/Credit_customers_list');
	}

	

	// Product List
	public function Products_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		// $data['userRecords'] = $this->master_model->Products_list();
		// $data['category'] = $this->master_model->getCategory();
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->Products_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->Products_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
		$data['userInfo'] = $this->master_model->company_list();
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Product List';
		$data['Pagename'] = 'Product List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/product_list",$data);
	}

	public function filterproductlist($mid)
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$category = $this->input->post('category');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filter_product_list($clientid,$branch,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->filter_product_list($clientid,$branch,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Filter By Client Product List';
		$data['Pagename'] = 'Filter By Client Product List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/product_list", $data);
	}
	
	public function Online_Products_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->Online_Products_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->Online_Products_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Online Product List';
		$data['Pagename'] = 'Online Product List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/online_product_list",$data);
	}
	
	public function filteronlineproductlist($mid)
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$category = $this->input->post('category');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filter_online_product_list($clientid,$branch,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->filter_online_product_list($clientid,$branch,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		$data['pageTitle'] = 'Filter By Client Online Product List';
		$data['Pagename'] = 'Filter By Client Online Product List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/online_product_list", $data);
	}
	
	public function Counter_Products_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->Counter_Products_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->Counter_Products_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Counter Product List';
		$data['Pagename'] = 'Counter Product List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/counter_product_list",$data);
	}
	
	public function filtercounterproductlist($mid)
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$category = $this->input->post('category');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filter_counter_product_list($clientid,$branch,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->filter_counter_product_list($clientid,$branch,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		$data['pageTitle'] = 'Filter By Client Counter Product List';
		$data['Pagename'] = 'Filter By Client Counter Product List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/counter_product_list", $data);
	}
	
	//Product List by product code
	public function product_list_by_product_code()
	{
	    $data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list_active($client_id);
            $data['userRecords'] = $this->master_model->ProductsByProductCode($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list_active($client_id);
            $data['userRecords'] = $this->master_model->ProductsByProductCode($client_id);
		}
// 		$data['Permission'] = $this->master_model->login_permission_access($mid);
	   // $data['mid'] = $mid;
		$data['pageTitle'] = 'Product List by Product Code';
		$data['Pagename'] = 'Product List by Product Code';
		$data['HomePage'] = 'Home';
		$this->load->view("master/product_list_by_product_code",$data);
	}
	
	public function filter_product_list_by_product_code()
	{
	    $clientid = $this->input->post('clientid');
		$category = $this->input->post('category');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filterProductsByProductCode($clientid,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->filterProductsByProductCode($clientid,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list_active($client_id);
		}
// 		$data['Permission'] = $this->master_model->login_permission_access($mid);
	   // $data['mid'] = $mid;
		$data['pageTitle'] = 'Product List by Product Code';
		$data['Pagename'] = 'Product List by Product Code';
		$data['HomePage'] = 'Home';
		$this->load->view("master/product_list_by_product_code", $data);
	}
	
	public function edit_product_by_product_code($clientid,$product_code)
	{
	    $data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list_active($client_id);
			//Clientid is passed from page client_id is login session id
			$data['baseProd'] = $this->master_model->getProductInfoByProductCode($clientid,$product_code);
			$data['counterProd'] = $this->master_model->getCounterProductsByProductCode($clientid,$product_code);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list_active($client_id);
			//Clientid is passed from page client_id is login session id
            $data['baseProd'] = $this->master_model->getProductInfoByProductCode($clientid,$product_code);
			$data['counterProd'] = $this->master_model->getCounterProductsByProductCode($clientid,$product_code);
		}
		$data['taxes'] = $this->master_model->tax_list_active();
		$data['pageTitle'] = 'Product Multi Edit';
		$data['Pagename'] = 'Product Multi Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/product_multi_edit", $data);
	}
	
	public function credit_advance_iteminsert()
	{
	    $customer_id = $this->input->post('customer_id');
	    
	    $item_name = $this->input->post('item_name');
        $item_number = $this->input->post('item_number');
        $branches = $this->input->post('branch');
        $product_price = $this->input->post('product_price');
        $tax_pecentage = $this->input->post('tax_pecentage');
        $item_hsn = $this->input->post('hsn_code');
        $pr_cat_id = $this->input->post('pr_cat_id');
        $cat_id = $this->input->post('cat_id');
        $status = $this->input->post('status');
        $item_ids = $this->input->post('item_ids');
        $spl_item_id = $this->input->post('spl_item_id');
        
        $final_pecrentage=0;
        if($tax_pecentage =='5')
        {
            $final_pecrentage=1.05;
        } else if ($tax_pecentage =='12')
        {
            $final_pecrentage=1.12;
        } else if ($tax_pecentage =='18') {
            $final_pecrentage=1.18;
        } else if ($tax_pecentage =='28') {
            $final_pecrentage=1.28;
        }
        
        $basic_rate = round($product_price / $final_pecrentage,2);
        $basic_tax = round($product_price - $basic_rate,2);
        $divided_gst = round($basic_tax /2,2);
        $divided_tax = $tax_pecentage /2;
        $query = $this->db->query("UPDATE splproduct set  basic_rate='$basic_rate', basic_tax_percent='$tax_pecentage',basic_tax_amount='$basic_tax',sgst_tax='$divided_tax',sgst_tax_amount='$divided_gst',cgst_tax='$divided_tax',cgst_tax_amount='$divided_gst',price='$product_price', product_status='$status' where spl_id ='$spl_item_id'");
        $total = $this->db->affected_rows();
        if($total>0)
        {
            $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Product updation success!!!</div>');
        } else {
            $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Product updation Failed!!!</div>');
        }
        //$lastid = $this->db->insert_id();
        redirect('Master_section/Institutional_product_list/110');
	}
	
	public function Institutional_product_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->Products_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->get_all_splproducts();
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	    $data['mid'] = $mid;
		$data['pageTitle'] = 'Assigned Product List';
		$data['Pagename'] = 'Assigned Product List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/institutional_productlist",$data);
	}
	
	// product filtter
	public function Splfilterproductlist($mid)
	{
		$branch = $this->input->post('branch');
		$category = $this->input->post('category');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filter_product_list($clientid,$branch,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->fillter_splproducts($branch,$category);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	    $data['mid'] = $mid;
		$data['pageTitle'] = 'Assigned Product List';
		$data['Pagename'] = 'Assigned Product List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/institutional_productlist", $data);
	}
	
	public function assign_items_individuval($spl_id,$branch,$pr_id,$cust_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->get_special_customer1($branch,$cust_id);
		$data['taxes'] = $this->master_model->tax_list_active();
		$data['productInfo'] = $this->master_model->get_product_details1($pr_id,$branch);
		$data['infoprodetails'] = $this->master_model->get_insti_details1($spl_id,$branch);
		$data['pageTitle'] = 'Assign Item Edit';
		$data['Pagename'] = 'Assign Items Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/assign_items_edit", $data);
	}
	
	public function update_product_by_product_code_multi()
	{
	    $clientid = $this->input->post('clientid');
	    $product_code = $this->input->post('product_code');
        $branches = $this->input->post('branch[]');
        $product_name = $this->input->post('product_name');
        $counter_product_ids = $this->input->post('product_id[]');
        $product_prices = $this->input->post('product_price[]');
        $basic_product_prices = $this->input->post('basic_price[]');
        $tax_pecentages = $this->input->post('tax_pecentage[]');
        $basic_tax_amounts = $this->input->post('basic_tax_amount[]');
        $cgst_prices = $this->input->post('cgst_price[]');
        $sgst_prices = $this->input->post('sgst_price[]');
        $cgst_taxs = $this->input->post('cgst_tax[]');
        $sgst_taxs = $this->input->post('sgst_tax[]');
        $effective_from = date("Y-m-d", strtotime($this->input->post('effective')));
        $social_order_statuses = $this->input->post('social_order_status[]');
        
        $counter_product_statuses = $this->input->post('counter_product_status[]');
        $social_product_statuses = $this->input->post('social_product_status[]');
        
        
        $tdata = array("client_id" => $clientid, "branch" => $branch, "product_name" => $product_name, "product_price" => $product_price, "basic_product_price" => $basic_product_price, "tax_pecentage" => $tax_pecentage, "basic_tax_amount" => $basic_tax_amount, "cgst_price" =>$cgst_price, "sgst_price" => $sgst_price, "cgst_tax" => $cgst_tax, "sgst_tax" => $sgst_tax, "effective_from" => $effective_from, "social_order_id" => $social_order_id, "social_order_percentage" => $social_order_percentage, "counter_product_status" => $counter_product_status, "social_product_status" => $social_product_status);
        // print_r($tdata);
        
        for($i=0; $i<count($branches); $i++)
        {
            $branch = $branches[$i];
            $counter_product_id = $counter_product_ids[$i];
            $product_price = $product_prices[$i];
            $basic_product_price = $basic_product_prices[$i];
            $tax_pecentage = $tax_pecentages[$i];
            $basic_tax_amount = $basic_tax_amounts[$i];
            $cgst_price = $cgst_prices[$i];
            $sgst_price = $sgst_prices[$i];
            $cgst_tax = $cgst_taxs[$i];
            $sgst_tax = $sgst_taxs[$i];
            $social_order_status = $social_order_statuses[$i];
            $counter_product_status = $counter_product_statuses[$i];
            
            $Allprod[] = array("pr_id" => $counter_product_id,
                                 "price" => $product_price,
                                 "basic_rate" => $basic_product_price,
                                 "basic_tax_percent" => $tax_pecentage,
                                 "basic_tax_amount" => $basic_tax_amount,
                                 "cgst_tax_amount" => $cgst_price,
                                 "sgst_tax_amount" => $sgst_price,
                                 "cgst_tax" => $cgst_tax,
                                 "sgst_tax" => $sgst_tax,
                                 "product_status" => $counter_product_status,
                                 "effective_from" => $effective_from,
                                 "data_transfer" => "pending"
                            );
            
            // $social_order_id = $social_order_ids[$i];
            $role_id = $this->session->userdata('role');
            if($role_id == '5' || $role_id == '11') 
            {
                $query = $this->db->query("SELECT a.* from product a, client_creation b where a.client_id = b.client_id and a.branch = '$branch' and a.product_code = $product_code and a.social_order = 1");
            }
            else
            {
                $query = $this->db2->query("SELECT a.* from product a, client_creation b where a.client_id = b.client_id and a.branch = '$branch' and a.product_code = $product_code and a.social_order = 1");
            }
            
		    if($query->num_rows() > 0)
		    {
		        $qrow = $query->row_array();
		        $social_order_id = $qrow['pr_id'];
		        
		        if($role_id == '5' || $role_id == '11')
                {
                    $q=$this->db->query("SELECT a.* from branch_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch_name = '$branch'");
                    $row = $q->row_array();
                    $social_order_percentage = $row['social_order_percentage'];
                }
                else
                {
                    $q=$this->db2->query("SELECT a.* from branch_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch_name = '$branch'");
                    $row = $q->row_array();
                    $social_order_percentage = $row['social_order_percentage'];
                }
                
                $social_product_status = $social_product_statuses[$i];
                
                $social_order_percent = $social_order_percentage / 100;
                $basic_product_price1 = $basic_product_price + ($basic_product_price * $social_order_percent);
                $basic_tax_amount1 = $basic_tax_amount + ($basic_tax_amount * $social_order_percent);
                $sgst_price1 = $sgst_price + ($sgst_price * $social_order_percent);
                $cgst_price1 = $cgst_price + ($cgst_price * $social_order_percent);
                $product_price1 = $product_price + ($product_price * $social_order_percent);
                
                $Allprod[] = array("pr_id" => $social_order_id,
                                    "price" => round($product_price1,2),
                                     "basic_rate" => round($basic_product_price1,2),
                                     "basic_tax_percent" => $tax_pecentage,
                                     "basic_tax_amount" => round($basic_tax_amount1,2),
                                     "cgst_tax_amount" => round($cgst_price1,2),
                                     "sgst_tax_amount" => round($sgst_price1,2),
                                     "cgst_tax" => $cgst_tax,
                                     "sgst_tax" => $sgst_tax,
                                     "product_status" => $social_product_status,
                                     "effective_from" => $effective_from,
                                     "data_transfer" => "pending"
                            );
            }
        }
        
        // print_r($Allprod);
            
        if($role_id == '5' || $role_id == '11') 
        {
            $response = $this->db->update_batch('product', $Allprod, 'pr_id');
        } 
        else  
        {
            $response = $this->db2->update_batch('product', $Allprod, 'pr_id');
        }
        
        if($response < 0)
        {
            $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSPMU01 Product Updation Failed!!!</div>');
            redirect('Master_section/product_list_by_product_code');
        }
        else
        {
            if($role_id == '5' || $role_id == '11')
            {
                $query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
                $row = $query->row_array();
                $client_url = $row['client_url'];
            }
            else
            {
                $query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
                $row = $query->row_array();
                $client_url = $row['client_url'];
            }

            $url = $client_url."updateProductbyProductCodeMulti";
            
            $jsarray = array("Product Name" => $product_name,
                             "Product Code" => $product_code,
                             "Products" => $Allprod
                            ); 

            $jsondata = json_encode($jsarray);
            
            // print_r($jsondata);
            
            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json')
            );
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
            $result = curl_exec($curl);
            
            // print_r($result);
            
            $json = json_decode($result, true);
            curl_close($curl);

            $api_status = $json['status'];
            $statuscode = $json['statuscode'];
            $response = $json['response'];

            if($statuscode == "200")
            {
                $udata = array(
                'api_status' => 'success', 
                );

                $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
            }
            else
            {
                $udata = array(
                'api_status' => 'failed', 
                );

                $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSPMU02 Products Updation failed!!!</div>');
            }

            if($role_id == '5' || $role_id == '11')
            {
                $where = array('client_id' => $clientid, 'product_code' => $product_code);
                $this->db->where($where);
                $sqlresult = $this->db->update('product',$udata);
            }
            else
            {
                $where = array('client_id' => $clientid, 'product_code' => $product_code);
                $this->db2->where($where);
                $sqlresult = $this->db2->update('product',$udata);
            }
        }
        redirect('Master_section/product_list_by_product_code');
	}

	// New Product Add
	public function addNewProducts()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		// $data['discount'] = $this->master_model->category_list_active();
		$data['uoms'] = $this->master_model->uom_list_active();
		$data['taxes'] = $this->master_model->tax_list_active();
		$data['pageTitle'] = 'Product Add';
		$data['Pagename'] = 'Product Add';
		$data['HomePage'] = 'Home';
		$this->load->view("master/add_products", $data);
	}
	
	public function getTokenGroupByBranch()
	{
        $branch_id = $this->input->post('branch_id');
        // get data
        $data = $this->master_model->getTokenGroupByBranch($branch_id);
        foreach($data as $row)
		{
    	    $token_group_id = $row->tokengroup;
    	    echo "<div class='card text-white bg-secondary mb-3' style='max-width: 18rem;'>";
            echo "<div class='card-header'>Token Group : $token_group_id </div>";
    	    $query2=$this->db->query("SELECT DISTINCT(b.pr_cat_name) FROM product a, product_category b WHERE a.pr_cat_id = b.pr_cat_code and a.tokengroup = $token_group_id");
    		$values2 = $query2->result_array();
    		foreach ($values2 as $r1) 
    		{
    		    $pr_cat_name = $r1['pr_cat_name']; 
    		    echo "<div class='card-body'>";
                echo "<h5 class='card-title'>$pr_cat_name </h5>";
                echo "</div>";
            }		  
		     echo " </div>";
		}
	}

	// Insert New Product
// 	public function insertNewProductsOld()
// 	{
// 		$clientid = $this->input->post('clientid');
// 		$branch = $this->input->post('branch');
// 		$categoryId = $this->input->post('categoryId');
// 		$product_name = $this->input->post('product_name');
// 		$product_code = $this->input->post('product_code');
// 		$product_uom = $this->input->post('product_uom');
// 		$product_price = $this->input->post('product_price');
// 		$basic_product_price = $this->input->post('basic_product_price');
// 		$tax_pecentage = $this->input->post('tax_pecentage');
// 		$basic_tax_amount = $this->input->post('basic_tax_amount');
// 		$cgst_price = $this->input->post('cgst_price');
// 		$sgst_price = $this->input->post('sgst_price');
// 		$cgst_tax = $this->input->post('cgst_tax');
// 		$sgst_tax = $this->input->post('sgst_tax');

// 		$product_stock = $this->input->post('product_stock');
		
// 		$product_status1 = $this->input->post('product_status');
// 		if($product_status1 == "true")
// 	    {
// 	        $product_status = "Active";
// 	    }
// 	    else
// 	    {
// 	        $product_status = "Inactive";
// 	    }
		
// 		$product_hsn = $this->input->post('product_hsn');
// 		$effective = $this->input->post('effective');
		
// 		$cat_token1 = $this->input->post('cat_token');
// 		if($cat_token1 == "true")
// 	    {
// 	        $cat_token = 1;
// 	    }
// 	    else
// 	    {
// 	        $cat_token = 0;
// 	    }
		
// 		$token_group = $this->input->post('token_group');

// 		$social_order1 = $this->input->post('social_order');
// 		if($social_order1 == "true")
// 	    {
// 	        $social_order = "1";
// 	    }
// 	    else
// 	    {
// 	        $social_order = "0";
// 	    }
	    
// 		$sales_item_type = $this->input->post('sales_item_type');
// 		$product_type = $this->input->post('product_type');
// 		$combination = $this->input->post('combination');
// 		$stock_status = $this->input->post('stock_status');
// 		$stock_limit = $this->input->post('stock_limit');

// 		$effectdate = date('Y-m-d',strtotime($effective));
// 		$sorting_order = $this->input->post('sorting_order');
		
// 		$date = date('Y-m-d');

// 		$role_id = $this->session->userdata('role');
// 		if($role_id == '5' || $role_id == '11') 
// 		{ 
// 			$query=$this->db->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
// 			$row = $query->row_array();
// 			$cat_discount = $row['discount'];
// 			$cat_id = $row['pr_cat_id'];
// 		} 
// 		else  
// 		{
// 			$query=$this->db2->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
// 			$row = $query->row_array();
// 			$cat_discount = $row['discount'];
// 			$cat_id = $row['pr_cat_id'];
// 		}
// 		// $cat_discount = $this->input->post('cat_discount');

// 		$data = array('product_name'=> $product_name,
// 						  'hsn_code' => $product_hsn,
// 						   'product_no' => $product_code,
// 						  'product_code'=>$product_code,
// 						  'uom'=> $product_uom,
// 						  'basic_rate'=>$basic_product_price,
// 						  'basic_tax_percent'=>$tax_pecentage,
// 						  'basic_tax_amount'=>$basic_tax_amount, 
// 						  'sgst_tax'=>$sgst_tax,
// 						  'sgst_tax_amount'=>$sgst_price,
// 						  'cgst_tax'=>$cgst_tax,
// 						  'cgst_tax_amount'=>$cgst_price,
// 						  'price'=>$product_price,
// 						  'discount_perc'=>$cat_discount,
// 						  'product_stock'=> $product_stock,
// 						  'product_status'=>$product_status,
// 						  'pr_cat_id'=>$categoryId,
// 						  'effective_from' =>$effectdate,
// 						  'created'=> $date,
// 						  'client_id'=>$clientid,
// 						  'branch' => $branch,
// 						  'data_transfer' =>'pending',
// 						  'token' =>$cat_token,
// 						  'tokengroup' =>$token_group,
// 						  'social_order' => $social_order,
// 						  'sales_item_type' => $sales_item_type,
// 						  'product_type' => $product_type,
// 						  'combination' => $combination,
// 						  'stock_status' => $stock_status,
// 						  'stock_limit' => $stock_limit,
// 						  'api_status' => 'processing',
// 						  'sorting_order' => $sorting_order,
// 						  'cat_id' => $cat_id
// 						);
						
// // 			print_r($data);

// 		if($role_id == '5' || $role_id == '11') 
// 		{ 
// 			$response = $this->master_model->checkProductExist($clientid,$branch,$categoryId,$product_name,$social_order);
// 		} 
// 		else  
// 		{
// 			$response = $this->client_master_model->checkProductExist($clientid,$branch,$categoryId,$product_name,$social_order);
// 		}

// 		if($response)
// 		{
// 			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP01 Product Already Exist for selected Client, Branch, Category and Social Order!!!</div>');
// 			redirect('Master_section/Products_list/8');
// 		}
// 		else
// 		{
// 		// print_r($data);
// 			if($role_id == '5' || $role_id == '11') 
// 			{ 
// 				$result = $this->db->insert('product',$data);
// 				$lastid = $this->db->insert_id();
// 			} 
// 			else  
// 			{
// 				$result = $this->db2->insert('product',$data);
// 				$lastid = $this->db2->insert_id();
// 			}

// 			if($result > 0)
// 			{
// 				$data = array('product_name'=> $product_name,
// 						  'hsn_code' => $product_hsn,
// 							  'product_no' => $product_code,
// 						  'product_code'=>$product_code,
// 						  'uom'=> $product_uom,
// 						  'basic_rate'=>$basic_product_price,
// 						  'basic_tax_percent'=>$tax_pecentage,
// 						  'basic_tax_amount'=>$basic_tax_amount, 
// 						  'sgst_tax'=>$sgst_tax,
// 						  'sgst_tax_amount'=>$sgst_price,
// 						  'cgst_tax'=>$cgst_tax,
// 						  'cgst_tax_amount'=>$cgst_price,
// 						  'price'=>$product_price,
// 						  'discount_perc'=>$cat_discount,
// 						  'product_stock'=> $product_stock,
// 						  'product_status'=>$product_status,
// 						  'pr_cat_id'=>$categoryId,
// 						  'effective_from' =>$effectdate,
// 						  'created'=> $date,
// 						  'client_id'=>$clientid,
// 						  'branch' => $branch,
// 						  'data_transfer' =>'pending',
// 						  'token' =>$cat_token,
// 						  'tokengroup' =>$token_group,
// 						  'social_order' => $social_order,
// 						  'sales_item_type' => $sales_item_type,
// 						  'product_type' => $product_type,
// 						  'combination' => $combination,
// 						  'stock_status' => $stock_status,
// 						  'stock_limit' => $stock_limit,
// 						  'cat_discount' => $cat_discount,
// 						  'pr_id' => $lastid,
// 						  'sorting_order' => $sorting_order,
// 						  'cat_id' => $cat_id
// 						);

// 				if($role_id == '5' || $role_id == '11')
// 				{
// 					$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
// 					$row = $query->row_array();
// 					$client_url = $row['client_url'];
// 				}
// 				else
// 				{
// 					$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
// 					$row = $query->row_array();
// 					$client_url = $row['client_url'];
// 				}

// 				$url = $client_url."insertNewProducts";

// 				$jsondata = json_encode($data);
				
// 				$curl = curl_init($url);
// 		        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
// 		        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
// 		        'Content-Type: application/json')
// 		        );
// 		        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
// 		        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
// 		        $result = curl_exec($curl);
		        
// 		        // print_r($result);
		        
// 		        $json = json_decode($result, true);
// 		        curl_close($curl);

// 		        $api_status = $json['status'];
// 		        $statuscode = $json['statuscode'];
// 		        $response = $json['response'];

// 				if($statuscode == "200")
// 				{
// 					$udata = array(
// 		        	'api_status' => 'success', 
// 		        	);

// 					$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
// 				}
// 				else
// 				{
// 					$udata = array(
// 		        	'api_status' => 'failed', 
// 		        	);

// 		        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP02 Products creation failed!!!</div>');
// 				}

// 				if($role_id == '5' || $role_id == '11')
// 				{
// 					$this->db->where('pr_id',$lastid);
// 					$result = $this->db->update('product',$udata);
// 				}
// 				else
// 				{
// 					$this->db2->where('pr_id',$lastid);
// 					$result = $this->db2->update('product',$udata);
// 				}
// 			}
// 			else
// 			{
// 				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP03 Products creation failed!!!</div>');
// 			}
// 		}
// 		redirect('Master_section/Products_list/8');
// 	}

    // Insert New Product
    public function insertNewProducts()
    {
        $clientid = $this->input->post('clientid');
        $branch = $this->input->post('branch');
        $categoryId = $this->input->post('categoryId');
        $product_name = strtoupper($this->input->post('product_name'));
        $product_uom = $this->input->post('product_uom');
        $product_price = $this->input->post('product_price');
        $basic_product_price = $this->input->post('basic_product_price');
        $tax_pecentage = $this->input->post('tax_pecentage');
        $basic_tax_amount = $this->input->post('basic_tax_amount');
        $cgst_price = $this->input->post('cgst_price');
        $sgst_price = $this->input->post('sgst_price');
        $cgst_tax = $this->input->post('cgst_tax');
        $sgst_tax = $this->input->post('sgst_tax');
    
        $product_stock = $this->input->post('product_stock');
        
        $product_status1 = $this->input->post('product_status');
        if($product_status1 == "true")
        {
            $product_status = "Active";
        }
        else
        {
            $product_status = "Inactive";
        }
        
        $product_hsn = $this->input->post('product_hsn');
        $effective = $this->input->post('effective');
        
        $cat_token1 = $this->input->post('cat_token');
        if($cat_token1 == "true")
        {
            $cat_token = 1;
        }
        else
        {
            $cat_token = 0;
        }
        
        $token_group = $this->input->post('token_group');
    
        $social_order1 = $this->input->post('social_order');
        if($social_order1 == "true")
        {
            $social_order = "1";
        }
        else
        {
            $social_order = "0";
        }
        
        $sales_item_type = $this->input->post('sales_item_type');
        $product_type = $this->input->post('product_type');
        $combination = $this->input->post('combination');
        $stock_status = $this->input->post('stock_status');
        $stock_limit = $this->input->post('stock_limit');
    
        $effectdate = date('Y-m-d',strtotime($effective));
        $sorting_order = $this->input->post('sorting_order');
        $barcode_number = $this->input->post('barcode_number');
        $date = date('Y-m-d');
        
        $social_order_status = $this->input->post('social_order_status');
        if($social_order_status == "true")
        {
            $social_order_status_value = 1;
        }
        else
        {
            $social_order_status_value = 0;
        }
    
        $role_id = $this->session->userdata('role');
        if($role_id == '5' || $role_id == '11') 
        { 
            $query=$this->db->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
            $row = $query->row_array();
            $cat_discount = $row['discount'];
            $cat_id = $row['pr_cat_id'];
            
            //To check whether product code exist for the product the client
            $cquery = $this->db->query("select a.* from product a, client_creation b where a.client_id = b.client_id and a.product_name = '$product_name' and a.client_id = $clientid and a.pr_cat_id = $categoryId and a.social_order = 0 GROUP BY a.product_code");
            if($cquery->num_rows() > 0)
            {
                $crow = $cquery->row_array();
                $max_product_code = (int)$crow['product_code'];
            }
            else
            {
                $query2=$this->db->query("SELECT MAX(a.product_code) as product_code from product a, client_creation b WHERE a.client_id = b.client_id and a.client_id = $clientid");
                $row2 = $query2->row_array();
                $max_product_code = (int)$row2['product_code'];
                $max_product_code = $max_product_code + 1;    
            }
        } 
        else  
        {
            $query=$this->db2->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
            $row = $query->row_array();
            $cat_discount = $row['discount'];
            $cat_id = $row['pr_cat_id'];
            
            //To check whether product code exist for the product the client
            $cquery = $this->db2->query("select a.* from product a, client_creation b where a.client_id = b.client_id and a.product_name = '$product_name' and a.client_id = $clientid and a.pr_cat_id = $categoryId and a.social_order = 0 GROUP BY a.product_code");
            if($cquery->num_rows() > 0)
            {
                $crow = $cquery->row_array();
                $max_product_code = (int)$crow['product_code'];
            }
            else
            {
                $query2=$this->db2->query("SELECT MAX(a.product_code) as product_code from product a, client_creation b WHERE a.client_id = b.client_id and a.client_id = $clientid");
                $row2 = $query2->row_array();
                $max_product_code = (int)$row2['product_code'];
                $max_product_code = $max_product_code + 1;
            }
        }
        // $cat_discount = $this->input->post('cat_discount');
    
        $data = array('product_name'=> $product_name,
                            'hsn_code' => $product_hsn,
                            'product_no' => 0,
                            'product_code'=>$max_product_code,
                            'uom'=> $product_uom,
                            'basic_rate'=>$basic_product_price,
                            'basic_tax_percent'=>$tax_pecentage,
                            'basic_tax_amount'=>$basic_tax_amount, 
                            'sgst_tax'=>$sgst_tax,
                            'sgst_tax_amount'=>$sgst_price,
                            'cgst_tax'=>$cgst_tax,
                            'cgst_tax_amount'=>$cgst_price,
                            'price'=>$product_price,
                            'discount_perc'=>$cat_discount,
                            'product_stock'=> $product_stock,
                            'product_status'=>$product_status,
                            'pr_cat_id'=>$categoryId,
                            'effective_from' =>$effectdate,
                            'created'=> $date,
                            'client_id'=>$clientid,
                            'branch' => $branch,
                            'data_transfer' =>'pending',
                            'token' =>$cat_token,
                            'tokengroup' =>$token_group,
                            'social_order' => $social_order,
                            'sales_item_type' => $sales_item_type,
                            'product_type' => $product_type,
                            'combination' => $combination,
                            'stock_status' => $stock_status,
                            'stock_limit' => $stock_limit,
                            'api_status' => 'processing',
                            'sorting_order' => $sorting_order,
                            'barcode_number' => $barcode_number,
                            'cat_id' => $cat_id
                        );
                        
    // 			print_r($data);
        if($social_order_status_value == 1)
        {
            if($role_id == '5' || $role_id == '11')
            {
                $query=$this->db->query("SELECT a.* from branch_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch_name = '$branch'");
                $row = $query->row_array();
                $social_order_percentage = $row['social_order_percentage'];
            }
            else
            {
                $query=$this->db2->query("SELECT a.* from branch_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch_name = '$branch'");
                $row = $query->row_array();
                $social_order_percentage = $row['social_order_percentage'];
            }
            
            $social_order_percent = $social_order_percentage / 100;
            $basic_product_price1 = $basic_product_price + ($basic_product_price * $social_order_percent);
            $basic_tax_amount1 = $basic_tax_amount + ($basic_tax_amount * $social_order_percent);
            $sgst_price1 = $sgst_price + ($sgst_price * $social_order_percent);
            $cgst_price1 = $cgst_price + ($cgst_price * $social_order_percent);
            $product_price1 = $product_price + ($product_price * $social_order_percent);
            
            
            $data2 = array('product_name'=> $product_name,
                            'hsn_code' => $product_hsn,
                            'product_no' => 0,
                            'product_code'=>$max_product_code,
                            'uom'=> $product_uom,
                            'basic_rate'=>round($basic_product_price1,2),
                            'basic_tax_percent'=>$tax_pecentage,
                            'basic_tax_amount'=>round($basic_tax_amount1,2), 
                            'sgst_tax'=>$sgst_tax,
                            'sgst_tax_amount'=>round($sgst_price1,2),
                            'cgst_tax'=>$cgst_tax,
                            'cgst_tax_amount'=>round($cgst_price1,2),
                            'price'=>round($product_price1,2),
                            'discount_perc'=>$cat_discount,
                            'product_stock'=> $product_stock,
                            'product_status'=>$product_status,
                            'pr_cat_id'=>$categoryId,
                            'effective_from' =>$effectdate,
                            'created'=> $date,
                            'client_id'=>$clientid,
                            'branch' => $branch,
                            'data_transfer' =>'pending',
                            'token' =>$cat_token,
                            'tokengroup' =>$token_group,
                            'social_order' => 1,
                            'sales_item_type' => $sales_item_type,
                            'product_type' => $product_type,
                            'combination' => $combination,
                            'stock_status' => $stock_status,
                            'stock_limit' => $stock_limit,
                            'api_status' => 'processing',
                            'sorting_order' => $sorting_order,
                            'barcode_number' => $barcode_number,
                            'cat_id' => $cat_id
                        );
        }
        
        if($role_id == '5' || $role_id == '11') 
        { 
            $response = $this->master_model->checkProductExist($clientid,$branch,$categoryId,$product_name,$social_order);
        } 
        else  
        {
            $response = $this->client_master_model->checkProductExist($clientid,$branch,$categoryId,$product_name,$social_order);
        }
    
        if($response)
        {
            $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP01 Product Already Exist for selected Client, Branch, Category and Social Order!!!</div>');
            redirect('Master_section/Products_list/8');
        }
        else
        {
        // print_r($data);
            if($role_id == '5' || $role_id == '11') 
            { 
                $result = $this->db->insert('product',$data);
                $lastid1 = $this->db->insert_id();
                if($social_order_status_value == 1)
                {
                    $result = $this->db->insert('product',$data2);
                    $lastid2 = $this->db->insert_id();
                }
            } 
            else  
            {
                $result = $this->db2->insert('product',$data);
                $lastid1 = $this->db2->insert_id();
                if($social_order_status_value == 1)
                {
                    $result = $this->db2->insert('product',$data2);
                    $lastid2 = $this->db2->insert_id();
                }
            }
    
            if($result > 0)
            {
                if($social_order_status_value == 1)
                {
                    $data = array('product_name'=> $product_name,
                            'hsn_code' => $product_hsn,
                            'product_no' => 0,
                            'product_code'=>$max_product_code,
                            'uom'=> $product_uom,
                            'basic_rate'=>$basic_product_price,
                            'basic_tax_percent'=>$tax_pecentage,
                            'basic_tax_amount'=>$basic_tax_amount, 
                            'sgst_tax'=>$sgst_tax,
                            'sgst_tax_amount'=>$sgst_price,
                            'cgst_tax'=>$cgst_tax,
                            'cgst_tax_amount'=>$cgst_price,
                            'price'=>$product_price,
                            'discount_perc'=>$cat_discount,
                            'product_stock'=> $product_stock,
                            'product_status'=>$product_status,
                            'pr_cat_id'=>$categoryId,
                            'effective_from' =>$effectdate,
                            'created'=> $date,
                            'client_id'=>$clientid,
                            'branch' => $branch,
                            'data_transfer' =>'pending',
                            'token' =>$cat_token,
                            'tokengroup' =>$token_group,
                            'social_order' => $social_order,
                            'sales_item_type' => $sales_item_type,
                            'product_type' => $product_type,
                            'combination' => $combination,
                            'stock_status' => $stock_status,
                            'stock_limit' => $stock_limit,
                            'cat_discount' => $cat_discount,
                            'pr_id' => $lastid1,
                            'sorting_order' => $sorting_order,
                            'barcode_number' => $barcode_number,
                            'cat_id' => $cat_id
                        );
                    
                    if($role_id == '5' || $role_id == '11')
                    {
                        $query=$this->db->query("SELECT a.* from branch_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch_name = '$branch'");
                        $row = $query->row_array();
                        $social_order_percentage = $row['social_order_percentage'];
                    }
                    else
                    {
                        $query=$this->db2->query("SELECT a.* from branch_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch_name = '$branch'");
                        $row = $query->row_array();
                        $social_order_percentage = $row['social_order_percentage'];
                    }
                    
                    $social_order_percent = $social_order_percentage / 100;
                    $basic_product_price1 = $basic_product_price + ($basic_product_price * $social_order_percent);
                    $basic_tax_amount1 = $basic_tax_amount + ($basic_tax_amount * $social_order_percent);
                    $sgst_price1 = $sgst_price + ($sgst_price * $social_order_percent);
                    $cgst_price1 = $cgst_price + ($cgst_price * $social_order_percent);
                    $product_price1 = $product_price + ($product_price * $social_order_percent);
                    
                    
                    $data2 = array('product_name'=> $product_name,
                                    'hsn_code' => $product_hsn,
                                    'product_no' => 0,
                                    'product_code'=>$max_product_code,
                                    'uom'=> $product_uom,
                                    'basic_rate'=>round($basic_product_price1,2),
                                    'basic_tax_percent'=>$tax_pecentage,
                                    'basic_tax_amount'=>round($basic_tax_amount1,2), 
                                    'sgst_tax'=>$sgst_tax,
                                    'sgst_tax_amount'=>round($sgst_price1,2),
                                    'cgst_tax'=>$cgst_tax,
                                    'cgst_tax_amount'=>round($cgst_price1,2),
                                    'price'=>round($product_price1,2),
                                    'discount_perc'=>$cat_discount,
                                    'product_stock'=> $product_stock,
                                    'product_status'=>$product_status,
                                    'pr_cat_id'=>$categoryId,
                                    'effective_from' =>$effectdate,
                                    'created'=> $date,
                                    'client_id'=>$clientid,
                                    'branch' => $branch,
                                    'data_transfer' =>'pending',
                                    'token' =>$cat_token,
                                    'tokengroup' =>$token_group,
                                    'social_order' => 1,
                                    'sales_item_type' => $sales_item_type,
                                    'product_type' => $product_type,
                                    'combination' => $combination,
                                    'stock_status' => $stock_status,
                                    'stock_limit' => $stock_limit,
                                    'cat_discount' => $cat_discount,
                                    'pr_id' => $lastid2,
                                    'sorting_order' => $sorting_order,
                                    'barcode_number' => $barcode_number,
                                    'cat_id' => $cat_id
                                );
                                
                        $productarray = array($data, $data2); 
                        $fdata = array("Products" => $productarray);
                }
                else
                {
                    $data = array('product_name'=> $product_name,
                            'hsn_code' => $product_hsn,
                            'product_no' => 0,
                            'product_code'=>$max_product_code,
                            'uom'=> $product_uom,
                            'basic_rate'=>$basic_product_price,
                            'basic_tax_percent'=>$tax_pecentage,
                            'basic_tax_amount'=>$basic_tax_amount, 
                            'sgst_tax'=>$sgst_tax,
                            'sgst_tax_amount'=>$sgst_price,
                            'cgst_tax'=>$cgst_tax,
                            'cgst_tax_amount'=>$cgst_price,
                            'price'=>$product_price,
                            'discount_perc'=>$cat_discount,
                            'product_stock'=> $product_stock,
                            'product_status'=>$product_status,
                            'pr_cat_id'=>$categoryId,
                            'effective_from' =>$effectdate,
                            'created'=> $date,
                            'client_id'=>$clientid,
                            'branch' => $branch,
                            'data_transfer' =>'pending',
                            'token' =>$cat_token,
                            'tokengroup' =>$token_group,
                            'social_order' => $social_order,
                            'sales_item_type' => $sales_item_type,
                            'product_type' => $product_type,
                            'combination' => $combination,
                            'stock_status' => $stock_status,
                            'stock_limit' => $stock_limit,
                            'cat_discount' => $cat_discount,
                            'pr_id' => $lastid1,
                            'sorting_order' => $sorting_order,
                            'barcode_number' => $barcode_number,
                            'cat_id' => $cat_id
                        );
                        
                        $productarray = array($data);
                        $fdata = array("Products" => $productarray);
                }
    
                if($role_id == '5' || $role_id == '11')
                {
                    $query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
                    $row = $query->row_array();
                    $client_url = $row['client_url'];
                }
                else
                {
                    $query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
                    $row = $query->row_array();
                    $client_url = $row['client_url'];
                }
    
                $url = $client_url."insertNewProducts";
    
                $jsondata = json_encode($fdata);
                
                // print_r($jsondata);
                
                $curl = curl_init($url);
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json')
                );
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
                $result = curl_exec($curl);
                
                // print_r($result);
                
                $json = json_decode($result, true);
                curl_close($curl);
    
                $api_status = $json['status'];
                $statuscode = $json['statuscode'];
                $response = $json['response'];
    
                if($statuscode == "200")
                {
                    $udata = array(
                    'api_status' => 'success', 
                    );
    
                    $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
                }
                else
                {
                    $udata = array(
                    'api_status' => 'failed', 
                    );
    
                    $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP02 Products creation failed!!!</div>');
                }
    
                if($role_id == '5' || $role_id == '11')
                {
                    $this->db->where('pr_id',$lastid1);
                    $sqlresult = $this->db->update('product',$udata);
                    if($sqlresult == true)
                    {
                        $this->db->where('pr_id',$lastid2);
                        $result11 = $this->db->update('product',$udata);    
                    }
                }
                else
                {
                    $this->db2->where('pr_id',$lastid1);
                    $sqlresult = $this->db2->update('product',$udata);
                    if($sqlresult == true)
                    {
                        $this->db2->where('pr_id',$lastid2);
                        $result11 = $this->db2->update('product',$udata);    
                    }
                }
            }
            else
            {
                $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP03 Products creation failed!!!</div>');
            }
        }
        redirect('Master_section/Products_list/8');
    }
    

	// Edit Product
// 	public function editProductsOld($pr_id)
// 	{
// 		$data['library_js']= $library_script = unserialize (Library_script_files);
// 		$data['library_css']= $library_style = unserialize (Library_style_files);
// 		$role_id = $this->session->userdata('role');
// 		if($role_id == '5' || $role_id == '11') 
// 		{ 
// 			$client_id = '';
// 			$data['clientlist'] = $this->master_model->client_list_active($client_id);
// 			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
// 			$data['categorylist'] = $this->master_model->category_list_active($client_id);
// 		} 
// 		else  
// 		{
// 			$client_id = $this->session->userdata('client_id'); 
// 			$data['clientlist'] = $this->master_model->client_list_active($client_id);
// 			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
// 			$data['categorylist'] = $this->master_model->category_list_active($client_id);
// 		}
// 		// $data['clientlist'] = $this->master_model->client_list_active();
// 		// $data['branchlist'] = $this->master_model->branch_list_active();
// 		// $data['categorylist'] = $this->master_model->category_list_active();
// 		$data['uoms'] = $this->master_model->uom_list_active();
// 		$data['taxes'] = $this->master_model->tax_list_active();
// 		// $data['discount'] = $this->master_model->getDiscount();
// 		$data['userInfo'] = $this->master_model->getProductInfo($pr_id);
// 		$data['pageTitle'] = 'Product Edit';
// 		$data['Pagename'] = 'Product Edit';
// 		$data['HomePage'] = 'Home';
// 		$this->load->view("master/product_edit", $data);
// 	}

    public function editProducts($pr_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		$data['uoms'] = $this->master_model->uom_list_active();
		$data['taxes'] = $this->master_model->tax_list_active();
		// $data['discount'] = $this->master_model->getDiscount();
		$data['userInfo'] = $this->master_model->getProductInfo($pr_id);
		$data['socialOrderInfo'] = $this->master_model->getSocialOrderProduct($pr_id);
		$data['pageTitle'] = 'Product Edit';
		$data['Pagename'] = 'Product Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/product_edit", $data);
	}

    // Product Edit details
// 	public function updateProductsDetails()
// 	{
// 	    $social_order = $this->input->post('social_order');
// 	    if($social_order == "true")
// 	    {
// 	        echo "ON";   
// 	    }
// 	    else
// 	    {
// 	        echo "OFF";
// 	    }
// 	}
    
	// Product Edit details
// 	public function updateProductsDetailsOld()
// 	{
// 		$clientid = $this->input->post('clientid');
// 		$branch = $this->input->post('branch');
// 		$produtsId = $this->input->post('produtsId');
// 		$categoryId = $this->input->post('categoryId');
// 		$product_name = $this->input->post('product_name');
// 		$product_code = $this->input->post('product_code');
// 		$product_uom = $this->input->post('product_uom');
// 		$product_price = $this->input->post('product_price');
// 		$basic_product_price = $this->input->post('basic_product_price');
// 		$tax_pecentage = $this->input->post('tax_pecentage');
// 		$basic_tax_amount = $this->input->post('basic_tax_amount');
// 		$cgst_price = $this->input->post('cgst_price');
// 		$sgst_price = $this->input->post('sgst_price');
// 		$cgst_tax = $this->input->post('cgst_tax');
// 		$sgst_tax = $this->input->post('sgst_tax');
		
// 		$product_stock = $this->input->post('product_stock');
		
// 		$product_status1 = $this->input->post('product_status');
// 		if($product_status1 == "true")
// 	    {
// 	        $product_status = "Active";
// 	    }
// 	    else
// 	    {
// 	        $product_status = "Inactive";
// 	    }
		
// 		$product_hsn = $this->input->post('product_hsn');
// 		$effective = $this->input->post('effective');
		
// 		$cat_token1 = $this->input->post('cat_token');
// 		if($cat_token1 == "true")
// 	    {
// 	        $cat_token = 1;
// 	    }
// 	    else
// 	    {
// 	        $cat_token = 0;
// 	    }
		
// 		$token_group = $this->input->post('token_group');

// 		$social_order1 = $this->input->post('social_order');
// 		if($social_order1 == "true")
// 	    {
// 	        $social_order = "1";
// 	    }
// 	    else
// 	    {
// 	        $social_order = "0";
// 	    }
	    
// 		$sales_item_type = $this->input->post('sales_item_type');
// 		$product_type = $this->input->post('product_type');
// 		$combination = $this->input->post('combination');
// 		$stock_status = $this->input->post('stock_status');
// 		$stock_limit = $this->input->post('stock_limit');

// 		$old_clientid = $this->input->post('old_clientid');
// 		$old_branch = $this->input->post('old_branch');
// 		$old_categoryId = $this->input->post('old_categoryid');
// 		$old_product_name = $this->input->post('old_product_name');
// 		$old_social_order = $this->input->post('old_social_order');

// 		$effectdate = date('Y-m-d',strtotime($effective));
// 		$sorting_order = $this->input->post('sorting_order');
// 		$date = date('Y-m-d');

// 		$role_id = $this->session->userdata('role');
// 		if($role_id == '5' || $role_id == '11') 
// 		{ 
// 			$query=$this->db->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
// 			$row = $query->row_array();
// 			$cat_discount = $row['discount'];
// 			$cat_id = $row['pr_cat_id'];
// 		} 
// 		else  
// 		{
// 			$query=$this->db2->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
// 			$row = $query->row_array();
// 			$cat_discount = $row['discount'];
// 			$cat_id = $row['pr_cat_id'];
// 		}

// 		$data = array('product_name'=> $product_name,
// 						  'hsn_code' => $product_hsn,
// 							  'product_no' => $product_code,
// 						  'product_code'=>$product_code,
// 						  'uom'=> $product_uom,
// 						  'basic_rate'=>$product_price,
// 						  'basic_tax_percent'=>$tax_pecentage,
// 						  'basic_tax_amount'=>$basic_tax_amount, 
// 						  'sgst_tax'=>$sgst_tax,
// 						  'sgst_tax_amount'=>$sgst_price,
// 						  'cgst_tax'=>$cgst_tax,
// 						  'cgst_tax_amount'=>$cgst_price,
// 						  'price'=>$basic_product_price,
// 						  'discount_perc'=>$cat_discount,
// 						  'product_stock'=> $product_stock,
// 						  'product_status'=>$product_status,
// 						  'pr_cat_id'=>$categoryId,
// 						  'effective_from' =>$effectdate,
// 						  'created'=> $date,
// 						  'updated' =>$date,
// 						  'branch' => $branch,
// 						  'client_id'=>$clientid,
// 						  'data_transfer' =>'pending',
// 						  'token' =>$cat_token,
// 						  'tokengroup' =>$token_group,
// 						  'social_order' => $social_order,
// 						  'sales_item_type' => $sales_item_type,
// 						  'product_type' => $product_type,
// 						  'combination' => $combination,
// 						  'stock_status' => $stock_status,
// 						  'stock_limit' => $stock_limit,
// 						  'sorting_order' => $sorting_order,
// 						  'cat_id' => $cat_id
// 						);

// 		// echo $clientid." : ".$old_clientid." - ";
// 		// echo $categoryId." : ".$old_categoryId." - ";
// 		// echo $branch." : ".$old_branch." - ";
// 		// echo $product_name." : ".$old_product_name." - ";
// 		if(($clientid == $old_clientid) && ($categoryId == $old_categoryId) && (strcasecmp($branch, $old_branch) == 0) && (strcasecmp($product_name, $old_product_name) == 0) && ($social_order == $old_social_order))
// 		{
// 			if($role_id == '5' || $role_id == '11') 
// 			{ 
// 				$result = $this->master_model->updateProductsDetails($data,$produtsId);
// 			} 
// 			else  
// 			{
// 				$result = $this->client_master_model->updateProductsDetails($data,$produtsId);
// 			}
// 		}
// 		else
// 		{
// 		    if($role_id == '5' || $role_id == '11') 
//     		{ 
//     			$response = $this->master_model->checkProductExist($clientid,$branch,$categoryId,$product_name,$social_order);
//     		} 
//     		else  
//     		{
//     			$response = $this->client_master_model->checkProductExist($clientid,$branch,$categoryId,$product_name,$social_order);
//     		}
    		
// 			if($response)
// 			{
// 				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP04 Product Already Exist in Selected Client, Branch, Category and Social Order Can\'t update!!!</div>');
// 				redirect('Master_section/Products_list/8');
// 			}
// 			else
// 			{
// 				if($role_id == '5' || $role_id == '11') 
// 				{ 
// 					$result = $this->master_model->updateProductsDetails($data,$produtsId);
// 				} 
// 				else  
// 				{
// 					$result = $this->client_master_model->updateProductsDetails($data,$produtsId);
// 				}
// 			}			
// 		}

// 		if($result == true)
// 		{
// 			$data = array('product_name'=> $product_name,
// 						  'hsn_code' => $product_hsn,
// 							  'product_no' => $product_code,
// 						  'product_code'=>$product_code,
// 						  'uom'=> $product_uom,
// 						  'basic_rate'=>$basic_product_price,
// 						  'basic_tax_percent'=>$tax_pecentage,
// 						  'basic_tax_amount'=>$basic_tax_amount, 
// 						  'sgst_tax'=>$sgst_tax,
// 						  'sgst_tax_amount'=>$sgst_price,
// 						  'cgst_tax'=>$cgst_tax,
// 						  'cgst_tax_amount'=>$cgst_price,
// 						  'price'=>$product_price,
// 						  'discount_perc'=>$cat_discount,
// 						  'product_stock'=> $product_stock,
// 						  'product_status'=>$product_status,
// 						  'pr_cat_id'=>$categoryId,
// 						  'effective_from' =>$effectdate,
// 						  'created'=> $date,
// 						  'client_id'=>$clientid,
// 						  'branch' => $branch,
// 						  'data_transfer' =>'pending',
// 						  'token' =>$cat_token,
// 						  'tokengroup' =>$token_group,
// 						  'social_order' => $social_order,
// 						  'sales_item_type' => $sales_item_type,
// 						  'product_type' => $product_type,
// 						  'combination' => $combination,
// 						  'stock_status' => $stock_status,
// 						  'stock_limit' => $stock_limit,
// 						  'cat_discount' => $cat_discount,
// 						  'pr_id' => $produtsId,
// 						  'old_clientid' => $old_clientid,
// 						  'old_branch' => $old_branch,
// 						  'old_categoryId' => $old_categoryId,
// 						  'old_product_name' => $old_product_name,
// 						  'sorting_order' => $sorting_order,
// 						  'old_social_order' => $old_social_order,
// 						  'cat_id' => $cat_id
// 						);

// 			if($role_id == '5' || $role_id == '11')
// 			{
// 				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
// 				$row = $query->row_array();
// 				$client_url = $row['client_url'];
// 			}
// 			else
// 			{
// 				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
// 				$row = $query->row_array();
// 				$client_url = $row['client_url'];
// 			}


// 			$url = $client_url."updateProductsDetails";

// 			$jsondata = json_encode($data);
			
// 			$curl = curl_init($url);
// 	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
// 	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
// 	        'Content-Type: application/json')
// 	        );
// 	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
// 	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
// 	        $result = curl_exec($curl);
	        
// 	        // print_r($result);
	        
// 	        $json = json_decode($result, true);
// 	        curl_close($curl);

// 	        $api_status = $json['status'];
// 	        $statuscode = $json['statuscode'];
// 	        $response = $json['response'];

// 			if($statuscode == "200")
// 			{
// 				$udata = array(
// 	        	'api_status' => 'success', 
// 	        	);

// 				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
// 			}
// 			else
// 			{
// 				$udata = array(
// 	        	'api_status' => 'failed', 
// 	        	);

// 	        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP05 Product updation failed!!!</div>');
// 			}

// 			if($role_id == '5' || $role_id == '11') 
// 			{ 
// 				$this->db->where('pr_id',$produtsId);
// 				$result = $this->db->update('product',$udata);
// 			} 
// 			else  
// 			{
// 				$this->db2->where('pr_id',$produtsId);
// 				$result = $this->db2->update('product',$udata);
// 			}
// 		}
// 		else
// 		{
// 			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP06 Product updation failed!!!</div>');
// 		}
// 		redirect('Master_section/Products_list/8');
// 	}

    // Product Edit details
    public function updateProductsDetails()
    {
        $clientid = $this->input->post('clientid');
        $branch = $this->input->post('branch');
        $produtsId = $this->input->post('produtsId');
        $categoryId = $this->input->post('categoryId');
        $product_name = strtoupper($this->input->post('product_name'));
        $product_code = $this->input->post('product_code');
        $product_uom = $this->input->post('product_uom');
        $basic_product_price = $this->input->post('basic_product_price');
        $product_price = $this->input->post('product_price');
        $tax_pecentage = $this->input->post('tax_pecentage');
        $basic_tax_amount = $this->input->post('basic_tax_amount');
        $cgst_price = $this->input->post('cgst_price');
        $sgst_price = $this->input->post('sgst_price');
        $cgst_tax = $this->input->post('cgst_tax');
        $sgst_tax = $this->input->post('sgst_tax');
        
        $product_stock = $this->input->post('product_stock');
        
        $product_status1 = $this->input->post('product_status');
        if($product_status1 == "true")
        {
            $product_status = "Active";
        }
        else
        {
            $product_status = "Inactive";
        }
        
        $product_hsn = $this->input->post('product_hsn');
        $effective = $this->input->post('effective');
        
        $cat_token1 = $this->input->post('cat_token');
        if($cat_token1 == "true")
        {
            $cat_token = 1;
        }
        else
        {
            $cat_token = 0;
        }
        
        $token_group = $this->input->post('token_group');
    
        $social_order1 = $this->input->post('social_order');
        if($social_order1 == "true")
        {
            $social_order = "1";
        }
        else
        {
            $social_order = "0";
        }
        
        $sales_item_type = $this->input->post('sales_item_type');
        $product_type = $this->input->post('product_type');
        $combination = $this->input->post('combination');
        $stock_status = $this->input->post('stock_status');
        $stock_limit = $this->input->post('stock_limit');
    
        $old_clientid = $this->input->post('old_clientid');
        $old_branch = $this->input->post('old_branch');
        $old_categoryId = $this->input->post('old_categoryid');
        $old_product_name = $this->input->post('old_product_name');
        $old_social_order = $this->input->post('old_social_order');
    
        $effectdate = date('Y-m-d',strtotime($effective));
        $sorting_order = $this->input->post('sorting_order');
        $barcode_number = $this->input->post('barcode_number');
        $date = date('Y-m-d');
        
        $social_order_status = $this->input->post('social_order_status');
        // Social Order Toggle is disabled and fetches hidden input value which is social order product id based on counter product product code
        $social_order_pr_id = $this->input->post('social_order_pr_id');
        if($social_order_status == "true")
        {
            //if Social Order Toggle is active and user enabled
            $social_order_status_value = 1;
        }
        else
        {
            //if Social Order Toggle is active and user not enabled and Social Order Toggle is disabled
            $social_order_status_value = 0;
        }
        
        // echo "Social Order Status : ".$social_order_status_value;
        
        $role_id = $this->session->userdata('role');
        if($role_id == '5' || $role_id == '11') 
        { 
            $query=$this->db->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
            $row = $query->row_array();
            $cat_discount = $row['discount'];
            $cat_id = $row['pr_cat_id'];
        } 
        else  
        {
            $query=$this->db2->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
            $row = $query->row_array();
            $cat_discount = $row['discount'];
            $cat_id = $row['pr_cat_id'];
        }
    
        $data = array('product_name'=> $product_name,
                            'hsn_code' => $product_hsn,
                            'uom'=> $product_uom,
                            'basic_rate'=>$basic_product_price,
                            'basic_tax_percent'=>$tax_pecentage,
                            'basic_tax_amount'=>$basic_tax_amount, 
                            'sgst_tax'=>$sgst_tax,
                            'sgst_tax_amount'=>$sgst_price,
                            'cgst_tax'=>$cgst_tax,
                            'cgst_tax_amount'=>$cgst_price,
                            'price'=>$product_price,
                            'discount_perc'=>$cat_discount,
                            'product_stock'=> $product_stock,
                            'product_status'=>$product_status,
                            'pr_cat_id'=>$categoryId,
                            'effective_from' =>$effectdate,
                            'branch' => $branch,
                            'client_id'=>$clientid,
                            'data_transfer' =>'pending',
                            'token' =>$cat_token,
                            'tokengroup' =>$token_group,
                            'social_order' => $social_order,
                            'sales_item_type' => $sales_item_type,
                            'product_type' => $product_type,
                            'combination' => $combination,
                            'stock_status' => $stock_status,
                            'stock_limit' => $stock_limit,
                            'sorting_order' => $sorting_order,
                            'barcode_number' => $barcode_number,
                            'cat_id' => $cat_id
                        );
        
        
        //Social Order Product Details prepration                
        if($role_id == '5' || $role_id == '11')
        {
            $query=$this->db->query("SELECT a.* from branch_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch_name = '$branch'");
            $row = $query->row_array();
            $social_order_percentage = $row['social_order_percentage'];
        }
        else
        {
            $query=$this->db2->query("SELECT a.* from branch_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch_name = '$branch'");
            $row = $query->row_array();
            $social_order_percentage = $row['social_order_percentage'];
        }
        
        $social_order_percent = $social_order_percentage / 100;
        $basic_product_price1 = $basic_product_price + ($basic_product_price * $social_order_percent);
        $basic_tax_amount1 = $basic_tax_amount + ($basic_tax_amount * $social_order_percent);
        $sgst_price1 = $sgst_price + ($sgst_price * $social_order_percent);
        $cgst_price1 = $cgst_price + ($cgst_price * $social_order_percent);
        $product_price1 = $product_price + ($product_price * $social_order_percent);
        
        
        $data2 = array('product_name'=> $product_name,
                        'hsn_code' => $product_hsn,
                        'uom'=> $product_uom,
                        'product_code' => $product_code,
                        'basic_rate'=>round($basic_product_price1,2),
                        'basic_tax_percent'=>$tax_pecentage,
                        'basic_tax_amount'=>round($basic_tax_amount1,2), 
                        'sgst_tax'=>$sgst_tax,
                        'sgst_tax_amount'=>round($sgst_price1,2),
                        'cgst_tax'=>$cgst_tax,
                        'cgst_tax_amount'=>round($cgst_price1,2),
                        'price'=>round($product_price1,2),
                        'discount_perc'=>$cat_discount,
                        'product_stock'=> $product_stock,
                        'product_status'=>$product_status,
                        'pr_cat_id'=>$categoryId,
                        'effective_from' =>$effectdate,
                        'client_id'=>$clientid,
                        'branch' => $branch,
                        'data_transfer' =>'pending',
                        'token' =>$cat_token,
                        'tokengroup' =>$token_group,
                        'social_order' => 1,
                        'sales_item_type' => $sales_item_type,
                        'product_type' => $product_type,
                        'combination' => $combination,
                        'stock_status' => $stock_status,
                        'stock_limit' => $stock_limit,
                        'api_status' => 'processing',
                        'sorting_order' => $sorting_order,
                        'barcode_number' => $barcode_number,
                        'cat_id' => $cat_id
                    );
        
    
        // echo $clientid." : ".$old_clientid." - ";
        // echo $categoryId." : ".$old_categoryId." - ";
        // echo $branch." : ".$old_branch." - ";
        // echo $product_name." : ".$old_product_name." - ";
        if(($clientid == $old_clientid) && ($categoryId == $old_categoryId) && (strcasecmp($branch, $old_branch) == 0) && (strcasecmp($product_name, $old_product_name) == 0) && ($social_order == $old_social_order))
        {
            if($role_id == '5' || $role_id == '11') 
            { 
                $qresult = $this->master_model->updateProductsDetails($data,$produtsId);
                if($qresult == true)
                {
                    //If Social Order Toggle is active and user enabled it so we need to add a new social product
                    if($social_order_status_value == 1)
                    {
                        $this->db->insert('product',$data2);
                        $lastid2 = $this->db->insert_id();
                    }
                    else
                    {
                        //If Social Order Toggle is disable and we need to update as social order product exist if social order id is no empty
                        if(!empty($social_order_pr_id))
                        {
                            $qresult2 = $this->master_model->updateProductsDetails($data2, $social_order_pr_id);
                        }
                    }
                }
            } 
            else  
            {
                $qresult = $this->client_master_model->updateProductsDetails($data,$produtsId);
                if($qresult == true)
                {
                    //If Social Order Toggle is active and user enabled it so we need to add a new social product
                    if($social_order_status_value == 1)
                    {
                        $this->db2->insert('product',$data2);
                        $lastid2 = $this->db2->insert_id();
                    }
                    else
                    {
                        //If Social Order Toggle is disable and we need to update as social order product exist if social order id is no empty
                        if(!empty($social_order_pr_id))
                        {
                            $qresult2 = $this->client_master_model->updateProductsDetails($data2, $social_order_pr_id);
                        }
                    }
                }
            }
        }
        else
        {
            if($role_id == '5' || $role_id == '11') 
            { 
                $response = $this->master_model->checkProductExist($clientid,$branch,$categoryId,$product_name,$social_order);
            } 
            else  
            {
                $response = $this->client_master_model->checkProductExist($clientid,$branch,$categoryId,$product_name,$social_order);
            }
            
            if($response)
            {
                $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP04 Product Already Exist in Selected Client, Branch, Category and Social Order Can\'t update!!!</div>');
                redirect('Master_section/Products_list/8');
            }
            else
            {
                if($role_id == '5' || $role_id == '11') 
                { 
                    $qresult = $this->master_model->updateProductsDetails($data,$produtsId);
                    if($qresult == true)
                    {
                        //If Social Order Toggle is active and user enabled it so we need to add a new social product
                        if($social_order_status_value == 1)
                        {
                            $this->db->insert('product',$data2);
                            $lastid2 = $this->db->insert_id();
                        }
                        else
                        {
                            //If Social Order Toggle is disable and we need to update as social order product exist if social order id is no empty
                            if(!empty($social_order_pr_id))
                            {
                                $qresult2 = $this->master_model->updateProductsDetails($data2, $social_order_pr_id);
                            }
                        }
                    }
                } 
                else  
                {
                    $qresult = $this->client_master_model->updateProductsDetails($data,$produtsId);
                    if($qresult == true)
                    {
                        //If Social Order Toggle is active and user enabled it so we need to add a new social product
                        if($social_order_status_value == 1)
                        {
                            $this->db2->insert('product',$data2);
                            $lastid2 = $this->db2->insert_id();
                        }
                        else
                        {
                            //If Social Order Toggle is disable and we need to update as social order product exist if social order id is no empty
                            if(!empty($social_order_pr_id))
                            {
                                $qresult2 = $this->client_master_model->updateProductsDetails($data2, $social_order_pr_id);
                            }
                        }
                    }
                }
            }			
        }
    
        if($qresult == true)
        {
            $data = array('product_name'=> $product_name,
                            'hsn_code' => $product_hsn,
                            'product_code' => $product_code,
                            'uom'=> $product_uom,
                            'basic_rate'=>$basic_product_price,
                            'basic_tax_percent'=>$tax_pecentage,
                            'basic_tax_amount'=>$basic_tax_amount, 
                            'sgst_tax'=>$sgst_tax,
                            'sgst_tax_amount'=>$sgst_price,
                            'cgst_tax'=>$cgst_tax,
                            'cgst_tax_amount'=>$cgst_price,
                            'price'=>$product_price,
                            'discount_perc'=>$cat_discount,
                            'product_stock'=> $product_stock,
                            'product_status'=>$product_status,
                            'pr_cat_id'=>$categoryId,
                            'effective_from' =>$effectdate,
                            'branch' => $branch,
                            'client_id'=>$clientid,
                            'data_transfer' =>'pending',
                            'token' =>$cat_token,
                            'tokengroup' =>$token_group,
                            'social_order' => $social_order,
                            'sales_item_type' => $sales_item_type,
                            'product_type' => $product_type,
                            'combination' => $combination,
                            'stock_status' => $stock_status,
                            'stock_limit' => $stock_limit,
                            'sorting_order' => $sorting_order,
                            'barcode_number' => $barcode_number,
                            'cat_id' => $cat_id,
                            'pr_id' => $produtsId
                        );
                
            if(!empty($social_order_pr_id))
            {
                //If Social Order Toggle is disable and we need to update as social order product exist if social order id is no empty
                $pr_id2 = $social_order_pr_id;
                
                $data2 = array('product_name'=> $product_name,
                    'hsn_code' => $product_hsn,
                    'product_code' => $product_code,
                    'uom'=> $product_uom,
                    'basic_rate'=>round($basic_product_price1,2),
                    'basic_tax_percent'=>$tax_pecentage,
                    'basic_tax_amount'=>round($basic_tax_amount1,2), 
                    'sgst_tax'=>$sgst_tax,
                    'sgst_tax_amount'=>round($sgst_price1,2),
                    'cgst_tax'=>$cgst_tax,
                    'cgst_tax_amount'=>round($cgst_price1,2),
                    'price'=>round($product_price1,2),
                    'discount_perc'=>$cat_discount,
                    'product_stock'=> $product_stock,
                    'product_status'=>$product_status,
                    'pr_cat_id'=>$categoryId,
                    'effective_from' =>$effectdate,
                    'client_id'=>$clientid,
                    'branch' => $branch,
                    'data_transfer' =>'pending',
                    'token' =>$cat_token,
                    'tokengroup' =>$token_group,
                    'social_order' => 1,
                    'sales_item_type' => $sales_item_type,
                    'product_type' => $product_type,
                    'combination' => $combination,
                    'stock_status' => $stock_status,
                    'stock_limit' => $stock_limit,
                    'sorting_order' => $sorting_order,
                    'barcode_number' => $barcode_number,
                    'cat_id' => $cat_id,
                    'pr_id' => $pr_id2
                    );
            }
            else
            {
                //If Social Order Toggle is active and user enabled it so we need to add a new social product lastid2 holds last inserted id of new product
                if(!empty($lastid2))
                {
                    $pr_id2 = $lastid2;
                    
                    $data2 = array('product_name'=> $product_name,
                    'hsn_code' => $product_hsn,
                    'product_code' => $product_code,
                    'uom'=> $product_uom,
                    'basic_rate'=>round($basic_product_price1,2),
                    'basic_tax_percent'=>$tax_pecentage,
                    'basic_tax_amount'=>round($basic_tax_amount1,2), 
                    'sgst_tax'=>$sgst_tax,
                    'sgst_tax_amount'=>round($sgst_price1,2),
                    'cgst_tax'=>$cgst_tax,
                    'cgst_tax_amount'=>round($cgst_price1,2),
                    'price'=>round($product_price1,2),
                    'discount_perc'=>$cat_discount,
                    'product_stock'=> $product_stock,
                    'product_status'=>$product_status,
                    'pr_cat_id'=>$categoryId,
                    'effective_from' =>$effectdate,
                    'client_id'=>$clientid,
                    'branch' => $branch,
                    'data_transfer' =>'pending',
                    'token' =>$cat_token,
                    'tokengroup' =>$token_group,
                    'social_order' => 1,
                    'sales_item_type' => $sales_item_type,
                    'product_type' => $product_type,
                    'combination' => $combination,
                    'stock_status' => $stock_status,
                    'stock_limit' => $stock_limit,
                    'sorting_order' => $sorting_order,
                    'barcode_number' => $barcode_number,
                    'cat_id' => $cat_id,
                    'pr_id' => $pr_id2
                    );
                }
            }
            
            // Data to be sent for api
            // Sending both the arrays as one array to be updated and one array to be added as social_order_status_value is 1
            if($social_order_status_value == 1)
            {
                $productarray = array($data, $data2); 
                $fdata = array("Products" => $productarray);
            }
            else
            {
                // Sending both the arrays as social_order_pr_id exists so both the arrays to be updated,
                if(!empty($social_order_pr_id))
                {
                    $productarray = array($data, $data2); 
                    $fdata = array("Products" => $productarray);
                }
                else
                {
                    // Sending only counter product array to be updated as social_order_pr_id is empty and social_order_status_value is 0 as nothing selected in toggle
                    $productarray = array($data);
                    $fdata = array("Products" => $productarray); 
                }
            }
            
            
            if($role_id == '5' || $role_id == '11')
            {
                $query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
                $row = $query->row_array();
                $client_url = $row['client_url'];
            }
            else
            {
                $query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
                $row = $query->row_array();
                $client_url = $row['client_url'];
            }
    
    
            $url = $client_url."updateProductsDetails";
    
            $jsondata = json_encode($fdata);
            
            // print_r($jsondata);
            
            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json')
            );
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
            $result = curl_exec($curl);
            
            // print_r($result);
            
            $json = json_decode($result, true);
            curl_close($curl);
    
            $api_status = $json['status'];
            $statuscode = $json['statuscode'];
            $response = $json['response'];
    
            if($statuscode == "200")
            {
                $udata = array(
                'api_status' => 'success', 
                );
    
                $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
            }
            else
            {
                $udata = array(
                'api_status' => 'failed', 
                );
    
                $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP05 Product updation failed!!!</div>');
            }
    
            if($role_id == '5' || $role_id == '11') 
            { 
                $this->db->where('pr_id',$produtsId);
                $uresult = $this->db->update('product',$udata);
                if($uresult == true)
                {
                    if($social_order_status_value == 1)
                    {
                        $this->db->where('pr_id',$lastid2);
                        $uresult = $this->db->update('product',$udata);
                    }
                    else
                    {
                        if(!empty($social_order_pr_id))
                        {
                            $this->db->where('pr_id',$social_order_pr_id);
                            $uresult = $this->db->update('product',$udata);
                        }
                    }    
                }
            } 
            else  
            {
                $this->db2->where('pr_id',$produtsId);
                $uresult = $this->db2->update('product',$udata);
                if($uresult == true)
                {
                    if($social_order_status_value == 1)
                    {
                        $this->db2->where('pr_id',$lastid2);
                        $uresult = $this->db2->update('product',$udata);
                    }
                    else
                    {
                        if(!empty($social_order_pr_id))
                        {
                            $this->db2->where('pr_id',$social_order_pr_id);
                            $uresult = $this->db2->update('product',$udata);
                        }
                    }    
                }
            }
        }
        else
        {
            $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP06 Product updation failed!!!</div>');
        }
        redirect('Master_section/Products_list/8');
    }
    
    // Product Multi Add
    public function multi_product_add()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		// $data['discount'] = $this->master_model->category_list_active();
		$data['uoms'] = $this->master_model->uom_list_active();
		$data['taxes'] = $this->master_model->tax_list_active();
		$data['pageTitle'] = 'Multi Product Add';
		$data['Pagename'] = 'Multi Product Add';
		$data['HomePage'] = 'Home';
		$this->load->view("master/multi_product_add", $data);
	}
	
	// Insert New Product
    public function insertNewMultiProducts()
    {
        $clientid = $this->input->post('clientid');
        $categoryId = $this->input->post('category');
        $product_name = strtoupper($this->input->post('product_name'));
        $product_uom = $this->input->post('product_uom');
        $product_price = $this->input->post('product_price');
        $basic_product_price = $this->input->post('basic_product_price');
        $tax_pecentage = $this->input->post('tax_pecentage');
        $basic_tax_amount = $this->input->post('basic_tax_amount');
        $cgst_price = $this->input->post('cgst_price');
        $sgst_price = $this->input->post('sgst_price');
        $cgst_tax = $this->input->post('cgst_tax');
        $sgst_tax = $this->input->post('sgst_tax');
    
        $product_stock = $this->input->post('product_stock');
        
        $product_status1 = $this->input->post('product_status');
        if($product_status1 == "true")
        {
            $product_status = "Active";
        }
        else
        {
            $product_status = "Inactive";
        }
        
        $product_hsn = $this->input->post('product_hsn');
        $effective = $this->input->post('effective');
        
        $cat_token1 = $this->input->post('cat_token');
        if($cat_token1 == "true")
        {
            $cat_token = 1;
        }
        else
        {
            $cat_token = 0;
        }
        
        $token_group = $this->input->post('token_group');
    
        $social_order = $this->input->post('social_order');
        
        $sales_item_type = $this->input->post('sales_item_type');
        $product_type = $this->input->post('product_type');
        $combination = $this->input->post('combination');
        $stock_status = $this->input->post('stock_status');
        $stock_limit = $this->input->post('stock_limit');
    
        $effectdate = date('Y-m-d',strtotime($effective));
        $sorting_order = $this->input->post('sorting_order');
        $barcode_number = $this->input->post('barcode_number');
        
        $date = date('Y-m-d');
    
        $role_id = $this->session->userdata('role');
        if($role_id == '5' || $role_id == '11') 
        { 
            //To check whether product code exist for the product the client
            $cquery = $this->db->query("select a.* from product a, client_creation b where a.client_id = b.client_id and a.product_name = '$product_name' and a.client_id = $clientid and a.pr_cat_id = $categoryId and a.social_order = 0 GROUP BY a.product_code");
            if($cquery->num_rows() > 0)
            {
                $crow = $cquery->row_array();
                $max_product_code = (int)$crow['product_code'];
            }
            else
            {
                $query2=$this->db->query("SELECT MAX(a.product_code) as product_code from product a, client_creation b WHERE a.client_id = b.client_id and a.client_id = $clientid");
                $row2 = $query2->row_array();
                $max_product_code = (int)$row2['product_code'];
                $max_product_code = $max_product_code + 1;    
            }
        } 
        else  
        {
            //To check whether product code exist for the product the client
            $cquery = $this->db2->query("select a.* from product a, client_creation b where a.client_id = b.client_id and a.product_name = '$product_name' and a.client_id = $clientid and a.pr_cat_id = $categoryId and a.social_order = 0 GROUP BY a.product_code");
            if($cquery->num_rows() > 0)
            {
                $crow = $cquery->row_array();
                $max_product_code = (int)$crow['product_code'];
            }
            else
            {
                $query2=$this->db2->query("SELECT MAX(a.product_code) as product_code from product a, client_creation b WHERE a.client_id = b.client_id and a.client_id = $clientid");
                $row2 = $query2->row_array();
                $max_product_code = (int)$row2['product_code'];
                $max_product_code = $max_product_code + 1;
            }
        }
        // $cat_discount = $this->input->post('cat_discount');
        
        if($role_id == '5' || $role_id == '11') 
        { 
            $branchquery = $this->db->query("SELECT b.* from client_creation a, branch_creation b WHERE a.client_id = b.client_id and a.client_id = $clientid and b.status = 'Active'");
            $branchresult = $branchquery->result();
            // print_r($branchresult);
            if(!empty($branchresult))
        	{
        		foreach ($branchresult as $br)
        		{
        		    $branch = $br->branch_name;
        		    $query=$this->db->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
                    $row = $query->row_array();
                    $cat_discount = $row['discount'];
                    $cat_id = $row['pr_cat_id'];
                    
                    $data[] = array('product_name'=> $product_name,
                            'hsn_code' => $product_hsn,
                            'product_no' => 0,
                            'product_code'=>$max_product_code,
                            'uom'=> $product_uom,
                            'basic_rate'=>$basic_product_price,
                            'basic_tax_percent'=>$tax_pecentage,
                            'basic_tax_amount'=>$basic_tax_amount, 
                            'sgst_tax'=>$sgst_tax,
                            'sgst_tax_amount'=>$sgst_price,
                            'cgst_tax'=>$cgst_tax,
                            'cgst_tax_amount'=>$cgst_price,
                            'price'=>$product_price,
                            'discount_perc'=>$cat_discount,
                            'product_stock'=> $product_stock,
                            'product_status'=>$product_status,
                            'pr_cat_id'=>$categoryId,
                            'effective_from' =>$effectdate,
                            'created'=> $date,
                            'client_id'=>$clientid,
                            'branch' => $branch,
                            'data_transfer' =>'pending',
                            'token' =>$cat_token,
                            'tokengroup' =>$token_group,
                            'social_order' => $social_order,
                            'sales_item_type' => $sales_item_type,
                            'product_type' => $product_type,
                            'combination' => $combination,
                            'stock_status' => $stock_status,
                            'stock_limit' => $stock_limit,
                            'api_status' => 'processing',
                            'sorting_order' => $sorting_order,
                            'barcode_number' => $barcode_number,
                            'cat_id' => $cat_id
                        );
        		}
        	}
        	else
        	{
        	    $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP01 Product Add Failed, No Branches Found!!!</div>');
                redirect('Master_section/Products_list/8');
        	}
        } 
        else  
        {
            $branchquery = $this->db2->query("SELECT b.* from client_creation a, branch_creation b WHERE a.client_id = b.client_id and a.client_id = $clientid and b.status = 'Active'");
            $branchresult = $branchquery->result();
            if(!empty($branchresult))
        	{
        		foreach ($branchresult as $br)
        		{
        		    $branch = $br->branch_name;
        		    $query=$this->db2->query("SELECT a.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE() and a.pr_cat_code = $categoryId and a.branch = '$branch'");
                    $row = $query->row_array();
                    $cat_discount = $row['discount'];
                    $cat_id = $row['pr_cat_id'];
                    
                    $data[] = array('product_name'=> $product_name,
                            'hsn_code' => $product_hsn,
                            'product_no' => 0,
                            'product_code'=>$max_product_code,
                            'uom'=> $product_uom,
                            'basic_rate'=>$basic_product_price,
                            'basic_tax_percent'=>$tax_pecentage,
                            'basic_tax_amount'=>$basic_tax_amount, 
                            'sgst_tax'=>$sgst_tax,
                            'sgst_tax_amount'=>$sgst_price,
                            'cgst_tax'=>$cgst_tax,
                            'cgst_tax_amount'=>$cgst_price,
                            'price'=>$product_price,
                            'discount_perc'=>$cat_discount,
                            'product_stock'=> $product_stock,
                            'product_status'=>$product_status,
                            'pr_cat_id'=>$categoryId,
                            'effective_from' =>$effectdate,
                            'created'=> $date,
                            'client_id'=>$clientid,
                            'branch' => $branch,
                            'data_transfer' =>'pending',
                            'token' =>$cat_token,
                            'tokengroup' =>$token_group,
                            'social_order' => $social_order,
                            'sales_item_type' => $sales_item_type,
                            'product_type' => $product_type,
                            'combination' => $combination,
                            'stock_status' => $stock_status,
                            'stock_limit' => $stock_limit,
                            'api_status' => 'processing',
                            'sorting_order' => $sorting_order,
                            'barcode_number' => $barcode_number,
                            'cat_id' => $cat_id
                        );
        		}
        	}
        	else
        	{
        	    $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP01 Product Add Failed, No Branches Found!!!</div>');
                redirect('Master_section/Products_list/8');
        	}
        }
        
        // print_r($data);
        $array_length = sizeof($data);
    
        if($role_id == '5' || $role_id == '11') 
        { 
            $response = $this->master_model->checkMultiProductExist($clientid,$categoryId,$product_name,$social_order);
        } 
        else  
        {
            $response = $this->client_master_model->checkMultiProductExist($clientid,$categoryId,$product_name,$social_order);
        }
    
        if($response)
        {
            $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSP01 Product Already Exist for selected Client, Category and Social Order!!!</div>');
            redirect('Master_section/Products_list/8');
        }
        else
        {
            $results = 0;
            if($role_id == '5' || $role_id == '11') 
            {
                for($i = 0; $i < $array_length; $i++)
                {
                    $result = $this->db->insert('product',$data[$i]);
                    $lastid = $this->db->insert_id();
                    $data[$i]["pr_id"] = $lastid;
                    $refids[] = $lastid; 
                    $postdata[] = $data[$i];
                    $results = $results + $lastid;
                }
            } 
            else  
            {
                for($i = 0; $i < $array_length; $i++)
                {
                    $result = $this->db2->insert('product',$data[$i]);
                    $lastid = $this->db2->insert_id();
                    $data[$i]["pr_id"] = $lastid;
                    $refids[] = $lastid;
                    $postdata[] = $data[$i];
                    $results = $results + $lastid;
                }
            }
            
            // print_r($postdata);
    
            if($results > 0)
            {
                $fdata = array("Multi_Products" => $postdata);
    
                if($role_id == '5' || $role_id == '11')
                {
                    $query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
                    $row = $query->row_array();
                    $client_url = $row['client_url'];
                }
                else
                {
                    $query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
                    $row = $query->row_array();
                    $client_url = $row['client_url'];
                }
    
                $url = $client_url."insertNewMultiProducts";
    
                $jsondata = json_encode($fdata);
                
                // print_r($jsondata);
                
                $curl = curl_init($url);
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json')
                );
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
                $result = curl_exec($curl);
                
                // print_r($result);
                
                $json = json_decode($result, true);
                curl_close($curl);
    
                $api_status = $json['status'];
                $statuscode = $json['statuscode'];
                $response = $json['response'];
    
                if($statuscode == "200")
                {
                    $udata = array(
                    'api_status' => 'success', 
                    );
    
                    $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
                }
                else
                {
                    $udata = array(
                    'api_status' => 'failed', 
                    );
    
                    $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSPMA02 Products creation failed!!!</div>');
                }
                
                $ref_length = sizeof($refids);
    
                if($role_id == '5' || $role_id == '11')
                {
                    for($i = 0; $i < $ref_length; $i++)
                    {
                        $this->db->where('pr_id',$refids[$i]);
                        $sqlresult = $this->db->update('product',$udata);    
                    }
                }
                else
                {
                    for($i = 0; $i < $ref_length; $i++)
                    {
                        $this->db2->where('pr_id',$refids[$i]);
                        $sqlresult = $this->db2->update('product',$udata);    
                    }
                }
            }
            else
            {
                $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSPMA03 Products creation failed!!!</div>');
            }
        }
        redirect('Master_section/Products_list/8');
    }

	// Add New Tax -form
	public function addNewTax()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['pageTitle'] = 'Tax Creation';
		$data['Pagename'] = 'Tax Creation';
		$data['HomePage'] = 'Home';
		$this->load->view("master/add_tax", $data);
	}

	// New Tax Insert
	public function insertNewTax()
	{
		// $tax_percentage = ucwords(strtolower($this->input->post('tax_percentage')));
		$tax_percentage = $this->input->post('tax_percentage');
		if(!$this->master_model->checkTaxExist($tax_percentage))
		{
			$status = $this->input->post('status');
			date_default_timezone_set('Asia/Kolkata');
			$created = date("Y-m-d", time());
			$userInfo = array('tax_percentage'=> $tax_percentage,'status'=>$status,'created'=>$created);
			$result = $this->master_model->insertNewTax($userInfo);
			if($result > 0)
			{
				// $this->session->set_flashdata('success', 'New Tax created successfully');
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Tax created successfully</div>');
			}
			else
			{
				// $this->session->set_flashdata('error', 'Tax creation failed');
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Tax creation failed!!!</div>');
			}	
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Tax Percentage Already Exist!!!</div>');
		}
		
		redirect('Master_section/Tax_list');
	}

	// Tax List
	public function Tax_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->tax_list();
		$data['pageTitle'] = 'Tax List';
		$data['Pagename'] = 'Tax List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/tax_list",$data);
	}

	// Tax Edit info
	public function editTax($taxId )
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getTaxInfo($taxId);
		$data['pageTitle'] = 'Tax Edit';
		$data['Pagename'] = 'Tax Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/taxedit",  $data);
	}
	
	// Update Tax info
	public function updateTaxDetails()
	{
		$taxId = $this->input->post('taxId');
		// $tax_percentage = ucwords(strtolower($this->input->post('tax_percentage')));
		$tax_percentage = $this->input->post('tax_percentage');
		$status = $this->input->post('status');
		
		$old_tax_percentage = $this->input->post('old_tax_percentage');

		date_default_timezone_set('Asia/Kolkata');
		$updated = date("Y-m-d", time());

		$userInfo = array('tax_percentage'=> $tax_percentage,'status'=>$status,'updated'=>$updated);
		

		if($tax_percentage == $old_tax_percentage)
		{
			$result = $this->master_model->updateTaxDetails($userInfo, $taxId);
		}
		else
		{
			if($this->master_model->checkTaxExist($tax_percentage))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>TAX Already Exist! Can\'t update!</div>');
				redirect('Master_section/tax_list');
			}
			else
			{
				$result = $this->master_model->updateTaxDetails($userInfo, $taxId);
			}
		}

		if($result == true)
		{
			// $this->session->set_flashdata('success', 'Tax updated successfully');
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Tax updated successfully</div>');
		}
		else
		{
			// $this->session->set_flashdata('error', 'TAx updation failed');
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Tax updation failed!!!</div>');
		}
		redirect('Master_section/Tax_list');
	}

	public function deleteTax($taxId)
	{
		$this->data['deleteTax'] = $this->master_model->deleteTax($taxId);
		if($this->data['deleteTax'] == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Value Deleted</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> No Data Found!!!</div>');
		}
		redirect('Master_section/Tax_list');
	}

	// Add Unit Of Mesurement
	public function addNewUom()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['pageTitle'] = 'UOM Creation';
		$data['Pagename'] = 'UOM Creation';
		$data['HomePage'] = 'Home';
		$this->load->view("master/add_uom", $data);
	}

	// UOM List
	public function Uom_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->uom_list();
		$data['pageTitle'] = 'UOM List';
		$data['Pagename'] = 'UOM List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/uom_list", $data);
	}

	// Insert New UOM 
	public function insertNewUom()
	{
		// $uom_name = ucwords(strtolower($this->input->post('uom_name')));
		$uom_name = strtoupper($this->input->post('uom_name'));
		if(!$this->master_model->checkUomExist($uom_name))
		{
			$desc = $this->input->post('description');
			$status = $this->input->post('status');
			date_default_timezone_set('Asia/Kolkata');
			$created = date("Y-m-d", time());
			$userInfo = array('uom_name'=> $uom_name,'description'=>$desc,'status'=>$status,'created'=>$created);
			$result = $this->master_model->insertNewUOM($userInfo);
			if($result > 0)
			{
				// $this->session->set_flashdata('success', 'New UOM created successfully');
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New UOM created successfully</div>');
			}
			else
			{
				// $this->session->set_flashdata('error', 'UOM creation failed');
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> UOM creation failed!!!</div>');
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> UOM Already Exist!!!</div>');
		}
		redirect('Master_section/Uom_list');
	}
	
	// Edit UOM
	public function editUom($uomId)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getUomInfo($uomId);
		$data['pageTitle'] = 'UOM Edit';
		$data['Pagename'] = 'UOM Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/uomedit",$data);
	}

	// Update UOM
	public function updateUomDetails()
	{
		$uomId = $this->input->post('uomId');
		$uom_name = strtoupper($this->input->post('uom_name'));
		$desc = $this->input->post('description');
		$status = $this->input->post('status');

		$old_uom_name = $this->input->post('old_uom_name');

		date_default_timezone_set('Asia/Kolkata');
		$updated = date("Y-m-d", time());

		$old_rolename = $this->input->post('old_rolename');

		$userInfo = array('uom_name'=> $uom_name,'description'=>$desc,'status'=>$status,'updated'=>$updated);
		

		if(strcasecmp($uom_name, $old_uom_name) == 0)
		{
			$result = $this->master_model->updateUomDetails($userInfo, $uomId);
		}
		else
		{
			if($this->master_model->checkUomExist($uom_name))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>UOM Already Exist! Can\'t update!</div>');
				redirect('Master_section/Uom_list');
			}
			else
			{
				$result = $this->master_model->updateUomDetails($userInfo, $uomId);
			}
		}
		
		if($result == true)
		{
			// $this->session->set_flashdata('success', 'UOM updated successfully');
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> '.$uom_name.' updated successfully</div>');
		}
		else
		{
			// $this->session->set_flashdata('error', 'UOM updation failed');
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> UOM update failed!!!</div>');
		}
		redirect('Master_section/Uom_list');
	}

	public function deleteUom($uomId)
	{
		$this->data['deleteUom'] = $this->master_model->deleteUom($uomId);
		if($this->data['deleteUom'] == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Value Deleted</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> No Data Found!!!</div>');
		}
		redirect('Master_section/Uom_list');
	}

	// Category List
	public function category_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->category_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->category_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		// $data['userRecords'] = $this->master_model->category_list();
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Category List';
		$data['Pagename'] = 'Category List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/category_list", $data);
	}

	public function filtercategorylist($mid)
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filter_category_list($clientid,$branch);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->filter_category_list($clientid,$branch);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Filter By Client Category List';
		$data['Pagename'] = 'Filter By Client Category List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/category_list", $data);
	}
	
	public function Online_category_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->online_category_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->online_category_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Online Category List';
		$data['Pagename'] = 'Online Category List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/online_category_list", $data);
	}
	
	public function filteronlinecategorylist($mid)
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filter_online_category_list($clientid,$branch);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->filter_online_category_list($clientid,$branch);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Filter By Client Online Category List';
		$data['Pagename'] = 'Filter By Client Online Category List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/online_category_list", $data);
	}
	
	public function Counter_category_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->counter_category_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->counter_category_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Counter Category List';
		$data['Pagename'] = 'Counter Category List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/counter_category_list", $data);
	}
	
	public function filtercountercategorylist($mid)
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filter_counter_category_list($clientid,$branch);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->filter_counter_category_list($clientid,$branch);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Filter By Client Counter Category List';
		$data['Pagename'] = 'Filter By Client Counter Category List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/counter_category_list", $data);
	}

	// New Category Creation
	public function addNewcategory()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		// $data['discount'] = $this->master_model->getDiscount();
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_master_list();
		// $data['discount'] = $this->master_model->master_creation_active();
		$data['discountlist'] = $this->master_model->master_creation_dicount_active();
		$data['pageTitle'] = 'Category Creation';
		$data['Pagename'] = 'Category Creation';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addCategory", $data);
	}

	// New Category Creation
	public function insertNewCategory()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$category = $this->input->post('category');

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$query=$this->db->query("select a.* from category_master a, client_creation b WHERE a.client_id = b.client_id and a.category_master_id = $category");
			$row = $query->row_array();
			$cat_name = $row['category_name'];
		} 
		else  
		{
			$query=$this->db2->query("select a.* from category_master a, client_creation b WHERE a.client_id = b.client_id and a.category_master_id = $category");
			$row = $query->row_array();
			$cat_name = $row['category_name'];
		}

		// $removecat = explode('+',$category);
		// $cat_name = $removecat[0];
		// $cat_code = $removecat[1];
		// var_dump($removecat);

		// echo $cat_name." ".$cat_code;

		$effect_date = $this->input->post('effective_from');
		$discount = $this->input->post('cat_discount');
		
		$status1 = $this->input->post('cat_status');
		if($status1 == "true")
	    {
	        $status = "Active";
	    }
	    else
	    {
	        $status = "Inactive";
	    }

		$effectdate = date('Y-m-d',strtotime($effect_date));
		$date = date('Y-m-d');
		$data = array('pr_cat_name'=> $cat_name,
					  'discount' => $discount,
					  'cr_discount' => '0',
					  'status' => $status,
					  'effective_from' => $effectdate,
					  'created' =>$date,
					  'data_transfer'=>'pending',
					  'client_id' =>$clientid,
					  'branch' =>$branch,
					  'pr_cat_code'=>$category,
					  'api_status' => 'processing'
					);
		// $result = $this->master_model->insertNewCategory($data);

		if($role_id == '5' || $role_id == '11') 
		{ 
			$response = $this->master_model->checkCategoryExist($clientid,$branch,$cat_name);
		} 
		else  
		{
			$response = $this->client_master_model->checkCategoryExist($clientid,$branch,$cat_name);
		}

		if($response)
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSC01 Category Already Exist in Client and Branch!!!</div>');
			redirect('Master_section/category_list/6');
		}
		else
		{
			if($role_id == '5' || $role_id == '11') 
			{ 
				$result = $this->db->insert('product_category',$data);
				$lastid = $this->db->insert_id();
			} 
			else  
			{
				$result = $this->db2->insert('product_category',$data);
				$lastid = $this->db2->insert_id();
			}

			if($result > 0)
			{
				$data = array('pr_cat_name'=> $cat_name,
					  'discount' => $discount,
					  'cr_discount' => '0',
					  'status' => $status,
					  'effective_from' => $effectdate,
					  'created' =>$date,
					  'data_transfer'=>'pending',
					  'client_id' =>$clientid,
					  'branch' =>$branch,
					  'pr_cat_code'=>$category,
					  'pr_cat_id' => $lastid
					);

				if($role_id == '5' || $role_id == '11')
				{
					$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}
				else
				{
					$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}

				$url = $client_url."insertNewCategory";

				$jsondata = json_encode($data);
				
				$curl = curl_init($url);
		        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
		        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
		        'Content-Type: application/json')
		        );
		        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
		        $result = curl_exec($curl);
		        
		        // print_r($result);
		        
		        $json = json_decode($result, true);
		        curl_close($curl);

		        $api_status = $json['status'];
		        $statuscode = $json['statuscode'];
		        $response = $json['response'];

				if($statuscode == "200")
				{
					$udata = array(
		        	'api_status' => 'success', 
		        	);

					$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
				}
				else
				{
					$udata = array(
		        	'api_status' => 'failed', 
		        	);

					$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSC02 Category creation failed!!</div>');	
				}

				if($role_id == '5' || $role_id == '11')
				{
					$this->db->where('pr_cat_id ',$lastid);
					$result = $this->db->update('product_category',$udata);
				}
				else
				{
					$this->db2->where('pr_cat_id ',$lastid);
					$result = $this->db2->update('product_category',$udata);
				}
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSC03 Category creation failed!!!</div>');
			}
		}
		redirect('Master_section/category_list/6');
	}

	// Edit Category
	public function editCategory($pr_cat_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_master_list($client_id);
		}
		$data['userInfo'] = $this->master_model->getCatInfo($pr_cat_id);
		$data['discountlist'] = $this->master_model->master_creation_dicount_active();
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_master_list();
		// $data['branchs'] = $this->master_model->get_branch_name();
		$data['pageTitle'] = 'Category Edit';
		$data['Pagename'] = 'Category Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/category_edit", $data);
	}

	// update Category  Details
	public function updateCategoryDetails()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$categoryId = $this->input->post('categoryId');
		$category = $this->input->post('category');

		$old_clientid = $this->input->post('old_clientid');
		$old_branch = $this->input->post('old_branch');
		$old_category = $this->input->post('old_category');

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$query=$this->db->query("select a.* from category_master a, client_creation b WHERE a.client_id = b.client_id and a.category_master_id = $category");
			$row = $query->row_array();
			$cat_name = $row['category_name'];	
		} 
		else  
		{
			$query=$this->db2->query("select a.* from category_master a, client_creation b WHERE a.client_id = b.client_id and a.category_master_id = $category");
			$row = $query->row_array();
			$cat_name = $row['category_name'];
		}

		// $removecat = explode('+',$category);
		// $cat_name = $removecat[0];
		// $cat_code = $removecat[1];

		$effect_date = $this->input->post('effective_from');
		$discount = $this->input->post('cat_discount');
		
		$status1 = $this->input->post('cat_status');
		if($status1 == "true")
	    {
	        $status = "Active";
	    }
	    else
	    {
	        $status = "Inactive";
	    }

		$effectdate = date('Y-m-d',strtotime($effect_date));
		$date = date('Y-m-d');
		$data = array('pr_cat_name'=> $cat_name,
					  'discount' => $discount,
					  'cr_discount' => '0',
					  'status' => $status,
					  'effective_from' => $effectdate,
					  'updated' =>$date,
					  'data_transfer'=>'pending',
					  'client_id' =>$clientid,
					  'branch' =>$branch,
					  'pr_cat_code'=>$category
					);


		if(($clientid == $old_clientid) && (strcasecmp($branch, $old_branch) == 0) && (strcasecmp($cat_name, $old_category) == 0))
		{
			if($role_id == '5' || $role_id == '11') 
			{ 
				$result = $this->master_model->editcategoryDetails($data, $categoryId);
			} 
			else  
			{
				$result = $this->client_master_model->editcategoryDetails($data, $categoryId);
			}
		}
		else
		{
			if($role_id == '5' || $role_id == '11') 
			{ 
				$response = $this->master_model->checkCategoryExist($clientid,$branch,$cat_name);
			} 
			else  
			{
				$response = $this->client_master_model->checkCategoryExist($clientid,$branch,$cat_name);
			}

			if($response)
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSC04 Category Already Exist in Client and Branch, Can\'t update!!!</div>');
				redirect('Master_section/category_list/6');
			}
			else
			{
				if($role_id == '5' || $role_id == '11') 
				{ 
					$result = $this->master_model->editcategoryDetails($data, $categoryId);
				} 
				else  
				{
					$result = $this->client_master_model->editcategoryDetails($data, $categoryId);
				}
			}			
		}
		
		if($result == true)
		{
			$data = array('pr_cat_name'=> $cat_name,
					  'discount' => $discount,
					  'cr_discount' => '0',
					  'status' => $status,
					  'effective_from' => $effectdate,
					  'created' =>$date,
					  'data_transfer'=>'pending',
					  'client_id' =>$clientid,
					  'branch' =>$branch,
					  'pr_cat_code'=>$category,
					  'pr_cat_id'=>$categoryId,
					  'old_clientid'=>$old_clientid,
					  'old_branch'=>$old_branch,
					  'old_category'=>$old_category
					);

			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}

			// Function name for each module concated with the client url and API function name
			$url = $client_url."updateCategoryDetails";

			$jsondata = json_encode($data);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result = curl_exec($curl);
	        
	        // print_r($result);
	        
	        $json = json_decode($result, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);

				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);

				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSC05 Category creation failed!!</div>');	
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('pr_cat_id ',$categoryId);
				$result = $this->db->update('product_category',$udata);
			} 
			else  
			{
				$this->db2->where('pr_cat_id ',$categoryId);
				$result = $this->db2->update('product_category',$udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSC06  Category updation failed!!!</div>');
		}
		redirect('Master_section/category_list/6');
	}

	//Client List
	public function clientlist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->client_list();
		$data['pageTitle'] = 'Client List';
		$data['Pagename'] = 'Client List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/client_list", $data);
	}

	//Add Client
	public function addClient()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['pageTitle'] = 'New Client Registeration';
		$data['Pagename'] = 'New Client Registeration';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addClient", $data);
	}

	//Add New Client
	public function addNewClient()
	{
		// $name = ucwords(strtoupper($this->input->post('cname')));
		$name = $this->input->post('cname');
		$username = $this->input->post('username');
		$branch_prefix = strtoupper($this->input->post('branch_prefix'));
		if($this->master_model->checkClientExist($name))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Client Already Exist!!!</div>');
			redirect('Master_section/clientlist');
		}
		else
		{
			if($this->master_model->checkUsernameExist($username))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Username Already Exist!!!</div>');
			}
			else
			{
			    $q = $this->db->query("select * from client_creation where branch_prefix = '$branch_prefix'");
                if ($q->num_rows() > 0)
			    {
			        $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Branch Prefix Already Exist!!!</div>');
			    }
			    else
			    {
			        $roleid = $this->session->userdata('role');
    				$prime_id = $this->input->post('password');
    				$password = password_hash($prime_id, PASSWORD_DEFAULT);
    				$ceorole = $this->input->post('role');
    				$branches = $this->input->post('branches');
    				date_default_timezone_set('Asia/Kolkata');
    				$effective_from = date("Y-m-d", strtotime($this->input->post('effective')));
    				$created = date("Y-m-d", time());
    				$vendorId = $this->session->userdata('uid');
    				$client_url = $this->input->post('client_url');
    
    				$cmrole = '6';
    				
    				//Client Info
    				$userInfo = array('client_name'=> $name,'role'=>$ceorole,'no_of_branches'=>$branches, 'branch_prefix' => $branch_prefix, 'status'=>'Pending','created'=>$created,'client_url' => $client_url);
    
    				//CEO Info
    				$logininfo1 = array('email'=>$username,'password'=>$password,'name'=>$name,'role'=>$ceorole,'createdBy'=>$roleid,'createdDtm'=>date('Y-m-d H:i:s'),'prime_id'=>$prime_id,'status'=>'Pending','created'=>$created, 'effective_from'=>$effective_from, 'data_transfer' => 'pending');
    
    				//CLIENT MASTER Info
    				$logininfo2 = array('email'=>$name."_master",'password'=>$password,'name'=>$name."_master",'role'=>$cmrole,'createdBy'=>$roleid,'createdDtm'=>date('Y-m-d H:i:s'),'prime_id'=>$prime_id,'status'=>'Pending','created'=>$created, 'effective_from'=>$effective_from, 'data_transfer' => 'pending');
    
    				// var_dump($logininfo2);
    				$result = $this->master_model->addNewClient($userInfo,$logininfo1,$logininfo2);
    				if($result > 0)
    				{
    					$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Client '.$name.' created successfully</div>');
    				}
    				else
    				{
    					$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Client creation failed!!!</div>');
    				}       
			    }
			}
			redirect('Master_section/clientlist');
		}
	}

	//Edit Client
	public function editClient($clientid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getClientInfo($clientid);
		// var_dump($data['userInfo']);
		$data['pageTitle'] = 'Client Edit';
		$data['Pagename'] = 'Client Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_client", $data);
	}

	//Edit Client
	public function editClientDetails()
	{
		// $name = ucwords(strtoupper($this->input->post('cname')));
		$name = $this->input->post('cname');
		$username = $this->input->post('username');
		$prime_id = $this->input->post('password');
		$password = password_hash($prime_id, PASSWORD_DEFAULT);
		$ceorole = $this->input->post('role');
		$branches = $this->input->post('branches');
		$clientid = $this->input->post('clientid');
		$client_url = $this->input->post('client_url');
		$roleid = $this->session->userdata('role');
		date_default_timezone_set('Asia/Kolkata');
		$effective_from = date("Y-m-d", strtotime($this->input->post('effective')));
		$updated = date("Y-m-d", time());
		$userInfo = array();
		$logininfo = array();
		
		$branch_prefix = strtoupper($this->input->post('branch_prefix'));

		$cmrole = '6';

		$old_name = $this->input->post('old_cname');
		$old_username = $this->input->post('old_username');

		if(empty($prime_id))
		{
			// Client Info
			$userInfo = array('client_name'=> $name,'role'=>$ceorole,'no_of_branches'=>$branches, 'branch_prefix'=>$branch_prefix,'updated'=>$updated, 'client_url' => $client_url, 'api_status' => 'processing');

			// Ceo Info
			$logininfo1 = array('email'=>$username,'name'=>$name,'roleId'=>$ceorole,'createdBy'=>$roleid,'updated'=>$updated, 'effective_from'=>$effective_from, 'api_status' => 'processing');

			// Client Master Info
			$logininfo2 = array('email'=>$name."_master",'name'=>$name."_master",'roleId'=>$cmrole,'createdBy'=>$roleid,'updated'=>$updated, 'effective_from'=>$effective_from, 'api_status' => 'processing');
		}
		else
		{
			// Client Info
			$userInfo = array('client_name'=> $name,'role'=>$ceorole,'no_of_branches'=>$branches, 'branch_prefix'=>$branch_prefix, 'updated'=>$updated, 'client_url' => $client_url, 'api_status' => 'processing');

			// Ceo Info
			$logininfo1 = array('email'=>$username,'password'=>$password,'name'=>$name,'roleId'=>$ceorole,'createdBy'=>$roleid,'prime_id'=>$prime_id,'updated'=>$updated, 'effective_from'=>$effective_from, 'api_status' => 'processing');

			// Client Master Info
			$logininfo2 = array('email'=>$name."_master",'password'=>$password,'name'=>$name."_master",'roleId'=>$cmrole,'createdBy'=>$roleid,'prime_id'=>$prime_id,'updated'=>$updated, 'effective_from'=>$effective_from, 'api_status' => 'processing');
		}

		if((strcasecmp($name, $old_name) == 0) && (strcasecmp($username, $old_username) == 0))
		{
			$result = $this->master_model->editClientDetails($userInfo,$logininfo1,$logininfo2,$clientid,$ceorole,$cmrole);
		}
		else
		{
			// echo $name." ".$username;
			$resp = $this->master_model->checkClientUsernameExist($name,$username);
			if($resp != 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Client or Username Already Exist, Can\'t Update!!!</div>');
				redirect('Master_section/clientlist');
			}
			else
			{
				$result = $this->master_model->editClientDetails($userInfo,$logininfo1,$logininfo2,$clientid,$ceorole,$cmrole);
			}
		}
		
		if($result == true)
		{
		    $role_id = $this->session->userdata('role');
			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
            
            $clientinfo = array(
                'client_id'=>$clientid,
                'client_name'=> $name,
                'role'=>$ceorole,
                'no_of_branches'=>$branches,
                'branch_prefix'=>$branch_prefix,
                'updated'=>$updated,
                'client_url' => $client_url
            );
            
            $ceoinfo = array(
                'email'=>$username,
                'password'=>$password,
                'name'=>$name,
                'roleId'=>$ceorole,
                'createdBy'=>$roleid,
                'prime_id'=>$prime_id,
                'updated'=>$updated, 
                'effective_from'=>$effective_from 
            );
            
            $cminfo = array(
                'email'=>$name."_master",
                'password'=>$password,
                'name'=>$name."_master",
                'roleId'=>$cmrole,
                'createdBy'=>$roleid,
                'prime_id'=>$prime_id,
                'updated'=>$updated, 
                'effective_from'=>$effective_from,
            );
            
            $data = array(
                'client_info'=> $clientinfo,
                'ceoinfo'=> $ceoinfo,
                'cminfo'=> $cminfo,
                'old_name'=> $old_name,
                'old_username'=> $old_username,
            );

			$url = $client_url."updateClient";

			$jsondata = json_encode($data);
			
// 			print_r($jsondata);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result1 = curl_exec($curl);
	        
	       // print_r($result1);
	        
	        $json = json_decode($result1, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);

				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);

	        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCU01 Client updation Failed!!!</div>');
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('client_id', $clientid);
		        $result = $this->db->update('client_creation', $udata);
		        
		        $ceoarray = array('client_id' => $clientid, 'roleId' => $ceorole);
    	        $this->db->where($ceoarray); 
    	        $this->db->update('users', $udata);
    	        
    	        $cmarray = array('client_id' => $clientid, 'roleId' => $cmrole);
    	        $this->db->where($cmarray); 
    	        $this->db->update('users', $udata);
			} 
			else  
			{
				$this->db2->where('client_id', $clientid);
		        $result = $this->db2->update('client_creation', $udata);
		        
		        $ceoarray = array('client_id' => $clientid, 'roleId' => $ceorole);
    	        $this->db2->where($ceoarray); 
    	        $this->db2->update('users', $udata);
    	        
    	        $cmarray = array('client_id' => $clientid, 'roleId' => $cmrole);
    	        $this->db2->where($cmarray); 
    	        $this->db2->update('users', $udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCU02 Client updation Failed!!!</div>');
		}
		redirect('Master_section/clientlist');
	}

	//Delete Client
	public function deleteClient($clientid,$name)
	{
		if(!$this->master_model->clientChildExist($clientid))
		{
			// echo "Not Exits";
			$this->data['deleteClient'] = $this->master_model->deleteClient($clientid);
			if($this->data['deleteClient'] == true)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> '.$name.' Deleted</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> No Data Found!!!</div>');
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Child Table Exits can\'t delete value!!</div>');
		}
		redirect('Master_section/clientlist');
	}

	//User Approval List
	public function userapprovelist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->user_approve_list();
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
		}
		$data['pageTitle'] = 'User Approval List';
		$data['Pagename'] = 'User Approval List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/user_approve_list", $data);
	}

	//Approve User
	public function approveUser($clientid,$userid)
	{
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11')
		{
			$response = $this->master_model->approveUser($clientid,$userid);
		}
		else
		{
			$response = $this->client_master_model->approveUser($clientid,$userid);
		}
		
		if($response)
		{
			$data = array(
				'clientid' => $clientid,
				'userid' => $userid
			);

			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}

			$url = $client_url."approveUser";

			$jsondata = json_encode($data);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result = curl_exec($curl);
	        
	        // print_r($result);
	        
	        $json = json_decode($result, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSU07 User Approval Failed!!!</div>');	
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> User Approval Failed!!!</div>');
		}
		redirect('Master_section/userapprovelist');
	}

	//Filter User Approve List
	public function filteruserapprovelist()
	{
		$clientid = $this->input->post('client');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->filter_user_approve_list($clientid);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->filter_user_approve_list($clientid);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
		}
		$data['pageTitle'] = 'Filter By Client User Approval List';
		$data['Pagename'] = 'Filter By Client User Approval List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/user_approve_list", $data);
	}

	//Branch List
	public function branchlist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);			
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		}
		$data['userRecords'] = $this->master_model->branch_list();
		// $data['clientlist'] = $this->master_model->client_list_active();
		$data['pageTitle'] = 'Branch List';
		$data['Pagename'] = 'Branch List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/branch_list", $data);
	}

	public function filterbranchlist()
	{
		$clientid = $this->input->post('client');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		}
		$data['userRecords'] = $this->master_model->filter_branch_list($clientid);
		// $data['clientlist'] = $this->master_model->client_list_active();
		$data['pageTitle'] = 'Filter By Client Branch List';
		$data['Pagename'] = 'Filter By Client Branch List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/branch_list", $data);
	}

	//Add Branch
	public function addBranch()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		$data['pageTitle'] = 'New Branch Registeration';
		$data['Pagename'] = 'New Branch Registeration';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addBranch", $data);
	}
	
	public function getBranchCountForClient()
	{
	    $client_id = $this->input->post('client_id');
	    if(!empty($client_id))
	    {
		    $query=$this->db->query("SELECT max(a.branch_slno) as last_branch, b.branch_prefix FROM branch_creation a, client_creation b WHERE a.client_id = b.client_id and a.client_id = $client_id");
		    $row = $query->row_array();
		    $branch_prefix = $row['branch_prefix'];
		    $last_branch = $row['last_branch'];
		    if($last_branch == null)
		    {
		        $branch_slno = 0;
		    }
		    else
		    {
		        $branch_slno = $last_branch;
		    }
		    
		    $array = array('status_code'=>'200','branch_prefix' => $branch_prefix, 'branch_slno' => $branch_slno);
	    }
	    else
	    {
	        $array = array('status_code'=>'400');
	    }
	    
	    echo json_encode($array);
	}

	//Add New Branch
	public function addNewBranch()
	{			
		$clientid = $this->input->post('clientid');
		$getNoOfBranchesAllowed = $this->master_model->getNoOfBranchesAllowed($clientid);
		
		foreach ($getNoOfBranchesAllowed as $row) 
		{
			$totalbranches = $row->no_of_branches;
		}
		
		$noofBranchesExist = $this->master_model->noofBranchesExist($clientid);
		foreach ($noofBranchesExist as $row) 
		{
			$currentbranches = $row->branch;
		}

		// echo $totalbranches." ".$currentbranches;
		if($currentbranches >= $totalbranches)
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Branch Creation Failed! Only '.$totalbranches.' branches are allowed to create</div>');
			redirect('Master_section/branchlist');	
		}
		else
		{
			$bname = $this->input->post('bname');
			if($this->master_model->checkBranchExist($bname,$clientid))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Branch Already Exist!!!</div>');
				redirect('Master_section/branchlist');
			}
			else
			{
				$btitle = $this->input->post('btitle');
				$bslno = $this->input->post('bslno');
				date_default_timezone_set('Asia/Kolkata');
				$created = date("Y-m-d", time());
				$userInfo = array('client_id'=> $clientid,'branch_name'=>$bname,'branch_title'=>$btitle,'branch_slno'=>$bslno,'status'=>'Pending','created'=>$created, 'api_status' => 'processing');
				
				$result = $this->master_model->addNewBranch($userInfo);
				$last_id = $result;
				
				if($result > 0)
				{
				    $role_id = $this->session->userdata('role');
    				if($role_id == '5' || $role_id == '11')
    				{
    					$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
    					$row = $query->row_array();
    					$client_url = $row['client_url'];
    				}
    				else
    				{
    					$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
    					$row = $query->row_array();
    					$client_url = $row['client_url'];
    				}
    
                    $data = array(
                        'branch_id' => $last_id,
                        'client_id'=> $clientid,
                        'branch_name'=>$bname,
                        'branch_title'=>$btitle,
                        'branch_slno'=>$bslno,
                        'status'=>'Pending',
                        'created'=>$created,
                    );
    
    				$url = $client_url."addBranch";
    
    				$jsondata = json_encode($data);
    				
    				// print_r($jsondata);
    				
    				$curl = curl_init($url);
    		        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
    		        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
    		        'Content-Type: application/json')
    		        );
    		        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    		        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
    		        $result1 = curl_exec($curl);
    		        
    		      //  print_r($result1);
    		        
    		        $json = json_decode($result1, true);
    		        curl_close($curl);
    
    		        $api_status = $json['status'];
    		        $statuscode = $json['statuscode'];
    		        $response = $json['response'];
    
    				if($statuscode == "200")
    				{
    					$udata = array(
    		        	'api_status' => 'success', 
    		        	);
    
    					$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
    				}
    				else
    				{
    					$udata = array(
    		        	'api_status' => 'failed', 
    		        	);
    
    		        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSBCA01 Branch creation failed!!!</div>');
    				}
    
    				if($role_id == '5' || $role_id == '11') 
    				{ 
    					$this->db->where('branch_id', $last_id);
		                $result = $this->db->update('branch_creation', $udata);
    				} 
    				else  
    				{
    					$this->db2->where('branch_id', $last_id);
		                $result = $this->db2->update('branch_creation', $udata);
    				}
				}
				else
				{
					$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSBCA02 Branch creation failed!!!</div>');
				}
				redirect('Master_section/branchlist');
			}
		}
	}

	// Edit Branch
	public function editBranch($branchid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		$data['userInfo'] = $this->master_model->getBranchInfo($branchid);
		$data['pageTitle'] = 'Branch Edit';
		$data['Pagename'] = 'Branch Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_branch", $data);
	}

	// Edit Branch Detail
	public function editBranchDetails()
	{
		$clientid = $this->input->post('clientid');
		$branchid = $this->input->post('branchid');
		$bname = $this->input->post('bname');
		$btitle = $this->input->post('btitle');
		$bslno = $this->input->post('bslno');

		$old_bname = $this->input->post('old_bname');
		$old_clientid = $this->input->post('old_clientid');

		date_default_timezone_set('Asia/Kolkata');
		$updated = date("Y-m-d H:i:s");

		$userInfo = array('client_id'=> $clientid,'branch_name'=>$bname,'branch_title'=>$btitle,'branch_slno'=>$bslno,'updated'=>$updated, 'api_status' => 'processing');

		if(($clientid == $old_clientid) && (strcasecmp($bname, $old_bname) == 0))
		{
			$result = $this->master_model->editBranchDetails($userInfo,$branchid);
		}
		else
		{
			if($this->master_model->checkBranchExist($bname,$clientid))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Branch Already Exist! Can\'t update!</div>');
				redirect('Master_section/branchlist');
			}
			else
			{
				$result = $this->master_model->editBranchDetails($userInfo,$branchid);
			}
		}

		if($result == true)
		{
		    $role_id = $this->session->userdata('role');
			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
            
            $data = array(
                'branch_id' =>(int)$branchid,
                'client_id'=> $clientid,
                'branch_name'=>$bname,
                'branch_title'=>$btitle,
                'branch_slno'=>$bslno,
                'updated'=>$updated,
                'old_bname' => $old_bname,
                'old_clientid' => $old_clientid
            );

			$url = $client_url."updateBranch";

			$jsondata = json_encode($data);
			
// 			print_r($jsondata);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result1 = curl_exec($curl);
	        
	       // print_r($result1);
	        
	        $json = json_decode($result1, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);

				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);

	        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSBU01 Branch updation Failed!!!</div>');
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('branch_id', $branchid);
		        $this->db->update('branch_creation', $udata);
			} 
			else  
			{
				$this->db2->where('branch_id', $branchid);
		        $this->db2->update('branch_creation', $udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-CMSBU02 Branch updation Failed!!!</div>');
		}
		redirect('Master_section/branchlist');
	}

	// Delete Branch 
	public function deleteBranch($branchid)
	{
		$this->data['deleteBranch'] = $this->master_model->deleteBranch($branchid);
		if($this->data['deleteBranch'] == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Branch Deleted</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> No Branch Found!!!</div>');
		}
		redirect('Master_section/branchlist');
	}

	//Branch Approval List
	public function branchapprovelist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		}

		$data['userRecords'] = $this->master_model->branch_approve_list();
		// $data['clientlist'] = $this->master_model->client_list_active();
		$data['pageTitle'] = 'Branch Approval List';
		$data['Pagename'] = 'Branch Approval List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/branch_approve_list", $data);
	}

	//Branch Approval List
	public function outletapprovelist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		}
		$data['userRecords'] = $this->master_model->outlet_approve_list();
		// $data['clientlist'] = $this->master_model->client_list_active();
		$data['pageTitle'] = 'Outlet Approval List';
		$data['Pagename'] = 'Outlet Approval List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/outlet_approve_list", $data);
	}

	public function approveOutlet($clientid,$outletid)
	{
	   // echo $outletid."/".$clientid;
	    $role_id = $this->session->userdata('role');
	    if($role_id == '5' || $role_id == '11')
		{
			$response = $this->master_model->approveOutlet($clientid,$outletid);
		}
		else
		{
			$response = $this->client_master_model->approveOutlet($clientid,$outletid);
		}
		
		if($response)
		{
			$data = array(
				'clientid' => $clientid,
				'outId' => $outletid
			);

			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}

			$url = $client_url."approveOutlet";

			$jsondata = json_encode($data);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result = curl_exec($curl);
	        
	        // print_r($result);
	        
	        $json = json_decode($result, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
			    $udata = array(
		        	'api_status' => 'success', 
		        	);
		        	
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
			    $udata = array(
		        	'api_status' => 'failed', 
		        	);
		        	
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSOA01 Outlet Approval Failed!!!</div>');	
			}
			
			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('outId',$outletid);
				$result = $this->db->update('outlet_deatils',$udata);
			} 
			else  
			{
				$this->db2->where('outId',$outletid);
				$result = $this->db2->update('outlet_deatils',$udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSOA02 Outlet Approval Failed!!!</div>');
		}
		redirect('Master_section/outletapprovelist');
	}

	//Filter User Approve List
	public function filteroutletapprovelist()
	{
		$clientid = $this->input->post('client');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		}

		$data['userRecords'] = $this->master_model->filter_outlet_approve_list($clientid);
		// $data['clientlist'] = $this->master_model->client_list_active();
		$data['pageTitle'] = 'Filter By Client Outlet Approval List';
		$data['Pagename'] = 'Filter By Client Outlet Approval List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/outlet_approve_list", $data);
	}

	//Approve Branch
	public function approveBranch($client_id,$branchid)
	{
		if($this->master_model->approveBranch($client_id,$branchid))
		{
		    $role_id = $this->session->userdata('role');
			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}

            $data = array(
                'client_id'=> $client_id,
                'branch_id'=> $branchid,
            );
            
			$url = $client_url."approveBranch";

			$jsondata = json_encode($data);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result1 = curl_exec($curl);
	        
	       // print_r($result1);
	        
	        $json = json_decode($result1, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);

				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);

	        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSBA01 Branch Approval Failed!!!</div>');
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('branch_id', $branchid);
		        $result = $this->db->update('branch_creation', $udata);
			} 
			else  
			{
				$this->db2->where('branch_id', $branchid);
		        $result = $this->db2->update('branch_creation', $udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSBA02 Branch Approval Failed!!!</div>');
		}
		redirect('Master_section/branchapprovelist');
	}

	//Filter User Approve List
	public function filterbranchapprovelist()
	{
		$clientid = $this->input->post('client');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			
		}
		$data['userRecords'] = $this->master_model->filter_branch_approve_list($clientid);
		// $data['clientlist'] = $this->master_model->client_list_active();
		$data['pageTitle'] = 'Filter By Client Branch Approval List';
		$data['Pagename'] = 'Filter By Client Branch Approval List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/branch_approve_list", $data);
	}

	public function getActiveBranchList()
	{
		if($this->input->post('clientid'))
		{
			echo $this->master_model->getActiveBranchList($this->input->post('clientid'));
		}
	}

	public function getActiveUserList()
	{
		if($this->input->post('branchid'))
		{
			echo $this->master_model->getActiveUserList($this->input->post('branchid'));
		}
	}
	
	//Setting Creation (Master) 
	public function settinglist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['settinglist'] = $this->master_model->setting_list();
		$data['pageTitle'] = 'Setting List';
		$data['Pagename'] = 'Setting List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/setting_list", $data);
	}		

	public function addSetting()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['pageTitle'] = 'Add Setting';
		$data['Pagename'] = 'Add Setting';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addSetting", $data);
	}

	public function addnewsetting()
	{
		$setting_title = $this->input->post('setting_title');
		if(!$this->master_model->checkSettingExist($setting_title))
		{
			$setting_type = $this->input->post('setting_type');
			$setting_name = $this->input->post('setting_name');
			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");

			$data = array('setting_name'=>$setting_name, 'setting_type'=>$setting_type, 'setting_title'=>$setting_title, 'created'=> $created);

			$res = $this->master_model->addSetting($setting_name,$setting_type,$setting_title);

		    if($res > 0)
			{
			    
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Setting is Added</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Values!</div>');
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Setting Already Exist!</div>');
		}
		redirect('Master_section/settinglist');
	}

	public function editSetting($settingid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['settingInfo'] = $this->master_model->getSettingInfo($settingid);
		$data['pageTitle'] = 'Setting Edit';
		$data['Pagename'] = 'Setting Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_setting", $data);
	}

	public function editSettingDetails()
	{
		$settingId = $this->input->post('settingId');
		$setting_name = $this->input->post('setting_name');
		$setting_title = $this->input->post('setting_title');
		$setting_type = $this->input->post('setting_type');

		$old_setting_title = $this->input->post('old_setting_title');

		date_default_timezone_set('Asia/Kolkata');
		$updated = date("Y-m-d H:i:s");

		$setInfo = array('setting_name'=>$setting_name,'setting_title'=>$setting_title,'setting_type'=>$setting_type,'updated'=>$updated);

		if(strcasecmp($setting_title, $old_setting_title) == 0)
		{
			$result = $this->master_model->editSettingDetails($setInfo,$settingId);
		}
		else
		{
			if($this->master_model->checkSettingExist($setting_title))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>TAX Already Exist! Can\'t update!</div>');
				redirect('Master_section/settinglist');
			}
			else
			{
				$result = $this->master_model->editSettingDetails($setInfo,$settingId);
			}
		}
		
		if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Setting updated successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Setting updation failed!!!</div>');
		}
		redirect('Master_section/settinglist');
	}

	public function deleteSetting($settingId)
	{
		$this->data['deleteSetting'] = $this->master_model->deleteSetting($settingId);
		if($this->data['deleteSetting'] == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Setting Deleted</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> No Setting Found!!!</div>');
		}
		redirect('Master_section/settinglist');
	}

	//Application Settings Master
	public function applicationsettinglist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		$data['applicationsetting'] = $this->master_model->application_setting_list_by_branch();
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Application Setting List';
		$data['Pagename'] = 'Application Setting List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/application_setting_list", $data);
	}

	public function filterapplicationsettinglist()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		$data['applicationsetting'] = $this->master_model->filter_application_setting_list($clientid,$branch);
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Filter By Client Application Setting List';
		$data['Pagename'] = 'Filter By Client Application Setting List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/application_setting_list", $data);
	}

	public function addApplicationSetting()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['settinglist'] = $this->master_model->setting_list();
		$data['pageTitle'] = 'Add Application Setting';
		$data['Pagename'] = 'Add Application Setting';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addApplicationSetting", $data);
	}

	public function getSettingsForBranch()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['settinglist'] = $this->master_model->getSettingsForBranch($clientid,$branch);
		$data['clientid'] = $clientid;
		$data['branch'] = $branch;
		$data['pageTitle'] = 'Add Application Setting';
		$data['Pagename'] = 'Add Application Setting';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addApplicationSetting", $data);
	}

	public function addnewapplicationsetting()
	{
	    $role_id = $this->session->userdata('role');
	    
		$client_id = $this->input->post('clientid');
		$branchname = $this->input->post('branch');

		$setting_id = $this->input->post('setting_id[]');
		$setting_name = $this->input->post('setting_name[]');
		$setting_type = $this->input->post('setting_type[]');
		$setting_title = $this->input->post('setting_title[]');
		$setting_access = $this->input->post('setting_access[]');
		$status = $this->input->post('status[]');
		$effective_from = $this->input->post('effective_from[]');
		date_default_timezone_set("Asia/Kolkata");
		$created = date("Y-m-d H:i:s");
		
	    for($i = 0; $i < count($setting_name); $i++) 
        {
           $data = array(
               	'setting_id' => $setting_id[$i],
               	'setting_name'=> $setting_name[$i],
               	'setting_access' => $setting_access[$i],
               	'setting_type' => $setting_type[$i],
               	'setting_title' => $setting_title[$i],
               	'status' => $status[$i],
               	'effective_from' => date('Y-m-d',strtotime($effective_from[$i])),
               	'data_transfer' => 'pending',
               	'branch' => $branchname,
               	'client_id' => (int)$client_id,
               	'created' => $created,
               	'api_status' => 'processing'
       	    );
       	    if($role_id == '5' || $role_id == '11')
       		{
       		    $this->db->insert('application_setting', $data);
       		    $last_id = $this->db->insert_id();
       		    $id[] = array(
       		        'app_setting_id' => $last_id
       		        );
       		    $idata[] = array(
    	                'app_setting_id' => $last_id,
        	            'setting_id' => $setting_id[$i],
                       	'setting_name'=> $setting_name[$i],
                       	'setting_access' => $setting_access[$i],
                       	'setting_type' => $setting_type[$i],
                       	'setting_title' => $setting_title[$i],
                       	'status' => $status[$i],
                       	'effective_from' => date('Y-m-d',strtotime($effective_from[$i])),
                       	'data_transfer' => 'pending',
                       	'branch' => $branchname,
                       	'client_id' => (int)$client_id,
                       	'created' => $created,
    	       		);
       		}
       		else
       		{
       		    $this->db2->insert('application_setting', $data);
       		    $last_id = $this->db2->insert_id();
       		    $id[] = array(
       		        'app_setting_id' => $last_id
       		        );
       		    $idata[] = array(
    	                'app_setting_id' => $last_id,
        	            'setting_id' => $setting_id[$i],
                       	'setting_name'=> $setting_name[$i],
                       	'setting_access' => $setting_access[$i],
                       	'setting_type' => $setting_type[$i],
                       	'setting_title' => $setting_title[$i],
                       	'status' => $status[$i],
                       	'effective_from' => date('Y-m-d',strtotime($effective_from[$i])),
                       	'data_transfer' => 'pending',
                       	'branch' => $branchname,
                       	'client_id' => (int)$client_id,
                       	'created' => $created,
    	       		);
       		}
       	}

       	// if($this->master_model->checkApplicationSettingExist($client_id,$branchname))
       	// {
       	// 	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Application Setting Already Exist! Can\'t update!</div>');
       	// }
       	// else
       	// {
	       		// print_r($data);
	        

	        if($last_id > 0)
			{
				if($role_id == '5' || $role_id == '11')
				{
					$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}
				else
				{
					$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}
                
                $data1 = array (
    			        "application_setting" => $idata,
    			        "client_id" => $client_id,
    			        "branch" => $branchname
    			    );
                
				$url = $client_url."addApplicationSetting";

				$jsondata = json_encode($data1);
				
				// print_r($jsondata);
				
				$curl = curl_init($url);
		        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
		        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
		        'Content-Type: application/json')
		        );
		        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
		        $result1 = curl_exec($curl);
		        
		      //  print_r($result1);
		        
		        $json = json_decode($result1, true);
		        curl_close($curl);

		        $api_status = $json['status'];
		        $statuscode = $json['statuscode'];
		        $response = $json['response'];

				if($statuscode == "200")
				{
					foreach($id as $rw) 
        	        {
        	           $udata[] = array(
        	               'app_setting_id' => $rw['app_setting_id'],
        	           	   'api_status' => 'success',
        	       		);
        	       	}

					$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
				}
				else
				{
					foreach($id as $rw) 
        	        {
        	           $udata[] = array(
        	               'app_setting_id' => $rw['app_setting_id'],
        	           	   'api_status' => 'failed',
        	       		);
        	       	}

		        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSASA01 Application Settings failed to add for $branch!!!</div>');
				}

				if($role_id == '5' || $role_id == '11') 
				{ 
					$result = $this->db->update_batch('application_setting',$udata, 'app_setting_id');
				    // print_r($udata);
				} 
				else  
				{
					$result = $this->db2->update_batch('application_setting',$udata, 'app_setting_id');
				// 	print_r($udata);
				}
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</buttonERR-MSASA01 Application Settings failed to add for $branchname</div>');
			}
       	// }
		redirect('Master_section/applicationsettinglist');
	}

	public function editApplicationSetting($branchname)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['settinglist'] = $this->master_model->getApplicationSettingDetailsByBranch($branchname);
		$data['pageTitle'] = 'Application Setting Edit';
		$data['Pagename'] = 'Application Setting Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_Application_Setting", $data);
	}

	public function editApplicationSettingDetails()
	{
		$client_id = $this->input->post('clientid');
		$branchname = $this->input->post('branch');

		$app_setting_id = $this->input->post('app_setting_id[]');

		$setting_id = $this->input->post('setting_id[]');
		$setting_name = $this->input->post('setting_name[]');
		$setting_type = $this->input->post('setting_type[]');
		$setting_title = $this->input->post('setting_title[]');
		$setting_access = $this->input->post('setting_access[]');
		$status = $this->input->post('status[]');
		$oldvalue = $this->input->post('old_setting_access&status&effective[]');
		$effective_from = $this->input->post('effective_from[]');
		date_default_timezone_set('Asia/Kolkata');
		$updated = date("Y-m-d H:i:s");

		$old_client_id = $this->input->post('old_clientid');
		$old_branchname = $this->input->post('old_branch');
		
		$dataimages = array();
	    for($i = 0; $i < count($setting_name); $i++) 
        {
            if($oldvalue[$i] != $setting_access[$i].$status[$i].$effective_from[$i])
            {
                $updatedata[] = array(
                   	'app_setting_id' => (int)$app_setting_id[$i],
                   	'setting_id' => $setting_id[$i],
                   	'setting_name'=> $setting_name[$i],
                   	'setting_access' => $setting_access[$i],
                   	'setting_type' => $setting_type[$i],
                   	'setting_title' => $setting_title[$i],
                   	'status' => $status[$i],
                   	'effective_from' => date('Y-m-d',strtotime($effective_from[$i])),
                   	'data_transfer' => 'pending',
                   	'branch' => $branchname,
                   	'client_id' => (int)$client_id,
                   	'updated' => $updated,
                   	'api_status' => 'processing'
       	        );   
            }
       	}
       	
       	// print_r($updatedata);
       	
       	if(empty($updatedata))
       	{
       	    $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Application Setting updation Failed due to No Changes!!!</div>');
       	}
        else
        {
            if(($client_id == $old_client_id) && (strcasecmp($branchname, $old_branchname) == 0))
    		{
    			$result = $this->db->update_batch('application_setting', $updatedata, 'app_setting_id');
    		}
    		else
    		{
    			if($this->master_model->checkApplicationSettingExist($client_id,$branchname))
    	       	{
    	       		$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Application Setting Already Exist for Client and Branch! Can\'t update!</div>');
    	       		redirect('Master_section/applicationsettinglist');
    	       	}
    			else
    			{
    				$result = $this->db->update_batch('application_setting', $updatedata, 'app_setting_id');
    			}
    		}
    		// echo $res;
    		
    		if($result == true)
    		{
    		    $role_id = $this->session->userdata('role');
    		    if($role_id == '5' || $role_id == '11')
    			{
    				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
    				$row = $query->row_array();
    				$client_url = $row['client_url'];
    			}
    			else
    			{
    				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
    				$row = $query->row_array();
    				$client_url = $row['client_url'];
    			}
    
    
    			$url = $client_url."updateApplicationSetting";
    			
    			$posdata = array(
    			        'application_setting' => $updatedata,
    			        'client_id' => $client_id,
    			        'branch' => $branchname,
    			        'old_client_id' => $old_client_id,
    			        'old_branch' => $old_branchname
    			    );
    
    			$jsondata = json_encode($posdata);
    			
    // 			print_r($jsondata);
    			
    			$curl = curl_init($url);
    	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
    	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
    	        'Content-Type: application/json')
    	        );
    	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
    	        $result1 = curl_exec($curl);
    	        
    	       // print_r($result1);
    	        
    	        $json = json_decode($result1, true);
    	        curl_close($curl);
    
    	        $api_status = $json['status'];
    	        $statuscode = $json['statuscode'];
    	        $response = $json['response'];
    
    			if($statuscode == "200")
    			{
    				foreach($updatedata as $d) 
                    {
                        $udata[] = array(
                            'app_setting_id' => $d['app_setting_id'],
    	        	        'api_status' => 'success', 
    	        	    );
                  	}
    
    				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
    			}
    			else
    			{
    				foreach($updatedata as $d) 
                    {
                        $udata[] = array(
                            'app_setting_id' => $d['app_setting_id'],
    	        	        'api_status' => 'failed', 
    	        	    );
                  	}
    
    	        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSEAS01 Application Setting updation Failed!!!</div>');
    			}
    
    			if($role_id == '5' || $role_id == '11') 
    			{ 
    				$result = $this->db->update_batch('application_setting', $udata, 'app_setting_id');
    				// print_r($udata);
    			} 
    			else  
    			{
    				$result = $this->db2->update_batch('application_setting', $udata, 'app_setting_id');
    				// print_r($udata);
    			}
    		}
    		else
    		{
    			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSEASU02 Application Setting updation Failed!!!</div>');
    		}   
        }
		redirect('Master_section/applicationsettinglist');
	}


	//Master 
	public function masterlist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['masterlist'] = $this->master_model->master_list();
		$data['pageTitle'] = 'Master List';
		$data['Pagename'] = 'Master List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/master_list", $data);
	}		

	public function addMaster()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['pageTitle'] = 'Add Master';
		$data['Pagename'] = 'Add Master';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addMaster", $data);
	}

	public function addnewmaster()
	{
		$master_type = $this->input->post('master_type');
		$master_details = $this->input->post('master_details');

		if($this->master_model->checkMasterExist($master_type,$master_details))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Master Already Exist!</div>');
			redirect('Master_section/masterlist');
		}
		else
		{
			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");

			$data = array('master_type'=>$master_type, 'master_details'=>$master_details,'created'=> $created);

			// var_dump($data);

			$res = $this->master_model->addMaster($data);

		    if($res > 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Master is Added</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Values!</div>');
			}
		}
		redirect('Master_section/masterlist');
	}

	public function editMaster($masterid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['masterInfo'] = $this->master_model->getMasterDetails($masterid);
		$data['pageTitle'] = 'Master Edit';
		$data['Pagename'] = 'Master Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_master", $data);
	}

	public function editMasterDetails()
	{
		$masterId = $this->input->post('masterId');
		$master_type = $this->input->post('master_type');
		$master_details = $this->input->post('master_details');

		$old_master_type = $this->input->post('old_master_type');
		$old_master_details = $this->input->post('old_master_details');

		date_default_timezone_set('Asia/Kolkata');
		$updated = date("Y-m-d H:i:s");

		$masterInfo = array('master_type'=>$master_type,'master_details'=>$master_details,'updated'=>$updated);

		if((strcasecmp($master_type, $old_master_type) == 0) && (strcasecmp($master_details, $old_master_details) == 0))
		{
			$result = $this->master_model->editMasterDetails($masterInfo,$masterId);	
		}
		else
		{
			if($this->master_model->checkMasterExist($master_type,$master_details))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Master Type or Master Detail Already Exist! Can\'t update!</div>');
				redirect('Master_section/masterlist');
			}
			else
			{
				$result = $this->master_model->editMasterDetails($masterInfo,$masterId);
			}
		}

		if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Master updated successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Master updation failed!!!</div>');
		}
		redirect('Master_section/masterlist');
	}

	// public function deleteMaster($masterId)
	// {
	// 	$this->data['deleteMaster'] = $this->master_model->deleteMaster($masterId);
	// 	if($this->data['deleteMaster'] == true)
	// 	{
	// 		$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Master Deleted</div>');
	// 	}
	// 	else
	// 	{
	// 		$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> No Master Found!!!</div>');
	// 	}
	// 	redirect('Master_section/masterlist');
	// }

	//Application Settings Master
	public function mastercreationlist()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		$data['mastercreationlist'] = $this->master_model->master_creation_list_by_branch();
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Master Creation List';
		$data['Pagename'] = 'Master Creation List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/master_creation_list", $data);
	}

	public function filtermastercreationlist()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		$data['mastercreationlist'] = $this->master_model->filter_master_creation_list($clientid,$branch);
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Filter By Client Master Creation List';
		$data['Pagename'] = 'Filter By Client Master Creation List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/master_creation_list", $data);
	}

	public function addMasterCreation()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['mastertype'] = $this->master_model->master_type_list();
		// $data['masterdetails'] = $this->master_model->master_details_list();
		$data['pageTitle'] = 'Add Master Creation';
		$data['Pagename'] = 'Add Master Creation';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addMasterCreation", $data);
	}

	public function getMasterDetailsForMasterType()
	{
		if($this->input->post('mastertype'))
		{
			echo $this->master_model->getMasterDetailsForMasterType($this->input->post('mastertype'));
		}
	}

	public function addnewmastercreation()
	{
		$client_id = $this->input->post('clientid');
		$branchname = $this->input->post('branch');

		$master_type = $this->input->post('mastertype');
		$master_details = $this->input->post('masterdetails');
		
		$status = $this->input->post('status');
		$effective_from = $this->input->post('effective_from');

		date_default_timezone_set("Asia/Kolkata");
		$created = date("Y-m-d H:i:s");

		$query=$this->db->query("SELECT * from master where master_type = '$master_type' and master_details = '$master_details'");
		$row = $query->row_array();
		$master_id = $row['master_id'];
		
        $data = array(
           	'masters_status'=> $master_type,
           	'master_details' => $master_details,
           	'status' => $status,
           	'effective_from' => date('Y-m-d',strtotime($effective_from)),
           	'data_transfer' => 'pending',
           	'branch' => $branchname,
           	'client_id' => $client_id,
           	'created' => $created,
           	'master_id' => $master_id,
           	'api_status' => 'processing'
       	);

       	// print_r($data);
       	if($this->master_model->checkMasterCreationExist($client_id,$branchname,$master_type,$master_details))
       	{
       		$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Master Creation Already Exist for Client and Branch!</div>');
       	}
       	else
       	{
       		$res = $this->master_model->addMasterCreation($data);
       		$last_id = $res;

	        // echo $res;

	        if($res > 0)
			{
			    $role_id = $this->session->userdata('role');
				if($role_id == '5' || $role_id == '11')
				{
					$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}
				else
				{
					$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}

                $data = array(
                    'masterId' => $last_id,
                   	'masters_type'=> $master_type,
                   	'master_details' => $master_details,
                   	'status' => $status,
                   	'effective_from' => date('Y-m-d',strtotime($effective_from)),
                   	'data_transfer' => 'pending',
                   	'branch' => $branchname,
                   	'client_id' => $client_id,
                   	'created' => $created,
                   	'master_id' => $master_id
               	);
                
				$url = $client_url."addMasterCreation";

				$jsondata = json_encode($data);
				
				//print_r($jsondata);
				
				$curl = curl_init($url);
		        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
		        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
		        'Content-Type: application/json')
		        );
		        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
		        $result1 = curl_exec($curl);
		        
		      //  print_r($result1);
		        
		        $json = json_decode($result1, true);
		        curl_close($curl);

		        $api_status = $json['status'];
		        $statuscode = $json['statuscode'];
		        $response = $json['response'];

				if($statuscode == "200")
				{
					$udata = array(
		        	'api_status' => 'success', 
		        	);

					$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
				}
				else
				{
					$udata = array(
		        	'api_status' => 'failed', 
		        	);

		        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSMACA01 Failed to Add Master Creation!!!</div>');
				}

				if($role_id == '5' || $role_id == '11') 
				{ 
					$this->db->where('masterId', $last_id);
		            $this->db->update('masters_creation', $udata);
				} 
				else  
				{
					$this->db2->where('masterId', $last_id);
		            $this->db2->update('masters_creation', $udata);
				}
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSMACA02 Failed to Add Master Creation!!!</div>');
			}
       	}
        redirect('Master_section/mastercreationlist');
	}

	public function editMasterCreation($masterid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['mastertype'] = $this->master_model->master_type_list();
		// $data['masterdetails'] = $this->master_model->master_details_list();
		$data['masterInfo'] = $this->master_model->getMasterCreationDetails($masterid);
		$data['pageTitle'] = 'Master Creation Edit';
		$data['Pagename'] = 'Master Creation Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_master_creation", $data);
	}

	public function editMasterCreationDetails()
	{
		$client_id = $this->input->post('clientid');
		$branchname = $this->input->post('branch');

		$masterId = $this->input->post('masterId');

		$master_type = $this->input->post('mastertype');
		$master_details = $this->input->post('masterdetails');
		
		date_default_timezone_set('Asia/Kolkata');			
		$status = $this->input->post('status');
		$effective_from = date('Y-m-d',strtotime($this->input->post('effective_from')));

		$query=$this->db->query("SELECT * from master where master_type = '$master_type' and master_details = '$master_details'");
		$row = $query->row_array();
		$master_id = $row['master_id'];

		$old_client_id = $this->input->post('old_clientid');
		$old_branchname = $this->input->post('old_branch');
		$old_master_type = $this->input->post('old_mastertype');
		$old_master_details = $this->input->post('old_masterdetails');

		$updated = date("Y-m-d H:i:s");
		$masterInfo = array('masters_status'=>$master_type,'master_details'=>$master_details,'status'=>$status,'effective_from'=>$effective_from,'updated'=>$updated, 'branch' => $branchname, 'client_id' => $client_id, 'master_id' => $master_id, 'data_transfer' => 'pending', 'api_status' => 'processing');

		if(($client_id == $old_client_id) && (strcasecmp($branchname, $old_branchname) == 0) && (strcasecmp($master_type, $old_master_type) == 0) && (strcasecmp($master_details, $old_master_details) == 0))
		{
			$result = $this->master_model->editMasterCreationDetails($masterInfo,$masterId);
		}
		else
		{
			if($this->master_model->checkMasterCreationExist($client_id,$branchname,$master_type,$master_details))
	       	{
	       		$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Master Creation Already Exist for Client and Branch, Can\'t Update!</div>');
	       		redirect('Master_section/mastercreationlist');
	       	}
	       	else
	       	{
	       		$result = $this->master_model->editMasterCreationDetails($masterInfo,$masterId);
	       	}
		}

		if($result == true)
		{
		    $role_id = $this->session->userdata('role');
			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$client_id);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}

            $data = array(
                'masterId' => (int)$masterId,
                'masters_type'=>$master_type,
                'master_details'=>$master_details,
                'status'=>$status,
                'effective_from'=>$effective_from,
                'updated'=>$updated, 
                'branch' => $branchname, 
                'client_id' => $client_id, 
                'master_id' => $master_id, 
                'data_transfer' => 'pending',
                'old_client_id' => $old_client_id,
                'old_branchname' => $old_branchname,
                'old_master_type' => $old_master_type,
                'old_master_details' => $old_master_details
            );
            
			$url = $client_url."updateMasterCreation";

			$jsondata = json_encode($data);
			
// 			print_r($jsondata);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result1 = curl_exec($curl);
	        
	       // print_r($result1);
	        
	        $json = json_decode($result1, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);

				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);

	        	$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSMAC01 Master Creation updation failed!!!</div>');
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('masterId', $masterId);
		        $this->db->update('masters_creation', $udata);
			} 
			else  
			{
				$this->db2->where('masterId', $masterId);
		        $this->db2->update('masters_creation', $udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSMAC01 Master Creation updation failed!!!</div>');
		}
		redirect('Master_section/mastercreationlist');
	}

	public function categorymasterlist($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['categorymasterlist'] = $this->master_model->category_master_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['categorymasterlist'] = $this->master_model->category_master_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Category Master List';
		$data['Pagename'] = 'Category Master List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/category_master_list", $data);
	}
	
	public function filter_categorymasterlist($mid)
	{
	    $clientid = $this->input->post('clientid');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['categorymasterlist'] = $this->master_model->filter_category_master_list($clientid);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['categorymasterlist'] = $this->master_model->filter_category_master_list($clientid);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'Filter By Client Category Master List';
		$data['Pagename'] = 'Filter By Client Category Master List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/category_master_list", $data);
	}

	public function addCategoryMaster()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Add Category Master';
		$data['Pagename'] = 'Add Category Master';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addCategoryMaster", $data);
	}

	public function addnewcategorymaster()
	{
		$client = $this->input->post('clientid');
		$category_name = $this->input->post('cat_name');

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$response = $this->master_model->checkCategoryMasterExist($category_name,$client);	
		} 
		else  
		{
			$response = $this->client_master_model->checkCategoryMasterExist($category_name,$client);	
		}

		if($response)
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCM01  Category Already Exist!</div>');
		}
		else
		{
			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");

			$data = array('category_name'=>$category_name, 'client_id'=>$client, 'created'=> $created, 'api_status' => 'processing');

			// var_dump($data);

			if($role_id == '5' || $role_id == '11') 
			{ 
				$response = $this->master_model->addCategoryMaster($data);
			} 
			else  
			{
				$response = $this->client_master_model->addCategoryMaster($data);	
			}

		    if($response > 0)
			{
				if($role_id == '5' || $role_id == '11')
				{
					$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$client);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}
				else
				{
					$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$client);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}
				
			    $data = array('category_name'=>$category_name, 'client_id'=>$client, 'created'=> $created, 'api_status' => 'processing', 'category_master_id' => $response);	
				
				// $query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$client);
				// $row = $query->row_array();
				// $client_url = $row['client_url'];

				$url = $client_url."addnewcategorymaster";

				$jsondata = json_encode($data);
				
				$curl = curl_init($url);
		        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
		        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
		        'Content-Type: application/json')
		        );
		        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
		        $result = curl_exec($curl);
		        
		        // print_r($result);
		        
		        $json = json_decode($result, true);
		        curl_close($curl);

		        $api_status = $json['status'];
		        $statuscode = $json['statuscode'];
		        $resp = $json['response'];

				if($statuscode == "200")
				{
					$udata = array(
		        	'api_status' => 'success', 
		        	);
					$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$resp.'</div>');
				}
				else
				{
					$udata = array(
		        	'api_status' => 'failed', 
		        	);
					$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCM02 Failed to Add Category!</div>');	
				}

				if($role_id == '5' || $role_id == '11')
				{
					$this->db->where('category_master_id ',$response);
					$result = $this->db->update('category_master',$udata);
				}
				else
				{
					$this->db2->where('category_master_id ',$response);
					$result = $this->db2->update('category_master',$udata);
				}
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCM03 Failed to Add Category!</div>');
			}
		}
		redirect('Master_section/categorymasterlist/4');
	}

	public function editCategoryMaster($categorymasterid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
		}
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['masterInfo'] = $this->master_model->getCategoryMasterDetails($categorymasterid);
		$data['pageTitle'] = 'Category Master Edit';
		$data['Pagename'] = 'Category Master Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/edit_category_master", $data);
	}

	public function editCategoryMasterDetails()
	{
		$categorymasterid = $this->input->post('categorymasterid');
		$client = $this->input->post('clientid');
		$category_name = $this->input->post('cat_name');

		$old_category_name = $this->input->post('old_cat_name');
		$old_client = $this->input->post('old_clientid');

		date_default_timezone_set('Asia/Kolkata');
		$updated = date("Y-m-d H:i:s");

		$data = array('category_name'=>$category_name, 'client_id'=>$client, 'updated'=> $updated, 'api_status' => 'processing');

		$role_id = $this->session->userdata('role');
		if(($client == $old_client) && (strcasecmp($category_name, $old_category_name) == 0))
		{
			if($role_id == '5' || $role_id == '11') 
			{ 
				$result = $this->master_model->editCategoryMasterDetails($data,$categorymasterid);	
			} 
			else  
			{
				$result = $this->client_master_model->editCategoryMasterDetails($data,$categorymasterid);
			}
		}
		else
		{
			if($role_id == '5' || $role_id == '11') 
			{ 
				$response = $this->master_model->checkCategoryMasterExist($category_name,$client);	
			} 
			else  
			{
				$response = $this->client_master_model->checkCategoryMasterExist($category_name,$client);
			}

			if($response)
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCM04 Category Already Exist! Can\'t update!</div>');
				redirect('Master_section/categorymasterlist/4');
			}
			else
			{
				if($role_id == '5' || $role_id == '11') 
				{ 
					$result = $this->master_model->editCategoryMasterDetails($data,$categorymasterid);	
				} 
				else  
				{
					$result = $this->client_master_model->editCategoryMasterDetails($data,$categorymasterid);
				}
			}
		}
		
		if($result == true)
		{
// 			$role_id = $this->session->userdata('role');
			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$client);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$client);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}

			$data = array('category_name'=>$category_name, 'client_id'=>$client, 'updated'=> $updated, 'old_category_name' => $old_category_name, 'old_client' => $old_client, 'category_master_id' => $categorymasterid);

			$url = $client_url."editCategoryMasterDetails";

			$jsondata = json_encode($data);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result = curl_exec($curl);
	        
	        // print_r($result);
	        
	        $json = json_decode($result, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $response = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$response.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCM05 Category updation failed!!!</div>');	
			}

			if($role_id == '5' || $role_id == '11') 
			{ 
				$this->db->where('category_master_id ',$categorymasterid);
				$result = $this->db->update('category_master',$udata);	
			} 
			else  
			{
				$this->db2->where('category_master_id ',$categorymasterid);
				$result = $this->db2->update('category_master',$udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSCM06 Category updation failed!!!</div>');
		}
		redirect('Master_section/categorymasterlist/4');
	}

	public function module_group_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->module_group_list();
		$data['pageTitle'] = 'Module Group List';
		$data['Pagename'] = 'Module Group List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/module_group_list",$data);
	}

	public function addModuleGroup()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Add Module Group';
		$data['Pagename'] = 'Add Module Group';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addModuleGroup", $data);
	}

	public function insertModuleGroup()
	{
		$groupname = $this->input->post('groupname');
		$sortid = $this->input->post('sortid');
		$icon = $this->input->post('icon');

		if($this->master_model->checkModuleGroupExist($groupname))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Module Group Already Exist!</div>');
		}
		else
		{
			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");

			$data = array('module_group_name'=>$groupname, 'sort_id'=>$sortid, 'icon' => $icon, 'created'=> $created);

			$res = $this->db->insert('module_groups',$data);

		    if($res > 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Module Group is Added</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Module Group!</div>');
			}
		}
		redirect('Master_section/module_group_list');
	}

	public function editModuleGroup($modulegroupid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getModuleGroupDetails($modulegroupid);
		$data['pageTitle'] = 'Module Group Edit';
		$data['Pagename'] = 'Module Group Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/editModuleGroup", $data);
	}

	public function editModuleGroupDetails()
	{
		$modulegroupid = $this->input->post('modulegroupid');
		$groupname = $this->input->post('groupname');
		$sortid = $this->input->post('sortid');
		$icon = $this->input->post('icon');

		$old_sortid = $this->input->post('old_sortid');
		$old_groupname = $this->input->post('old_groupname');

		date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");

		$data = array('module_group_name'=>$groupname, 'sort_id'=>$sortid, 'icon' => $icon, 'updated'=> $updated);

		// if(($sortid == $old_sortid) && (strcasecmp($groupname, $old_groupname) == 0))
		if(strcasecmp($groupname, $old_groupname) == 0)
		{
			$this->db->where('module_group_id',$modulegroupid);
			$result = $this->db->update('module_groups',$data);	
		}
		else
		{
			if($this->master_model->checkModuleGroupExist($groupname))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Module Group Already Exist! Can\'t update!</div>');
				redirect('Master_section/module_group_list');
			}
			else
			{
				$this->db->where('module_group_id',$modulegroupid);
				$result = $this->db->update('module_groups',$data);
			}
		}

	    if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Module Group is Updated</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Update Module Group!</div>');
		}
		redirect('Master_section/module_group_list');
	}

	public function sms_authorize_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['userRecords'] = $this->master_model->sms_authorize_list();
		$data['pageTitle'] = 'SMS Authorize List';
		$data['Pagename'] = 'SMS Authorize List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/sms_authorize_list",$data);
	}

	public function filter_sms_authorize_list()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		$data['userRecords'] = $this->master_model->filter_sms_authorize_list($clientid,$branch);
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Filter By Client SMS Authorize List';
		$data['Pagename'] = 'Filter By Client SMS Authorize List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/sms_authorize_list",$data);
	}

	public function addSmsAuthorize()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['messagetypelist'] = $this->master_model->message_type_active();
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['messagetypelist'] = $this->master_model->message_type_active();
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Add SMS Authorize';
		$data['Pagename'] = 'Add SMS Authorize';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addSmsAuthorize", $data);
	}

	public function insertSmsAuthorize()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$btitle = $this->input->post('btitle');
		$mobile = $this->input->post('mobile');
		$apikey = $this->input->post('apikey');
		$senderid = $this->input->post('senderid');
		$status = $this->input->post('status');
		$ownernum = $this->input->post('ownernum');
		$service = $this->input->post('service');
		$template_id = $this->input->post('template_id');
		$email = $this->input->post('email');
		$admemail = $this->input->post('admemail');
		$message_type_id = $this->input->post('message_type_id');
		$location = $this->input->post('location');
		
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$response = $this->master_model->checkSmsAuthorizeExist($clientid,$branch,$message_type_id);	
		} 
		else  
		{
			$response = $this->client_master_model->checkSmsAuthorizeExist($clientid,$branch,$message_type_id);	
		}

		if($response)
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>SMS Authorization Already Exist!</div>');
		}
		else
		{
			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");

			$data = array('client_id'=>$clientid, 'branch'=>$branch, 'branch_title' => $btitle, 'mobile_no' => $mobile, 'api_key' => $apikey, 'sender_id' => $senderid, 'owner_num' => $ownernum, 'service' => $service, 'template_id' => $template_id, 'email_id' => $email, 'adminstrative_email' => $admemail, 'message_type_id' => $message_type_id, 'location' => $location, 'status' => $status, 'created'=> $created, 'api_status' => 'processing');

// 			print_r($data);

			$res = $this->db->insert('sms_authorize',$data);
            $last_id = $this->db->insert_id();
            
		    if($res > 0)
			{
			    // SMS authorize test table data
			    $mobile1 = sms_authorize_test_numbers;
			    
			    $data1 = array('client_id'=>$clientid, 'branch'=>$branch, 'branch_title' => $btitle, 'mobile_no' => $mobile1, 'api_key' => $apikey, 'sender_id' => $senderid, 'owner_num' => $ownernum, 'service' => $service, 'template_id' => $template_id, 'email_id' => $email, 'adminstrative_email' => $admemail, 'message_type_id' => $message_type_id, 'location' => $location, 'status' => $status, 'created'=> $created);

			    // print_r($data);

			    $res1 = $this->db->insert('sms_authorize_test',$data1);
			    
			    
		        if($role_id == '5' || $role_id == '11')
				{
					$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}
				else
				{
					$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
					$row = $query->row_array();
					$client_url = $row['client_url'];
				}
				
				$posdata = array('auth_id' => $last_id,'client_id'=>$clientid, 'branch'=>$branch, 'branch_title' => $btitle, 'mobile_no' => $mobile, 'api_key' => $apikey, 'sender_id' => $senderid, 'owner_num' => $ownernum, 'service' => $service, 'template_id' => $template_id, 'email_id' => $email, 'adminstrative_email' => $admemail, 'message_type_id' => $message_type_id, 'location' => $location, 'status' => $status, 'created'=> $created);
				
				$url = $client_url."addSmsAuthorize";

				$jsondata = json_encode($posdata);
				
				$curl = curl_init($url);
		        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
		        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
		        'Content-Type: application/json')
		        );
		        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
		        $result = curl_exec($curl);
		        
		        // print_r($result);
		        
		        $json = json_decode($result, true);
		        curl_close($curl);

		        $api_status = $json['status'];
		        $statuscode = $json['statuscode'];
		        $resp = $json['response'];

				if($statuscode == "200")
				{
					$udata = array(
		        	'api_status' => 'success', 
		        	);
					$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$resp.'</div>');
				}
				else
				{
					$udata = array(
		        	'api_status' => 'failed', 
		        	);
					$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSSA01 Failed to Add Sms Authorization!</div>');	
				}

				if($role_id == '5' || $role_id == '11')
				{
					$this->db->where('auth_id',$last_id);
					$result = $this->db->update('sms_authorize',$udata);
				}
				else
				{
					$this->db2->where('auth_id',$last_id);
					$result = $this->db2->update('sms_authorize',$udata);
				}
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSSA02 Failed to Add SMS Authorize!</div>');
			}
		}
		redirect('Master_section/sms_authorize_list');
	}

	public function editSmsAuthorize($auth_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['messagetypelist'] = $this->master_model->message_type_active();
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['messagetypelist'] = $this->master_model->message_type_active();
		}
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['userInfo'] = $this->master_model->getSmsauthorizeDetails($auth_id);
		$data['pageTitle'] = 'SMS Authorize Edit';
		$data['Pagename'] = 'SMS Authorize Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/editSmsAuthorize", $data);
	}

	public function editSmsAuthorizeDetails()
	{
		$authid = $this->input->post('auth_id');
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$btitle = $this->input->post('btitle');
		$mobile = $this->input->post('mobile');
		$apikey = $this->input->post('apikey');
		$senderid = $this->input->post('senderid');
		$status = $this->input->post('status');
		$ownernum = $this->input->post('ownernum');
		$service = $this->input->post('service');
		$template_id = $this->input->post('template_id');
		$email = $this->input->post('email');
		$admemail = $this->input->post('admemail');
		$message_type_id = $this->input->post('message_type_id');
		$location = $this->input->post('location');

		$old_client_id = $this->input->post('old_client_id');
		$old_branch = $this->input->post('old_branch');
		$old_message_type_id = $this->input->post('old_message_type_id');
		$branchresp = false;
		
		if(strcasecmp($branch, $old_branch) == 0)
		{
			$branchresp = true;
		}
		
		date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");

		if(($clientid == $old_client_id) && ($branchresp == true) && ($message_type_id == $old_message_type_id))
		{
			// echo "No Check ";
			// echo $clientid." -: ".$old_client_id;
			// echo $branch." -: ".$old_branch;
			$data = array('client_id'=>$clientid, 'branch'=>$branch, 'branch_title' => $btitle, 'mobile_no' => $mobile, 'api_key' => $apikey, 'sender_id' => $senderid, 'owner_num' => $ownernum, 'service' => $service, 'template_id' => $template_id, 'email_id' => $email, 'adminstrative_email' => $admemail, 'message_type_id' => $message_type_id, 'location' => $location, 'status' => $status, 'updated'=> $updated,'api_status'=>'processing');

			$this->db->where('auth_id',$authid);
			$result = $this->db->update('sms_authorize',$data);
		}
		else
		{
			// echo "Check ";
			// echo $clientid." -: ".$old_client_id;
			// echo $branch." -: ".$old_branch;
			
			$role_id = $this->session->userdata('role');
    		if($role_id == '5' || $role_id == '11') 
    		{ 
    			$response = $this->master_model->checkSmsAuthorizeExist($clientid,$branch,$message_type_id);	
    		} 
    		else  
    		{
    			$response = $this->client_master_model->checkSmsAuthorizeExist($clientid,$branch,$message_type_id);	
    		}
			
			
			if($response)
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>SMS Authorize Already Exist! Can\'t update!</div>');
				redirect('Master_section/sms_authorize_list');
			}
			else
			{
				$data = array('client_id'=>$clientid, 'branch'=>$branch, 'branch_title' => $btitle, 'mobile_no' => $mobile, 'api_key' => $apikey, 'sender_id' => $senderid, 'owner_num' => $ownernum, 'service' => $service, 'template_id' => $template_id, 'email_id' => $email, 'adminstrative_email' => $admemail, 'message_type_id' => $message_type_id, 'status' => $status, 'location' => $location, 'updated'=> $updated, 'api_status'=>'processing');

				$this->db->where('auth_id',$authid);
				$result = $this->db->update('sms_authorize',$data);
			}
		}

	    if($result == true)
		{
		    // SMS authorize test table data
		    $mobile1 = sms_authorize_test_numbers;
		    
		    $data1 = array('client_id'=>$clientid, 'branch'=>$branch, 'branch_title' => $btitle, 'mobile_no' => $mobile1, 'api_key' => $apikey, 'sender_id' => $senderid, 'owner_num' => $ownernum, 'service' => $service, 'template_id' => $template_id, 'email_id' => $email, 'adminstrative_email' => $admemail, 'message_type_id' => $message_type_id, 'location' => $location, 'status' => $status, 'updated'=> $updated);

			$this->db->where('auth_id',$authid);
			$result = $this->db->update('sms_authorize_test',$data1);
			
			if($role_id == '5' || $role_id == '11')
			{
				$query=$this->db->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			else
			{
				$query=$this->db2->query("SELECT a.* from client_creation a where a.client_id = ".$clientid);
				$row = $query->row_array();
				$client_url = $row['client_url'];
			}
			
			$posdata = array('auth_id' => $authid,'client_id'=>$clientid, 'branch'=>$branch, 'branch_title' => $btitle, 'mobile_no' => $mobile, 'api_key' => $apikey, 'sender_id' => $senderid, 'owner_num' => $ownernum, 'service' => $service, 'template_id' => $template_id, 'email_id' => $email, 'adminstrative_email' => $admemail, 'message_type_id' => $message_type_id, 'location' => $location, 'status' => $status, 'updated'=> $updated, 'old_client_id' => $old_client_id, 'old_branch' => $old_branch, 'old_message_type_id' => $old_message_type_id);
			
			$url = $client_url."updateSmsAuthorize";

			$jsondata = json_encode($posdata);
			
			$curl = curl_init($url);
	        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
	        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
	        'Content-Type: application/json')
	        );
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
	        $result = curl_exec($curl);
	        
	        // print_r($result);
	        
	        $json = json_decode($result, true);
	        curl_close($curl);

	        $api_status = $json['status'];
	        $statuscode = $json['statuscode'];
	        $resp = $json['response'];

			if($statuscode == "200")
			{
				$udata = array(
	        	'api_status' => 'success', 
	        	);
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>'.$resp.'</div>');
			}
			else
			{
				$udata = array(
	        	'api_status' => 'failed', 
	        	);
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSSAU01 Failed to Update Sms Authorization!</div>');	
			}

			if($role_id == '5' || $role_id == '11')
			{
				$this->db->where('auth_id',$authid);
				$result = $this->db->update('sms_authorize',$udata);
			}
			else
			{
				$this->db2->where('auth_id',$authid);
				$result = $this->db2->update('sms_authorize',$udata);
			}
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>ERR-MSSAU01 Failed to Update SMS Authorize!</div>');
		}
		redirect('Master_section/sms_authorize_list');
	}

	public function deleteSmsAuthorize($auth_id,$title)
	{
		$this->data['deletedata'] = $this->master_model->deleteSmsAuthorize($auth_id);
		if($this->data['deletedata'] == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> '.$title.' Deleted</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> No Data Found!!!</div>');
		}	
		redirect('Master_section/sms_authorize_list');
	}

	public function store_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['userRecords'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Store List';
		$data['Pagename'] = 'Store List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/store_list",$data);
	}

	public function filter_store_list()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		$data['userRecords'] = $this->master_model->filter_store_list($clientid,$branch);
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Filter By Client Store List';
		$data['Pagename'] = 'Filter By Client Store List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/store_list",$data);
	}

	public function addStore()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['pageTitle'] = 'Add Store';
		$data['Pagename'] = 'Add Store';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addStore", $data);
	}

	public function insertStore()
	{
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$sname = $this->input->post('sname');
		$sid = $this->input->post('sid');
		$address = $this->input->post('address');
		$city = $this->input->post('city');
		$phone = $this->input->post('phone');
		$ordval = $this->input->post('ordval');
		$picktime = $this->input->post('picktime');
		$deltime = $this->input->post('deltime');
		$latval = $this->input->post('latval');
		$longval = $this->input->post('longval');
		$hidefrom = $this->input->post('hidefrom');
		$active = $this->input->post('active');
		$ordering = $this->input->post('ordering');


		if($this->master_model->checkStoreExist($clientid,$branch))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Already Exist!</div>');
		}
		else
		{
			// date_default_timezone_set("Asia/Kolkata");
			// $created = date("Y-m-d H:i:s");

			$data = array('store_ref_id' => $sid, 'city' => $city, 'name' => $sname, 'min_pickup_time' => $picktime, 'min_delivery_time' => $deltime, 'contact_phone' => $phone, 'min_order_value' => $ordval, 'hide_from_ui'=> $hidefrom, 'address' => $address, 'geo_longitude' => $longval, 'active' => $active, 'geo_latitude' => $latval, 'ordering_enabled' => $ordering, 'branch' => $branch, 'client_id' => $clientid, 'process_status' => 'pending');

			$res = $this->db->insert('store',$data);

		    if($res > 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Added</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Store!</div>');
			}
		}
		redirect('Master_section/store_list');
	}

	public function editStore($store_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);

		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
		}

		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		$data['userInfo'] = $this->master_model->getStoreDetails($store_id);
		$data['pageTitle'] = 'Store Edit';
		$data['Pagename'] = 'Store Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/editStore", $data);
	}

	public function editStoreDetails()
	{
		$storeid = $this->input->post('store_id');
		$clientid = $this->input->post('clientid');
		$branch = $this->input->post('branch');
		$sname = $this->input->post('sname');
		$sid = $this->input->post('sid');
		$address = $this->input->post('address');
		$city = $this->input->post('city');
		$phone = $this->input->post('phone');
		$ordval = $this->input->post('ordval');
		$picktime = $this->input->post('picktime');
		$deltime = $this->input->post('deltime');
		$latval = $this->input->post('latval');
		$longval = $this->input->post('longval');
		$hidefrom = $this->input->post('hidefrom');
		$active = $this->input->post('active');
		$ordering = $this->input->post('ordering');

		$old_client_id = $this->input->post('old_client_id');
		$old_branch = $this->input->post('old_branch');
		$branchresp = false;
		
		if(strcasecmp($branch, $old_branch) == 0)
		{
			$branchresp = true;
		}
		
		// date_default_timezone_set("Asia/Kolkata");
		// $updated = date("Y-m-d H:i:s");

		$data = array('store_ref_id' => $sid, 'city' => $city, 'name' => $sname, 'min_pickup_time' => $picktime, 'min_delivery_time' => $deltime, 'contact_phone' => $phone, 'min_order_value' => $ordval, 'hide_from_ui'=> $hidefrom, 'address' => $address, 'geo_longitude' => $longval, 'active' => $active, 'geo_latitude' => $latval, 'ordering_enabled' => $ordering, 'branch' => $branch, 'client_id' => $clientid);

		if(($clientid == $old_client_id) && ($branchresp == true))
		{
			$this->db->where('store_id',$storeid);
			$result = $this->db->update('store',$data);
		}
		else
		{
			if($this->master_model->checkStoreExist($clientid,$branch))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Already Exist! Can\'t update!</div>');
				redirect('Master_section/store_list');
			}
			else
			{
				$this->db->where('store_id',$storeid);
				$result = $this->db->update('store',$data);
			}
		}

	    if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store is Updated</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Update Store!</div>');
		}
		redirect('Master_section/store_list');
	}

	// public function deleteStore($store_id,$title)
	// {
	// 	$this->data['deletedata'] = $this->master_model->deleteStore($store_id);
	// 	if($this->data['deletedata'] == true)
	// 	{
	// 		$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> '.$title.' Deleted</div>');
	// 	}
	// 	else
	// 	{
	// 		$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> No Data Found!!!</div>');
	// 	}	
	// 	redirect('Master_section/store_list');
	// }

	public function platform_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->platform_list();
		$data['pageTitle'] = 'Platform List';
		$data['Pagename'] = 'Platform List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/platform_list",$data);
	}

	// public function filter_platform_list()
	// {
	// 	$clientid = $this->input->post('clientid');
	// 	$branch = $this->input->post('branch');
	// 	$data['library_js']= $library_script = unserialize (Library_script_files);
	// 	$data['library_css']= $library_style = unserialize (Library_style_files);
	// 	$data['userRecords'] = $this->master_model->filter_platform_list($clientid,$branch);
	// 	$data['clientlist'] = $this->master_model->client_list_active();
	// 	$data['branchlist'] = $this->master_model->branch_list_active();
	// 	$data['pageTitle'] = 'Filter By Client Platform List';
	// 	$data['Pagename'] = 'Filter By Client Platform List';
	// 	$data['HomePage'] = 'Home';
	// 	$this->load->view("master/platform_list",$data);
	// }

	public function addPlatform()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['pageTitle'] = 'Add Platform';
		$data['Pagename'] = 'Add Platform';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addPlatform", $data);
	}

	public function insertPlatform()
	{
		$platform = $this->input->post('platform');

		if($this->master_model->checkPlatformExist($platform))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Platform Already Exist!</div>');
		}
		else
		{
			date_default_timezone_set("Asia/Kolkata");
			$created = date("Y-m-d H:i:s");

			$data = array('platform_name' => $platform, 'created' => $created);

			$res = $this->db->insert('platform',$data);

		    if($res > 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Platform Added</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Platform!</div>');
			}
		}
		redirect('Master_section/platform_list');
	}

	public function editPlatform($platform_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getPlatformDetails($platform_id);
		$data['pageTitle'] = 'Platform Edit';
		$data['Pagename'] = 'Platform Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/editPlatform", $data);
	}

	public function editPlatformDetails()
	{
		$platformid = $this->input->post('platformid');
		$platform = $this->input->post('platform');

		$old_platform = $this->input->post('old_platform');
		
		date_default_timezone_set("Asia/Kolkata");
		$updated = date("Y-m-d H:i:s");

		$data = array('platform_name' => $platform, 'updated' => $updated);

		if(strcasecmp($platform, $old_platform) == 0)
		{
			$this->db->where('platform_id',$platformid);
			$result = $this->db->update('platform',$data);
		}
		else
		{
			if($this->master_model->checkPlatformExist($platform))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Platform Already Exist! Can\'t update!</div>');
				redirect('Master_section/platform_list');
			}
			else
			{
				$this->db->where('platform_id',$platformid);
				$result = $this->db->update('platform',$data);
			}
		}

	    if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Platform is Updated</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Update Platform!</div>');
		}
		redirect('Master_section/platform_list');
	}

	public function store_action_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->store_action_list();
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Store Actions List';
		$data['Pagename'] = 'Store Actions List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/store_action_list",$data);
	}

	public function filter_store_action_list()
	{
		$storeid = $this->input->post('storeid');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->filter_store_action_list($storeid);
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Filter By Store Actions List';
		$data['Pagename'] = 'Filter By Store Actions List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/store_action_list",$data);
	}

	public function addStoreAction()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['storelist'] = $this->master_model->store_list();
		$data['platformlist'] = $this->master_model->platform_list();
		$data['pageTitle'] = 'Add Store Actions';
		$data['Pagename'] = 'Add Store Actions';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addStoreAction", $data);
	}

	public function insertStoreAction()
	{
		$storeid = $this->input->post('storeid');
		$platform = $this->input->post('platform');
		$platformurl = $this->input->post('platformurl');
		$platformstoreid = $this->input->post('platformstoreid');
		$locationrefid = $this->input->post('locationrefid');
		$action = $this->input->post('action');
		$status = $this->input->post('status');

		if($this->master_model->checkStoreActionExist($storeid,$platform))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Action Already Exist!</div>');
		}
		else
		{
			// date_default_timezone_set("Asia/Kolkata");
			// $created = date("Y-m-d H:i:s");

			$data = array('action' => $action, 'location_ref_id' => $locationrefid, 'platform' => $platform, 'platform_url' => $platformurl, 'platform_store_id' => $platformstoreid, 'status' => $status, 'store_id' => $storeid,'str_action_status' => 'pending');

			// print_r($data);

			$res = $this->db->insert('store_actions',$data);

		    if($res > 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Action Added</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Store Action!</div>');
			}
		}
		redirect('Master_section/store_action_list');
	}

	public function editStoreAction($storeaction_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getStoreActionDetails($storeaction_id);
		$data['storelist'] = $this->master_model->store_list();
		$data['platformlist'] = $this->master_model->platform_list();
		$data['pageTitle'] = 'Store Action Edit';
		$data['Pagename'] = 'Store Action Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/editStoreAction", $data);
	}

	public function editStoreActionDetails()
	{
		$storeaction_id = $this->input->post('storeaction_id'); 
		$storeid = $this->input->post('storeid');
		$platform = $this->input->post('platform');
		$platformurl = $this->input->post('platformurl');
		$platformstoreid = $this->input->post('platformstoreid');
		$locationrefid = $this->input->post('locationrefid');
		$action = $this->input->post('action');
		$status = $this->input->post('status');

		$old_store_id = $this->input->post('old_store_id');
		$old_platform = $this->input->post('old_platform');
		$platformresp = false;
		
		if(strcasecmp($platform, $old_platform) == 0)
		{
			$platformresp = true;
		}
		
		// date_default_timezone_set("Asia/Kolkata");
		// $updated = date("Y-m-d H:i:s");

		$data = array('action' => $action, 'location_ref_id' => $locationrefid, 'platform' => $platform, 'platform_url' => $platformurl, 'platform_store_id' => $platformstoreid, 'status' => $status, 'store_id' => $storeid);

		if(($storeid == $old_store_id) && ($platformresp == true))
		{
			$this->db->where('storeaction_id',$storeaction_id);
			$result = $this->db->update('store_actions',$data);
		}
		else
		{
			if($this->master_model->checkStoreActionExist($storeid,$platform))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Action Already Exist! Can\'t update!</div>');
				redirect('Master_section/store_action_list');
			}
			else
			{
				$this->db->where('storeaction_id',$storeaction_id);
				$result = $this->db->update('store_actions',$data);
			}
		}

	    if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Action is Updated</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Update Store Action!</div>');
		}
		redirect('Master_section/store_action_list');
	}

	public function notification_email_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->notification_email_list();
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Notification Email List';
		$data['Pagename'] = 'Notification Email List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/notification_email_list",$data);
	}

	public function filter_notification_email_list()
	{
		$storeid = $this->input->post('storeid');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->filter_notification_email_list($storeid);
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Filter By Store Notification Email List';
		$data['Pagename'] = 'Filter By Store Notification Email List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/notification_email_list",$data);
	}

	public function addNotificationEmail()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Add Store Notification Email';
		$data['Pagename'] = 'Add Store Notification Email';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addNotificationEmail", $data);
	}

	public function insertNotificationEmail()
	{
		$storeid = $this->input->post('storeid');
		$email = $this->input->post('email');
		$status = $this->input->post('status');

		// date_default_timezone_set("Asia/Kolkata");
		// $created = date("Y-m-d H:i:s");

		if($this->master_model->checkNotificationEmailExist($storeid,$email))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Action Already Exist!</div>');
		}
		else
		{
			$data = array('store_id' => $storeid, 'email' => $email, 'status' => $status);

			// print_r($data);

			$res = $this->db->insert('notification_emails',$data);

		    if($res > 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Notification Email Added</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Store Notification Email!</div>');
			}
		}
		redirect('Master_section/notification_email_list');
	}

	public function editNotificationEmail($email_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getNotificationEmailDetails($email_id);
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Notification Email Edit';
		$data['Pagename'] = 'Notification Email Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/editNotificationEmail", $data);
	}

	public function editNotificationEmailDetails()
	{
		$email_id = $this->input->post('email_id'); 
		$storeid = $this->input->post('storeid');
		$email = $this->input->post('email');
		$status = $this->input->post('status');

		$old_storeid = $this->input->post('old_storeid');
		$old_email = $this->input->post('old_email');

		$data = array('store_id' => $storeid, 'email' => $email, 'status' => $status);

		// print_r($data);		

		if(($storeid == $old_storeid) && (strcasecmp($email, $old_email) == 0))
		{
			$this->db->where('email_id',$email_id);
			$result = $this->db->update('notification_emails',$data);
		}
		else
		{
			if($this->master_model->checkNotificationEmailExist($storeid,$email))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Notification Email Already Exist! Can\'t update!</div>');
				redirect('Master_section/notification_email_list');
			}
			else
			{
				$this->db->where('email_id',$email_id);
				$result = $this->db->update('notification_emails',$data);
			}
		}
		
	    if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Notification Email is Updated</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Update Store Notification Email!</div>');
		}
		redirect('Master_section/notification_email_list');
	}

	public function notification_phone_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->notification_phone_list();
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Notification Phone List';
		$data['Pagename'] = 'Notification Phone List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/notification_phone_list",$data);
	}

	public function filter_notification_phone_list()
	{
		$storeid = $this->input->post('storeid');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->filter_notification_phone_list($storeid);
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Filter By Store Notification Phone List';
		$data['Pagename'] = 'Filter By Store Notification Phone List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/notification_phone_list",$data);
	}

	public function addNotificationPhone()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Add Store Notification Phone';
		$data['Pagename'] = 'Add Store Notification Phone';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addNotificationPhone", $data);
	}

	public function insertNotificationPhone()
	{
		$storeid = $this->input->post('storeid');
		$phone = $this->input->post('phone');
		$status = $this->input->post('status');

		// date_default_timezone_set("Asia/Kolkata");
		// $created = date("Y-m-d H:i:s");

		if($this->master_model->checkNotificationPhoneExist($storeid,$phone))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Notification Phone Already Exist!</div>');
			redirect('Master_section/notification_phone_list');
		}
		else
		{
			$data = array('store_id' => $storeid, 'phone_no' => $phone, 'status' => $status);

			// print_r($data);

			$res = $this->db->insert('notification_phones',$data);

		    if($res > 0)
			{
				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Notification Phone Added</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Store Notification Phone!</div>');
			}
		}
		redirect('Master_section/notification_phone_list');
	}

	public function editNotificationPhone($phone_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getNotificationPhoneDetails($phone_id);
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Notification Phone Edit';
		$data['Pagename'] = 'Notification Phone Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/editNotificationPhone", $data);
	}

	public function editNotificationPhoneDetails()
	{
		$phone_id = $this->input->post('phone_id'); 
		$storeid = $this->input->post('storeid');
		$phone = $this->input->post('phone');
		$status = $this->input->post('status');

		$old_storeid = $this->input->post('old_storeid');
		$old_phone = $this->input->post('old_phone');

		$data = array('store_id' => $storeid, 'phone_no' => $phone, 'status' => $status);

		// print_r($data);		

		if(($storeid == $old_storeid) && (strcasecmp($phone, $old_phone) == 0))
		{
			$this->db->where('phone_id',$phone_id);
			$result = $this->db->update('notification_phones',$data);
		}
		else
		{
			if($this->master_model->checkNotificationPhoneExist($storeid,$phone))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Notification Email Already Exist! Can\'t update!</div>');
				redirect('Master_section/notification_phone_list');
			}
			else
			{
				$this->db->where('phone_id',$phone_id);
				$result = $this->db->update('notification_phones',$data);
			}
		}
		
	    if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Notification Phone is Updated</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Update Store Phone Email!</div>');
		}
		redirect('Master_section/notification_phone_list');
	}

	public function zipcode_list()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->zipcode_list();
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Store Zip Code List';
		$data['Pagename'] = 'Store Zip Code List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/zipcode_list",$data);
	}

	public function filter_zipcode_list()
	{
		$storeid = $this->input->post('storeid');
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userRecords'] = $this->master_model->filter_zipcode_list($storeid);
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Filter By Store Store Zip Code List';
		$data['Pagename'] = 'Filter By Store Store Zip Code List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/zipcode_list",$data);
	}

	public function addZipcode()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$clientname = $this->session->userdata('client_id');
		// $roll_id = $this->session->userdata('role');
		// if($role_id =='5') { 
		// 	    $data['storelist'] = $this->master_model->store_list();
		// 	} else  { 
		// 	    $data['storelist'] = $this->master_model->store_list($clientname);
		// 	}
		
		$data['pageTitle'] = 'Add Store Zip Code';
		$data['Pagename'] = 'Add Store Zip Code';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addZipcode", $data);
	}

	public function insertZipcode()
	{
		$storeid = $this->input->post('storeid');
		$zipcode = $this->input->post('zipcode');
		$status = $this->input->post('status');

		// date_default_timezone_set("Asia/Kolkata");
		// $created = date("Y-m-d H:i:s");

		if($this->master_model->checkZipcodeExist($storeid,$zipcode))
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Zipcode Already Exist!</div>');
			redirect('Master_section/zipcode_list');
		}
		else
		{
			$data = array('store_id' => $storeid, 'zip_code' => $zipcode, 'status' => $status, 'api_status' => 'processing');

			// print_r($data);

			$res = $this->db->insert('zipcode',$data);
			$zip_id = $this->db->insert_id();

		    if($res > 0)
			{
				$query=$this->db->query("SELECT a.* from client_creation a, store b where a.client_id = b.client_id and b.store_id = 1");
				$row = $query->row_array();
				$client_url = $row['client_url'];

				$url = $client_url."insertZipcode";

				$jsondata = json_encode($data);
				
				$curl = curl_init($url);
		        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
		        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
		        'Content-Type: application/json')
		        );
		        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
		        $result = curl_exec($curl);
		        
		        // print_r($result);
		        
		        $json = json_decode($result, true);
		        curl_close($curl);

		        $api_status = $json['status'];
		        $response = $json['response'];

		        $udata = array(
		        	'api_status' => $api_status, 
		        );

		        $this->db->where('zip_id',$zip_id);
				$result = $this->db->update('zipcode',$udata);

				$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Zip Code Added, '.$response.'</div>');
			}
			else
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Add Store Zip Code!</div>');
			}
		}
		redirect('Master_section/zipcode_list');
	}

	public function editZipcode($zip_id)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->getZipcodeDetails($zip_id);
		$data['storelist'] = $this->master_model->store_list();
		$data['pageTitle'] = 'Store Zip Code Edit';
		$data['Pagename'] = 'Store Zip Code Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/editZipcode", $data);
	}

	public function editZipcodeDetails()
	{
		$zip_id = $this->input->post('zip_id'); 
		$storeid = $this->input->post('storeid');
		$zipcode = $this->input->post('zipcode');
		$status = $this->input->post('status');

		$old_zipcode = $this->input->post('old_zipcode');
		$old_storeid = $this->input->post('old_storeid');

		$data = array('store_id' => $storeid, 'zip_code' => $zipcode, 'status' => $status);

		// print_r($data);

		if(($storeid == $old_storeid) && ($zipcode == $old_zipcode))
		{
			$this->db->where('zip_id',$zip_id);
			$result = $this->db->update('zipcode',$data);
		}
		else
		{
			if($this->master_model->checkZipcodeExist($storeid,$zipcode))
			{
				$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Store Zipcode Already Exist! Can\'t update!</div>');
				redirect('Master_section/zipcode_list');
			}
			else
			{
				$this->db->where('zip_id',$zip_id);
				$result = $this->db->update('zipcode',$data);
			}
		}		
		
	    if($result == true)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Zip Code is Updated</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>Failed to Update Store Zip Code!</div>');
		}
		redirect('Master_section/zipcode_list');
	}
	
	
	public function addClientConfig()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
		} 
		$data['pageTitle'] = 'Client Configuration';
		$data['Pagename'] = 'Client Configuration';
		$data['HomePage'] = 'Home';
		$this->load->view("master/addClientConfig", $data);
	}
	
	public function pushConfigData()
	{
		$client_id = $this->input->post('clientid');
		
		$query=$this->db->query("SELECT * from client_creation where client_id = $client_id");
		$row = $query->row_array();
		$client_url = $row['client_url'];
		
// 		echo $client_id." - ".$client_url;
		
		//Roles Array
		$query=$this->db->query("SELECT * from roles");
		foreach ($query->result() as $r) 
		{
			$roles[] = array(
			        'roleId' => $r->roleId,
			        'role' => $r->role
			    ); 
		}
		
		//Tax Array
		$query=$this->db->query("SELECT * from tax_creation");
		foreach ($query->result() as $r) 
		{
			$taxes[] = array(
			        'taxId' => $r->taxId,
			        'tax_percentage' => $r->tax_percentage,
			        'status' => $r->status
			    ); 
		}
		
		// Uom Array
		$query=$this->db->query("SELECT * from uom_creation");
		foreach ($query->result() as $r) 
		{
			$uoms[] = array(
			        'uomId' => $r->uomId,
			        'uom_name' => $r->uom_name,
			        'description' => $r->description,
			        'status' => $r->status
			    ); 
		}
		
		// Master Array
		$query=$this->db->query("SELECT * from master");
		foreach ($query->result() as $r) 
		{
			$masters[] = array(
			        'master_id' => $r->master_id,
			        'master_type' => $r->master_type,
			        'master_details' => $r->master_details,
			    ); 
		}
		
		
		// Module Groups Array
		$query=$this->db->query("SELECT * from module_groups");
		foreach ($query->result() as $r) 
		{
			$modulegroups[] = array(
			        'module_group_id' => $r->module_group_id,
			        'module_group_name' => $r->module_group_name,
			        'sort_id' => $r->sort_id,
			        'icon' => $r->icon
			    ); 
		}
		
		// Module Array
		$query=$this->db->query("SELECT * from modules");
		foreach ($query->result() as $r) 
		{
			$modules[] = array(
			        'module_master_id' => $r->module_master_id,
			        'module_name' => $r->module_name,
			        'module_group_id' => $r->module_group_id,
			        'sections' => $r->sections,
			        'link' => $r->link,
			        'icon' => $r->icon
			    ); 
		}
		
		// Permission Array
		$query=$this->db->query("SELECT * from permission");
		foreach ($query->result() as $r) 
		{
			$permissions[] = array(
			        'permission_master_id' => $r->permission_master_id,
			        'permission_name' => $r->permission_name,
			        'icon' => $r->icon
			    ); 
		}


		// Message Type Array
		$query=$this->db->query("SELECT * from message_type");
		foreach ($query->result() as $r) 
		{
			$message_type[] = array(
			        'message_type_id' => $r->message_type_id,
			        'message_type' => $r->message_type,
			        'status' => $r->status
			    ); 
		}
		
		// Settings Array
		$query=$this->db->query("SELECT * from setting");
		foreach ($query->result() as $r) 
		{
			$settings[] = array(
			        'setting_id' => $r->setting_id,
			        'setting_name' => $r->setting_name,
			        'setting_type' => $r->setting_type,
			        'setting_title' => $r->setting_title
			    ); 
 		}
 		
 		
 		// Client Array
 		$query=$this->db->query("SELECT * from client_creation where client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$client[] = array(
			        'client_id' => $r->client_id,
			        'client_name' => $r->client_name,
			        'role' => $r->role,
			        'no_of_branches' => $r->no_of_branches,
			        'branch_prefix' => $r->branch_prefix,
			        'status' => $r->status,
			        'client_url' => $r->client_url,
			    ); 
 		}
 		
 		// Branch Array
 		$query=$this->db->query("SELECT * from branch_creation where client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$branches[] = array(
			        'branch_id' => $r->branch_id,
			        'client_id' => $r->client_id,
			        'branch_name' => $r->branch_name,
			        'branch_title' => $r->branch_title,
			        'branch_slno' => $r->branch_slno,
			        'status' => $r->status,
			    ); 
 		}
 		
 		// Users Array
 		$query=$this->db->query("SELECT * from users where client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$users[] = array(
			        'userId' => $r->userId,
			        'email' => $r->email,
			        'password' => $r->password,
			        'name' => $r->name,
			        'mobile' => $r->mobile,
			        'roleId' => $r->roleId,
			        'isDeleted' => $r->isDeleted,
			        'createdBy' => $r->createdBy,
			        'createdDtm' => $r->createdDtm,
			        'updatedBy' => $r->updatedBy,
			        'updatedDtm' => $r->updatedDtm,
			        'branch' => $r->branch,
			        'branch_id' => $r->branch_id,
			        'santhe_branch' => $r->santhe_branch,
			        'prime_id' => $r->prime_id,
			        'effective_from' => $r->effective_from,
			        'data_transfer' => $r->data_transfer,
			        'status' => $r->status,
			        'client_id' => $r->client_id,
			    ); 
 		}
 		
 		// Module Creation Array
 		$query=$this->db->query("SELECT * from module_creation WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$modulecreation[] = array(
			        'module_id' => $r->module_id,
			        'module_master_id' => $r->module_master_id,
			        'role_id' => $r->role_id,
			        'status' => $r->status,
			        'branch' => $r->branch,
			        'client_id' => $r->client_id,
			    ); 
 		}
 		
 		// Permission Creation Array
 		$query=$this->db->query("SELECT * from permission_creation WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$permissioncreation[] = array(
			        'permission_id' => $r->permission_id,
			        'permission_master_id' => $r->permission_master_id,
			        'module_creation_id' => $r->module_creation_id,
			        'role_id' => $r->role_id,
			        'status' => $r->status,
			        'branch' => $r->branch,
			        'client_id' => $r->client_id,
			    ); 
 		}
 		
 		// Master Creation Array
 		$query=$this->db->query("SELECT * from masters_creation WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$masterscreation[] = array(
			        'masterId' => $r->masterId,
			        'masters_status' => $r->masters_status,
			        'master_details' => $r->master_details,
			        'effective_from' => $r->effective_from,
			        'data_transfer' => $r->data_transfer,
			        'status' => $r->status,
			        'branch' => $r->branch,
			        'client_id' => $r->client_id,
			        'master_id' => $r->master_id
			    ); 
 		}
 		
 		// Category Master Array
 		$query=$this->db->query("SELECT * from category_master WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$categorymaster[] = array(
			        'category_master_id' => $r->category_master_id,
			        'category_name' => $r->category_name,
			        'client_id' => $r->client_id
			    ); 
 		}
 		
 		// Product Category Array
 		$query=$this->db->query("SELECT * from product_category WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$productcategory[] = array(
			        'pr_cat_id' => $r->pr_cat_id,
			        'pr_cat_name' => $r->pr_cat_name,
			        'discount' => $r->discount,
			        'cr_discount' => $r->cr_discount,
			        'status' => $r->status,
			        'effective_from' => $r->effective_from,
			        'data_transfer' => $r->data_transfer,
			        'branch' => $r->branch,
			        'pr_cat_code' => $r->pr_cat_code,
			        'combination' => $r->combination,
			        'combo_qty_limit' => $r->combo_qty_limit,
			        'client_id' => $r->client_id,
			    ); 
 		}
 		
 		// Products Array
 		$query=$this->db->query("SELECT * from product WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$products[] = array(
			        'pr_id' => $r->pr_id,
			        'product_name' => $r->product_name,
			        'hsn_code' => $r->hsn_code,
			        'product_no' => $r->product_no,
			        'product_code' => $r->product_code,
			        'sorting_order' => $r->sorting_order,
			        'uom' => $r->uom,
			        'basic_rate' => $r->basic_rate,
			        'basic_tax_percent' => $r->basic_tax_percent,
			        'basic_tax_amount' => $r->basic_tax_amount,
			        'sgst_tax' => $r->sgst_tax,
			        'sgst_tax_amount' => $r->sgst_tax_amount,
			        'cgst_tax' => $r->cgst_tax,
			        'cgst_tax_amount' => $r->cgst_tax_amount,
			        'price' => $r->price,
			        'discount_perc' => $r->discount_perc,
			        'product_stock' => $r->product_stock,
			        'product_status' => $r->product_status,
			        'pr_cat_id' => $r->pr_cat_id,
			        'effective_from' => $r->effective_from,
			        'branch' => $r->branch,
			        'data_transfer' => $r->data_transfer,
			        'token' => $r->token,
			        'tokengroup' => $r->tokengroup,
			        'social_order' => $r->social_order,
			        'sales_item_type' => $r->sales_item_type,
			        'combination' => $r->combination,
			        'product_type' => $r->product_type,
			        'qty_sales_type' => $r->qty_sales_type,
			        'stock_status' => $r->stock_status,
			        'stock_limit' => $r->stock_limit,
			        'client_id' => $r->client_id,
			        'cat_id' => $r->cat_id,
			        'product_image_path' => $r->product_image_path,
                    'newyear_sale' => $r->newyear_sale,
			    ); 
 		}
 		
 		// Application Settings Array
 		$query=$this->db->query("SELECT * from application_setting WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$applicationsetting[] = array(
			        'app_setting_id' => $r->app_setting_id,
			        'setting_name' => $r->setting_name,
			        'setting_access' => $r->setting_access,
			        'setting_type' => $r->setting_type,
			        'setting_title' => $r->setting_title,
			        'status' => $r->status,
			        'effective_from' => $r->effective_from,
			        'data_transfer' => $r->data_transfer,
			        'branch' => $r->branch,
			        'client_id' => $r->client_id,
			        'setting_id' => $r->setting_id
			    ); 
 		}
 		
 		// Credit Customers Array
 		$query=$this->db->query("SELECT * from credit_customer WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$creditcustomer[] = array(
			        'cust_id' => $r->cust_id,
			        'cust_name' => $r->cust_name,
			        'phone_number' => $r->phone_number,
			        'gst_no' => $r->gst_no,
			        'cust_address' => $r->cust_address,
			        'status' => $r->status,
			        'effective_from' => $r->effective_from,
			        'branch' => $r->branch,
			        'data_transfer' => $r->data_transfer,
			        'client_id' => $r->client_id,
			    ); 
 		}
 		
 		// Outlet Details Array
 		$query=$this->db->query("SELECT * from outlet_deatils WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$outletdeatils[] = array(
			        'outId' => $r->outId,
			        'branch_title' => $r->branch_title,
			        'branch_slno' => $r->branch_slno,
			        'invoice_prefix' => $r->invoice_prefix,
			        'org_name' => $r->org_name,
			        'land_no' => $r->land_no,
			        'mobile' => $r->mobile,
			        'email_id' => $r->email_id,
			        'gstin_no' => $r->gstin_no,
			        'address1' => $r->address1,
			        'address2' => $r->address2,
			        'website_name' => $r->website_name,
			        'branch' => $r->branch,
			        'userId' => $r->userId,
			        'status' => $r->status,
			        'effective_from' => $r->effective_from,
			        'data_transfer' => $r->data_transfer,
			        'client_id' => $r->client_id,
			        'cin_no' => $r->cin_no
			    ); 
 		}

 		// SMS Authorize Array
 		$query=$this->db->query("SELECT * from sms_authorize WHERE client_id = $client_id");
		foreach ($query->result() as $r) 
		{
			$smsauthorize[] = array(
			        'auth_id' => $r->auth_id,
			        'api_key' => $r->api_key,
			        'sender_id' => $r->sender_id,
			        'mobile_no' => $r->mobile_no,
			        'branch' => $r->branch,
			        'branch_title' => $r->branch_title,
			        'location' => $r->location,
			        'status' => $r->status,
			        'owner_num' => $r->owner_num,
			        'service' => $r->service,
			        'email_id' => $r->email_id,
			        'adminstrative_email' => $r->adminstrative_email,
			        'template_id' => $r->template_id,
			        'message_type_id' => $r->message_type_id,
			        'client_id' => $r->client_id
			    ); 
 		}
		
	    $dataimport = array(
	    'Roles' => $roles,
	    'Taxes' => $taxes,
	    'Uoms' => $uoms,
	    'Masters' => $masters,
	    'ModuleGroups' => $modulegroups,
	    'Modules' => $modules,
	    'Permissions'=> $permissions,
	    'MessageType'=> $message_type,
	    'Settings' => $settings,
	    'Client' => $client,
	    'Branches' => $branches,
	    'Users' => $users,
	    'ModuleCreation' => $modulecreation,
	    'PermissionCreation' => $permissioncreation,
	    'MastersCreation' => $masterscreation,
	    'CategoryMaster' => $categorymaster,
	    'ProductCategory' => $productcategory,
	    'Products' => $products,
	    'ApplicationSetting' => $applicationsetting,
	    'CreditCustomer' => $creditcustomer,
	    'OutletDeatils' => $outletdeatils,
	    'SmsAuthorize'=> $smsauthorize,
	    );
	    
		$jsondata = json_encode($dataimport);
// 		print_r($jsondata);
        
        $url = $client_url."insertConfigData";
		
		$curl = curl_init($url);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json')
        );
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $jsondata);
        $result = curl_exec($curl);
        
        // print_r($result);
        
        $json = json_decode($result, true);
        curl_close($curl);

      $Roles = $json['Roles'];
      $Tax = $json['Tax'];
      $Uom = $json['Uom'];
      $Masters = $json['Masters'];
      $ModuleGroups = $json['ModuleGroups'];
      $Modules = $json['Modules'];
      $Permissions = $json['Permissions'];
      $MessageType = $json['MessageType'];
      $Settings = $json['Settings'];
      $Client = $json['Client'];
      $Branches = $json['Branches'];
      $Users = $json['Users'];
      $ModuleCreation = $json['ModuleCreation'];
      $PermissionCreation = $json['PermissionCreation'];
      $MastersCreation = $json['MastersCreation'];
      $CategoryMaster = $json['CategoryMaster'];
      $ProductCategory = $json['ProductCategory'];
      $Products = $json['Products'];
      $ApplicationSetting = $json['ApplicationSetting'];
      $CreditCustomer = $json['CreditCustomer'];
      $OutletDeatils = $json['OutletDeatils'];
      $SmsAuthorize = $json['SmsAuthorize'];
       
      $resp = "<h4>Config Response</h4> <br/> Roles : $Roles <br/> Tax : $Tax <br/> Uom : $Uom <br/> Masters : $Masters <br/> ModuleGroups : $ModuleGroups <br/> Modules : $Modules <br/> Permissions : $Permissions <br/> Settings : $Settings <br/> Client : $Client </br>  Branches : $Branches <br/> Users : $Users <br/> ModuleCreation : $ModuleCreation <br/> PermissionCreation : $PermissionCreation <br> MastersCreation : $MastersCreation <br/> CategoryMaster : $CategoryMaster <br/> ProductCategory : $ProductCategory <br/> Products : $Products <br/> ApplicationSetting : $ApplicationSetting <br/> CreditCustomer : $CreditCustomer <br/> OutletDetails : $OutletDeatils <br/> MessageType: $MessageType <br/> SmsAuthorize : $SmsAuthorize";
    
		$this->session->set_flashdata('message','<div class="alert alert-primary alert-dismissable">'.$resp.'</div>');
		redirect('Master_section/addClientConfig');
			
	}
	
// 	public function CRONAPICALL()
// 	{
// 	   // echo "API Called";
// 	    $select = $this->db->query("select * from client_creation where client_id != 1");
// 	    if($select->num_rows() > 0)
// 	    {
// 	        foreach($select->result() as $r)
// 	        {
// 	            $client_url = $r->client_url;
// 	            $client_name = $r->client_name;
	            
// 	            if(!empty($client_url))
// 	            {
// 	                $client_url2 = substr($client_url, 0, strpos($client_url, "Client_Master_section"));
// 	                $api_url = $client_url2.'Client_Api_section/pushMasterGenericData';
// 	               // echo $client_name." - ".$api_url;
		
//             		$curl = curl_init($api_url);
//                     curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "GET");
//                     curl_setopt($curl, CURLOPT_HTTPHEADER, array(
//                     'Content-Type: application/json')
//                     );
//                     curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//                     $result = curl_exec($curl);
                    
//                     $json = json_decode($result, true);
//                     curl_close($curl);
                    
//                     $resp = array(
//                         'Client' => $client_name,
//                         'Client URL' => $client_url
//                     );
// 	            }
// 	        }
	        
// 	        $this->session->set_flashdata('message1','<div class="alert alert-success alert-dismissable">Generic Master API Called</div>');
// 		    redirect('Master_section/addClientConfig');
// 	    }
// 	    else
// 	    {
// 	        $this->session->set_flashdata('message1','<div class="alert alert-danger alert-dismissable">No Clients Found!!!</div>');
// 		    redirect('Master_section/addClientConfig');
// 	    }
// 	}

    public function assign_items($pr_id,$branch_title)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$data['userInfo'] = $this->master_model->get_special_customer($branch_title);
		$data['taxes'] = $this->master_model->tax_list_active();
		$data['productInfo'] = $this->master_model->get_product_details($pr_id,$branch_title);
		$data['pageTitle'] = 'Assign Item';
		$data['Pagename'] = 'Assign Items';
		$data['HomePage'] = 'Home';
		$this->load->view("master/item_assign", $data);
	}
	
	public function get_summary_details($current_date)
	{
	    $bills = array();
	    $query=$this->db->query("SELECT branch_slno,branch_synch as branch FROM outlet_deatils WHERE status='Active'");
		$total_branch = $query->result_array();
		foreach ($total_branch as $brans) 
		{
			$branch_code = $brans['branch_slno'];
			$branches = $brans['branch'];
			
			$table1 = 'product_billdetail'.$branch_code;
			$table2 = 'billed_product'.$branch_code;
			$table3 = 'payments_details'.$branch_code;
			
			$query1=$this->db->query("SELECT bill_id, in_no,invoice_no,invoice_date,invoice_time,synch_date,synch_time,branch FROM $table1 order BY bill_id desc limit 1");
            $rowcount1 = $query1->num_rows();
            if($rowcount1 > 0)
            {
                foreach ($query1->result() as $row) 
    		    { 
    		        // day close tracking
    		        $dayclosetrack = array();
    		        $query2=$this->db2->query("SELECT day_close_date,day_close_time,status_remarks FROM day_close_tracking WHERE day_close_date='$current_date' and branch_name='$branches'");
                    $rowcount2 = $query2->num_rows();
                    if($rowcount2 > 0)
                    {
                        foreach ($query2->result() as $row1) 
            		    {
            		        $dayclosetrack[] = array(
            		            'date' =>$row1->day_close_date,
            		            'Time' =>$row1->day_close_time,
            		            'Remarks' =>$row1->status_remarks,
            		        );
            		    }
                    } else {
                            $dayclosetrack[] = array(
            		            'date' =>'',
            		            'Time' =>'',
            		            'Remarks' =>'No records found',
        		            );
                    }
                    
                    $salestrack = array();
                    // sales tracking 
                    $query3=$this->db2->query("SELECT tracking_date,start_invoice_no,end_invoice_no,cash,card,nc,credit,paytm,phonepe,swiggy,zomato,vouchers,dotpe,cafe FROM sales_tracking WHERE tracking_date='$current_date' and branch_name='$branches'");
                    $rowcount3 = $query3->num_rows();
                    if($rowcount3 > 0)
                    {
                        foreach ($query3->result() as $row3) 
            		    {
            		        $salestrack[] = array(
            		            'date' =>$row3->tracking_date,
            		            'start_invoiceno' =>$row3->start_invoice_no,
            		            'end_invoiceno' =>$row3->end_invoice_no,
            		            'cash' =>$row3->cash,
            		            'card' =>$row3->card,
            		            'nc' =>$row3->nc,
            		            'credit' =>$row3->credit,
            		            'paytm' =>$row3->paytm,
            		            'phonepe' =>$row3->phonepe,
            		            'swiggy' =>$row3->swiggy,
            		            'zomato' =>$row3->zomato,
            		            'vouchers' =>$row3->vouchers,
            		            'dotpe' =>$row3->dotpe,
            		            'cafe' =>$row3->cafe
            		        );
            		    }
                    } else {
                            $salestrack[] = array(
            		            'Remarks' =>'No records found',
        		            );
                    }
                    $logintrack = array();
                    // login track 
                    $query4=$this->db2->query("SELECT login_date,login_time,logout_date,logout_time,user_id FROM login_track WHERE login_date='$current_date' and branch_name='$branches'");
                    $rowcount4 = $query4->num_rows();
                    if($rowcount4 > 0)
                    {
                        foreach ($query4->result() as $row4) 
            		    {
            		        $logintrack[] = array(
            		            'login_date' =>$row4->login_date,
            		            'login_time' =>$row4->login_time,
            		            'logout_date' =>$row4->logout_date,
            		            'logout_time' =>$row4->logout_time,
            		            'user_id' =>$row4->user_id
            		        );
            		    }
                    } else {
                            $logintrack[] = array(
            		            'Remarks' =>'No records found',
        		            );
                    }
    		        
    		        $bills[] = array(
    		            'bill_id' =>$row->bill_id,
    		            'in_no' =>$row->in_no,
    		            'invoice_no' =>$row->invoice_no,
    		            'invoice_date' =>$row->invoice_date,
    		            'invoice_time' =>$row->invoice_time,
    		            'synch_date' =>$row->synch_date,
    		            'synch_time' =>$row->synch_time,
    		            'branch' =>$row->branch,
    		            'Day_close_track' =>$dayclosetrack,
    		            'Sales_track' =>$salestrack,
    		            'login_track' =>$logintrack
    		        );  
    		    }
            }
    	}
    	
    	echo json_encode($bills);
	}
	
	
	public function MasterTableReset($branch)
	{
	    $date = date("Y-m-d");
	    
	    $data = array();
	    
	    if(!empty($branch))
	    {
	        $this->db->query("update application_setting set data_transfer = 'pending', effective_from = '$date' where branch = '$branch'");
	        $this->db->query("update credit_customer set data_transfer='pending', effective_from= '$date' where branch = '$branch'");
	        $this->db->query("update masters_creation set data_transfer = 'pending', effective_from = '$date' where branch = '$branch'");
	        $this->db->query("update outlet_deatils set data_transfer='pending', effective_from = '$date' where branch = '$branch'");
	        $this->db->query("update product_category set data_transfer = 'pending', effective_from = '$date' where branch = '$branch'");
	        $this->db->query("update product set data_transfer = 'pending', effective_from = '$date' where branch = '$branch'");
	        $this->db->query("update users set data_transfer='pending', effective_from = '$date' where branch = '$branch'");
	        $this->db->query("update sms_authorize set data_transfer='pending', effective_date = '$date' where branch = '$branch'");
	        
	        $data = array(
	            'status' =>'Master Reseted Success'
	       );
	    }
	    else
	    {
	         $data = array(
	            'status' =>'Master Reseted Failed'
	       );
	    }
	    echo json_encode($data);
	}
	
	// excel export data to gsteam
	
	public function export_salesdata($branch,$from,$to,$no)
	{
	    if($no == '1')
	    {
            $this->load->dbutil();
    		$this->load->helper('file');
    		$this->load->helper('download');
    		$delimiter = ",";
    		$newline = "\r\n";
    		$filename = "product_billdetails.csv";
    	   	$query=$this->db->query("SELECT branch_slno,invoice_prefix as branch FROM outlet_deatils WHERE status='Active' and  invoice_prefix='$branch'");
    		$total_branch = $query->result_array();
            foreach ($total_branch as $brans) 
            {
        		$branch_code = $brans['branch_slno'];
        		$branches = $brans['branch'];
        		if ($branch == $branches)
        		{
    		        $table = 'product_billdetail'.$branch_code;
    		        $table1 = 'billed_product'.$branch_code;
    	            $query = "SELECT * from $table  where invoice_date between '$from' and '$to'";
        		}
    		}
    		$result = $this->db->query($query);
    		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
    		force_download($filename, $data);
	    } else if($no == '2') {
	        $this->load->dbutil();
    		$this->load->helper('file');
    		$this->load->helper('download');
    		$delimiter = ",";
    		$newline = "\r\n";
    		$filename = "billed_product.csv";
    	   	$query=$this->db->query("SELECT branch_slno,invoice_prefix as branch FROM outlet_deatils WHERE status='Active' and  invoice_prefix='$branch'");
    		$total_branch = $query->result_array();
            foreach ($total_branch as $brans) 
            {
        		$branch_code = $brans['branch_slno'];
        		$branches = $brans['branch'];
        		if ($branch == $branches)
        		{
    		        $table = 'product_billdetail'.$branch_code;
    		        $table1 = 'billed_product'.$branch_code;
    	            $query = "SELECT C.pr_cat_name as cat_name,B.pr_id as product_id,B.product_name,B.uom,B.basic_rate,B.quantity,B.pc_qty,B.price as basic_price,B.disc_per as disc_percentage,B.disc_amount,B.item_taxable_amt as taxable_amt,B.tax_percentage,B.item_tax_amt as tax_amt,round(B.total_price,2) as total_price,B.bill_status,B.bill_id,P.cust_name as customer_name from $table P inner join $table1 B on P.bill_id=B.bill_id inner join product_category C on B.cat_name=C.pr_cat_code where ((P.invoice_date between '$from' and '$to') and (C.branch='$branch'))";
    			}
    		}
    		$result = $this->db->query($query);
    		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
    		force_download($filename, $data);
	    } else if($no == '3') {
	        $this->load->dbutil();
    		$this->load->helper('file');
    		$this->load->helper('download');
    		$delimiter = ",";
    		$newline = "\r\n";
    		$filename = "payment_details.csv";
    	   	$query=$this->db->query("SELECT branch_slno,invoice_prefix as branch FROM outlet_deatils WHERE status='Active' and  invoice_prefix='$branch'");
    		$total_branch = $query->result_array();
            foreach ($total_branch as $brans) 
            {
        		$branch_code = $brans['branch_slno'];
        		$branches = $brans['branch'];
        		if ($branch == $branches)
        		{
    		        $table = 'payments_details'.$branch_code;
    	            $query = "SELECT payment_id,payment_date,payment_types,multi_payment as amount,branch,bill_id,synch_date,synch_time FROM $table WHERE payment_date between '$from' and '$to'";
    			}
    		}
    		$result = $this->db->query($query);
    		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
    		force_download($filename, $data);
	    }
	}
	
	public function addNewProductsodc()
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['uoms'] = $this->master_model->uom_list_active();
		$data['taxes'] = $this->master_model->tax_list_active();
		$data['pageTitle'] = 'Product ODC Add';
		$data['Pagename'] = 'Product ODC Add';
		$data['HomePage'] = 'Home';
		$this->load->view("master/odc_add_products", $data);
	}
	
	public function odc_products_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		// $data['userRecords'] = $this->master_model->Products_list();
		// $data['category'] = $this->master_model->getCategory();
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->odc_Products_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->odc_Products_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	$data['mid'] = $mid;
		$data['pageTitle'] = 'ODC Product List';
		$data['Pagename'] = ' ODC Product List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/odc_product_list",$data);
	}
	
	public function odcinsertNewProducts()
	{
	    $clientid = $this->input->post('clientid');
        $branch = $this->input->post('branch');
        $categoryId = $this->input->post('categoryId');
        $product_name = strtoupper($this->input->post('product_name'));
        $product_uom = $this->input->post('product_uom');
        $product_price = $this->input->post('product_price');
        $basic_product_price = $this->input->post('basic_product_price');
        $tax_pecentage = $this->input->post('tax_pecentage');
        $basic_tax_amount = $this->input->post('basic_tax_amount');
        $cgst_price = $this->input->post('cgst_price');
        $sgst_price = $this->input->post('sgst_price');
        $cgst_tax = $this->input->post('cgst_tax');
        $sgst_tax = $this->input->post('sgst_tax');
    
        $product_stock = $this->input->post('product_stock');
        
        $product_status1 = $this->input->post('product_status');
        if($product_status1 == "true")
        {
            $product_status = "Active";
        }
        else
        {
            $product_status = "Inactive";
        }
        
        $product_hsn = $this->input->post('product_hsn');
        $effective = $this->input->post('effective');
        
        $query=$this->db->query("INSERT INTO splproduct(product_name, hsn_code, product_no, uom, basic_rate, basic_tax_percent, basic_tax_amount, sgst_tax, sgst_tax_amount, cgst_tax, cgst_tax_amount, price, product_status, pr_cat_id, branch, cat_id, cust_id, pr_id) VALUES ('$product_name','$product_hsn','0','$product_uom','$basic_product_price','$tax_pecentage','$basic_tax_amount','$sgst_tax','$cgst_price','$sgst_tax','$sgst_price','$product_price','$product_status','$categoryId','$branch','1','1','15914')");
   	    $last_id = $this->db->insert_id();
   	    if($last_id > 0)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New ODC Product created successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> ODC Product creation failed!!!</div>');
		}        
	    redirect('Master_section/odc_products_list/129');
	}
	
	public function odceditProducts($pr_id)
	{
	    $data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
			$data['userInfo'] = $this->master_model->get_product_ids($pr_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
			$data['userInfo'] = $this->master_model->get_product_ids($pr_id);
		}
		$data['uoms'] = $this->master_model->uom_list_active();
		$data['taxes'] = $this->master_model->tax_list_active();
		$data['pageTitle'] = 'Product ODC Edit';
		$data['Pagename'] = 'Product ODC Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/odc_product_edit", $data);
	}
	
	public function odcupdateProductsDetails()
	{
	    $clientid = $this->input->post('clientid');
        $branch = $this->input->post('branch');
        $categoryId = $this->input->post('categoryId');
        $product_name = strtoupper($this->input->post('product_name'));
        $product_uom = $this->input->post('product_uom');
        $product_price = $this->input->post('product_price');
        $basic_product_price = $this->input->post('basic_product_price');
        $tax_pecentage = $this->input->post('tax_pecentage');
        $basic_tax_amount = $this->input->post('basic_tax_amount');
        $cgst_price = $this->input->post('cgst_price');
        $sgst_price = $this->input->post('sgst_price');
        $cgst_tax = $this->input->post('cgst_tax');
        $sgst_tax = $this->input->post('sgst_tax');
    
        $product_stock = $this->input->post('product_stock');
         $produtsId = $this->input->post('produtsId');
        $product_status1 = $this->input->post('product_status');
        if($product_status1 == "true")
        {
            $product_status = "Active";
        }
        else
        {
            $product_status = "Inactive";
        }
        
        $product_hsn = $this->input->post('product_hsn');
        $effective = $this->input->post('effective');
        
        $query=$this->db->query("UPDATE splproduct SET product_name='$product_name', hsn_code='$product_hsn', product_no='0', uom='$product_uom', basic_rate='$basic_product_price', basic_tax_percent='$tax_pecentage', basic_tax_amount='$basic_tax_amount', sgst_tax='$sgst_tax', sgst_tax_amount='$sgst_price', cgst_tax='$cgst_tax', cgst_tax_amount='$cgst_price', price='$product_price', product_status='$product_status', pr_cat_id='$categoryId', branch='$branch', cat_id='1', cust_id='1', pr_id='15914' where spl_id ='$produtsId'");
   	    $last_id = $this->db->affected_rows(); 
   	    if($last_id > 0)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button>  ODC updation created successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> ODC Product updation failed!!!</div>');
		}        
	    redirect('Master_section/odc_products_list/129');
	}
	
	public function company_creation()
	{
	    $data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
	
		$data['locations'] = $this->master_model->get_location();
		$data['pageTitle'] = 'Company Add';
		$data['Pagename'] = 'Company Add';
		$data['HomePage'] = 'Home';
		$this->load->view("master/company_creation", $data);
	}
	
	public function newcompanycreation()
	{
	    $company_name = $this->input->post('company_name');
        $gst_no = $this->input->post('gst_no');
        $moile1 = $this->input->post('mobile1');
        $moile2 = $this->input->post('mobile2');
        $location = $this->input->post('location');
        $query=$this->db->query("INSERT INTO Company_details(company_name, customer_gst,company_mobile,alernative_mobile,branch,location_id) VALUES ('$company_name','$gst_no','$moile1','$moile2','MC1','$location')");
   	    $last_id = $this->db->insert_id();
   	    if($last_id > 0)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> New Company created successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Company creation failed!!!</div>');
		}        
	    redirect('Master_section/company_list/132');
	}
	
	public function company_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		// $data['userRecords'] = $this->master_model->Products_list();
		// $data['category'] = $this->master_model->getCategory();
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->company_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->company_list($client_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	    $data['mid'] = $mid;
		$data['pageTitle'] = 'Company List';
		$data['Pagename'] = ' Company List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/company_list",$data);
	}
	
	public function edit_company($company_id)
	{
	    $data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		// $data['userRecords'] = $this->master_model->Products_list();
		// $data['category'] = $this->master_model->getCategory();
		// $data['clientlist'] = $this->master_model->client_list_active();
		// $data['branchlist'] = $this->master_model->branch_list_active();
		// $data['categorylist'] = $this->master_model->category_list_active();
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userInfo'] = $this->master_model->company_listedit($company_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userInfo'] = $this->master_model->company_listedit($company_id);
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
		$data['locations'] = $this->master_model->get_location();
	    $data['mid'] = $mid;
		$data['pageTitle'] = 'Company Edit';
		$data['Pagename'] = ' Company Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/compnay_edit",$data);
	}
	
	public function updated_company()
	{
	    $company_id = $this->input->post('company_id');
	    $company_name = $this->input->post('company_name');
        $gst_no = $this->input->post('gst_no');
        $mobile1 = $this->input->post('mobile1');
        $mobile2 = $this->input->post('mobile2');
        $location = $this->input->post('location');
        $query=$this->db->query("UPDATE Company_details SET location_id ='$location',company_name='$company_name', customer_gst='$gst_no',company_mobile='$mobile1',alernative_mobile='$mobile2'  where company_id='$company_id'");
   	    $last_id = $this->db->affected_rows(); 
   	    if($last_id > 0)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Company Updation successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Company Updation failed!!!</div>');
		}        
	    redirect('Master_section/company_list/132');
	    
	}
	
	// item Price updated
	public function itemprice_assignd()
	{
	    $company = $this->input->post('company');
	    $item_name = $this->input->post('item_name');
        $tax_per = $this->input->post('tax_per');
        $item_price = $this->input->post('item_price');
        $status = $this->input->post('status');
        $item_id = $this->input->post('item_id');
        
        $final_pecrentage=0;
        if($tax_per =='5')
        {
            $final_pecrentage=1.05;
        } else if ($tax_per =='12')
        {
            $final_pecrentage=1.12;
        } else if ($tax_per =='18') {
            $final_pecrentage=1.18;
        } else if ($tax_per =='28') {
            $final_pecrentage=1.28;
        }
        $basic_rate = round($item_price / $final_pecrentage,2);
        $basic_tax = round($item_price - $basic_rate,2);
        $divided_gst = round($basic_tax /2,2);
        $divided_tax = $tax_pecentage /2;
        
        $query=$this->db->query("SELECT * FROM splproduct WHERE cust_id='$company' and pr_id='$item_id'");
		if($query->num_rows() > 0)
		{
		    $this->session->set_flashdata('message','<div class="alert alert-warning alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Product Already Assigned!!!</div>');
		     redirect('Master_section/Products_list/8');
		} else {
            $query = $this->db->query("SELECT hsn_code,product_no,product_code,uom,pr_cat_id,branch,cat_id FROM product WHERE pr_id='$item_id'");
            $rows = $query->row();
            if (isset($rows))
            {
                $hsn_code = $rows->hsn_code;
                $product_no = $rows->product_no;
                $product_code = $rows->product_code;
                $uom = $rows->uom;
                $pr_cat_id = $rows->pr_cat_id;
                $branch = $rows->branch;
                $cat_id = $rows->cat_id;
                $query = $this->db->query("INSERT INTO splproduct (product_name,hsn_code,product_no,uom,basic_rate,basic_tax_percent,basic_tax_amount,sgst_tax, sgst_tax_amount,cgst_tax,cgst_tax_amount,price,product_status,pr_cat_id,branch,cat_id,cust_id, pr_id) VALUES ('$item_name','$hsn_code','$product_no','$uom','$basic_rate','$tax_per','$basic_tax','$divided_tax','$divided_gst','$divided_tax','$divided_gst','$item_price','$status','$pr_cat_id','$branch','$cat_id','$company','$item_id')");
                $insert_id = $this->db->insert_id();
                if($insert_id > 0)
                {
                    $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Product updation success!!!</div>');
                } else {
                    $this->session->set_flashdata('message','<div class="alert alert-warning alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Product updation Failed!!!</div>');
                }
            }
            redirect('Master_section/Institutional_product_list/110');
		}
		
	}
	
	public function location_creation()
	{
	    $data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['clientlist'] = $this->master_model->client_list_active($client_id);
			$data['branchlist'] = $this->master_model->branch_list_active($client_id);
			$data['categorylist'] = $this->master_model->category_list_active($client_id);
		}
		$data['pageTitle'] = 'Location Add';
		$data['Pagename'] = 'Location Add';
		$data['HomePage'] = 'Home';
		$this->load->view("master/location_creation", $data);
	}
	// insert location 
	public function newlocationcreation()
	{
	    $location_name = $this->input->post('location_name');
        $query=$this->db->query("INSERT INTO locations(location_name) VALUES ('$location_name')");
   	    $last_id = $this->db->insert_id();
   	    if($last_id > 0)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Location created successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Location creation failed!!!</div>');
		}        
	    redirect('Master_section/location_list/132');
	}
	// location list 
	public function location_list($mid)
	{
		$data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userRecords'] = $this->master_model->get_location();
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userRecords'] = $this->master_model->get_location();
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	    $data['mid'] = $mid;
		$data['pageTitle'] = 'Location List';
		$data['Pagename'] = ' Location List';
		$data['HomePage'] = 'Home';
		$this->load->view("master/location_list",$data);
	}
	// edit location 
	public function edit_location($location_id)
	{
	    $data['library_js']= $library_script = unserialize (Library_script_files);
		$data['library_css']= $library_style = unserialize (Library_style_files);
		$role_id = $this->session->userdata('role');
		if($role_id == '5' || $role_id == '11') 
		{ 
			$client_id = '';
			$data['userInfo'] = $this->master_model->location_listedit($location_id);
		} 
		else  
		{
			$client_id = $this->session->userdata('client_id'); 
			$data['userInfo'] = $this->master_model->location_listedit($location_id);
		}
		$data['Permission'] = $this->master_model->login_permission_access($mid);
	    $data['mid'] = $mid;
		$data['pageTitle'] = 'Location Edit';
		$data['Pagename'] = ' Location Edit';
		$data['HomePage'] = 'Home';
		$this->load->view("master/location_edit",$data);
	}
	// update location 
	
	public function updated_location()
	{
	    $location_id = $this->input->post('location_id');
	    $location_name = $this->input->post('location_name');
        $query=$this->db->query("UPDATE locations SET location_name ='$location_name' where location_id ='$location_id'");
   	    $last_id = $this->db->affected_rows(); 
   	    if($last_id > 0)
		{
			$this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Location Updation successfully</div>');
		}
		else
		{
			$this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Location Updation failed!!!</div>');
		}        
	    redirect('Master_section/location_list/132');
	    
	}
	
}
?>