<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, OPTIONS");
defined('BASEPATH') OR exit('No direct script access allowed');
	class Urban_piper extends CI_Controller {
		var $library_script;
		var $library_style;
		public function __construct()
		{
			parent::__construct();
		    $this->load->model('urban_model');
			$this->load->model('role_model');
			$this->load->helper(array('form', 'url')); 
		}
		
		// ******************MASTERS CONFIGRATION **********************//
		
		// Stores - add or update
		public function add_update_store()
        {
            $result = $this->urban_model->add_update_store_data();
        }
        
        // Stores - add / update callback Response
        public function store_creation_callback()
        {
            header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'),true);
            $reference = $row['reference'];
            $error = $row['stats']['errors'];
            if($error =='0') 
            {
                $query = $this->db->query("update store set process_status ='success' where reference='$reference'");
            }
        }
        
        // stores actions
		public function stores_action()
        {
           $result = $this->urban_model->stores_action_data(); 
        }
        
        //  store action - callback response
        public function store_action_callback()
        {
            header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'),true);
            $action = $row['action'];
            $location_ref = $row['location_ref_id'];
            $plat_form = $row['platform'];
            $ref_id = $row['reference_id'];
            $status = $row['status'];
            $ts_utc = $row['ts_utc'];
            $store_operator = $row['action_src'];
            $store_reson = $row['additional_info']['reason'];
            $updated_date = date('d-m-Y h:i A', floor($ts_utc / 1000));
            $active = "";
            $operater_by="";
            $reson =""; 
            if($store_operator == "aggregator")
            {
                $operater_by = $store_operator;
                $reson = $store_reson;
            } else {
                $operater_by = "Outlets Manager";
                $reson = "store".$action."by Outlet Manager";
            }
            if($status == 1)
            {
                $active="true";
            }else {
                $active="false";
            }
            $query = $this->db->query("update store_actions set action='$action',ts_utc='$ts_utc',status='$active',str_action_status='completed' where location_ref_id='$location_ref' and platform='$plat_form'");
            $query10 = $this->db->query("INSERT INTO store_cancellation(location_ref,platform,datetimes,closed_by,resons) VALUES ('$location_ref','$plat_form','$updated_date','$operater_by','$reson')");
        }   
        
        
        
		// manage catalogue 
        public function get_catalogue()
        {
            $result = $this->urban_model->get_catalogue_api();
        }
        //  catalogue  - callback Response
        public function catalogue_callback()
        {
            header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'),true);
            $reference = $row['reference'];
            $cat_error = $row['stats']['categories']['errors'];
            $product_error = $row['stats']['items']['errors'];
            if($cat_error =='0') 
            {
                $query = $this->db->query("update product_category set catalouge_status='success' where catalouge_reference ='$reference'");
            }
            if($product_error =='0')
            {
                $query2 = $this->db->query("update product set catalogue_status='success',fd_status='success' where catalouge_refrence ='$reference'");
            }
        }
        
        // item action
        public function get_itemaction()
        {
            $result = $this->urban_model->get_itemaction_api();
        }
        
        //  Item actions - Callback Response
        public function item_action_callback()
        {
            header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'),true);
            $reference = $row['reference_id'];
            $action = $row['action'];
            
            if($action =='stock-out') {
                $final_status ="InActive";
            } else {
                $final_status ="Active";
            }
            $ss = $row['status'];
            foreach ($ss as $r1) 
            {
                $items = $r1['items'];
                $location_refid = $r1['location']['ref_id'];
                foreach ($items as $r2) 
                {
                  $item_id = $r2['ref_id'];
                  $item_ref=substr($item_id,2);
                  $status = $r2['status'];
                  if($status =="success")
                  {
                     $query = $this->db->query("update product set fd_status ='success',product_status='$final_status',item_action_status ='success' where product_no='$item_ref' and location_ref_id='$location_refid'");
                   }
                }
            }
        }
        
        // webhook config
        public function get_webhook_config()
        {
            $result = $this->urban_model->get_webhook_apis();
        }
        // get taxs list
         public function get_taxes()
        {
            $result = $this->urban_model->get_taxes_api();
        }
        // get charge
        public function get_charges()
        {
            $result = $this->urban_model->get_charges_api();
        }
        
        //  category timing
        public function category_timing_callback()
        {
            //$result = $this->dashboard_model->store_action();
        }
        
        
        //  order relay placed
        public function orderrelay_callback()
        {
            $current_date = date('Y-m-d');
            header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'),true);
            
            // customer data 
            $email_id = $row['customer']['email'];
            $cust_name = $row['customer']['name'];
            $phone_no = $row['customer']['phone'];
            $city =  $row['customer']['address']['city'];
            $guestmode =  $row['customer']['address']['is_guest_mode'];
            $land_mark =  $row['customer']['address']['landmark'];
            $lttude =  $row['customer']['address']['latitude'];
            $val = $row['customer']['address']['line_1'];
            $val2 = $row['customer']['address']['line_2'];
            $address1 = str_replace("'","\'", $val);
            $address2 = str_replace("'","\'", $val2);
            $lgtude =  $row['customer']['address']['longitude'];
            $pincode =  $row['customer']['address']['pin'];
            $slocality =  $row['customer']['address']['sub_locality'];
            $tags =  $row['customer']['address']['tag'];
            // orders details data 
            $order_id = $row['order']['details']['id'];
            $biz_id = $row['order']['details']['biz_id'];
            $channel = $row['order']['details']['channel'];
            $charges = $row['order']['details']['charges']; // array of string []
            $coupon = $row['order']['details']['coupon'];
            $created = $row['order']['details']['created'];
            $delivery_datetime = $row['order']['details']['delivery_datetime'];
            $discount = $row['order']['details']['discount'];
            $ext_platforms = $row['order']['details']['ext_platforms']; // array of objects [{}] 
            $instructions = $row['order']['details']['instructions'];
            $test_val = $new_value = str_replace("'","\'", $instructions);
            $item_level_total_charges = $row['order']['details']['item_level_total_charges'];
            $item_level_total_taxes = $row['order']['details']['item_level_total_taxes'];
            $item_taxes = $row['order']['details']['item_taxes'];
            $merchant_ref_id = $row['order']['details']['merchant_ref_id'];
            $order_level_total_charges = $row['order']['details']['order_level_total_charges'];
            $order_level_total_taxes = $row['order']['details']['order_level_total_taxes'];
            $order_state = $row['order']['details']['order_state'];
            $order_subtotal = $row['order']['details']['order_subtotal'];
            $order_total = $row['order']['details']['order_total'];
            $order_type = $row['order']['details']['order_type'];
            $payable_amount = $row['order']['details']['payable_amount'];
            $state = $row['order']['details']['state'];
            $taxes = $row['order']['details']['taxes']; // array of string []
            $total_charges = $row['order']['details']['total_charges'];
            $total_external_discount = $row['order']['details']['total_external_discount'];
            $merchant_discount = $discount - $total_external_discount;
            $total_taxes = $row['order']['details']['total_taxes'];
            $next_state = $row['order']['next_state'];
            $next_states = $row['order']['next_states']; // array string []
            $payment_amount = $row['order']['payment'];
            $store = $row['order']['store'];
            $store_ref = $row['order']['store']['merchant_ref_id'];
            $branch ="";
            if($store_ref =="cakewala_1")
            {
                $branch ="CW1";
            }else if($store_ref =="cakewala_2") {
                $branch ="CW2";
            } else if($store_ref =="cakewala_3") {
                $branch ="CW3";
            } else if($store_ref =="cakewala_4") {
                $branch ="CW4";
            } else if($store_ref =="cakewala_5") {
                $branch ="CW5";
            }
            
            $invoice_date = date('Y-m-d');
            $invoice_time = date("h:i a");
            $query=$this->db->query("SELECT MAX(in_no) AS bno from social_orders where branch='$branch'");
            $rowcount = $query->num_rows();
            $orderType = array();
            if($rowcount > 0)
            {
                foreach ($query->result() as $ids) 
		        { 
		            $bno = $ids->bno;
		            if($bno == 0)
		            {
    			        $b_no = 1;
    	        	}
            		else{
            			$b_no = $bno+1;
            		}
    	        	$bill_no = $branch."2122000".$b_no;
		        }
            } 
            $aggregator_id = $merchant_ref_id;
            $check=$this->db->query("SELECT socialorder_id  FROM social_orders WHERE socialorder_id='$order_id'");
            if($check->num_rows() == 0 )
            {
                $query = $this->db->query("INSERT INTO social_orders(socialorder_id,agreID,in_no,invoice_no,invoice_date,invoice_time,city, is_guest_mode, line_1, line_2, status, landmark, latitude, longitude, sub_locality, pin, tag, email, name, phone, biz_id, channel, coupon, created, delivery_datetime, discount, total_external_discount, instructions, item_level_total_charges, item_level_total_taxes, item_taxes, merchant_ref_id, order_level_total_charges, order_level_total_taxes, order_state, order_subtotal, order_total, order_type, total_charges, total_taxes, next_state, store_id,merchant_discount,orders_date,branch) VALUES ('$order_id','$aggregator_id','$b_no','$bill_no','$invoice_date','$invoice_time','$city','$guestmode','$address1','$address2','0','$land_mark','$lttude','$lgtude','$slocality','$pincode','$tags','$email_id','$cust_name','$phone_no','$biz_id','$channel','$coupon','$created','$delivery_datetime','$discount','$total_external_discount','$test_val','$item_level_total_charges','$item_level_total_taxes','$item_taxes','$merchant_ref_id','$order_level_total_charges','$order_level_total_taxes','$order_state','$order_subtotal','$order_total','$order_type','$total_charges','$total_taxes','$next_state','$store_ref','$merchant_discount','$current_date','$branch')"); 
                foreach ($ext_platforms as $ext) 
                {
                   $extsId = $ext['id'];
                    $query101 = $this->db->query("UPDATE social_orders set agreID='$extsId' where socialorder_id='$order_id'");
                }
                $current_date = date('Y-m-d');
                $current_time = date("h:i:s a");
                for($i=0;$i<count($next_states);$i++)
                {
                    $status_name ='';
                    $status_message ='';
                    $status_event ='';
                    if($next_states[$i] =='Acknowledged')
                    {
                        $status_name ='Acknowledge';
                        $status_message ='Order Accepted From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } else if($next_states[$i] =='Food Ready') 
                    {
                        $status_name ='Markfoodready';
                        $status_message ='Food Ready From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } else if($next_states[$i] =='Dispatched') 
                    {
                        $status_name ='Dispatch';
                        $status_message ='Dispatched From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } else if($next_states[$i] =='Completed') 
                    {
                        $status_name ='Complete';
                        $status_message ='Order Completed From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } else if($next_states[$i] =='Cancelled') 
                    {
                        $status_name ='Cancel';
                        $status_message ='Order Cancelled From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } 
                    $query = $this->db->query("INSERT INTO orders_status_log(status_type, status, message,created,store_id, socialorder_id, callback_message, log_status,order_final_status,order_update_status,order_update_message) VALUES('$status_name','$next_states[$i]','$status_message','','$store_ref','$order_id','','$status_event','pending','','')"); 
                }
                foreach ($payment_amount as $p1) 
                {
                    $amounts = $p1['amount'];
                    $options = $p1['option'];
                    $srvr_trx_ids = $p1['srvr_trx_id'];
                    $query2 = $this->db->query("INSERT INTO order_payment(orderpayment_amount, orderpayment_option, orderpayment_srvr_trx_id, socialorder_id,order_date,order_time,order_status) VALUES ('$amounts','$options','$srvr_trx_ids','$order_id','$current_date','$current_time','running')"); 
                }
                $ss = $row['order']['items'];
                foreach ($ss as $r1) 
                {
                    $charges = $r1['charges'];
                    $discount = $r1['discount'];
                    $food_type = $r1['food_type'];
                    $id = $r1['id'];
                    $image_landscape_url = $r1['image_landscape_url'];
                    $image_url = $r1['image_url'];
                    $merchant_id = $r1['merchant_id'];
                    $options_to_add = $r1['options_to_add'];
                    $options_to_remove = $r1['options_to_remove'];
                    $price = $r1['price'];
                    $quantity = $r1['quantity'];
                    $taxes = $r1['taxes'];
                    $title = $r1['title'];
                    $total = $r1['total'];
                    $total_with_tax = $r1['total_with_tax'];
                    $unit_weight = $r1['unit_weight'];
                    $item_id = substr($merchant_id,2);
                    $item_taxable = round($total - $discount,2);
                    $query101=$this->db->query("SELECT hsn_code,pr_cat_id,uom,basic_tax_percent,sgst_tax,sgst_tax_amount,cgst_tax,cgst_tax_amount,product_no FROM product WHERE product_name='$title' and social_order='1'");
                    $row3 = $query101->row_array();
                    $cat_id = $row3['pr_cat_id'];
                    $uom = $row3['uom'];
                    $basic_tax_percent = $row3['basic_tax_percent'];
                    $sgst_tax = $row3['sgst_tax'];
                    $sgst_tax_amount = $row3['sgst_tax_amount'];
                    $cgst_tax = $row3['cgst_tax'];
                    $cgst_tax_amount = $row3['cgst_tax_amount'];
                    $hsn_code = $row3['hsn_code'];
                    $product_nos = $row3['product_no'];
                    $query1 = $this->db->query("INSERT INTO items_orders_social(itemId,cat_name, product_name, hsn_code, uom, basic_rate, tax_percentage, sgst_tax, sgst_base_tax_amt, cgst_tax, cgst_base_tax_amt, basic_price, pc_qty, quantity, price, disc_per, disc_amount, item_taxable_amt, sgst_tax_amount, cgst_tax_amount, item_tax_amt, total_price, bill_status, sd_status, bill_id, pr_id, edit_status, disc_type, sales_type, synch_date, synch_time,product_no) VALUES ('$id','$cat_id','$title','$hsn_code','$uom','$price','$basic_tax_percent','0','$sgst_tax_amount','0','$cgst_tax_amount','$price','0','$quantity','$total','0','$discount','$item_taxable','0','0','0','$total_with_tax','pendig','no','$order_id','$item_id','0','0','0','$current_date','$current_time','$product_nos')");
                    foreach ($taxes as $t1) 
                    {
                        $rate =   $t1['rate'];
                        $title = $t1['title'];
                        $value = $t1['value'];
                        $total_tax = $value * 2;
                        $query10 = $this->db->query("UPDATE items_orders_social set cgst_tax='$rate',sgst_tax_amount='$value',sgst_tax='$rate',cgst_tax_amount='$value',item_tax_amt='$total_tax' where itemId='$id'");
                    }
                }
            } else {
                $query = $this->db->query("INSERT INTO urban_piper_order_relay(order_id, location_name, remarks) VALUES ('$order_id','$store_ref','called again')");
            }
        }
        
        public function orderrelay_callback_test()
        {
            $current_date = date('Y-m-d');
            header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'),true);
           
            // customer data 
            $email_id = $row['customer']['email'];
            $cust_name = $row['customer']['name'];
            $phone_no = $row['customer']['phone'];
            $city =  $row['customer']['address']['city'];
            $guestmode =  $row['customer']['address']['is_guest_mode'];
            $land_mark =  $row['customer']['address']['landmark'];
            $lttude =  $row['customer']['address']['latitude'];
            //$address1 =  $row['customer']['address']['line_1'];
            $val = $row['customer']['address']['line_1'];
            $val2 = $row['customer']['address']['line_2'];
                
            $address1 = str_replace("'","\'", $val);
            $address2 = str_replace("'","\'", $val2);
                
            //$address2 =  $row['customer']['address']['line_2'];
            $lgtude =  $row['customer']['address']['longitude'];
            $pincode =  $row['customer']['address']['pin'];
            $slocality =  $row['customer']['address']['sub_locality'];
            $tags =  $row['customer']['address']['tag'];
                
            // orders details data 
            $order_id = $row['order']['details']['id'];
            $biz_id = $row['order']['details']['biz_id'];
            $channel = $row['order']['details']['channel'];
            $charges = $row['order']['details']['charges']; // array of string []
            $coupon = $row['order']['details']['coupon'];
            $created = $row['order']['details']['created'];
            $delivery_datetime = $row['order']['details']['delivery_datetime'];
            $discount = $row['order']['details']['discount'];
            $ext_platforms = $row['order']['details']['ext_platforms']; // array of objects [{}]
            $instructions = $row['order']['details']['instructions'];
            $test_val = $new_value = str_replace("'","\'", $instructions);
            $item_level_total_charges = $row['order']['details']['item_level_total_charges'];
            $item_level_total_taxes = $row['order']['details']['item_level_total_taxes'];
            $item_taxes = $row['order']['details']['item_taxes'];
            $merchant_ref_id = $row['order']['details']['merchant_ref_id'];
            $order_level_total_charges = $row['order']['details']['order_level_total_charges'];
            $order_level_total_taxes = $row['order']['details']['order_level_total_taxes'];
            $order_state = $row['order']['details']['order_state'];
            $order_subtotal = $row['order']['details']['order_subtotal'];
            $order_total = $row['order']['details']['order_total'];
            $order_type = $row['order']['details']['order_type'];
            $payable_amount = $row['order']['details']['payable_amount'];
            $state = $row['order']['details']['state'];
            $taxes = $row['order']['details']['taxes']; // array of string []
            $total_charges = $row['order']['details']['total_charges'];
            $total_external_discount = $row['order']['details']['total_external_discount'];
            $merchant_discount = $discount - $total_external_discount;
            $total_taxes = $row['order']['details']['total_taxes'];
            $next_state = $row['order']['next_state'];
            $next_states = $row['order']['next_states']; // array string []
            $payment_amount = $row['order']['payment'];
            $store = $row['order']['store'];
            $store_ref = $row['order']['store']['merchant_ref_id'];
            $branch ="";
                
            if($store_ref =="cakewala_1")
            {
                $branch ="CW1";
            }else if($store_ref =="cakewala_2") {
                $branch ="CW2";
            } else if($store_ref =="cakewala_3") {
                $branch ="CW3";
            } else if($store_ref =="cakewala_4") {
                $branch ="CW4";
            } else if($store_ref =="cakewala_5") {
                $branch ="CW5";
            }
            $invoice_date = date('Y-m-d');
            $invoice_time = date("h:i a");
            $query=$this->db->query("SELECT MAX(in_no) AS bno from social_orders_test where branch='$branch'");
            $rowcount = $query->num_rows();
            $orderType = array();
            if($rowcount > 0)
            {
                foreach ($query->result() as $ids) 
		        { 
		            $bno = $ids->bno;
		            if($bno == 0)
		            {
    			        $b_no = 1;
    	        	}
            		else{
            			$b_no = $bno+1;
            		}
    	        	$bill_no = $branch."2122000".$b_no;
		        }
            } 
            $aggregator_id = $merchant_ref_id;
            $check=$this->db->query("SELECT socialorder_id  FROM social_orders_test WHERE socialorder_id='$order_id'");
            if($check->num_rows() == 0 )
            {
                $query = $this->db->query("INSERT INTO social_orders_test(socialorder_id,agreID,in_no,invoice_no,invoice_date,invoice_time,city, is_guest_mode, line_1, line_2, status, landmark, latitude, longitude, sub_locality, pin, tag, email, name, phone, biz_id, channel, coupon, created, delivery_datetime, discount, total_external_discount, instructions, item_level_total_charges, item_level_total_taxes, item_taxes, merchant_ref_id, order_level_total_charges, order_level_total_taxes, order_state, order_subtotal, order_total, order_type, total_charges, total_taxes, next_state, store_id,merchant_discount,orders_date,branch) VALUES ('$order_id','$aggregator_id','$b_no','$bill_no','$invoice_date','$invoice_time','$city','$guestmode','$address1','$address2','0','$land_mark','$lttude','$lgtude','$slocality','$pincode','$tags','$email_id','$cust_name','$phone_no','$biz_id','$channel','$coupon','$created','$delivery_datetime','$discount','$total_external_discount','$test_val','$item_level_total_charges','$item_level_total_taxes','$item_taxes','$merchant_ref_id','$order_level_total_charges','$order_level_total_taxes','$order_state','$order_subtotal','$order_total','$order_type','$total_charges','$total_taxes','$next_state','$store_ref','$merchant_discount','$current_date','$branch')"); 
                foreach ($ext_platforms as $ext) 
                {
                   $extsId = $ext['id'];
                    $query101 = $this->db->query("UPDATE social_orders_test set agreID='$extsId' where socialorder_id='$order_id'");
                }
                $current_date = date('Y-m-d');
                $current_time = date("h:i:s a");
                for($i=0;$i<count($next_states);$i++)
                {
                    $status_name ='';
                    $status_message ='';
                    $status_event ='';
                    if($next_states[$i] =='Acknowledged')
                    {
                        $status_name ='Acknowledge';
                        $status_message ='Order Accepted From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } else if($next_states[$i] =='Food Ready') 
                    {
                        $status_name ='Markfoodready';
                        $status_message ='Food Ready From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } else if($next_states[$i] =='Dispatched') 
                    {
                        $status_name ='Dispatch';
                        $status_message ='Dispatched From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } else if($next_states[$i] =='Completed') 
                    {
                        $status_name ='Complete';
                        $status_message ='Order Completed From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } else if($next_states[$i] =='Cancelled') 
                    {
                        $status_name ='Cancel';
                        $status_message ='Order Cancelled From Restaurant';
                        if($next_states[$i] == $next_state)
                        {
                            $status_event ='next';
                        } else {
                            $status_event ='Waiting';
                        }
                    } 
                    $query = $this->db->query("INSERT INTO orders_status_log_test(status_type, status, message,created,store_id, socialorder_id, callback_message, log_status,order_final_status,order_update_status,order_update_message) VALUES('$status_name','$next_states[$i]','$status_message','','$store_ref','$order_id','','$status_event','pending','','')"); 
                }
                foreach ($payment_amount as $p1) 
                {
                    $amounts = $p1['amount'];
                    $options = $p1['option'];
                    $srvr_trx_ids = $p1['srvr_trx_id'];
                    $query2 = $this->db->query("INSERT INTO order_payment_test(orderpayment_amount, orderpayment_option, orderpayment_srvr_trx_id, socialorder_id,order_date,order_time,order_status) VALUES ('$amounts','$options','$srvr_trx_ids','$order_id','$current_date','$current_time','running')"); 
                }
                $ss = $row['order']['items'];
                foreach ($ss as $r1) 
                {
                   $charges = $r1['charges'];
                   $discount = $r1['discount'];
                   $food_type = $r1['food_type'];
                   $id = $r1['id'];
                   $image_landscape_url = $r1['image_landscape_url'];
                   $image_url = $r1['image_url'];
                   $merchant_id = $r1['merchant_id'];
                   $options_to_add = $r1['options_to_add'];
                   $options_to_remove = $r1['options_to_remove'];
                   $price = $r1['price'];
                   $quantity = $r1['quantity'];
                   $taxes = $r1['taxes'];
                   $title = $r1['title'];
                   $total = $r1['total'];
                   $total_with_tax = $r1['total_with_tax'];
                   $unit_weight = $r1['unit_weight'];
                   $item_id = substr($merchant_id,2);
                   $item_taxable = round($total - $discount,2);
                   
                    $query101=$this->db->query("SELECT hsn_code,pr_cat_id,uom,basic_tax_percent,sgst_tax,sgst_tax_amount,cgst_tax,cgst_tax_amount,product_no FROM product WHERE product_name='$title' and social_order='1'");
                    $row3 = $query101->row_array();
                    $cat_id = $row3['pr_cat_id'];
                    $uom = $row3['uom'];
                    $basic_tax_percent = $row3['basic_tax_percent'];
                    $sgst_tax = $row3['sgst_tax'];
                    $sgst_tax_amount = $row3['sgst_tax_amount'];
                    $cgst_tax = $row3['cgst_tax'];
                    $cgst_tax_amount = $row3['cgst_tax_amount'];
                    $hsn_code = $row3['hsn_code'];
                    $product_nos = $row3['product_no'];
                        
                    // $check=$this->db->query("SELECT itemId  FROM items_orders_social_test WHERE bill_id='$order_id' and itemId='$id'");
                    // if($check->num_rows() >0 )
                    // {
                    //     $query1 = $this->db->query("UPDATE items_orders_social_test SET itemId='$id',cat_name='$cat_id', product_name='$title', hsn_code='$hsn_code', uom='$uom', basic_rate='$price', tax_percentage='$basic_tax_percent', sgst_base_tax_amt='$sgst_tax_amount', cgst_base_tax_amt='$cgst_tax_amount', basic_price='$price', quantity='$quantity', price='$total',disc_amount='$discount', item_taxable_amt='$item_taxable',total_price='$total_with_tax', bill_status='pending', sd_status='no', bill_id='$order_id', pr_id='$item_id', edit_status='0', disc_type='0', sales_type='0', synch_date='$current_date', synch_time='$current_time',product_no='$product_nos' where bill_id='$order_id' and itemId='$id'");
                    // } else {
                        $query1 = $this->db->query("INSERT INTO items_orders_social_test(itemId,cat_name, product_name, hsn_code, uom, basic_rate, tax_percentage, sgst_tax, sgst_base_tax_amt, cgst_tax, cgst_base_tax_amt, basic_price, pc_qty, quantity, price, disc_per, disc_amount, item_taxable_amt, sgst_tax_amount, cgst_tax_amount, item_tax_amt, total_price, bill_status, sd_status, bill_id, pr_id, edit_status, disc_type, sales_type, synch_date, synch_time,product_no) VALUES ('$id','$cat_id','$title','$hsn_code','$uom','$price','$basic_tax_percent','0','$sgst_tax_amount','0','$cgst_tax_amount','$price','0','$quantity','$total','0','$discount','$item_taxable','0','0','0','$total_with_tax','pendig','no','$order_id','$item_id','0','0','0','$current_date','$current_time','$product_nos')");
                    //}
                    foreach ($taxes as $t1) 
                    {
                        $rate =   $t1['rate'];
                        $title = $t1['title'];
                        $value = $t1['value'];
                        
                        $total_tax = $value * 2;
                        $query10 = $this->db->query("UPDATE items_orders_social_test set cgst_tax='$rate',sgst_tax_amount='$value',sgst_tax='$rate',cgst_tax_amount='$value',item_tax_amt='$total_tax' where itemId='$id'");
                    }
                }
            } else {
                $query = $this->db->query("INSERT INTO urban_piper_order_relay_test(order_id, location_name, remarks) VALUES ('$order_id','$store_ref','called again')");
            }
        }
        
        //  order status change
        public function order_status_callback()
        {
            header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'),true);
            $new_state = $row['new_state']; // orders new state
            $prev_state = $row['prev_state']; // orders previous state
            $order_id = $row['order_id']; // orders id 
            $timestamp = $row['timestamp']; // orders time stamp
            $store_id = $row['store_id']; // orders time stamp
            $message = $row['message']; // orders status update message
            $timestamp_unix = $row['timestamp_unix'];
            $next_state='';
            $branch ="";
            if($store_id == "cakewala_1")
            {
                $branch = "CW1";
            }else if($store_id == "cakewala_2"){
                $branch = "CW2";
            }else if($store_id == "cakewala_3"){
                $branch = "CW3";
            }else if($store_id == "cakewala_4"){
                $branch = "CW4";
            }else if($store_id == "cakewala_5"){
                $branch = "CW5";
            }
            if($new_state =="Placed")
            { 
                $next_state = "Acknowledged";
                $query2 = $this->db->query("update social_orders set order_state='$new_state',next_state='$next_state',created='$timestamp_unix',callback_response='success' where socialorder_id='$order_id'");
            } else if($new_state =="Acknowledged") {
                
                $next_state = "Food Ready";
                $query2 = $this->db->query("update social_orders set order_state='$new_state',next_state='$next_state',created='$timestamp_unix',callback_response='success' where socialorder_id='$order_id'");
                
            } else if($new_state =="Food Ready") {
                
                $next_state = "Dispatched";
                $query2 = $this->db->query("update social_orders set order_state='$new_state',next_state='$next_state',created='$timestamp_unix',callback_response='success' where socialorder_id='$order_id'");
                
            } else if($new_state =="Dispatched") {
                $next_state = "Completed";
                $query2 = $this->db->query("update social_orders set order_state='$new_state',next_state='$next_state',created='$timestamp_unix',callback_response='success' where socialorder_id='$order_id'");
                
            } else if($new_state =="Completed") {
              $next_state = "Completed";
              $query2 = $this->db->query("update social_orders set order_state='$new_state',next_state='$next_state',created='$timestamp_unix',callback_response='success' where socialorder_id='$order_id'");
           } else {
               $next_state = "Cancelled";
              $query2 = $this->db->query("update social_orders set order_state='$new_state',next_state='$next_state',created='$timestamp_unix',callback_response='success' where socialorder_id='$order_id'");
           }
            
            $query6=$this->db->query("SELECT status FROM orders_status_log WHERE socialorder_id ='$order_id'");
            foreach ($query6->result() as $sts) 
            {
                  $get_status = $sts->status;
                  if($new_state == $get_status)
                  {
                      $query3 = $this->db->query("update orders_status_log set order_callback_message ='$message',created='$timestamp_unix',log_status='completed',order_final_status='$new_state' where socialorder_id='$order_id' and status='$new_state'");
            	       $query20 = $this->db->query("update orders_status_log set log_status='next',order_final_status='$new_state' where socialorder_id='$order_id' and status='$next_state'");
                    if($new_state == "Completed")
                    {
                        $query25 = $this->db->query("update orders_status_log set log_status='completed' where socialorder_id='$order_id' and status_type !='Cancel'");
                    } else if($new_state == "Cancelled") {
                        $query26 = $this->db->query("update orders_status_log set log_status='Waiting' where socialorder_id='$order_id' and status_type !='Cancel'");
                    } 
                }
            }  
            
            
        }
        //  rider status change
        public function rider_status_callback()
        {
            //$result = $this->dashboard_model->store_action();
        }
        
         public function placed_order_update()
        {
            header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'), true);
            
            $log_status = $row['new_status'];
            $log_message = $row['message'];
            $log_order_id = $row['order_id'];
            
            $store_action = array(
                "new_status" => $log_status,
                "message" => $log_message
            );
            
            $data_string =  json_encode($store_action);
            $curl = curl_init('https://biz.urbanpiper.com/external/api/v1/orders/'.$log_order_id. '/status/');
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: apikey biz_adm_clients_MaFUscncGQoP:309a354cbf1601744fb59d27dc8aeb931a183679')
            );
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);
            $result = curl_exec($curl);
            $json = json_decode($result, true);
            curl_close($curl);
            //echo $message;
            //echo $status;
            $message = $json["message"];
            $status = $json["status"];
            
            if($message !='' && $status =='success') 
            {
                $order_states ='';
                $order_next_state ='';
                if($log_status == 'Acknowledged')
                {
                     $order_states ='Food Ready';
                     $order_next_state = 'Dispatched';
                     
                } else if ($log_status == 'Food Ready') 
                {
                    $order_states ='Dispatched';
                    $order_next_state = 'Completed';
                    
                } else if ($log_status == 'Dispatched') 
                {
                    $order_states ='Completed';
                    $order_next_state = 'Completed';
                }
                $query2 = $this->db->query("update social_orders set order_state='$order_states',next_state='$order_next_state',callback_response='processing' where socialorder_id='$log_order_id'");
            }  
            $data = array(
                "message" =>$message,
                "status" =>$status
            );
            echo  json_encode($data);
        }
        public function order_status_update()
        {
            header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $order_id = $row['order_id'];
                $order_type = $row['status'];
                $status_commenet = $row['status_comments'];
                $channel = $row['channel_name'];
                $result = $this->urban_model->order_status_update($order_id,$order_type,$status_commenet,$channel);
            }
        }
        
        public function cancel_status_update()
        {
            header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $order_id = $row['order_id'];
                $order_type = $row['status'];
                $status_commenet = $row['status_comments'];
               $channel = $row['channel_name'];
               $result = $this->urban_model->order_status_cancel_update($order_id,$order_type,$status_commenet,$channel);
            }
        }
        
        public function stores_update_app()
        {
            header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
               $stname = $row['store'];
               $staction = $row['ststatus'];
               //$stname = "cakewala_1";
               //$staction = "true";
               $result = $this->urban_model->add_update_store_data_app($stname,$staction); 
            }
        }
        public function stores_action_app()
        {
            header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
               $stname = $row['store'];
               $staction = $row['ststatus'];
               $stplat = $row['platforms'];
               $result = $this->urban_model->stores_action_data_app($stname,$staction,$stplat); 
            }
        }
        public function stores_action_app_swiggy()
        {
            header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
               $stname = $row['store'];
               $staction = $row['ststatus'];
               $stplat = $row['platforms'];
               $result = $this->urban_model->stores_action_data_swiggy($stname,$staction,$stplat); 
            }
        }
        
        
        public function stores_status_change()
        {
            header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
               $storename = $row['store'];
               $storestatus = $row['ststatus'];
               $platform_name = $row['platforms'];
               $result = $this->urban_model->store_status_changeupdate($storename,$storestatus,$platform_name); 
            }
        }
        
        
        // //  options actions
        // public function options_action_callback()
        // {
        //     $result = $this->dashboard_model->store_action();
        // }
        
        
        
        
        
        
        
        
         public function sms_call()
        {
            $result = $this->urban_model->sms_details();
        }
        
		public function http_status()
		{
		    header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'),true);
            if (empty($row))
            {
                echo http_response_code(404);
            }
            else
            {
                echo "not empty";
            } 
		}
		
		// urban piper API configration / send data to urban piper 
	
	    public function testcall()
        {
            $result = $this->urban_model->fetch_access_token();
        }
        
        
        
        
		
		
		
		// New Store Creation
		public function addstore()
		{
			$data['library_js']= $library_script = unserialize (Library_script_files);
			$data['library_css']= $library_style = unserialize (Library_style_files);
			$data['branch_list'] = $this->urban_model->get_branch_name();
			$data['platform_list'] = $this->urban_model->get_platform_name();
			$data['pageTitle'] = 'New store reation';
			$data['Pagename'] = 'New store creation';
			$data['HomePage'] = 'Home';
			$this->load->view("master/addstore", $data);
		}
		// Insert Store Info
		public function insertnewstore()
		{
		    $orders = $this->input->post('orders');
		    //$zomato = $this->input->post('zomato');
		    //$uber = $this->input->post('uber');
		    //$site = $this->input->post('site');
			$name = $this->input->post('store_name');
			$contact_phone	 = $this->input->post('contact_no');
			$city = $this->input->post('city_name');
			$branch = $this->input->post('branch_name');
			$min_pickup_time = $this->input->post('pickup_time');
			$min_delivery_time = $this->input->post('delivery_time');
			$min_order_value = $this->input->post('order_value');
			$hide_from_ui = $this->input->post('hide_url');
			$geo_longitude = $this->input->post('longitude');
			$geo_latitude = $this->input->post('latitude');
			$ordering_enabled = $this->input->post('order_status');
			$active = $this->input->post('store_status');
			$address = $this->input->post('address');
			
			$this->db->select('MAX(store_id) AS str_id',false);
			$result = $this->db->get('store')->row();
			$ref_no = $result->str_id;
			if($ref_no == 0){
				$ref_no = 1;
			}
			else{
				$ref_no = $ref_no+1;
			}
			$str_ref_no = $name."_".$ref_no;
			$current_date = date("Y-m-d");
			$current_time = date("H:S:I A");
			$data = array(
			    'store_ref_id'=> $str_ref_no,
			    'city'=>$city,
			    'name'=> $name,
			    'min_pickup_time'=>$min_pickup_time,
			    'min_delivery_time'=> $min_delivery_time,
			    'contact_phone'=>$contact_phone,
			    'min_order_value'=>$min_order_value,
			    'hide_from_ui'=>$hide_from_ui,
			    'address'=>$address,
			    'geo_longitude'=>$geo_longitude,
			    'active'=>$active,
			    'geo_latitude'=>$geo_latitude,
			    'ordering_enabled'=> $ordering_enabled,
			    'branch'=>$branch,
			    'reference'=>'0',
			    'created' =>'1',
			    'updated' =>'0',
			    'process_status' =>'pending'
			    );
			   $this->db->insert('store',$data);
		       $bid = $this->db->insert_id();
    			if($bid > 0)
    			{
    		        if($ordering_enabled =='true') {
    		               $store_action = 'enable';
    		        } else {
    		                $store_action = 'disable';
    		        }
    		       if($active =='true') {
    		           $action_action = 'true';
    		       } else {
    		           $action_action = 'false';
    		       }
    		       for($i=0; $i < count($orders); $i++)
    		       {
    		           $data1=array(
    		           'action' => $store_action,
    		           'location_ref_id' => $str_ref_no,
    		           'platform' => $orders[$i],
    		           'status' =>$action_action,
    		           'reference_id'=>'0',
    		           'ts_utc' =>'0',
    		           'str_action_status'=>'pending',
    		           'store_id' =>$bid
                        );
                        $this->db->insert('store_actions', $data1);
    		       }
		       
    				$this->session->set_flashdata('success', 'Store & Actions created');
    			}
    			else
    			{
    				$this->session->set_flashdata('error', ' Store & Actions creation failed');
    			}
    			redirect('Urban_piper/store_list');
		}
		// store List
		public function store_list()
		{
			$data['library_js']= $library_script = unserialize (Library_script_files);
			$data['library_css']= $library_style = unserialize (Library_style_files);
			$data['userRecords'] = $this->urban_model->get_store_list();
			$data['pageTitle'] = 'Store List';
			$data['pageId'] = '4';
			$data['Pagename'] = 'Store List';
			$data['HomePage'] = 'Home';
			$this->load->view("master/store_list", $data);
		}
		//Store Edit
		public function editstore($store_id)
		{
			$data['library_js']= $library_script = unserialize (Library_script_files);
			$data['library_css']= $library_style = unserialize (Library_style_files);
			$data['branch_list'] = $this->urban_model->get_branch_name();
			$data['platform_list'] = $this->urban_model->get_platform_name();
			$data['userInfo'] = $this->urban_model->getStoreInfo($store_id);
			$data['useractionInfo'] = $this->urban_model->getStoreactionInfo($store_id);
			$data['pageTitle'] = 'Store Edit';
			$data['Pagename'] = 'Store Edit';
			$data['HomePage'] = 'Home';
			$this->load->view("master/edit_store", $data);
		}
		// update store information
		public function updatestoreinfo()
		{
		    $orders = $this->input->post('orders');
		   
		  //  $swiggy = $this->input->post('swiggy');
		  //  $zomato = $this->input->post('zomato');
		  //  $uber = $this->input->post('uber');
		  //  $site = $this->input->post('site');
			$storeId = $this->input->post('storeId');
			//echo $storeId;
			$name = $this->input->post('store_name');
			$contact_phone	 = $this->input->post('contact_no');
			$city = $this->input->post('city_name');
			$branch = $this->input->post('branch_name');
			$min_pickup_time = $this->input->post('pickup_time');
			$min_delivery_time = $this->input->post('delivery_time');
			$min_order_value = $this->input->post('order_value');
			$hide_from_ui = $this->input->post('hide_url');
			$geo_longitude = $this->input->post('longitude');
			$geo_latitude = $this->input->post('latitude');
			$ordering_enabled = $this->input->post('order_status');
			$active = $this->input->post('store_status');
			$address = $this->input->post('address');
			
// 			$this->db->select('MAX(store_id) AS str_id',false);
// 			$result = $this->db->get('store')->row();
// 			$ref_no = $result->str_id;
// 			if($ref_no == 0){
// 				$ref_no = 1;
// 			}
// 			else{
// 				$ref_no = $ref_no+1;
// 			}
			$str_ref_no = $name."_".$storeId;
			$current_date = date("Y-m-d");
			$current_time = date("H:S:I A");
			$data = array(
			    'store_ref_id'=> $str_ref_no,
			    'city'=>$city,
			    'name'=> $name,
			    'min_pickup_time'=>$min_pickup_time,
			    'min_delivery_time'=> $min_delivery_time,
			    'contact_phone'=>$contact_phone,
			    'min_order_value'=>$min_order_value,
			    'hide_from_ui'=>$hide_from_ui,
			    'address'=>$address,
			    'geo_longitude'=>$geo_longitude,
			    'active'=>$active,
			    'geo_latitude'=>$geo_latitude,
			    'ordering_enabled'=> $ordering_enabled,
			    'branch'=>$branch,
			    'reference'=>'0',
			    'created' =>'0',
			    'updated' =>'1',
			    'process_status' =>'pending'
			    );
			   $result = $this->urban_model->editstoreDetails($data, $storeId);
			   //$result1 = $this->urban_model->deleteaction($storeId);
			
			if($result == true)
			{
			    //$query=$this->db->query("DELETE from store_actions where store_id='$store_id'");
			    //$result1 = $query->result();
		        //return $result;
			    $this->db->where('store_id',$storeId);
                $this->db->delete('store_actions');
			    
			    if($ordering_enabled =='true') {
		               $store_action = 'enable';
		        } else {
		               $store_action = 'disable';
		        }
		       if($active =='true') {
		           $action_action = 'true';
		       } else {
		           $action_action = 'false';
		       }
		       for($i=0; $i < count($orders); $i++)
		       {
		           $data1=array(
		           'action' => $store_action,
		           'location_ref_id' => $str_ref_no,
		           'platform' => $orders[$i],
		           'status' =>$action_action,
		           'reference_id'=>'0',
		           'ts_utc' =>'0',
		           'str_action_status'=>'pending',
		           'store_id' =>$storeId
                    );
                    $this->db->insert('store_actions', $data1);
		       }
			    $this->session->set_flashdata('success', 'Store updated');
			}
			else
			{
				$this->session->set_flashdata('error', 'Store updation failed');
			}
			redirect('Urban_piper/store_list');
		}
		
		// urban APIS
		
		// store add / update 
		 public function store()
        {
            $this->load->view('master/urbans/welcome_message');
        }
        
        // store action status update response
        public function store_status_update()
        {
            $ref_id = $this->input->post('reference');
            $status = $this->input->post('status');
            $store_api = $this->urban_model->get_store_update_details($ref_id,$status);
        }
        // store action
        // public function store_action()
        // {
        //     $this->load->view('master/urbans/store_action');
        // }
        
        public function storeaction_update()
        {
            $ref_id = $this->input->post('reference');
            $status = $this->input->post('status');
            $store_api = $this->urban_model->storeaction_update($ref_id,$status);
        }
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
           // catelogue
        public function catalogues()
        {
            $this->load->view('master/urbans/catalogue');
        }
       
        // taxes
        public function taxs()
        {
            $this->load->view('master/urbans/tax');
        }
       
        // charges
        public function charges()
        {
            $this->load->view('master/urbans/charge');
        }
       
        // items action
        public function items_action()
        {
            $this->load->view('master/urbans/item_action');
        }
        
        // webhooks
        public function webhooks()
        {
            $this->load->view('master/urbans/webhooks');
        }
        
        
        
        // dashboard data 
        
        public function order_placed() {
            $current_date = date('Y-m-d');
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("SELECT socialorder_id,agreID,channel, created, delivery_datetime,store_id,order_total,name,phone,order_state FROM social_orders where store_id='$branch' and orders_date='$current_date'");
                     
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
    		            $cr_date = date('d-m-Y h:i a', floor($pay->created / 1000));
    		            $dl_date = date('d-m-Y h:i a', floor($pay->delivery_datetime / 1000));
                        $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "channelId" => $pay->agreID,
                        "chennel_name" => $pay->channel,
                        "created_date" => $cr_date,
                        "delivery" => $dl_date,
                        "storeId" => $pay->store_id,
                        "order_amount" => $pay->order_total,
                        "customer_name" => $pay->name,
                        "customer_phone" => $pay->phone,
                        "orders_status" => $pay->order_state
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	} 
    	
    	public function order_placed_new() {
    	    $current_date = date('Y-m-d');
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("SELECT agreID,socialorder_id,channel, created,delivery_datetime,store_id,order_total,name,phone,order_state FROM social_orders where store_id='$branch' and order_state='Placed' and orders_date='$current_date'");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
    		            $cr_date = date('d-m-Y h:i a', floor($pay->created / 1000));
    		            $dl_date = date('d-m-Y h:i a', floor($pay->delivery_datetime / 1000));
                        $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "channelId" => $pay->agreID,
                        "chennel_name" => $pay->channel,
                        "created_date" => $cr_date,
                        "delivery" => $dl_date,
                        "storeId" => $pay->store_id,
                        "order_amount" => $pay->order_total,
                        "customer_name" => $pay->name,
                        "customer_phone" => $pay->phone,
                        "orders_status" => $pay->order_state,
                         //"order_count" => $rowcount
                        );
                    } 
                } 
                // else {
                //     $head[] = array(
                //       "order_count" => "0"
                //     );
                // }
                
                echo json_encode($head);
            } 
    	} 
    	
    	// datetime check 
    	
    	public function order_date_new() {
        	header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'), true);
            //foreach ($requestData as $row)
            //{
                $branch = $row['storesname'];
                $query1=$this->db->query("SELECT socialorder_id,created,delivery_datetime FROM social_orders where store_id='cakewala_4' and order_state='Placed'");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
    		            $cr_date = date('d-m-Y h:i a', floor($pay->created / 1000));
    		            $dl_date = date('d-m-Y h:i a', floor($pay->delivery_datetime / 1000));
                        $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "created_date" => $cr_date,
                        "delivery" => $dl_date
                        );
                    } 
                }
                echo json_encode($head);
            //} 
    	} 
    	
    	// orders Details
    	public function order_details() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $orderId = $row['order_id'];
                $query1=$this->db->query("SELECT S.socialorder_id, S.agreID,S.name,S.email,S.phone,S.line_1,S.line_2,S.channel,S.order_state,S.store_id,FROM_UNIXTIME(S.delivery_datetime/1000,'%d-%m-%Y %H:%i %p') as  delivery_datetime,P.orderpayment_option,S.instructions,S.order_type FROM social_orders S inner join order_payment P on S.socialorder_id=P.socialorder_id WHERE S.socialorder_id='$orderId'");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "chennalId" => $pay->agreID,
                        "customer_name" => $pay->name,
                        "customer_phone" => $pay->phone,
                        "customer_email" => $pay->email,
                        "address1" => $pay->line_1,
                        "address2" => $pay->line_2,
                        "chennel_name" => $pay->channel,
                        "order_status" =>$pay->order_state,
                        "storeId" => $pay->store_id,
                        "delivery_datetime" => date(' h:i A',$pay->delivery_datetime),
                        "pay_mode" =>$pay->orderpayment_option,
                        "instructions" =>$pay->instructions,
                        "order_type" => $pay->order_type
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    	// orders Details - full details
    	public function order_details_more() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            $orderitems = array();
            $order_summary = array();
            $next_states = array();
            $orders_info = array();
            $chennel_name = "";
            $ordersstatus = "";
            $globalorderId = "";
            
            foreach ($requestData as $row)
            {
                $orderId = $row['order_id'];
                $query=$this->db->query("SELECT S.socialorder_id,S.agreID,S.invoice_no,S.invoice_date,S.invoice_time,O.branch_title,O.org_name,O.land_no,O.gstin_no,O.website_name,O.address1,O.address2,O.cin_no,S.created,S.merchant_ref_id,S.channel,S.order_type,S.store_id,S.delivery_datetime,S.name,S.phone,S.email,S.line_1,S.line_2,S.order_state,S.store_id, S.instructions,S.order_type,S.order_subtotal,S.total_taxes,S.order_total,S.discount,S.merchant_discount,S.total_charges FROM social_orders S inner join outlet_deatils O on S.branch=O.branch WHERE S.socialorder_id='$orderId'");
                $rowcount = $query->num_rows();
                $pay = $query->result();
                if($rowcount > 0)
                {
                    foreach ($query->result() as $pay) 
    		        { 
    		            $in_date = date("d-m-Y", strtotime($pay->invoice_date));
    		            $dl_date = date('d-m-Y h:i A', floor($pay->delivery_datetime / 1000));
    		            $in_time = date("h:i A", strtotime($pay->invoice_time));
    		            $placed_time = date('d-m-Y h:i A', floor($pay->created / 1000));
    		            $chennel_name = $pay->channel;
    		            $ordersstatus = $pay->order_state;
    		            $globalorderId = $pay->socialorder_id;
                        $orders_info[] = array(
                        //  outlets information
                        "invoice_no" => $pay->invoice_no,
                        "invoice_date" => $in_date,
                        "invoice_time" => $in_time,
                        "org_name" => $pay->org_name,
                        "branch_title" => $pay->branch_title,
                        "landline_no" => $pay->land_no,
                        "website_name" => $pay->website_name,
                        "gst_no" => $pay->gstin_no,
                        "cin_no" => $pay->cin_no,
                        "address_line1" => $pay->address1,
                        "address_line2" => $pay->address2,
                        // Urban piper order summary 
                        "orders_placed" => $placed_time,
                        "urbanpiper_id" => $pay->socialorder_id,
                        "marchant_ref" => $pay->merchant_ref_id,
                        "payment_nmode" => $pay->channel, // note
                        "channel" =>$pay->channel,
                        "pulfilment_mode" => $pay->order_type,
                        "oulet_name" => $pay->store_id,
                        // Platform Details
                        "Platform" => $pay->channel."             (Message :  ".$pay->instructions."  )",
                        "platform_id" =>$pay->agreID,
                        // Delivery Details
                        "delivery_person"=> "",
                        "delivery_phone"=> "",
                        "delivery_channel"=> "",
                        "delivery_mode"=> "",
                        "delivery_time"=>$dl_date,
                        // customer Details
                        "customer_name" =>$pay->name,
                        "customer_phone" =>$pay->phone,
                        "customer_email" =>$pay->email,
                        "address1" => $pay->line_1,
                        "address2" => $pay->line_2,
                        "order_status" =>$pay->order_state,
                        "storeId" => $pay->store_id,
                        "instructions" =>$pay->instructions,
                        "order_type" => $pay->order_type,
                        // orders summary 
                        "subTotal" => $pay->order_subtotal,
                        "itemTax" => $pay->total_taxes,
                        "totalAmount" => $pay->order_total,
                        "discountAmt" => $pay->discount,
                        "merchantdiscount_amount" => $pay->merchant_discount,
                        "changres" => $pay->total_charges
                        );
                    } 
                }
                // Orders Items
                $query1=$this->db->query("SELECT I.product_name,I.quantity, I.basic_rate,I.price,P.hsn_code,P.cgst_tax,P.sgst_tax FROM items_orders_social I inner join product P on I.pr_id=P.product_no WHERE I.bill_id ='$orderId' and P.branch='CW1' and P.social_order='1'");
                $rowcount1 = $query1->num_rows();
                if($rowcount1 > 0)
                {
                    foreach ($query1->result() as $item) 
    		        { 
                        $orderitems[] = array(
                        "item_name" => $item->product_name,
                        "basic_rate" => $item->basic_rate,
                        "item_qty" => $item->quantity,
                        "price" => $item->price,
                        "hsn_code" => $item->hsn_code,
                        "cgst_tax" =>$item->cgst_tax,
                        "sgst_tax" =>$item->sgst_tax
                        );
                    } 
                }
                // orders next states 
                $query2=$this->db->query("select socialorder_id,status,status_type from orders_status_log where socialorder_id='$orderId' and log_status='next'");
                $rowcount2 = $query2->num_rows();
                if($rowcount2 > 0)
                {
                    foreach ($query2->result() as $state) 
    		        { 
                        $next_states[] = array(
                        "order_status" => $state->status,
                        "order_id" => $state->socialorder_id,
                        "status_type" => $state->status_type
                        );
                    } 
                }
                
                // Final Data export
                $order_summary[] = array(
                    "chennelname" => $chennel_name,
                    "ordersstatus" => $ordersstatus,
                    "orders_info" =>$orders_info,
                    "orders_items" =>$orderitems,
                    "orders_nextstate" =>$next_states,
                    "globalId" =>$globalorderId
                );
                echo json_encode($order_summary);
            } 
    	}
    	
    	// Orders Items 
    	public function order_details_items() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $orderId = $row['order_id'];
                $query1=$this->db->query("SELECT product_name,quantity, price FROM items_orders_social WHERE bill_id ='$orderId'");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "item_name" => $pay->product_name,
                        "item_qty" => $pay->quantity,
                        "price" => $pay->price
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	// orders Items summary 
    	public function order_details_itemsummary() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $orderId = $row['order_id'];
                $query1=$this->db->query("SELECT order_subtotal as sub_total, total_taxes as tax,order_total as total,discount,merchant_discount,total_charges as charges  FROM social_orders   WHERE socialorder_id='$orderId'");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "subTotal" => $pay->sub_total,
                        "itemTax" => $pay->tax,
                        "totalAmount" => $pay->total,
                        "discountAmt" => $pay->discount,
                        "merchantdiscount_amount" => $pay->merchant_discount,
                        "changres" => $pay->charges
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    	// order status logs
    	public function order_statuslogs() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $orderId = $row['order_id'];
                $query1=$this->db->query("select status,FROM_UNIXTIME(created/1000,'%d-%m-%Y %H:%i %p') as created_date,order_callback_message,cancel_comments from orders_status_log where socialorder_id='$orderId' and order_update_status='success'");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "createdDate" => $pay->created_date,
                        "message" => $pay->order_callback_message,
                        "status" => $pay->status,
                        "comment" =>$pay->cancel_comments
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    	// orders next states
    	public function order_next_states() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $orderId = $row['order_id'];
                $query1=$this->db->query("select socialorder_id,status,status_type from orders_status_log where socialorder_id='$orderId' and log_status='next'");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "order_status" => $pay->status,
                        "order_id" => $pay->socialorder_id,
                        "status_type" => $pay->status_type
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    	
    	// order status logs
    	public function orderlogstatus() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $orderId = $row['order_id'];
                $orderstatus = $row['order_status'];
                if($orderstatus =="Acknowledged") {
                    $query1=$this->db->query("select status_type,socialorder_id from orders_status_log where ((socialorder_id='$orderId') and (status !='$orderstatus'))");
                } else if($orderstatus =="Food Ready") {
                    $query1=$this->db->query("select status_type,socialorder_id from orders_status_log where ((socialorder_id='$orderId') and (status !='$orderstatus' and status !='Acknowledged'))");
                } else if($orderstatus =="Dispatched") {
                    $query1=$this->db->query("select status_type,socialorder_id from orders_status_log where ((socialorder_id='$orderId') and (status !='$orderstatus' and status !='Acknowledged' and status !='Food Ready'))");
                } else if($orderstatus =="Completed") {
                    $query1=$this->db->query("select status_type,socialorder_id from orders_status_log where ((socialorder_id='$orderId') and (status !='$orderstatus' and status !='Acknowledged' and status !='Food Ready'and status !='Dispatched'))");
                } else if($orderstatus =="Cancelled") {
                    $query1=$this->db->query("select status_type,socialorder_id from orders_status_log where ((socialorder_id='$orderId') and (status !='$orderstatus' and status !='Acknowledged' and status !='Food Ready'and status !='Dispatched' and status='Completed'))");
                } else {
                    $query1=$this->db->query("select status_type,socialorder_id from orders_status_log where socialorder_id='$orderId'");
                }
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "status" => $pay->status_type,
                        "order_id" => $pay->socialorder_id
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    public function login_check()
    {
        header('Content-type: application/json');
        $requestData = json_decode(file_get_contents('php://input'), true);
        foreach ($requestData as $row)
        {
           $username = $row['username'];
           $password = $row['password'];
            $query=$this->db->query("SELECT L.userId,L.email,L.roleId,L.branch,L.prime_id,S.store_ref_id FROM users L inner join store S on L.branch=S.branch WHERE ((L.email='$username' and L.prime_id='$password') and  (L.status='Active' and L.roleId ='2'))");
            $rowcount = $query->num_rows();
            $orderType = array();
            if($rowcount > 0)
            {
                foreach ($query->result() as $login) 
		        { 
                    $login = array(
                    "useid" => $login->userId,
                    "email" => $login->email,
                    "roleid" => $login->roleId,
                    "branch" => $login->branch,
                    "store_ref" => $login->store_ref_id,
                    "status" => "success"
                );
                } 
            } else {
                $login = array(
                    "status" => "fail"
                );
            } 
            echo json_encode($login);
        } 
    }
    public function getstoresactions() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $storename = $row['storesname'];
                $query1=$this->db->query("SELECT action,location_ref_id,platform FROM store_actions WHERE location_ref_id='$storename'");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "actions" => $pay->action,
                         "plat" => $pay->platform,
                         "ref_id" => $pay->location_ref_id
                        
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    	// get store status
    	public function getstorestatus() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $storename = $row['storesname'];
                $query1=$this->db->query("SELECT active FROM store WHERE store_ref_id='$storename'");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "active" => $pay->active
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    	// get Items 
    	public function getitems() {
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
               
                $storename = $row['storesname'];
                $query1=$this->db->query("SELECT P.product_no,P.product_name,P.uom,P.basic_tax_amount,P.basic_tax_percent,P.product_status,round(P.basic_rate,2) as basic,P.price,P.product_stock,C.pr_cat_name FROM product P inner join product_category C on P.pr_cat_id=C.pr_cat_code where P.social_order ='1' and P.branch='$storename' GROUP by P.product_name ORDER BY P.product_name ASC");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "pro_id" => $pay->product_no,
                        "product_name" => $pay->product_name,
                         "uom" => $pay->uom,
                        "item_basic" => $pay->basic,
                        "item_tax" => $pay->basic_tax_amount,
                        "basic_tax_percent" => $pay->basic_tax_percent,
                        "total_price" => $pay->price,
                        "product_status" => $pay->product_status,
                        "product_stock" => $pay->product_stock,
                        "pr_cat_name" => $pay->pr_cat_name
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    	public function Item_status_change()
    	{
    	    header('Content-type: application/json');
            $row = json_decode(file_get_contents('php://input'), true);
            $storename = $row['store'];
            $itemstatus = $row['ststatus'];
            $itemIDs = $row['itemID'];
            $store_ref = $row['store_ref'];
            
            $proid = "I-".$itemIDs;
            $item_ref_ids[] = (
                $proid
            );
              $active ="";  
              $pro_status="";
            if($itemstatus =='Active')
            {
                $active = "enable";
                $pro_status = "Active";
            } else {
                $active = "disable";
                $pro_status = "InActive";
            }
            $items_action = array(
                "location_ref_id" => $store_ref,
                "item_ref_ids" => $item_ref_ids,
                "option_ref_ids" =>"",
                "action" => $active
            );
            
            $data_string =  json_encode($items_action);
            //echo $data_string;
            $curl = curl_init('https://biz.urbanpiper.com/hub/api/v1/items/');
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Authorization: apikey biz_adm_clients_MaFUscncGQoP:309a354cbf1601744fb59d27dc8aeb931a183679')
            );
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);
            $result = curl_exec($curl);
            $json = json_decode($result, true);
            curl_close($curl);
            $ref_id = $json["reference_id"];
            $status = $json["status"];
            
            //echo $ref_id;
            //echo $status;
           if($ref_id !='' && $status !='') 
            {
               //echo "hi";
                 $query1=$this->db->query("update product set product_status='$pro_status',item_reference_id='$ref_id',item_action_status='processing' where ((product_no='$itemIDs') and (social_order ='1' and branch='$storename'))"); 
            }
            
            $response_date = array(
                "ref_id" => $ref_id,
                "status" =>$status
            );
            echo json_encode($response_date);
    	}
    	
    	// new orders placed
        public function new_orders_placed()
    	{
    	    $current_date = date('Y-m-d');
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("SELECT S.socialorder_id,S.invoice_no,S.invoice_date,S.invoice_time,S.agreID,S.channel,S.created, S.delivery_datetime,S.store_id,S.order_total,S.name,phone,S.email,S.line_1,S.line_2,S.order_state,S.cancelled_by,S.order_subtotal as sub_total, S.total_taxes as tax,S.order_total as total,S.discount,S.merchant_discount,S.total_charges as charges,S.next_state,S.order_type,S.instructions,O.branch_title,O.org_name,O.land_no,O.gstin_no,O.website_name,O.address1,O.address2,O.cin_no,S.merchant_ref_id FROM social_orders S inner join outlet_deatils O on S.branch=O.branch where ((S.store_id='$branch' and S.orders_date='$current_date') and (S.order_state='Placed'))");
                foreach ($query1->result() as $pay) 
		        { 
                    $query2=$this->db->query("SELECT I.product_name,I.quantity,I.basic_rate,I.price,P.hsn_code,P.cgst_tax,P.sgst_tax FROM items_orders_social I inner join product P on I.pr_id=P.product_no WHERE I.bill_id ='$pay->socialorder_id' and P.social_order='1' group BY I.product_name");
                    foreach ($query2->result() as $item) 
    		        { 
                        $items[] = array(
                        "item_name" => $item->product_name,
                        "item_qty" => $item->quantity,
                        "price" => $item->price,
                        "orderno" =>$pay->socialorder_id,
                        "basic_rate" => $item->basic_rate,
                        "hsn_code" => $item->hsn_code,
                        "cgst_tax" =>$item->cgst_tax,
                        "sgst_tax" =>$item->sgst_tax
                        );
                    } 
                    
                    $message = '';
                    if($pay->next_state =='Acknowledged')
                    {
                        $message = 'Order Accepted From Restaurant';
                    } else if($pay->next_state =='Food Ready')
                    {
                        $message = 'Food Ready From Restaurant';
                    } else if($pay->next_state =='Dispatched')
                    {
                        $message = 'Dispatched From Restaurant';
                    } else if($pay->next_state =='Completed')
                    {
                        $message = 'Order Completed From Restaurant';
                    }
                    $next_status[] = array(
                        "present_status" => $pay->order_state,
                        "social_order_id" => $pay->socialorder_id,
                        "next_state" => $pay->next_state,
                        "message" =>$message
                    );
		            $cr_date = date('h:i A', floor($pay->created / 1000));
		            $dl_date = date('h:i A', floor($pay->delivery_datetime / 1000));
		            $in_date = date("d-m-Y", strtotime($pay->invoice_date));
		            $in_time = date("h:i A", strtotime($pay->invoice_time));
		            $placed_time = date('d-m-Y h:i A', floor($pay->created / 1000));
                    $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "channelId" => $pay->agreID,
                        "chennel_name" => $pay->channel,
                        "created_date" => $cr_date,
                        "delivery" => $dl_date,
                        "storeId" => $pay->store_id,
                        "order_amount" => round($pay->order_total,2),
                        "customer_name" => $pay->name,
                        "customer_phone" => $pay->phone,
                        "orders_status" => $pay->order_state,
                        "sub_Total" => $pay->sub_total,
                        "item_Tax" => $pay->tax,
                        "totalAmount" => $pay->total,
                        "discountAmt" => $pay->discount,
                        "merchantdiscount_amount" => $pay->merchant_discount,
                        "changres" => $pay->charges,
                        "cancelled" =>  "",
                        "items" =>$items,
                        "nextstatus" =>$next_status,
                        "invoice_no" => $pay->invoice_no,
                        "invoice_date" => $in_date,
                        "invoice_time" => $in_time,
                        "org_name" => $pay->org_name,
                        "branch_title" => $pay->branch_title,
                        "landline_no" => $pay->land_no,
                        "website_name" => $pay->website_name,
                        "gst_no" => $pay->gstin_no,
                        "cin_no" => $pay->cin_no,
                        "address_line1" => $pay->address1,
                        "address_line2" => $pay->address2,
                        // Urban piper order summary 
                        "orders_placed" => $placed_time,
                        "urbanpiper_id" => $pay->socialorder_id,
                        "marchant_ref" => $pay->merchant_ref_id,
                        "payment_nmode" => $pay->channel, // note
                        "channel" =>$pay->channel,
                        "pulfilment_mode" => $pay->order_type,
                        "oulet_name" => $pay->store_id,
                        // Platform Details
                        "Platform" => $pay->channel."             (Message :  ".$pay->instructions."  )",
                        "platform_id" =>$pay->agreID,
                        // Delivery Details
                        "delivery_person"=> "",
                        "delivery_phone"=> "",
                        "delivery_channel"=> "",
                        "delivery_mode"=> "",
                        //"delivery_time"=>$dl_date,
                        // customer Details
                        "customer_email" =>$pay->email,
                        "address1" => $pay->line_1,
                        "address2" => $pay->line_2,
                        "order_status" =>$pay->order_state,
                        "instructions" =>$pay->instructions,
                        "order_type" => $pay->order_type,
                        "changres" => $pay->total_charges
                        );
                    } 
                     echo json_encode($head);
                }
    	    }
    	// In-progress - orders
    	public function inprogess_orders()
    	{
    	    $current_date = date('Y-m-d');
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("SELECT S.socialorder_id,S.invoice_no,S.invoice_date,S.invoice_time,S.agreID,S.channel,S.created, S.delivery_datetime,S.store_id,S.order_total,S.name,phone,S.email,S.line_1,S.line_2,S.order_state,S.cancelled_by,S.order_subtotal as sub_total, S.total_taxes as tax,S.order_total as total,S.discount,S.merchant_discount,S.total_charges as charges,S.next_state,S.order_type,S.instructions,O.branch_title,O.org_name,O.land_no,O.gstin_no,O.website_name,O.address1,O.address2,O.cin_no,S.merchant_ref_id FROM social_orders S inner join outlet_deatils O on S.branch=O.branch where ((S.store_id='$branch' and S.orders_date='$current_date') and (S.order_state='Dispatched' or S.order_state='Acknowledged' or S.order_state='Food Ready'))");
                foreach ($query1->result() as $pay) 
		        { 
                    $query2=$this->db->query("SELECT I.product_name,I.quantity,I.basic_rate,I.price,P.hsn_code,P.cgst_tax,P.sgst_tax FROM items_orders_social I inner join product P on I.pr_id=P.product_no WHERE I.bill_id ='$pay->socialorder_id' and P.social_order='1' group BY I.product_name");
                    foreach ($query2->result() as $item) 
    		        { 
                        $items[] = array(
                        "item_name" => $item->product_name,
                        "item_qty" => $item->quantity,
                        "price" => $item->price,
                        "orderno" =>$pay->socialorder_id,
                        "basic_rate" => $item->basic_rate,
                        "hsn_code" => $item->hsn_code,
                        "cgst_tax" =>$item->cgst_tax,
                        "sgst_tax" =>$item->sgst_tax
                        );
                    } 
                    
                    $message = '';
                    if($pay->next_state =='Acknowledged')
                    {
                        $message = 'Order Accepted From Restaurant';
                    } else if($pay->next_state =='Food Ready')
                    {
                        $message = 'Food Ready From Restaurant';
                    } else if($pay->next_state =='Dispatched')
                    {
                        $message = 'Dispatched From Restaurant';
                    } else if($pay->next_state =='Completed')
                    {
                        $message = 'Order Completed From Restaurant';
                    }
                    $next_status[] = array(
                        "present_status" => $pay->order_state,
                        "social_order_id" => $pay->socialorder_id,
                        "next_state" => $pay->next_state,
                        "message" =>$message
                    );
		            $cr_date = date('h:i A', floor($pay->created / 1000));
		            $dl_date = date('h:i A', floor($pay->delivery_datetime / 1000));
		            $in_date = date("d-m-Y", strtotime($pay->invoice_date));
		            $in_time = date("h:i A", strtotime($pay->invoice_time));
		            $placed_time = date('d-m-Y h:i A', floor($pay->created / 1000));
                    $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "channelId" => $pay->agreID,
                        "chennel_name" => $pay->channel,
                        "created_date" => $cr_date,
                        "delivery" => $dl_date,
                        "storeId" => $pay->store_id,
                        "order_amount" => round($pay->order_total,2),
                        "customer_name" => $pay->name,
                        "customer_phone" => $pay->phone,
                        "orders_status" => $pay->order_state,
                        "sub_Total" => $pay->sub_total,
                        "item_Tax" => $pay->tax,
                        "totalAmount" => $pay->total,
                        "discountAmt" => $pay->discount,
                        "merchantdiscount_amount" => $pay->merchant_discount,
                        "changres" => $pay->charges,
                        "cancelled" =>  "",
                        "items" =>$items,
                        "nextstatus" =>$next_status,
                        "invoice_no" => $pay->invoice_no,
                        "invoice_date" => $in_date,
                        "invoice_time" => $in_time,
                        "org_name" => $pay->org_name,
                        "branch_title" => $pay->branch_title,
                        "landline_no" => $pay->land_no,
                        "website_name" => $pay->website_name,
                        "gst_no" => $pay->gstin_no,
                        "cin_no" => $pay->cin_no,
                        "address_line1" => $pay->address1,
                        "address_line2" => $pay->address2,
                        // Urban piper order summary 
                        "orders_placed" => $placed_time,
                        "urbanpiper_id" => $pay->socialorder_id,
                        "marchant_ref" => $pay->merchant_ref_id,
                        "payment_nmode" => $pay->channel, // note
                        "channel" =>$pay->channel,
                        "pulfilment_mode" => $pay->order_type,
                        "oulet_name" => $pay->store_id,
                        // Platform Details
                        "Platform" => $pay->channel."             (Message :  ".$pay->instructions."  )",
                        "platform_id" =>$pay->agreID,
                        // Delivery Details
                        "delivery_person"=> "",
                        "delivery_phone"=> "",
                        "delivery_channel"=> "",
                        "delivery_mode"=> "",
                        //"delivery_time"=>$dl_date,
                        // customer Details
                        "customer_email" =>$pay->email,
                        "address1" => $pay->line_1,
                        "address2" => $pay->line_2,
                        "order_status" =>$pay->order_state,
                        "instructions" =>$pay->instructions,
                        "order_type" => $pay->order_type,
                        "changres" => $pay->total_charges
                        );
                    } 
                     echo json_encode($head);
                }
    	    }
    	    
    	// completed - orders
    	public function completed_orders()
    	{
    	    $current_date = date('Y-m-d');
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("SELECT S.socialorder_id,S.invoice_no,S.invoice_date,S.invoice_time,S.agreID,S.channel,S.created, S.delivery_datetime,S.store_id,S.order_total,S.name,phone,S.email,S.line_1,S.line_2,S.order_state,S.cancelled_by,S.order_subtotal as sub_total, S.total_taxes as tax,S.order_total as total,S.discount,S.merchant_discount,S.total_charges as charges,S.next_state,S.order_type,S.instructions,O.branch_title,O.org_name,O.land_no,O.gstin_no,O.website_name,O.address1,O.address2,O.cin_no,S.merchant_ref_id FROM social_orders S inner join outlet_deatils O on S.branch=O.branch where S.store_id='$branch' and S.orders_date='$current_date' and S.order_state='Completed'");
                foreach ($query1->result() as $pay) 
		        { 
                    $query2=$this->db->query("SELECT I.product_name,I.quantity,I.basic_rate,I.price,P.hsn_code,P.cgst_tax,P.sgst_tax FROM items_orders_social I inner join product P on I.pr_id=P.product_no WHERE I.bill_id ='$pay->socialorder_id' and P.social_order='1' group BY I.product_name");
                    foreach ($query2->result() as $item) 
    		        { 
                        $items[] = array(
                        "item_name" => $item->product_name,
                        "item_qty" => $item->quantity,
                        "price" => $item->price,
                        "orderno" =>$pay->socialorder_id,
                        "basic_rate" => $item->basic_rate,
                        "hsn_code" => $item->hsn_code,
                        "cgst_tax" =>$item->cgst_tax,
                        "sgst_tax" =>$item->sgst_tax
                        );
                    } 
                    $message = '';
                    if($pay->next_state =='Acknowledged')
                    {
                        $message = 'Order Accepted From Restaurant';
                    } else if($pay->next_state =='Food Ready')
                    {
                        $message = 'Food Ready From Restaurant';
                    } else if($pay->next_state =='Dispatched')
                    {
                        $message = 'Dispatched From Restaurant';
                    } else if($pay->next_state =='Completed')
                    {
                        $message = 'Order Completed From Restaurant';
                    }
                    $next_status[] = array(
                        "present_status" => $pay->order_state,
                        "social_order_id" => $pay->socialorder_id,
                        "next_state" => $pay->next_state,
                        "message" =>$message
                    );
		            $cr_date = date('h:i A', floor($pay->created / 1000));
		            $dl_date = date('h:i A', floor($pay->delivery_datetime / 1000));
		            $in_date = date("d-m-Y", strtotime($pay->invoice_date));
		            $in_time = date("h:i A", strtotime($pay->invoice_time));
		            $placed_time = date('d-m-Y h:i A', floor($pay->created / 1000));
                    $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "channelId" => $pay->agreID,
                        "chennel_name" => $pay->channel,
                        "created_date" => $cr_date,
                        "delivery" => $dl_date,
                        "storeId" => $pay->store_id,
                        "order_amount" => round($pay->order_total,2),
                        "customer_name" => $pay->name,
                        "customer_phone" => $pay->phone,
                        "orders_status" => $pay->order_state,
                        "sub_Total" => $pay->sub_total,
                        "item_Tax" => $pay->tax,
                        "totalAmount" => $pay->total,
                        "discountAmt" => $pay->discount,
                        "merchantdiscount_amount" => $pay->merchant_discount,
                        "changres" => $pay->charges,
                        "cancelled" =>  "",
                        "items" =>$items,
                        "nextstatus" =>$next_status,
                        "invoice_no" => $pay->invoice_no,
                        "invoice_date" => $in_date,
                        "invoice_time" => $in_time,
                        "org_name" => $pay->org_name,
                        "branch_title" => $pay->branch_title,
                        "landline_no" => $pay->land_no,
                        "website_name" => $pay->website_name,
                        "gst_no" => $pay->gstin_no,
                        "cin_no" => $pay->cin_no,
                        "address_line1" => $pay->address1,
                        "address_line2" => $pay->address2,
                        // Urban piper order summary 
                        "orders_placed" => $placed_time,
                        "urbanpiper_id" => $pay->socialorder_id,
                        "marchant_ref" => $pay->merchant_ref_id,
                        "payment_nmode" => $pay->channel, // note
                        "channel" =>$pay->channel,
                        "pulfilment_mode" => $pay->order_type,
                        "oulet_name" => $pay->store_id,
                        // Platform Details
                        "Platform" => $pay->channel."             (Message :  ".$pay->instructions."  )",
                        "platform_id" =>$pay->agreID,
                        // Delivery Details
                        "delivery_person"=> "",
                        "delivery_phone"=> "",
                        "delivery_channel"=> "",
                        "delivery_mode"=> "",
                        //"delivery_time"=>$dl_date,
                        // customer Details
                        "customer_email" =>$pay->email,
                        "address1" => $pay->line_1,
                        "address2" => $pay->line_2,
                        "order_status" =>$pay->order_state,
                        "instructions" =>$pay->instructions,
                        "order_type" => $pay->order_type,
                        "changres" => $pay->total_charges
                        );
                    } 
                     echo json_encode($head);
                }
    	    }
    	 
    	    
    	// Cancelled - orders
    	public function cancelled_orders()
    	{
    	    $current_date = date('Y-m-d');
    	    $orders_cancelled ='0';
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("SELECT S.socialorder_id,S.invoice_no,S.invoice_date,S.invoice_time,S.agreID,S.channel,S.created, S.delivery_datetime,S.store_id,S.order_total,S.name,phone,S.email,S.line_1,S.line_2,S.order_state,S.cancelled_by,S.order_subtotal as sub_total, S.total_taxes as tax,S.order_total as total,S.discount,S.merchant_discount,S.total_charges as charges,S.next_state,S.order_type,S.instructions,O.branch_title,O.org_name,O.land_no,O.gstin_no,O.website_name,O.address1,O.address2,O.cin_no,S.merchant_ref_id FROM social_orders S inner join outlet_deatils O on S.branch=O.branch where S.store_id='$branch' and S.orders_date='$current_date' and S.order_state='Cancelled'");
                foreach ($query1->result() as $pay) 
		        { 
                    $query2=$this->db->query("SELECT I.product_name,I.quantity,I.basic_rate,I.price,P.hsn_code,P.cgst_tax,P.sgst_tax FROM items_orders_social I inner join product P on I.pr_id=P.product_no WHERE I.bill_id ='$pay->socialorder_id' and P.social_order='1' group BY I.product_name");
                    foreach ($query2->result() as $item) 
    		        { 
                        $items[] = array(
                        "item_name" => $item->product_name,
                        "item_qty" => $item->quantity,
                        "price" => $item->price,
                        "orderno" =>$pay->socialorder_id,
                        "basic_rate" => $item->basic_rate,
                        "hsn_code" => $item->hsn_code,
                        "cgst_tax" =>$item->cgst_tax,
                        "sgst_tax" =>$item->sgst_tax
                        );
                    } 
                    if($pay->order_state =="Cancelled" && $pay->cancelled_by =="outlet")
                    {
                        $orders_cancelled ="oulets";
                        
                    } else if($pay->order_state =="Cancelled" && $pay->cancelled_by =="0")
                    {
                        $orders_cancelled = "Aggregator";
                    } else {
                        $orders_cancelled = "0";
                    }
                    
                    $message = '';
                    if($pay->next_state =='Acknowledged')
                    {
                        $message = 'Order Accepted From Restaurant';
                    } else if($pay->next_state =='Food Ready')
                    {
                        $message = 'Food Ready From Restaurant';
                    } else if($pay->next_state =='Dispatched')
                    {
                        $message = 'Dispatched From Restaurant';
                    } else if($pay->next_state =='Completed')
                    {
                        $message = 'Order Completed From Restaurant';
                    }
                    $next_status[] = array(
                        "present_status" => $pay->order_state,
                        "social_order_id" => $pay->socialorder_id,
                        "next_state" => $pay->next_state,
                        "message" =>$message
                    );
		            $cr_date = date('h:i A', floor($pay->created / 1000));
		            $dl_date = date('h:i A', floor($pay->delivery_datetime / 1000));
		            $in_date = date("d-m-Y", strtotime($pay->invoice_date));
		            $in_time = date("h:i A", strtotime($pay->invoice_time));
		            $placed_time = date('d-m-Y h:i A', floor($pay->created / 1000));
                    $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "channelId" => $pay->agreID,
                        "chennel_name" => $pay->channel,
                        "created_date" => $cr_date,
                        "delivery" => $dl_date,
                        "storeId" => $pay->store_id,
                        "order_amount" => round($pay->order_total,2),
                        "customer_name" => $pay->name,
                        "customer_phone" => $pay->phone,
                        "orders_status" => $pay->order_state,
                        "sub_Total" => $pay->sub_total,
                        "item_Tax" => $pay->tax,
                        "totalAmount" => $pay->total,
                        "discountAmt" => $pay->discount,
                        "merchantdiscount_amount" => $pay->merchant_discount,
                        "changres" => $pay->charges,
                        "cancelled" =>  $orders_cancelled,
                        "items" =>$items,
                        "nextstatus" =>$next_status,
                        "invoice_no" => $pay->invoice_no,
                        "invoice_date" => $in_date,
                        "invoice_time" => $in_time,
                        "org_name" => $pay->org_name,
                        "branch_title" => $pay->branch_title,
                        "landline_no" => $pay->land_no,
                        "website_name" => $pay->website_name,
                        "gst_no" => $pay->gstin_no,
                        "cin_no" => $pay->cin_no,
                        "address_line1" => $pay->address1,
                        "address_line2" => $pay->address2,
                        // Urban piper order summary 
                        "orders_placed" => $placed_time,
                        "urbanpiper_id" => $pay->socialorder_id,
                        "marchant_ref" => $pay->merchant_ref_id,
                        "payment_nmode" => $pay->channel, // note
                        "channel" =>$pay->channel,
                        "pulfilment_mode" => $pay->order_type,
                        "oulet_name" => $pay->store_id,
                        // Platform Details
                        "Platform" => $pay->channel."             (Message :  ".$pay->instructions."  )",
                        "platform_id" =>$pay->agreID,
                        // Delivery Details
                        "delivery_person"=> "",
                        "delivery_phone"=> "",
                        "delivery_channel"=> "",
                        "delivery_mode"=> "",
                        //"delivery_time"=>$dl_date,
                        // customer Details
                        "customer_email" =>$pay->email,
                        "address1" => $pay->line_1,
                        "address2" => $pay->line_2,
                        "order_status" =>$pay->order_state,
                        "instructions" =>$pay->instructions,
                        "order_type" => $pay->order_type,
                        "changres" => $pay->total_charges
                        );
                    } 
                     echo json_encode($head);
                }
    	    }
    	    
    	    
    	
    	public function order_placed_test_new() {
             $current_date = date('Y-m-d');
             //$current_date = "2021-12-07";
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            $orders_cancelled ='0';
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("SELECT socialorder_id,agreID,channel,created, delivery_datetime,store_id,order_total,name,phone,order_state,cancelled_by,order_subtotal as sub_total, total_taxes as tax,order_total as total,discount,merchant_discount,total_charges as charges FROM social_orders where store_id='$branch' and orders_date='$current_date'");
                     
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        if($pay->order_state =="Cancelled" && $pay->cancelled_by =="outlet")
                        {
                            $orders_cancelled ="oulets";
                            
                        } else if($pay->order_state =="Cancelled" && $pay->cancelled_by =="0")
                        {
                            $orders_cancelled = "Aggregator";
                        } else {
                            $orders_cancelled = "0";
                        }
                        // fetch items 
                        $query2=$this->db->query("SELECT product_name,quantity, price FROM items_orders_social WHERE bill_id ='$pay->socialorder_id'");
                        $rowcount1 = $query2->num_rows();
                        if($rowcount1 > 0)
                        {
                            foreach ($query2->result() as $item) 
            		        { 
                                $items[] = array(
                                "item_name" => $item->product_name,
                                "item_qty" => $item->quantity,
                                "price" => $item->price,
                                "orderno" =>$pay->socialorder_id
                                );
                            } 
                        }
                        
                        $query3=$this->db->query("select socialorder_id,status,status_type from orders_status_log where socialorder_id='$pay->socialorder_id' and log_status='next'");
                        $rowcount3 = $query3->num_rows();
                        if($rowcount3 > 0)
                        {
                            foreach ($query3->result() as $status) 
            		        { 
                                $next_status[] = array(
                                "order_status" => $status->status,
                                "order_id" => $status->socialorder_id,
                                "status_type" => $status->status_type,
                                "refno" =>$pay->socialorder_id
                                );
                            } 
                        }
                
    		            $cr_date = date('h:i A', floor($pay->created / 1000));
    		            $dl_date = date('h:i A', floor($pay->delivery_datetime / 1000));
                        $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "channelId" => $pay->agreID,
                        "chennel_name" => $pay->channel,
                        "created_date" => $cr_date,
                        "delivery" => $dl_date,
                        "storeId" => $pay->store_id,
                        "order_amount" => round($pay->order_total,2),
                        "customer_name" => $pay->name,
                        "customer_phone" => $pay->phone,
                        "orders_status" => $pay->order_state,
                        "subTotal" => $pay->sub_total,
                        "itemTax" => $pay->tax,
                        "totalAmount" => $pay->total,
                        "discountAmt" => $pay->discount,
                        "merchantdiscount_amount" => $pay->merchant_discount,
                        "changres" => $pay->charges,
                        "cancelled" =>  $orders_cancelled,
                        "items" =>$items,
                        "nextstatus" =>$next_status
                        
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	} 
    	
    	public function order_placed_test() {
              $current_date = date('Y-m-d');
            // $current_date = "2021-08-29";
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            $orders_cancelled ='0';
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("SELECT socialorder_id,agreID,channel, created, delivery_datetime,store_id,order_total,name,phone,order_state,cancelled_by FROM social_orders where store_id='$branch' and orders_date='$current_date'");
                     
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        if($pay->order_state =="Cancelled" && $pay->cancelled_by =="outlet")
                        {
                            $orders_cancelled ="oulets";
                            
                        } else if($pay->order_state =="Cancelled" && $pay->cancelled_by =="0")
                        {
                            $orders_cancelled = "Aggregator";
                        } else {
                            $orders_cancelled = "0";
                        }
    		            $cr_date = date('h:i A', floor($pay->created / 1000));
    		            $dl_date = date('h:i A', floor($pay->delivery_datetime / 1000));
                        $head[] = array(
                        "orderId" => $pay->socialorder_id,
                        "channelId" => $pay->agreID,
                        "chennel_name" => $pay->channel,
                        "created_date" => $cr_date,
                        "delivery" => $dl_date,
                        "storeId" => $pay->store_id,
                        "order_amount" => round($pay->order_total,2),
                        "customer_name" => $pay->name,
                        "customer_phone" => $pay->phone,
                        "orders_status" => $pay->order_state,
                        "cancelled" =>  $orders_cancelled
                        
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	} 
    	
    	// orders total 
    	public function order_total_new() {
    	    $placed_total = 0;
    	    $completed_total=0;
    	    $cancelled_total=0;
    	    $others_total=0;
           $current_date = date('Y-m-d');
            //$current_date = "2021-12-07";
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("select A.placed as new_orders,B.other as progress,C.complete as completed,D.cancel as cancelled from (SELECT IFNULL(count(socialorder_id),0) as placed  from  social_orders where (invoice_date = '$current_date' and store_id='$branch') and order_state='Placed') A join (SELECT IFNULL(count(socialorder_id),0) as other  from  social_orders where ((invoice_date = '$current_date' and store_id='$branch') and (order_state ='Food Ready' or order_state ='Dispatched' or order_state ='Acknowledged'))) B join (SELECT IFNULL(count(socialorder_id),0) as complete  from  social_orders where (invoice_date = '$current_date' and store_id='$branch') and order_state='Completed') C  join (SELECT IFNULL(count(socialorder_id),0) as cancel  from  social_orders where (invoice_date = '$current_date') and order_state='Cancelled' and store_id='$branch') D");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "placed" => $pay->new_orders,
                        "progress" => $pay->progress,
                        "completed" => $pay->completed,
                        "cancelled" => $pay->cancelled
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    	// orders total 
    	public function order_total() {
    	    $placed_total = 0;
    	    $completed_total=0;
    	    $cancelled_total=0;
    	    $others_total=0;
            $current_date = date('Y-m-d');
            //$current_date = "2021-08-08";
        	header('Content-type: application/json');
            $requestData = json_decode(file_get_contents('php://input'), true);
            foreach ($requestData as $row)
            {
                $branch = $row['storesname'];
                $query1=$this->db->query("select A.placed as new_orders,B.other as progress,C.complete as completed,D.cancel as cancelled from (SELECT IFNULL(count(socialorder_id),0) as placed  from  social_orders where (invoice_date = '$current_date' and store_id='$branch') and order_state='Placed') A join (SELECT IFNULL(count(socialorder_id),0) as other  from  social_orders where ((invoice_date = '$current_date' and store_id='$branch') and (order_state ='Food Ready' or order_state ='Dispatched' or order_state ='Acknowledged'))) B join (SELECT IFNULL(count(socialorder_id),0) as complete  from  social_orders where (invoice_date = '$current_date' and store_id='$branch') and order_state='Completed') C  join (SELECT IFNULL(count(socialorder_id),0) as cancel  from  social_orders where (invoice_date = '$current_date') and order_state='Cancelled' and store_id='$branch') D");
                $rowcount = $query1->num_rows();
                $orderType = array();
                if($rowcount > 0)
                {
                    foreach ($query1->result() as $pay) 
    		        { 
                        $head[] = array(
                        "placed" => $pay->new_orders,
                        "progress" => $pay->progress,
                        "completed" => $pay->completed,
                        "cancelled" => $pay->cancelled
                        );
                    } 
                }
                echo json_encode($head);
            } 
    	}
    	
    	// Test
    	
    	 
        // urbanpiper conigration
        public function urbanpiperconfig($mid)
		{
		    $branchname = $this->input->post('branch_name');
		    $config_type = $this->input->post('config_type');
		    $storerefid='';
		    if($branchname == 'CW1')
		    {
		        $storerefid = 'cakewala_1';
		        
		    }else if($branchname == 'CW2') {
		        
		        $storerefid = 'cakewala_2';
		        
		    }else if($branchname == 'CW3') {
		        
		        $storerefid = 'cakewala_3';
		        
		    }else if($branchname == 'CW4') {
		        
		        $storerefid = 'cakewala_4';
		        
		    }else if($branchname == 'CW5') {
		        
		        $storerefid = 'cakewala_5';  
		    }
		    if($config_type == "new_config"){
		        
		        $storesupdate = $this->urban_model->add_update_store_data();
		        $catlogue = $this->urban_model->get_catalogue_api();
		        $taxes = $this->urban_model->get_taxes_api();
		        
		    } else if($config_type == "catalogue_config")
		    {
		        $final_status='';
		        $final_ref_id='';
		        $query = $this->db->query("update store set  active='true',process_status='pending' where branch = '$branchname'");
    		    $total = $this->db->affected_rows();
            	if($total>0)
            	{
		            $cataloguemain = array();
                    $catalogue = array();
                    $categories = array();
                    $items = array();
                    $category_ref_ids = array();
                    $included_platforms = array();
                    $item_ref_ids = array();
                    $item_ref_idss = array();
                    
                    
                    $storedata=$this->db->query("SELECT store_ref_id,branch FROM store where active='true' and process_status='pending'");
                    $storecount = $storedata->num_rows();
                    if($storecount > 0)
                    {
                        foreach ($storedata->result() as $stores) 
                        { 
                            $store_ref_id = $stores->store_ref_id;
                            $branchs = $stores->branch;
                        
                            $query1=$this->db->query("SELECT C.pr_cat_name,C.status,C.pr_cat_code,C.branch FROM product_category C inner join product P on C.pr_cat_code=P.pr_cat_id WHERE ((P.social_order ='1' and P.branch='$branchs') and (P.fd_status='pending')) group by C.pr_cat_code");
                            unset($category_ref_ids);
                            foreach ($query1->result() as $cats)
                            { 
                                $catid = $cats->pr_cat_code;
                                $cat_branch = $cats->branch;
                                $ct_re_id = "C-".$cats->pr_cat_code;
                                if($cats->status =='Active')
                                {
                                    $actives = true;
                                }else{
                                    $actives = false;
                                }
                                $cat_desc = "famous-".$cats->pr_cat_name;
                                $categories[] = array(
                                    "ref_id" => $ct_re_id,
                                    "name" => $cats->pr_cat_name,
                                    "description" => $cat_desc,
                                    "sort_order"=> $cats->pr_cat_code,
                                    "active" => $actives
                                );
                                $category_ref_ids = array(
                                    $ct_re_id
                                );
                                $included_platforms = array(
                                    "zomato",
                                    "swiggy"
                                );
                                // items
                                $query2=$this->db->query("SELECT product_no,product_name,cgst_tax,basic_tax_percent,product_status,round(basic_rate,2) as prices,product_stock,product_image,product_type FROM product where ((social_order ='1' and branch='$branchs') and (pr_cat_id='$catid' and fd_status='pending')) ORDER BY product_name ASC");
                                foreach ($query2->result() as $prod)
                                {
                                    $proid = $prod->product_no;
                                    $re_id = "I-".$prod->product_no;
                                    if($prod->product_status =='Active')
                                    {
                                        $active = true;
                                        
                                    } else {
                                        $active = false;
                                    }
                                    if($prod->product_stock =='0')
                                    {
                                        $stock = -1;  
                                    } else {
                                        $stock = $prod->product_stock;
                                    }
                                    // $img = array(
                                    //     "tag"=> "default",
                                    //     "url"=> $prod->product_image
                                    // );
                                    $item_desc = $prod->product_name." available in small and large sizes";
                                    $prices =$prod->prices;
                                    $pname = $prod->product_name;
                                    $query20=$this->db->query("SELECT round(basic_rate,2) as prices FROM product where product_name='$pname' and social_order !='1' and branch='$branchs'");
                                    $web_prices= 0;
                                    foreach ($query20->result() as $prod1)
                                    {
                                        $web_prices = $prod1->prices;
                                    }   
                                    $items[] = array(
                                        "ref_id" =>  $re_id,
                                        "title" => $prod->product_name,
                                        "available" => $active,
                                        "description" => $item_desc,
                                        "sold_at_store" => true,
                                        "sort_order"=> $prod->product_no,
                                        // "external_price" => number_format((float)$prices, 2, '.', ''),
                                        // "price" =>  number_format((float)$web_prices, 2, '.', ''),
                                        "external_price" => floatval($prices),
                                         "price" =>  floatval($web_prices),
                                        "markup_price" => 0,
                                        "current_stock" => $stock,
                                        "recommended" => true,
                                        "img_url" =>$prod->product_image,
                                        "food_type" => $prod->product_type,
                                        "category_ref_ids" => $category_ref_ids,
                                        "included_platforms" => $included_platforms
                                    ); 
                                }
                            }    
                            $catalogue = array(
                                "flush_categories" => false,
                                "categories" => $categories,
                                "flush_items" => false,
                                "items" => $items
                            );
                            $data_string =  json_encode($catalogue);
                            //echo $data_string;
                            $curl = curl_init('https://api.urbanpiper.com/external/api/v1/inventory/locations/'.$store_ref_id.'/');
                            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
                            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                            'Content-Type: application/json',
                            'Authorization: apikey biz_adm_clients_MaFUscncGQoP:309a354cbf1601744fb59d27dc8aeb931a183679')
                            );
                            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);
                            $result = curl_exec($curl);
                            $json = json_decode($result, true);
                            curl_close($curl);
                            $ref_id = $json["reference"];
                            $status = $json["status"];
                            //$final_status=$json["reference"];
		                    //$final_ref_id=$json["status"];
                            //echo $ref_id;
                            //echo $status;
                            if($ref_id !='' && $status !='') 
                            {
                                //echo "entered";
                                $query = $this->db->query("update product_category set catalouge_reference='$ref_id', catalouge_status='processing' where catalouge_status ='pending'");
                                $query2 = $this->db->query("update product set catalouge_refrence='$ref_id', catalogue_status='processing',fd_status='processing' where catalogue_status ='pending' and fd_status='pending' and branch='$branchs'");
                            
                                $this->session->set_flashdata('message','<div class="alert alert-success alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Catalouge Updation : '.$status.'  REF ID   : '.$ref_id.'</div>');
                                redirect('User_section/urbanpiper_config/'.$mid.'');
                            } else {
                                $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Catalouge Updation Failed</div>');
                                redirect('User_section/urbanpiper_config/'.$mid.'');
                            }
                        }
                    } 
                    else {
                        $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Not Found</div>');
                    } // else end
                } else {
                    $this->session->set_flashdata('message','<div class="alert alert-danger alert-dismissable"><button class="close" aria-hidden="true" data-dismiss="alert" type="button">×</button> Store Not in Active</div>');
                }
		    }
        	
		}
    }
?>