<?php
class Master_model extends CI_Model
{
	public function __construct()
	{
		parent:: __construct();
		$this->load->database();
	}
	
	// Check Role Exist
	public function checkRoleExist($name)
	{
		$q=$this->db->query("select * from roles where role = '$name'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	// Add new Role data info 
	public function addNewRolers($userInfo)
	{
		$this->db->trans_start();
		$sql = "INSERT INTO roles(role) VALUES (?)";
		$this->db->query($sql, $userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}
	// Get Role Data List
	public function role_list()
	{
		$query=$this->db->query("SELECT BaseTbl.roleId, BaseTbl.role from roles as BaseTbl");
		$result = $query->result();
		return $result;
	}
	// get products Edited info
	public function getRoleInfo($roleId)
	{
		$query=$this->db->query("SELECT roleId,role from roles where roleId='$roleId'");
		$result = $query->result();
		return $result;
	}

	// update role edited info
	public function editRoleDetails($userInfo, $roleId)
	{
		$this->db->where('roleId', $roleId);
		$this->db->update('roles', $userInfo);
		return TRUE;
	}

	// Check role exist
	public function roleChildExist($roleId)
	{
		$q = $this->db->query("SELECT a.roleId FROM users a, roles b WHERE a.roleId = b.roleId and b.roleId = ".$roleId);
        if ($q->num_rows() > 0)
            return 1;
        else
            return 0;
	}

	// Delete Role
	public function deleteRole($roleId)
	{
		$this->db->query("delete from roles where roleId ='$roleId'");
		$total = $this->db->affected_rows();
        if($total>0)
            return true;
        else
            return false;
	}

	// User List
	public function userList($client_id)
	{
		if(empty($client_id))
		{
			$query=$this->db2->query("select a.*, b.*, c.client_name from users a, roles b, client_creation c where a.roleId = b.roleId and a.client_id = c.client_id and b.role = 'USER'");
			$result = $query->result();
			return $result;		
		}
		else
		{
			$query=$this->db2->query("select a.*, b.*, c.client_name from users a, roles b, client_creation c where a.roleId = b.roleId and a.client_id = c.client_id and b.role = 'USER' and a.client_id = $client_id");
			$result = $query->result();
			return $result;			
		}
	}

	// Active User List
	public function activeuserList()
	{
		$query=$this->db->query("select * from users where status = 'Active' and effective_from <= CURDATE()");
		$result = $query->result();
		return $result;	
	}

	// Check if user already exist or not
	public function checkEmailExists($email, $userId = 0)
	{
		$this->db->select("email");
		$this->db->from("users");
		$this->db->where("email", $email);   
		$this->db->where("isDeleted", 0);
		if($userId != 0){
			$this->db->where("userId !=", $userId);
		}
		$query = $this->db->get();
		return $query->result();
	}

	// Insert new user info
	public function addNewUser($userInfo)
	{
		$this->db->trans_start();
		$this->db->insert('users', $userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	// User Info
	public function getUserInfo($userId)
	{
		$q = $this->db2->query("SELECT a.*, b.client_name FROM users a, client_creation b WHERE a.client_id = b.client_id and a.userId =".$userId);
        if ($q->num_rows() > 0)
            return $q->result();
        else
            return false;
	}

	// Get User Edited info
	public function editUser($userInfo, $userId)
	{
		$this->db2->where('userId', $userId);
		$this->db2->update('users', $userInfo);
		$total = $this->db->affected_rows();
    	if($total>0)
        	return true;
    	else
        	return false;
	}

	// Delete user record
	public function deleteUser($userId, $userInfo)
	{
		$this->db->where('userId', $userId);
		$this->db->update('users', $userInfo);
		return $this->db->affected_rows();
	}

	// Client List
	public function client_list()
	{
		$query=$this->db->query("SELECT * from client_creation where client_id != 1");
		$result = $query->result();
		return $result;
	}

	// Client List Active
	public function client_list_active($client_id)
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT * from client_creation where status = 'Active' and client_id != 1");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT * from client_creation where status = 'Active' and client_id != 1  and client_id = $client_id");
			$result = $query->result();
			return $result;	
		}
	}

	//Add new client
	public function addNewClient($userInfo,$logininfo1,$logininfo2)
	{
		$this->db->trans_start();

		$sql = "INSERT INTO client_creation(client_name,role,no_of_branches,branch_prefix,status,created,client_url) VALUES (?,?,?,?,?,?,?)";
		$this->db->query($sql, $userInfo);
		$insert_id = $this->db->insert_id();

		$sql1 = "INSERT INTO users(email,password,name,roleId,client_id,createdBy,createdDtm,prime_id,status,created,effective_from,data_transfer) VALUES (?,?,?,?,$insert_id,?,?,?,?,?,?,?)";
		$this->db->query($sql1, $logininfo1);
		$insert_id1 = $this->db->insert_id();

		$sql2 = "INSERT INTO users(email,password,name,roleId,client_id,createdBy,createdDtm,prime_id,status,created,effective_from,data_transfer) VALUES (?,?,?,?,$insert_id,?,?,?,?,?,?,?)";
		$this->db->query($sql2, $logininfo2);
		$insert_id2 = $this->db->insert_id();

		$this->db->trans_complete();
		return $insert_id;
	}

	//edit client info
	public function getClientInfo($clientid)
	{
		$query=$this->db->query("SELECT a.*, b.* from client_creation a, users b where a.client_id = b.client_id and a.client_id=$clientid and b.roleId = 1");
		$result = $query->result();
		return $result;
	}

	// Client Child Exist
	public function clientChildExist($clientid)
	{
		$q = $this->db->query("SELECT a.client_id FROM users a, client_creation b WHERE a.client_id = b.client_id and b.client_id = ".$clientid);
        if ($q->num_rows() > 0)
            return 1;
        else
            return 0;
	}

	// Delete Client
	public function deleteClient($clientid)
	{
		$this->db->query("delete from client_creation where client_id ='$clientid'");
		$total = $this->db->affected_rows();
        if($total>0)
            return true;
        else
            return false;
	}

	//update client
	public function editClientDetails($userInfo,$logininfo1,$logininfo2,$clientid,$ceorole,$cmrole)
	{
		$this->db->where('client_id', $clientid);
		$this->db->update('client_creation', $userInfo);
		$ceoarray = array('client_id' => $clientid, 'roleId' => $ceorole);
		$this->db->where($ceoarray); 
		// $this->db->where('client_id', $clientid);
		$this->db->update('users', $logininfo1);
		$cmarray = array('client_id' => $clientid, 'roleId' => $cmrole);
		$this->db->where($cmarray); 
		// $this->db->where('client_id', $clientid);
		$this->db->update('users', $logininfo2);
		return TRUE;
	}

	// Check Client Exist
	public function checkClientExist($name)
	{
		$q = $this->db->query("select * from client_creation where client_name = '".$name."'");
        if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}


	public function checkUsernameExistForUsers($email,$clientid,$branch)
	{
		$q = $this->db2->query("select * from users a where email = '$email' and client_id = $clientid and branch = '$branch'");
        if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function checkUsernameExist($username)
	{
		$q = $this->db2->query("select * from users a where email ='".$username."'");
        if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function checkClientUsernameExist($name,$username)
	{
		$query = $this->db->query("SELECT COUNT(*) as CNT from (SELECT a.client_name as name from client_creation a where a.client_name = '$name' UNION SELECT b.email as name FROM users b where b.email = '$username') x");
		$row = $query->row_array();
		$cnt = $row['CNT'];
		return $cnt;
        // if ($q->num_rows() > 1)
        //     return true;
        // else
        //     return false;
	}

	public function checkCreditCustomerExist($clientid,$branch,$gst_no)
	{
		$q = $this->db->query("SELECT a.* from credit_customer a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch = '$branch' and a.gst_no = '$gst_no'");
        if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	// Check Branch Exist
	public function checkBranchExist($bname,$client_id)
	{
		$q = $this->db->query("select * from branch_creation where client_id = ".$client_id." and branch_name = '".$bname."'");
        if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	// Branch List View
	public function branch_list()
	{
		$query=$this->db->query("SELECT * from branch_creation a, client_creation b where a.client_id = b.client_id");
		$result = $query->result();
		return $result;
	}

	// Active Branch List View
	public function branch_list_active($client_id)
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT * from branch_creation a, client_creation b where a.client_id = b.client_id and a.status ='Active'");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT * from branch_creation a, client_creation b where a.client_id = b.client_id and a.status ='Active' and a.client_id = $client_id");
			$result = $query->result();
			return $result;
		}
	}

	// Add New Branch
	public function addNewBranch($userInfo)
	{
		$this->db->trans_start();
		$this->db->insert('branch_creation', $userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	//Get Branch info
	public function getBranchInfo($branchid)
	{
		$query=$this->db->query("SELECT * from branch_creation a, client_creation b where a.client_id = b.client_id and a.branch_id='$branchid'");
		$result = $query->result();
		return $result;
	}

	// Edit Branch Info
	public function editBranchDetails($userInfo,$branchid)
	{
		$this->db->where('branch_id', $branchid);
		$this->db->update('branch_creation', $userInfo);
		return TRUE;
	}

	// Delete Branch Info
	public function deleteBranch($branchid)
	{
		$this->db->query("delete from branch_creation where branch_id ='$branchid'");
		$total = $this->db->affected_rows();
        if($total>0)
            return true;
        else
            return false;
	}

	public function branch_approve_list()
	{
		$query=$this->db->query("SELECT * from client_creation a, branch_creation b where a.client_id = b.client_id and b.status ='Pending'");
		$result = $query->result();
		return $result;
	}
	
	public function outlet_approve_list()
	{
		$query=$this->db->query("SELECT a.*, b.client_name from outlet_deatils a, client_creation b where a.client_id = b.client_id and a.status ='pending'");
		$result = $query->result();
		return $result;
	}

	public function filter_outlet_approve_list($clientid)
	{
		$query=$this->db->query("SELECT * from outlet_deatils a, client_creation b, users c where a.client_id = b.client_id and a.userId = c.userId and a.status ='pending' and a.client_id =".$clientid);
		$result = $query->result();
		return $result;	
	}

	public function approveOutlet($clientid,$outid)
	{
		$total = $this->db->query('update outlet_deatils set status = "Active", data_transfer = "pending", api_status = "processing" where outId ='.$outid.' and client_id ='.$clientid);
		
		$total = $this->db->affected_rows();
    	if($total>0)
        	return true;
    	else
        	return false;
	}

	public function filter_branch_approve_list($clientid)
	{
		$query=$this->db->query("SELECT * from client_creation a, branch_creation b where a.client_id = b.client_id and b.status ='pending' and b.client_id =".$clientid);
		$result = $query->result();
		return $result;	
	}

	public function approveBranch($client_id,$branchid)
	{
		$total1 = $this->db->query('UPDATE branch_creation SET status = "Active" , api_status = "processing" WHERE branch_id = '.$branchid.' and client_id = '.$client_id);
		
		$total = $this->db->affected_rows();
    	if($total>0)
        	return true;
    	else
        	return false;
	}

	public function getNoOfBranchesAllowed($clientid)
	{
		$query = $this->db->query('select no_of_branches from client_creation where client_id ='.$clientid);
		$result = $query->result();
		return $result;	
	}

	public function noofBranchesExist($clientid)
	{
		$query = $this->db->query('select count(branch_id)as branch from branch_creation where client_id ='.$clientid);
		$result = $query->result();
		return $result;	
	}

	public function getActiveBranchList($clientid)
	{
		$q = $this->db->query("select * from branch_creation a, client_creation b where a.client_id = b.client_id and a.status = 'Active' and a.client_id = ".$clientid." order by a.branch_name ASC");
		// $q = $this->db->query("select * from branch_creation");
		$output = '<option value="">Select Branch</option>';

		foreach ($q->result() as $r) 
		{
			$output .= '<option value="'.$r->branch_name.'">'.$r->branch_name.'</option>';
		}
		return $output;
	}

	public function getActiveUserList($branchid)
	{
		$q = $this->db->query("select * from users a, branch_creation b where a.branch = b.branch_name and a.status = 'Active' and a.effective_from <= CURDATE() and a.branch = '".$branchid."' order by a.name ASC");
		// $q = $this->db->query("select * from users");
		$output = '<option value="">Select User</option>';

		foreach ($q->result() as $r) 
		{
			$output .= '<option value="'.$r->userId.'">'.$r->name.'</option>';
		}
		return $output;
	}	

	public function setting_list()
	{
		$query=$this->db->query("SELECT * from setting");
		$result = $query->result();
		return $result;
	}

	public function application_setting_list_by_branch()
	{
		$query=$this->db->query("SELECT DISTINCT c.branch, b.client_name, a.branch_title from branch_creation a, client_creation b, application_setting c where a.client_id = b.client_id and c.client_id = b.client_id and c.branch = a.branch_name");
		$result = $query->result();
		return $result;
	}

	public function getApplicationSettingDetailsByBranch($branchname)
	{
		$query=$this->db->query("SELECT c.branch, b.client_name, c.* from branch_creation a, client_creation b, application_setting c where a.client_id = b.client_id and c.client_id = b.client_id and c.branch = a.branch_name and c.branch = '$branchname'");
		$result = $query->result();
		return $result;	
	}
	

	public function addSetting($setting_name,$setting_type,$setting_title)
	{
// 		$this->db->trans_start();
// 		$this->db->insert('setting', $data);
// 		$insert_id = $this->db->insert_id();
			
// 		$this->db->trans_complete();
// 		return $insert_id;

        $query=$this->db->query("insert into setting(setting_name,setting_type,setting_title) values('$setting_name','$setting_type','$setting_title')");
        $insert_id = $this->db->insert_id();
        
        $q = $this->db->query("select branch, client_id from outlet_deatils");
        if ($q->num_rows() > 0)
        {
            foreach($q->result() as $row)
            {
                $branch = $row->branch;
                $client_id = $row->client_id;
                date_default_timezone_set("Asia/Kolkata");
			    $effectdate = date("Y-m-d");
                $query1=$this->db->query("INSERT INTO application_setting(setting_name, setting_access, setting_type, setting_title, status, effective_from, data_transfer, branch, client_id, setting_id) VALUES ('$setting_name',0,'$setting_type','$setting_title','Inactive','$effectdate','','$branch',$client_id,$insert_id)");
            }
        }
        
        return $insert_id;
	}

	public function getSettingInfo($settingid)
	{
		$query=$this->db->query("SELECT * from setting where setting_id='$settingid'");
		$result = $query->result();
		return $result;
	}

	public function editSettingDetails($setInfo,$settingId)
	{
		$this->db->where('setting_id', $settingId);
		$this->db->update('setting', $setInfo);
		return TRUE;
	}

	public function deleteSetting($settingId)
	{
		$this->db->query("delete from setting where setting_id ='$settingId'");
		$total = $this->db->affected_rows();
        if($total>0)
            return true;
        else
            return false;
	}

	public function master_list()
	{
		$query=$this->db->query("SELECT * from master");
		$result = $query->result();
		return $result;
	}

	public function addMaster($data)
	{
		$this->db->trans_start();
		$this->db->insert('master', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	public function checkMasterExist($master_type,$master_details)
	{
		$q = $this->db->query("select * from master where master_type = '$master_type' and master_details = '$master_details'");
        if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function getMasterDetails($masterid)
	{
		$query=$this->db->query("SELECT * from master where master_id='$masterid'");
		$result = $query->result();
		return $result;
	}

	public function editMasterDetails($masterInfo,$masterId)
	{
		$this->db->where('master_id', $masterId);
		$this->db->update('master', $masterInfo);
		return TRUE;
	}

	public function filter_user_list($clientid,$branch,$client_id)
	{
		if(empty($branch) && empty($client_id))
		{
			$query=$this->db->query("select a.*, b.*, c.client_name from users a, roles b, client_creation c where a.client_id = c.client_id and a.roleId = b.roleId and b.role = 'USER' and a.client_id =".$clientid);
			$result = $query->result();
			return $result;	
		}
		else if(empty($branch))
		{
			$query=$this->db->query("select a.*, b.*, c.client_name from users a, roles b, client_creation c where a.client_id = c.client_id and a.roleId = b.roleId and b.role = 'USER'  and a.client_id =".$clientid);
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("select a.*, b.*, c.client_name from users a, roles b, client_creation c where a.client_id = c.client_id and a.roleId = b.roleId and b.role = 'USER' and a.client_id = $clientid and a.branch = '$branch'");
			$result = $query->result();
			return $result;		
		}
	}

	public function user_approve_list()
	{
		$query=$this->db->query("SELECT * from client_creation a, users b where a.client_id = b.client_id and b.status ='pending'");
		$result = $query->result();
		return $result;
	}

	public function filter_user_approve_list($clientid)
	{
		$query=$this->db->query("SELECT * from client_creation a, users b where a.client_id = b.client_id and b.status ='pending' and b.client_id =".$clientid);
		$result = $query->result();
		return $result;	
	}

	public function filter_category_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT a.*, b.*, c.branch_title,a.status from product_category a, client_creation b, branch_creation c WHERE a.client_id = b.client_id and a.branch = c.branch_name and b.client_id =".$clientid." order by a.pr_cat_name");
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.*, c.branch_title,a.status from product_category a, client_creation b, branch_creation c WHERE a.client_id = b.client_id and a.branch = c.branch_name and b.client_id = $clientid and a.branch = '$branch' order by a.pr_cat_name");
			$result = $query->result();
			return $result;	
		}
	}
	
	public function filter_online_category_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT a.*, b.*, d.branch_title from product_category a, client_creation b, product c, branch_creation d where a.client_id = b.client_id and a.branch = d.branch_name and a.pr_cat_id = c.cat_id and c.social_order = '1' and a.client_id = $clientid GROUP BY a.pr_cat_id");
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.*, d.branch_title from product_category a, client_creation b, product c, branch_creation d where a.client_id = b.client_id and a.branch = d.branch_name and a.pr_cat_id = c.cat_id and c.social_order = '1' and a.client_id = $clientid and a.branch = '$branch' GROUP BY a.pr_cat_id");
			$result = $query->result();
			return $result;	
		}
	}
	
	public function filter_counter_category_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT a.*, b.*, d.branch_title from product_category a, client_creation b, product c, branch_creation d where a.client_id = b.client_id and a.branch = d.branch_name and a.pr_cat_id = c.cat_id and c.social_order = '0' and a.client_id = $clientid GROUP BY a.pr_cat_id");
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.*, d.branch_title from product_category a, client_creation b, product c, branch_creation d where a.client_id = b.client_id and a.branch = d.branch_name and a.pr_cat_id = c.cat_id and c.social_order = '0' and a.client_id = $clientid and a.branch = '$branch' GROUP BY a.pr_cat_id");
			$result = $query->result();
			return $result;	
		}
	}

	public function filter_product_list($clientid,$branch,$category)
	{
		if(empty($branch) && empty($category))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and d.category_master_id = a.pr_cat_id and a.client_id = $clientid and a.social_order = 0");
			$result = $query->result();
			return $result;	
		}
		else if(empty($category))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and d.category_master_id = a.pr_cat_id and a.client_id = $clientid and a.branch = '$branch' and a.social_order = 0");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and d.category_master_id = a.pr_cat_id and a.client_id = $clientid and a.branch = '$branch' and a.pr_cat_id = $category and a.social_order = 0");
			$result = $query->result();
			return $result;
		}
	}
	
	public function filter_online_product_list($clientid,$branch,$category)
	{
		if(empty($branch) && empty($category))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and d.category_master_id = a.pr_cat_id and a.client_id = $clientid and a.social_order = '1'");
			$result = $query->result();
			return $result;	
		}
		else if(empty($category))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and d.category_master_id = a.pr_cat_id and a.client_id = $clientid and a.branch = '$branch' and a.social_order = '1'");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and d.category_master_id = a.pr_cat_id and a.client_id = $clientid and a.branch = '$branch' and a.pr_cat_id = $category and a.social_order = '1'");
			$result = $query->result();
			return $result;
		}
	}
    
    public function filter_counter_product_list($clientid,$branch,$category)
	{
		if(empty($branch) && empty($category))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and d.category_master_id = a.pr_cat_id and a.client_id = $clientid and a.social_order = '0'");
			$result = $query->result();
			return $result;	
		}
		else if(empty($category))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and d.category_master_id = a.pr_cat_id and a.client_id = $clientid and a.branch = '$branch' and a.social_order = '0'");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and d.category_master_id = a.pr_cat_id and a.client_id = $clientid and a.branch = '$branch' and a.pr_cat_id = $category and a.social_order = '0'");
			$result = $query->result();
			return $result;
		}
	}

	public function filter_outlet_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title from outlet_deatils a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and b.client_id =".$clientid);
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.*, c.branch_title from outlet_deatils a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and a.client_id = $clientid and a.branch = '$branch'");
			$result = $query->result();
			return $result;	
		}
	}

	public function filter_credit_customer_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title from credit_customer a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and b.client_id =".$clientid);
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title from credit_customer a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and b.client_id = $clientid and a.branch = '$branch'");
			$result = $query->result();
			return $result;	
		}
			
	}

	public function filter_master_creation_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT c.*, b.*, a.* from branch_creation a, client_creation b, masters_creation c where a.client_id = b.client_id and c.client_id = b.client_id and c.branch = a.branch_name and b.client_id =".$clientid);
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT c.*, b.*, a.* from branch_creation a, client_creation b, masters_creation c where a.client_id = b.client_id and c.client_id = b.client_id and c.branch = a.branch_name and b.client_id = $clientid and c.branch = '$branch'");
			$result = $query->result();
			return $result;		
		}
	}

	public function filter_application_setting_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT DISTINCT c.branch, b.client_name, a.branch_title from branch_creation a, client_creation b, application_setting c where a.client_id = b.client_id and c.client_id = b.client_id and c.branch = a.branch_name and b.client_id =".$clientid);
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT DISTINCT c.branch, b.client_name, a.branch_title from branch_creation a, client_creation b, application_setting c where a.client_id = b.client_id and c.client_id = b.client_id and c.branch = a.branch_name and b.client_id = $clientid and c.branch = '$branch'");
			$result = $query->result();
			return $result;	
		}
	}

	public function filter_branch_list($clientid)
	{
		$query=$this->db->query("SELECT a.*, b.* from branch_creation a, client_creation b where a.client_id = b.client_id and b.client_id =".$clientid);
		$result = $query->result();
		return $result;	
	}

	public function filter_module_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT DISTINCT c.role, d.branch, b.client_name, d.role_id, d.client_id from branch_creation a, client_creation b, roles c, module_creation d where a.client_id = b.client_id and d.client_id = b.client_id and c.roleId = d.role_id and b.client_id =".$clientid);
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT DISTINCT c.role, d.branch, b.client_name, d.role_id, d.client_id from branch_creation a, client_creation b, roles c, module_creation d where a.client_id = b.client_id and d.client_id = b.client_id and c.roleId = d.role_id and b.client_id = $clientid and a.branch_name = '$branch'");
			$result = $query->result();
			return $result;	
		}
	}

	public function filter_permissions_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT a.permission_id, f.permission_name, c.module_name, b.module_id, a.role_id, a.branch, d.client_name, d.client_id, e.role from permission_creation a, module_creation b, modules c, client_creation d, roles e, permission f where a.module_creation_id = b.module_id and b.module_master_id = c.module_master_id and a.client_id = d.client_id and a.role_id = e.roleId and a.permission_master_id = f.permission_master_id and a.client_id = ".$clientid);
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.permission_id, f.permission_name, c.module_name, b.module_id, a.role_id, a.branch, d.client_name, d.client_id, e.role from permission_creation a, module_creation b, modules c, client_creation d, roles e, permission f where a.module_creation_id = b.module_id and b.module_master_id = c.module_master_id and a.client_id = d.client_id and a.role_id = e.roleId and a.permission_master_id = f.permission_master_id and a.client_id = $clientid and a.branch = '$branch'");
			$result = $query->result();
			return $result;	
		}
	}	

	public function approveUser($clientid,$userid)
	{
		
		$total = $this->db->query('update client_creation set status = "Active" where client_id ='.$clientid);

		$total = $this->db->query('update users set status = "Active", data_transfer = "pending" where userId ='.$userid);	
		
		$total = $this->db->affected_rows();
    	if($total>0)
        	return true;
    	else
        	return false;
	}

	public function deleteMaster($masterId)
	{
		$this->db->query("delete from master where master_id ='$masterId'");
		$total = $this->db->affected_rows();
        if($total>0)
            return true;
        else
            return false;
	}

	public function master_creation_list_by_branch()
	{
		$query=$this->db->query("SELECT c.*, b.*, a.* from branch_creation a, client_creation b, masters_creation c where a.client_id = b.client_id and c.client_id = b.client_id and c.branch = a.branch_name");
		$result = $query->result();
		return $result;
	}

	public function master_type_list()
	{
		$query=$this->db->query("SELECT DISTINCT master_type from master");
		$result = $query->result();
		return $result;
	}

	public function master_details_list()
	{
		$query=$this->db->query("SELECT DISTINCT master_details from master");
		$result = $query->result();
		return $result;
	}

	public function getMasterDetailsForMasterType($mastertype)
	{
		$q = $this->db->query("SELECT * FROM master where master_type = '$mastertype'");
		
		$output = '<option value="">--- Select Master Details * ---</option>';


		foreach ($q->result() as $r) 
		{
			$output .= '<option value="'.$r->master_details.'">'.$r->master_details.'</option>';
		}
		return $output;
	}

	public function addMasterCreation($data)
	{
		$this->db->trans_start();
		$this->db->insert('masters_creation', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	public function getMasterCreationDetails($masterid)
	{
		$query=$this->db->query("SELECT a.*, b.client_id, c.branch_name from masters_creation a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and a.masterId='$masterid'");
		$result = $query->result();
		return $result;
	}

	public function editMasterCreationDetails($masterInfo,$masterId)
	{
		$this->db->where('masterId', $masterId);
		$this->db->update('masters_creation', $masterInfo);
		return TRUE;
	}

	public function getBranchDetailsByClientId($clientid)
	{
		$query=$this->db->query("select a.* from branch_creation a, client_creation b WHERE a.client_id = b.client_id and a.client_id = $clientid");
		$result = $query->result();
		return $result;
	}

	public function addCategoryMaster($data)
	{
		$this->db->trans_start();
		$this->db->insert('category_master', $data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	public function checkCategoryMasterExist($category_name,$client_id)
	{
		$q=$this->db->query("select * from category_master where category_name = '$category_name' and client_id = $client_id");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function category_master_list($client_id)
	{
		if(empty($client_id))
		{
			$query=$this->db->query("select a.*, b.* from category_master a, client_creation b WHERE a.client_id = b.client_id");
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("select a.*, b.* from category_master a, client_creation b WHERE a.client_id = b.client_id and a.client_id = $client_id");
			$result = $query->result();
			return $result;	
		}
	}
	
	public function filter_category_master_list($client_id)
	{
		$query=$this->db->query("select a.*, b.* from category_master a, client_creation b WHERE a.client_id = b.client_id and a.client_id = $client_id");
		$result = $query->result();
		return $result;	
	}
	
	
	public function getCategoryMasterDetails($categorymasterid)
	{
		$query=$this->db->query("select a.*, b.* from category_master a, client_creation b WHERE a.client_id = b.client_id and a.category_master_id =".$categorymasterid);
		$result = $query->result();
		return $result;		
	}

	public function editCategoryMasterDetails($data,$categorymasterid)
	{
		$this->db->where('category_master_id', $categorymasterid);
		$this->db->update('category_master', $data);
		$total = $this->db->affected_rows();
    	if($total>0)
        	return true;
    	else
        	return false;
	}

	public function module_master_list()
	{
		$query=$this->db->query("SELECT a.*, b.module_group_name from modules a, module_groups b where a.module_group_id = b.module_group_id");
		$result = $query->result();
		return $result;
	}

	public function role_list_active_by_branch()
	{
		$query=$this->db->query("select a.*, b.*, c.* from users a, branch_creation b, roles c WHERE a.branch = b.branch_name and a.roleId = c.roleId");
		$result = $query->result();
		return $result;	
	}

	public function role_list_active_by_client()
	{
		$query=$this->db->query("select distinct b.client_id, c.* from users a, client_creation b, roles c WHERE a.client_id = b.client_id and a.roleId = c.roleId and a.status = 'Active' and a.effective_from <= CURDATE()");
		$result = $query->result();
		return $result;	
	}

	public function module_list()
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT DISTINCT c.role, d.branch, b.client_name, d.role_id, d.client_id from branch_creation a, client_creation b, roles c, module_creation d where a.client_id = b.client_id and d.client_id = b.client_id and c.roleId = d.role_id");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT DISTINCT c.role, d.branch, b.client_name, d.role_id, d.client_id from branch_creation a, client_creation b, roles c, module_creation d where a.client_id = b.client_id and d.client_id = b.client_id and c.roleId = d.role_id and d.client_id = $client_id");
			$result = $query->result();
			return $result;
		}
	}

	public function getmoduleInfobyRoleid($role_id,$clientid)
	{
		// $query=$this->db->query("SELECT c.branch, b.client_name, d.module_name, c.* from branch_creation a, client_creation b, module_creation c, modules d where a.client_id = b.client_id and c.client_id = b.client_id and c.branch = a.branch_name and c.module_master_id = d.module_master_id and c.role_id = '$role_id'");
		$query=$this->db->query("SELECT c.branch, b.client_name, d.module_name, e.role, c.* from client_creation b, module_creation c, modules d, roles e where c.client_id = b.client_id and c.module_master_id = d.module_master_id and c.role_id = e.roleId and c.role_id = $role_id and c.client_id = $clientid");
		$result = $query->result();
		return $result;	
	}

	public function checkRoleIdExistInModule($clientid,$roleid)
	{
		// $q=$this->db->query("SELECT a.* from module_creation a, client_creation b, roles c where a.client_id = b.client_id and a.role_id = c.roleId and a.client_id = $clientid and a.branch = '$branch' and a.role_id = $roleid");
		$q=$this->db->query("SELECT a.* from module_creation a, client_creation b, roles c where a.client_id = b.client_id and a.role_id = c.roleId and a.client_id = $clientid and a.role_id = $roleid");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function checkModuleExistInMasterModules($name)
	{
		$q=$this->db->query("select * from modules where module_name = '$name'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function checkPermissionExistInMasterPermission($name)
	{
		$q=$this->db->query("select * from permission where permission_name = '$name'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function permission_master_list()
	{
		$query=$this->db->query("SELECT * from permission");
		$result = $query->result();
		return $result;
	}

	// public function module_list_by_branch()
	// {
	// 	$query=$this->db->query("SELECT b.*, c.branch_name from module_creation a, modules b, branch_creation c  WHERE a.module_master_id = b.module_master_id and a.branch = c.branch_name");
	// 	$result = $query->result();
	// 	return $result;	
	// }

	public function module_list_by_client()
	{
		$query=$this->db->query("SELECT b.*, c.client_id from module_creation a, modules b, client_creation c WHERE a.module_master_id = b.module_master_id and a.client_id = c.client_id");
		$result = $query->result();
		return $result;	
	}

	// public function user_list_by_module_and_branch()
	// {
	// 	$query=$this->db->query("SELECT DISTINCT b.roleId, b.role, a.module_master_id from module_creation a, roles b, branch_creation c, modules d where a.branch = c.branch_name and a.role_id = b.roleId and a.module_master_id = d.module_master_id");
	// 	$result = $query->result();
	// 	return $result;	
	// }

	public function getRolesForModuleAjax($clientid, $moduleid)
	{
		$q = $this->db->query("SELECT R.role, M.role_id, M.module_master_id, M.client_id from module_creation M inner join client_creation C on M.client_id = C.client_id inner join roles R on M.role_id = R.roleId where M.module_master_id = $moduleid and M.client_id = $clientid");
		
		$output = '<option value="">--- Select User* ---</option>';

		foreach ($q->result() as $r) 
		{
			$output .= '<option value="'.$r->role_id.'">'.$r->role.'</option>';
		}
		return $output;
	}

	public function user_list_by_module_and_client()
	{
		// SELECT DISTINCT(R.role), R.roleId, C.client_id, M.module_master_id FROM client_creation C inner join module_creation M  on C.client_id=M.client_id inner join roles R on M.role_id=R.roleId INNER JOIN modules N on M.module_master_id = N.module_master_id group by C.client_id
		$query=$this->db->query("SELECT R.role, M.role_id, M.module_master_id, M.client_id from module_creation M inner join client_creation C on M.client_id = C.client_id inner join roles R on M.role_id = R.roleId");
		// $query=$this->db->query("SELECT DISTINCT(c.role), b.module_master_id from module_creation a, modules b, roles c WHERE a.module_master_id = b.module_master_id and a.role_id = c.roleId");
		$result = $query->result();
		return $result;	
	}


	public function checkRoleIdExistInPermission($clientid,$branch,$roleid,$moduleid)
	{
		$q=$this->db->query("SELECT a.* from permission_creation a, client_creation b, roles c, module_creation d where a.client_id = b.client_id and a.role_id = c.roleId and a.module_id = d.module_id and a.client_id = $clientid and a.branch = '$branch' and a.role_id = $roleid and a.module_id = $moduleid");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function getModuleMasterDetailsById($moduleid)
	{
		$query=$this->db->query("select * from modules where module_master_id = $moduleid");
		$result = $query->result();
		return $result;
	}

	public function getPermissionMasterDetailsById($permissionid)
	{
		$query=$this->db->query("select * from permission where permission_master_id = $permissionid");
		$result = $query->result();
		return $result;
	}	

	public function checkUomExist($uom_name)
	{
		$q=$this->db->query("select * from uom_creation where uom_name = '$uom_name'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function checkTaxExist($tax_percentage)
	{
		$q=$this->db->query("select * from tax_creation where tax_percentage = '$tax_percentage'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function checkSettingExist($setting_title)
	{
		$q=$this->db->query("select * from setting where setting_title = '$setting_title'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function module_group_list()
	{
		$query=$this->db->query("select * from module_groups order by sort_id");
		$result = $query->result();
		return $result;
	}

	public function checkModuleGroupExist($groupname)
	{
		$q=$this->db->query("select * from module_groups where module_group_name = '$groupname'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}
	// public function checkModuleGroupExist($groupname,$sortid)
	// {
	// 	$q=$this->db->query("select * from module_groups where module_group_name = '$groupname' or sort_id = $sortid");
	// 	if ($q->num_rows() > 0)
 //            return true;
 //        else
 //            return false;	
	// }

	public function getModuleGroupDetails($modulegroupid)
	{
		$query=$this->db->query("select * from module_groups where module_group_id = $modulegroupid");
		$result = $query->result();
		return $result;
	}

	// outlest - list 
	public function get_outlets_details()
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title from outlet_deatils a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title from outlet_deatils a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and a.client_id = $client_id");
			$result = $query->result();
			return $result;
		}
	}

	// outlets data insert 
	public function outlet_creation($userInfo)
	{
		$this->db->trans_start();
		$this->db->insert('outlet_deatils', $userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	// outlets edit - get info
	public function getoutletInfo($outId)
	{
		$query=$this->db->query("SELECT * from outlet_deatils where outId='$outId'");
		$result = $query->result();
		return $result;
	}

	// update outlets - Edited info
	public function outlet_update($userInfo, $outid)
	{
		$this->db->where('outId', $outid);
		$this->db->update('outlet_deatils', $userInfo);
		return TRUE;
	}

	// Module list
	public function get_module_details()
	{
		$query=$this->db->query("SELECT * from module_creation");
		$result = $query->result();
		return $result;
	}

	// Get role list 
	public function get_role_by_name()
	{
		$query=$this->db->query("SELECT * from roles where roleId = '3'");
		$result = $query->result();
		return $result;
	}

	public function get_all_role_by_name()
	{
		$query=$this->db->query("SELECT * from roles where roleId !=5 and roleId != 8 and roleId != 7");
		$result = $query->result();
		return $result;
	}

	// insert new module info 
	public function insertNewmodules($userInfo)
	{
		$this->db->trans_start();
		// $sql = "INSERT INTO module_creation(module_name, link, icon, ceo, manager, users, admins, sales, master, accounts, smart_delete, cash_vocher, eshanya, roottop,kacha_book,santhe,sections,client_id,branch) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		// $this->db->query($sql, $userInfo);
		$this->db->insert('module_creation',$userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	// Get Module edited info 
	public function getmoduleInfo($module_id)
	{
		$query=$this->db->query("SELECT * from module_creation where module_id ='$module_id'");
		$result = $query->result();
		return $result;
	}

	// update module edited info
	public function updatemodules($userInfo, $module_id)
	{
		$this->db->where('module_id', $module_id);
		$this->db->update('module_creation', $userInfo);
		return TRUE;
	}
 
	// permissions data list info
	public function get_permissions_details()
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.permission_id, f.permission_name, c.module_name, b.module_id, a.role_id, a.branch, d.client_name, d.client_id, e.role from permission_creation a, module_creation b, modules c, client_creation d, roles e, permission f where a.module_creation_id = b.module_id and b.module_master_id = c.module_master_id and a.client_id = d.client_id and a.role_id = e.roleId and a.permission_master_id = f.permission_master_id and a.client_id != 1 ORDER BY a.permission_id");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.permission_id, f.permission_name, c.module_name, b.module_id, a.role_id, a.branch, d.client_name, d.client_id, e.role from permission_creation a, module_creation b, modules c, client_creation d, roles e, permission f where a.module_creation_id = b.module_id and b.module_master_id = c.module_master_id and a.client_id = d.client_id and a.role_id = e.roleId and a.permission_master_id = f.permission_master_id and a.client_id = $client_id ORDER BY a.permission_id");
			$result = $query->result();
			return $result;
		}
		
	}

	// insert permissions info 
	public function insertNewpermission($userInfo)
	{
		$this->db->trans_start();
		//$this->db->insert('roles', $userInfo);
		$sql = "INSERT INTO permission_creation(permission_name, link, icon, ceo, manager, users, admins, sales, master, accounts, smart_delete, cash_vocher, eshanya, roottop, kacha_book, santhe, module_id) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		$this->db->query($sql, $userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	// Get permissions edited info 
	public function getpermissionInfo($permission_id)
	{
// 		$query=$this->db->query("SELECT a.*, b.permission_name FROM permission_creation a, permission b WHERE a.permission_master_id = b.permission_master_id and a.module_id = $moduleid and a.role_id = $roleid and a.client_id = $clientid");
		$query=$this->db->query("SELECT a.*, f.permission_name, c.module_name, b.module_id, d.client_name, d.client_id, e.role from permission_creation a, module_creation b, modules c, client_creation d, roles e, permission f where a.module_creation_id = b.module_id and b.module_master_id = c.module_master_id and a.client_id = d.client_id and a.role_id = e.roleId and a.permission_master_id = f.permission_master_id and a.permission_id = $permission_id");
		$result = $query->result();
		return $result; 
	}

	// update permissions edited info
	public function updatepermission($userInfo, $permission_id)
	{
		$this->db->where('permission_id', $permission_id);
		$this->db->update('permission_creation', $userInfo);
		return TRUE;
	}

	public function Created_customers_list()
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title from credit_customer a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title from credit_customer a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and a.client_id = $client_id");
			$result = $query->result();
			return $result;
		}
	}

	// insert credit customers info
	public function insertNewCreditCustomer($userInfo)
	{
		$this->db->trans_start();
		$this->db->insert('credit_customer', $userInfo);
		// $sql = "INSERT INTO credit_customer(cust_name,phone_number,gst_no,status,branch,client_id) VALUES (?,?,?,?,?,?)";
		// $this->db->query($sql, $userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	// Get Credit customers info
	public function getCreditedInfo($cust_id)
	{
		$query=$this->db->query("SELECT * from credit_customer where cust_id='$cust_id'");
		$result = $query->result();
		return $result;
	}

	// Credit Customers status info
	public function getstatusInfo($cust_id)
	{
		$query=$this->db->query("SELECT DISTINCT(status) from credit_customer");
		$result = $query->result();
		return $result;
	}

	// update credit customers edited info
	public function updatedcreditedCustomer($userInfo, $cust_id)
	{
		$this->db->where('cust_id', $cust_id);
		$this->db->update('credit_customer', $userInfo);
		return TRUE;
	}

	// Get Category List
	public function getCategory()
	{
	 //    $branch = $this->session->userdata('branch');
		// $query=$this->db->query("SELECT * from product_category where branch='$branch'");
		// SELECT a.*, b.*, c.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active'
		$query=$this->db->query("select * from product_category a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and a.pr_cat_code = d.category_master_id and a.status='Active' and a.effective_from <= CURDATE()");
		$result = $query->result();
		return $result;
	}

	// public function gercategory_list_active()
	// {
	//  //    $branch = $this->session->userdata('branch');
	// 	// $query=$this->db->query("SELECT * from product_category where branch='$branch'");
	// 	// SELECT a.*, b.*, c.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active'
	// 	$query=$this->db->query("select * from product_category a, branch_creation b, client_creation c, category_master d where a.branch = b.branch_name and a.client_id = c.client_id and a.pr_cat_code = d.category_master_id and a.status='Active' and a.effective_from <= CURDATE()");
	// 	$result = $query->result();
	// 	return $result;
	// }

	public function get_disc_info()
	{
		// $query=$this->db->query("SELECT *,masterId as disId, master_details as discount  from masters_creation where masters_status='Defaul_discount'");
		// $query=$this->db->query("SELECT *,master_id as disId, master_details as discount  from master where master_type='Defaul_discount'");
		$query=$this->db->query("SELECT Distinct master_details as discount from master where master_type='Defaul_discount'");
		$result = $query->result();
		return $result;
	}

	public function category_list_active($client_id)
	{
	 //    $branch = $this->session->userdata('branch');
		// $query=$this->db->query("SELECT * from product_category where branch='$branch'");
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.*, c.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.effective_from <= CURDATE()");
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.*, c.* from product_category a, branch_creation b, category_master c where a.branch = b.branch_name and a.pr_cat_code = c.category_master_id and a.status='Active' and a.client_id = $client_id and a.effective_from <= CURDATE()");
			$result = $query->result();
			return $result;
		}
	}
	
    public function category_master_list_active($client_id)
	{
	    if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.client_id from category_master a, client_creation b WHERE a.client_id = b.client_id");
    		$result = $query->result();
    		return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.client_id from category_master a, client_creation b WHERE a.client_id = b.client_id and b.client_id = ".$client_id);
    		$result = $query->result();
    		return $result;
		}
	}

	// Get UOM List
	public function getUoms()
	{
		$query=$this->db->query("SELECT *,uomId as uom_name, uom_name  from uom_creation");
		$result = $query->result();
		return $result;
	}

	//UOM Active List
	public function uom_list_active()
	{
		$query=$this->db->query("SELECT *,uomId as uom_name, uom_name  from uom_creation where status = 'Active'");
		$result = $query->result();
		return $result;
	}

	// Get Tax List
	public function getTaxes()
	{
		$query=$this->db->query("SELECT *,taxId as tax_percentage, tax_percentage   from tax_creation");
		$result = $query->result();
		return $result;
	}

	//Get Active Tax list
	public function tax_list_active()
	{
		$query=$this->db->query("SELECT *,taxId as tax_percentage, tax_percentage   from tax_creation where status = 'Active'");
		$result = $query->result();
		return $result;
	}

	// Get All products data List
	public function Products_list($client_id)
	{
	 //    $branch = $this->session->userdata('branch');
		// $query=$this->db->query("SELECT * from product where branch='$branch'");
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c where a.branch = b.branch_name and a.client_id = c.client_id and a.social_order = 0");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c where a.branch = b.branch_name and a.client_id = c.client_id and a.client_id = $client_id and a.social_order = 0");
			$result = $query->result();
			return $result;	
		}
	}
	
	public function Online_Products_list($client_id)
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c where a.branch = b.branch_name and a.client_id = c.client_id and a.social_order = '1'");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c where a.branch = b.branch_name and a.client_id = c.client_id and a.client_id = $client_id and a.social_order = '1'");
			$result = $query->result();
			return $result;	
		}
	}
	
	public function Counter_Products_list($client_id)
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c where a.branch = b.branch_name and a.client_id = c.client_id and a.social_order = '0'");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from product a, branch_creation b, client_creation c where a.branch = b.branch_name and a.client_id = c.client_id and a.client_id = $client_id and a.social_order = '0'");
			$result = $query->result();
			return $result;	
		}
	}
	
	//Product List By Product Code
	public function ProductsByProductCode($client_id)
	{
	    if(empty($client_id))
	    {
	        $query=$this->db->query("SELECT a.*, b.client_name, c.category_name FROM product a, client_creation b, category_master c WHERE a.client_id = b.client_id and a.pr_cat_id = c.category_master_id and a.product_code != 0 GROUP BY  a.product_code, a.client_id");
    		$result = $query->result();
    		return $result;
	    }
	    else
	    {
	        $query=$this->db->query("SELECT a.*, b.client_name, c.category_name FROM product a, client_creation b, category_master c WHERE a.client_id = b.client_id and a.pr_cat_id = c.category_master_id and a.client_id = $client_id and a.product_code != 0 GROUP BY a.product_code");
    		$result = $query->result();
    		return $result;
	    }
	}
	
	//Filter Product List By Product Code
	public function filterProductsByProductCode($clientid,$category)
	{
	    if(empty($category))
	    {
	        $query=$this->db->query("SELECT a.*, b.client_name, c.category_name FROM product a, client_creation b, category_master c WHERE a.client_id = b.client_id and a.pr_cat_id = c.category_master_id and a.client_id = $clientid and a.product_code != 0 GROUP BY a.product_code");
    		$result = $query->result();
    		return $result;
	    }
	    else
	    {
	        $query=$this->db->query("SELECT a.*, b.client_name, c.category_name FROM product a, client_creation b, category_master c WHERE a.client_id = b.client_id and a.pr_cat_id = c.category_master_id and a.client_id = $clientid and a.pr_cat_id = $category and a.product_code != 0 GROUP BY a.product_code");   
    		$result = $query->result();
    		return $result;
	    }
	}
	
	//Product Info By Product Code 
	public function getProductInfoByProductCode($client_id,$product_code)
	{
		$query=$this->db->query("SELECT a.*, b.client_name, c.category_name from product a, client_creation b, category_master c where a.client_id = b.client_id and a.pr_cat_id = c.category_master_id and a.client_id = $client_id and a.product_code=$product_code and a.social_order = 0 group by a.product_code");
		$result = $query->result();
		return $result;
	}
	
	//Product Info By Product Code
	public function getCounterProductsByProductCode($client_id,$product_code)
	{
		$query=$this->db->query("SELECT a.* from product a, client_creation b where a.client_id = b.client_id and a.client_id = $client_id and a.product_code=$product_code and a.social_order = 0");
		$result = $query->result();
		return $result;
	}

	// Inserts Products list
	public function insertNewProducts($data)
	{
		$this->db->trans_start();
		$this->db->insert('product',$data);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	//Get Product Edited info
	public function getProductInfo($pr_id)
	{
		$query=$this->db->query("SELECT * from product where pr_id='$pr_id'");
		$result = $query->result();
		return $result;
	}

	// update product edited info
	public function updateProductsDetails($data, $produtsId)
	{
		$this->db->where('pr_id', $produtsId);
		$this->db->update('product', $data);
		return TRUE;
	}

	// Tax data list
	public function tax_list()
	{
		$query=$this->db->query("SELECT * from tax_creation");
		$result = $query->result();
		return $result;
	}

	// insert new tax percentage
	public function insertNewTax($userInfo)
	{
		$this->db->trans_start();
		$sql = "INSERT INTO tax_creation(tax_percentage,status,created) VALUES (?,?,?)";
		$this->db->query($sql, $userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	// Get Tax Edited Info
	public function getTaxInfo($taxId)
	{
		$query=$this->db->query("SELECT * from tax_creation where taxId='$taxId'");
		$result = $query->result();
		return $result;
	} 

	//update tax edited info
	public function updateTaxDetails($userInfo, $taxId)
	{
		$this->db->where('taxId', $taxId);
		$this->db->update('tax_creation', $userInfo);
		return TRUE;
	}

	public function deleteTax($taxId)
	{
		$this->db->query("delete from tax_creation where taxId ='$taxId'");
		$total = $this->db->affected_rows();
        if($total>0)
            return true;
        else
            return false;
	}

	// public function uomChildExist($uomId)
	// {
	// 	$q = $this->db->query("SELECT a.roleId FROM users a, roles b WHERE a.roleId = b.roleId and b.roleId = ".$uomId);
 //        if ($q->num_rows() > 0)
 //            return 1;
 //        else
 //            return 0;
	// }

	public function deleteUom($uomId)
	{
		$this->db->query("delete from uom_creation where uomId ='$uomId'");
		$total = $this->db->affected_rows();
        if($total>0)
            return true;
        else
            return false;
	}

	// Get UOM Data List
	public function uom_list()
	{
		$query=$this->db->query("SELECT * from uom_creation");
		$result = $query->result();
		return $result;
	}

	// insert new UOM info
	public function insertNewUOM($userInfo)
	{
		$this->db->trans_start();
		$this->db->insert('uom_creation', $userInfo);
		// $sql = "INSERT INTO uom_creation(uom_name,description,status,created) VALUES (?,?,?,?)";
		// $this->db->query($sql, $userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	//Get UOM edited Info
	public function getUomInfo($uomId)
	{
		$query=$this->db->query("SELECT * from uom_creation where uomId='$uomId'");
		$result = $query->result();
		return $result;
	}

	// update uom edited info
	public function updateUomDetails($userInfo, $uomId)
	{
		$this->db->where('uomId', $uomId);
		$this->db->update('uom_creation', $userInfo);
		return TRUE;
	}

	// Get Categort Data List
	public function category_list($client_id)
	{
	    // $branch = $this->session->userdata('branch');
		// $query=$this->db->query("SELECT * from product_category where  branch='$branch' order by pr_cat_name");
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.*, c.branch_title,a.status from product_category a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name order by a.pr_cat_name");
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.*, c.branch_title,a.status from product_category a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and a.client_id = $client_id order by a.pr_cat_name");
			$result = $query->result();
			return $result;	
		}
	}
	
	public function online_category_list($client_id)
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.*, d.branch_title from product_category a, client_creation b, product c, branch_creation d where a.client_id = b.client_id and a.branch = d.branch_name and a.pr_cat_id = c.cat_id and c.social_order = '1' GROUP BY a.pr_cat_id");
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.*, d.branch_title from product_category a, client_creation b, product c, branch_creation d where a.client_id = b.client_id and a.branch = d.branch_name and a.pr_cat_id = c.cat_id and c.social_order = '1' and a.client_id = $client_id GROUP BY a.pr_cat_id");
			$result = $query->result();
			return $result;	
		}
	}
	
	public function counter_category_list($client_id)
	{
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.*, d.branch_title from product_category a, client_creation b, product c, branch_creation d where a.client_id = b.client_id and a.branch = d.branch_name and a.pr_cat_id = c.cat_id and c.social_order = '0' GROUP BY a.pr_cat_id");
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.*, d.branch_title from product_category a, client_creation b, product c, branch_creation d where a.client_id = b.client_id and a.branch = d.branch_name and a.pr_cat_id = c.cat_id and c.social_order = '0' and a.client_id = $client_id GROUP BY a.pr_cat_id");
			$result = $query->result();
			return $result;	
		}
	}

	//insert new category info
	// public function insertNewCategory($data)
	// {
	// 	$this->db->insert('product_category',$data);
	// 	$insert_id = $this->db->insert_id();
	// 	$data1 = array(
	// 		"pr_cat_code"  =>$insert_id
	//         );
	// 	$this->db->where('pr_cat_id', $insert_id);
	// 	$this->db->update('product_category', $data1);
	// 	return $insert_id;
	// }

	// Get Category Edited Info
	public function getCatInfo($pr_cat_id)
	{
		$query=$this->db->query("SELECT a.*, b.* from product_category a, category_master b where a.pr_cat_code = b.category_master_id and a.pr_cat_id='$pr_cat_id'");
		$result = $query->result();
		return $result;
	}

	//update category edited info
	public function editcategoryDetails($userInfo, $categoryId)
	{
		$this->db->where('pr_cat_id', $categoryId);
		$this->db->update('product_category', $userInfo);
		$total = $this->db->affected_rows();
    	if($total>0)
        	return true;
    	else
        	return false;
	}

	// Insert new Dicount info
	public function insert_new_masters($userInfo)
	{
		$this->db->trans_start();
		$sql = "INSERT INTO masters_creation(masters_status,master_details,effective_from) VALUES (?,?,?)";
		$this->db->query($sql, $userInfo);
		$insert_id = $this->db->insert_id();
		$this->db->trans_complete();
		return $insert_id;
	}

	

	// get Discount Data Info
	public function masters_list()
	{
		$query=$this->db->query("SELECT * from masters_creation");
		$result = $query->result();
		return $result;
	}

	// Get Disocunt edited info
	public function getDiscountInfo($discId)
	{
		$query=$this->db->query("SELECT * from masters_creation where masterId='$discId'");
		$result = $query->result();
		return $result;
	}
	
	public function getmasterinfo()
	{
		$query=$this->db->query("SELECT * from masters_creation");
		$result = $query->result();
		return $result;
	}

	// update edited dicount info
	public function update_masters_details($userInfo, $masterId)
	{
		$this->db->where('masterId', $masterId);
		$this->db->update('masters_creation', $userInfo);
		return TRUE;
	}

	public function getDiscount()
	{
		// $query=$this->db->query("SELECT *,masterId as disId, master_details as discount  from masters_creation where masters_status='Defaul_discount'");
		// $query=$this->db->query("SELECT *,master_id as disId, master_details as discount  from master where master_type='Defaul_discount'");
		$query=$this->db->query("SELECT Distinct master_details as discount from master where master_type='Defaul_discount'");
		$result = $query->result();
		return $result;
	}

	public function master_creation_active()
	{
		$query=$this->db->query("SELECT a.* from masters_creation a, client_creation b where a.client_id = b.client_id and a.status = 'Active'");
		$result = $query->result();
		return $result;
	}

	public function master_creation_dicount_active()
	{
		$query=$this->db->query("SELECT * from masters_creation a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and a.masters_status ='Defaul_discount' and a.status = 'Active' and a.effective_from <= CURDATE()");
		$result = $query->result();
		return $result;
	}

	public function message_type_active()
	{
		$query=$this->db->query("SELECT * from message_type where status = 'Active'");
		$result = $query->result();
		return $result;
	}

	public function sms_authorize_list()
	{
		$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title as branchtitle from sms_authorize a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name");
		$result = $query->result();
		return $result;
	}

	public function checkSmsAuthorizeExist($clientid,$branch,$message_type_id)
	{
		$q=$this->db->query("select * from sms_authorize where client_id = $clientid and branch = '$branch' and message_type_id = $message_type_id");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function getSmsauthorizeDetails($auth_id)
	{
		$query=$this->db->query("SELECT a.*, b.client_name from sms_authorize a, client_creation b where a.client_id = b.client_id and a.auth_id = $auth_id");
		$result = $query->result();
		return $result;
	}

	public function deleteSmsAuthorize($auth_id)
	{
		$this->db->query("delete from sms_authorize where auth_id = $auth_id");
		$total = $this->db->affected_rows();
        if($total>0)
            return true;
        else
            return false;
	}

	public function filter_sms_authorize_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title as branchtitle from sms_authorize a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and a.client_id = ".$clientid);
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.client_name, c.branch_title as branchtitle from sms_authorize a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and a.client_id = $clientid and a.branch = '$branch'");
			$result = $query->result();
			return $result;	
		}
	}

	// public function store_list($clientid)
	// {
	// 	$query=$this->db->query("SELECT a.*, b.client_name from store a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid");
	// 		$result = $query->result();
	// 		return $result;	
	// }

	public function store_list()
	{
		$query=$this->db->query("SELECT a.*, b.client_name from store a, client_creation b where a.client_id = b.client_id");
			$result = $query->result();
			return $result;	
	}

	public function checkStoreExist($clientid,$branch)
	{
		$q=$this->db->query("select * from store where client_id = $clientid and branch = '$branch'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function getStoreDetails($store_id)
	{
		$query=$this->db->query("select * from store where store_id = $store_id");
		$result = $query->result();
		return $result;	
	}

	public function filter_store_list($clientid,$branch)
	{
		if(empty($branch))
		{
			$query=$this->db->query("SELECT * from store a, client_creation b where a.client_id = b.client_id and a.client_id = ".$clientid);
			$result = $query->result();
			return $result;	
		}
		else
		{
			$query=$this->db->query("SELECT * from store a, client_creation b, branch_creation c where a.client_id = b.client_id and a.branch = c.branch_name and a.client_id = $clientid and a.branch = '$branch'");
			$result = $query->result();
			return $result;	
		}
	}

	public function filter_store_action_list($storeid)
	{
		$query=$this->db->query("SELECT a.*, b.name from store_actions a, store b where a.store_id = b.store_id and a.store_id = $storeid");
		$result = $query->result();
		return $result;
	}

	public function platform_list()
	{
		$query=$this->db->query("SELECT * from platform");
		$result = $query->result();
		return $result;	
	}

	public function checkPlatformExist($platform)
	{
		$q=$this->db->query("select * from platform where platform_name = '$platform'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function getPlatformDetails($platform_id)
	{
		$query=$this->db->query("SELECT * from platform where platform_id = '$platform_id'");
		$result = $query->result();
		return $result;	
	}

	public function store_action_list()
	{
		$query=$this->db->query("SELECT * from store_actions a, store b where a.store_id = b.store_id");
		$result = $query->result();
		return $result;
	}

	public function checkStoreActionExist($storeid,$platform)
	{
		$q=$this->db->query("select * from store_actions where platform = '$platform' and store_id = $storeid");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;		
	}

	public function getStoreActionDetails($storeaction_id)
	{
		$query=$this->db->query("select * from store_actions where storeaction_id = $storeaction_id");
		$result = $query->result();
		return $result;	
	}

	public function notification_email_list()
	{
		$query=$this->db->query("SELECT * from store a, notification_emails b where a.store_id = b.store_id");
		$result = $query->result();
		return $result;
	}

	public function filter_notification_email_list($storeid)
	{
		$query=$this->db->query("SELECT b.*, a.name from store a, notification_emails b where a.store_id = b.store_id and b.store_id = $storeid");
		$result = $query->result();
		return $result;
	}

	public function checkNotificationEmailExist($storeid,$email)
	{
		$q=$this->db->query("SELECT * from store a, notification_emails b where a.store_id = b.store_id and b.store_id = $storeid and b.email = '$email'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function notification_phone_list()
	{
		$query=$this->db->query("SELECT * from store a, notification_phones b where a.store_id = b.store_id");
		$result = $query->result();
		return $result;
	}

	public function filter_notification_phone_list($storeid)
	{
		$query=$this->db->query("SELECT b.*, a.name from store a, notification_phones b where a.store_id = b.store_id and b.store_id = $storeid");
		$result = $query->result();
		return $result;
	}

	public function checkNotificationPhoneExist($storeid,$phone)
	{
		$q=$this->db->query("SELECT * from store a, notification_phones b where a.store_id = b.store_id and b.store_id = $storeid and b.phone_no = '$phone'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function zipcode_list()
	{
		$query=$this->db->query("SELECT * from store a, zipcode b where a.store_id = b.store_id");
		$result = $query->result();
		return $result;
	}

	public function filter_zipcode_list($storeid)
	{
		$query=$this->db->query("SELECT b.*, a.name from store a, zipcode b where a.store_id = b.store_id and b.store_id = $storeid");
		$result = $query->result();
		return $result;
	}

	public function checkZipcodeExist($storeid,$zip_code)
	{
		$q=$this->db->query("SELECT * from store a, zipcode b where a.store_id = b.store_id and b.store_id = $storeid and b.zip_code = '$zip_code'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function getNotificationEmailDetails($email_id)
	{
		$query=$this->db->query("SELECT * from store a, notification_emails b where a.store_id = b.store_id and b.email_id = $email_id");
		$result = $query->result();
		return $result;	
	}

	public function getNotificationPhoneDetails($phone_id)
	{
		$query=$this->db->query("SELECT * from store a, notification_phones b where a.store_id = b.store_id and b.phone_id = $phone_id");
		$result = $query->result();
		return $result;	
	}

	public function getZipcodeDetails($zip_id)
	{
		$query=$this->db->query("SELECT * from store a, zipcode b where a.store_id = b.store_id and b.zip_id = $zip_id");
		$result = $query->result();
		return $result;	
	}

	public function checkCategoryExist($clientid,$branch,$cat_name)
	{
		$q=$this->db->query("SELECT a.*, b.* from product_category a, client_creation b where a.client_id = b.client_id and a.client_id = $clientid and a.branch = '$branch' and a.pr_cat_name = '$cat_name'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function checkProductExist($clientid,$branch,$categoryId,$product_name,$social_order)
	{
		$q=$this->db->query("SELECT * from product a, client_creation b, product_category c where a.client_id = b.client_id and a.pr_cat_id = c.pr_cat_id and a.client_id = $clientid and a.branch = '$branch' and a.pr_cat_id = $categoryId and a.product_name = '$product_name' and a.social_order = $social_order");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;		
	}
	
	public function checkMultiProductExist($clientid,$categoryId,$product_name,$social_order)
	{
		$q=$this->db->query("SELECT * from product a, client_creation b, category_master c where a.client_id = b.client_id and a.pr_cat_id = c.category_master_id and a.client_id = $clientid and a.pr_cat_id = $categoryId and a.product_name = '$product_name' and a.social_order = $social_order");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;		
	}

	public function checkOutletExist($client,$branch)
	{
		$q=$this->db->query("SELECT * FROM outlet_deatils a, client_creation b where a.client_id = b.client_id and a.client_id = $client and a.branch = '$branch' ");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;		
	}

	public function checkMasterCreationExist($client_id,$branchname,$master_type,$master_details)
	{
		$q=$this->db->query("SELECT a.* from masters_creation a, client_creation b where a.client_id = b.client_id and a.client_id = $client_id and a.branch = '$branchname' and a.masters_status = '$master_type' and a.master_details = '$master_details'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;
	}

	public function checkApplicationSettingExist($client_id,$branchname)
	{
		$q=$this->db->query("SELECT a.* from application_setting a, client_creation b where a.client_id = b.client_id and a.client_id = $client_id and a.branch = '$branchname'");
		if ($q->num_rows() > 0)
            return true;
        else
            return false;	
	}

	public function getSettingsForBranch($clientid,$branch)
	{
		$query=$this->db->query("SELECT * from setting where setting_id NOT IN (SELECT setting_id from application_setting WHERE client_id = $clientid and branch = '$branch')");
		$result = $query->result();
		return $result;
	}

	public function getModulesForUser($clientid,$roleid)
	{
		$query=$this->db->query("SELECT a.* from modules a, module_groups b where a.module_group_id = b.module_group_id and a.module_master_id NOT IN (SELECT module_master_id from module_creation where client_id = $clientid and role_id = $roleid)");
		$result = $query->result();
		return $result;	
	}

	public function getRoleNameandClientName($clientid,$roleid)
	{
		$query=$this->db->query("SELECT a.role, b.client_name from roles a, client_creation b WHERE a.roleId = $roleid and b.client_id = $clientid");
		$result = $query->result();
		return $result;
	}

	public function getPermissionForUser($clientid,$moduleid,$roleid)
	{
		$query=$this->db->query("SELECT * from permission where permission_master_id NOT IN (SELECT permission_master_id from permission_creation where client_id = $clientid and module_id = $moduleid and role_id = $roleid)");
		$result = $query->result();
		return $result;	
	}

	public function getRoleNameandClientNameandModuleName($clientid,$roleid,$moduleid)
	{
		$query=$this->db->query("SELECT a.role, b.client_name, c.module_name from roles a, client_creation b, modules c WHERE a.roleId = $roleid and b.client_id = $clientid and c.module_master_id = $moduleid");
		$result = $query->result();
		return $result;
	}
	
	public function getModuleCreationForPermissionCreation()
	{
		$query=$this->db->query("SELECT * from module_creation where module_id NOT IN (SELECT module_creation_id from permission_creation)");
		if($query->num_rows() > 0)
		{
		    return $query->result();
		}
		else
		{
		    return null;
		}
	}
	
	public function getModuleCreationForPermission()
	{
	    $query=$this->db->query("SELECT * from module_creation");
		if($query->num_rows() > 0)
		{
		    return $query->result();
		}
		else
		{
		    return null;
		}
	}
	
	public function permissioncreationexist()
	{
	    $query=$this->db->query("SELECT DISTINCT(`permission_master_id`) FROM permission_creation");
		if($query->num_rows() > 0)
		{
		    return $query->result();
		}
		else
		{
		    return null;
		}
	}
	
	public function getTokenGroupByBranch($branch_id)
	{
        $query = $this->db->query("SELECT distinct(tokengroup) from product where branch = '$branch_id'");
    	return $query->result(); 
    }
	
	//Get Social Product info
	public function getSocialOrderProduct($pr_id)
	{
		$query=$this->db->query("SELECT * from product where pr_id='$pr_id'");
		$row = $query->row_array();
        $product_code = $row['product_code'];
        $branch = $row['branch'];
        $client_id = $row['client_id'];
        
        $query=$this->db->query("SELECT pr_id as social_order_pr_id from product where product_code = '$product_code' and client_id = '$client_id' and branch = '$branch' and social_order = '1'");
		if($query->num_rows() > 0)
		{
		    return $query->result();
		}
		else
		{
		    return null;
		}
	}
	public function fillter_splproducts($branch,$category)
	{
		$query=$this->db->query("SELECT * from splproduct S inner join credit_customer C on S.cust_id=C.cust_id where S.branch='$branch' and S.pr_cat_id='$category'");
		$result = $query->result();
		return $result;
	}
	
	// institutional sales product details
	public function get_insti_details1($spl_id,$branch)
	{
		$query=$this->db->query("SELECT * from splproduct where branch='$branch' and spl_id='$spl_id'");
		$result = $query->result();
		return $result;
	}
	
	public function get_special_customer1($branch,$cust_id)
	{
	    $query=$this->db->query("SELECT company_id  as splcust_id,company_name as cust_name FROM Company_details WHERE branch='$branch' and company_id='$cust_id'");
		$result = $query->result();        
		return $result;
		
// 		$query=$this->db->query("SELECT * from special_customer where branch='$branch_title'");
// 		$result = $query->result();
// 		return $result;
	}
		// get special customer details
	public function get_product_details1($pr_id,$branch)
	{
		$query=$this->db->query("SELECT * from product where branch='$branch' and pr_id='$pr_id'");
		$result = $query->result();
		return $result;
	}
		// get spl product details 
	public function get_all_splproducts()
	{
		$query=$this->db->query("SELECT * from splproduct S inner join Company_details C on S.cust_id=C.company_id ");
		$result = $query->result();
		return $result;
	}
	
	// get special customer details
	public function get_special_customer($branch_title)
	{
		$query=$this->db->query("SELECT * from special_customer");
		$result = $query->result();
		return $result;
	}
	
	// get special customer details
	public function get_product_details($pr_id,$branch_title)
	{
		$query=$this->db->query("SELECT * from product where branch='$branch_title' and pr_id='$pr_id'");
		$result = $query->result();
		return $result;
	}
	
	public function login_permission_access($mid)
	{
	    $clientid = $this->session->userdata('client_id');
	    $role_id = $this->session->userdata('role');
	    $branch = $this->session->userdata('branch');
	    $query=$this->db->query("select C.module_id from module_groups  G inner join modules M on G.module_group_id=M.module_group_id inner join module_creation C on M.module_master_id=C.module_master_id where C.module_master_id='$mid' and C.role_id='$role_id' and C.client_id='$clientid'");
		$module_details = $query->result_array();
		foreach ($module_details as $module) {
			$module_id = $module['module_id'];
			$query=$this->db->query("SELECT P.permission_name,PC.permission_master_id,PC.module_creation_id,PC.role_id,PC.client_id,PC.status FROM permission P inner join permission_creation PC on P.permission_master_id=PC.permission_master_id where PC.module_creation_id='$module_id' and PC.status='Active'");
			$result = $query->result();
		}	
		return $result;
	}
	
	public function odc_Products_list($client_id)
	{
	 //    $branch = $this->session->userdata('branch');
		// $query=$this->db->query("SELECT * from product where branch='$branch'");
		if(empty($client_id))
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from splproduct a, branch_creation b, client_creation c where a.branch = b.branch_name");
			$result = $query->result();
			return $result;
		}
		else
		{
			$query=$this->db->query("SELECT a.*, b.branch_title, c.client_name from splproduct a, branch_creation b, client_creation c where a.branch = b.branch_name and b.client_id = c.client_id and b.client_id = $client_id");
			$result = $query->result();
			return $result;	
		}
	}
	
	public function get_product_ids($pr_id)
	{
	    $query=$this->db->query("SELECT * from splproduct  where spl_id ='$pr_id'");
		$result = $query->result();
		return $result;	
	}
	
	public function company_list()
	{
	    $query=$this->db->query("SELECT * FROM Company_details C left join locations L on C.location_id = L.location_id  order by C.company_name asc");
		$result = $query->result();
		return $result;	
	}
	
	public function company_listedit($company_id)
	{
	    $query=$this->db->query("SELECT * FROM Company_details where company_id='$company_id'");
		$result = $query->result();
		return $result;	
	}
	
	public function get_special_customers()
	{
		$query=$this->db->query("SELECT * from Company_details");
		$result = $query->result();
	}
	
	public function get_location()
	{
		$query=$this->db->query("SELECT * FROM locations");
		$result = $query->result();
		return $result;	
	}
	
	public function location_listedit($location_id)
	{
		$query=$this->db->query("SELECT * FROM locations where location_id='$location_id'");
		$result = $query->result();
		return $result;	
	}
	
	
	
}
?>