<?php 
	$header_file=APPPATH.'views/includes/header.php';
	require($header_file); ?>
<style>
.top-header {
    margin-bottom: 10px;
    border-bottom: 2px solid #5d2cb4;
    padding: 7px 0px;
}

.top-bottom {
    margin-top: 10px;
    padding-top: 10px;
    border-top: 2px solid #5d2cb4;
}

.texthidden {
    visibility: hidden;
}

input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
}

/* Firefox */
input[type=number] {
    -moz-appearance: textfield;
}
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css" />
<div class="container-fluid bg-light-opac">
    <div class="row">
        <div class="container my-3 main-container">
            <!-- Top Bar -->
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="content-color-primary page-title"><?php echo $Pagename;?></h2>
                </div>
                <div class="col-auto">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="<?php echo site_url("User_section/Credit_advance_form/105"); ?>">Home</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo $Pagename;?></li>
                        </ol>
                    </nav>
                </div>
            </div>
            <!--- Top Bar completed-->
        </div>
    </div>
</div>
<div class="container mt-4 main-container" ng-app="myApp" ng-controller="mainController">
    <div class="">
        <form name="myForm">
            <div class="card-body">
                <div class="box-body">
                    <div class="row top-header">
                        <div class="col-md-4">
                            <div class="form-group text-center">
                                <input type="text" class="form-control " name="customer_name" id="customer_name" ng-model="customer_name" placeholder="Customer name" required="required">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group text-center">
                                <input type="text"  class="form-control " name="order_qty" id="order_qty" ng-model="order_qty" placeholder="Phone Number" required="required" autocomplete="off">
                                <input type="hidden" min="0" class="form-control " name="order_price" id="order_price" ng-model="order_price" placeholder="Order Price" value="1" required="required" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group text-center">
                                <input type="text" class="form-control" min="15" max="15" name="customer_gst" id="customer_gst" ng-model="customer_gst" placeholder="Customer GST">
                            </div>
                        </div>
                        </div>
                        <div class="row top-header">
                        <div class="col-md-5">
                            <div class="form-group text-center">
                                <select name="categorys" ng-options="json.pr_cat_name for json in category" data-js-select2="" ng-change="getproduct()" ng-model="catsselected"  class="form-control">
                                    <option value="">Category</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group text-center">
                                <select name="items" ng-options="json.product_name for json in products" data-js-select2="" ng-change="getproductdetails()" ng-model="productselected" class="form-control">
                                    <option value="">--Select product--</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <div class="row" ng-repeat="pr in productsdetails | filter:query as res">
                               
                                <div class="col-md-9">
                                    <div class="form-group text-center">
                                        <input type="hidden" class="form-control" id="uom" ng-model="pr.pr_uom" placeholder="UOM" required="required" readonly>
                                        <input type="hidden" class="form-control" id="qty" ng-model="pr.p_quantity" placeholder="QTY" min="1" autocomplete="off">
                                        <input type="hidden" class="form-control" id="price" ng-model="pr.total" placeholder="Price" required="required" readonly>
                                    </div>
                                </div>
                               
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <a ng-click="add_cart(pr)" class="btn btn-primary" style="margin-top: -15px;" />Add</a>
                                    </div>
                                </div>
                            </div>
                            <div class="row" ng-if="!res.length">
                                
                                <div class="col-md-9">
                                    <div class="form-group text-center">
                                        <input type="hidden" class="form-control" id="uom" ng-model="pr.pr_uom" placeholder="UOM" required="required" readonly>
                                        <input type="hidden" class="form-control" id="qty" ng-model="pr.p_quantity" placeholder="QTY" min="1" autocomplete="off">
                                        <input type="hidden" class="form-control" id="price" ng-model="pr.total" placeholder="Price" required="required" readonly>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <a ng-click="add_cart(pr)" class="btn btn-primary" style="margin-top: -15px;"  ng-disabled="pr.p_quantity >=1"/>Add</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <table class="table table-bordered">
                        <thead class="header">
                            <tr>
                                <th>+</th>
                                <th>Item Name</th>
                                <!--<th>Uom</th>-->
                                <!--<th>Price</th>-->
                                <th>Qty</th>
                                <!--<th>Disc(%)</th>-->
                                <th>Price</th>
                                <th>-</th>
                                <th>X</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr ng-repeat="item in carts track by $index">
                                <td class="text-center"> <a ng-click="increase(item)"  class="btn btn-primary">+</a></td>
                                <td>{{item.p_name}} <input type="hidden" name="item_name[]" value="{{item.p_name}}" ng-model="item.p_name" class="form-control hidden" ng-readonly="true"></td>
                                <!--<td>{{item.p_uom}}</td>-->
                                <td class="text-center"><input type="hidden" name="item_basic[]" ng-model="item.p_price"  value="{{item.p_price}}" class="form-control"><input type="text" min="0" name="item_quantity[]"  ng-model="item.p_quantity" value="{{item.p_quantity}}" class="form-control" ng-blur="cursorposition()">
                                
                                    <input type="hidden" name="discount_per[]" min="0" id="discount_per" ng-change="checkdiscount(item)" ng-model="item.p_disc" class="form-control" value="{item.p_disc}">
                                    <input type="hidden" name="cr_per[]" min="0" id="cr_per"  ng-model="item.pcr_disc" class="form-control" value="{item.pcr_disc}">
                                    <input type="hidden" name="p_disc_basic[]" id="p_disc_basic"  ng-model="item.p_disc_basic" value="{{item.p_disc_basic=item.p_disc * (item.p_price*item.p_quantity) / 100 }}">
                               </td>
                               <td>
                                   {{item.p_total=(item.p_price*item.p_quantity) - item.discount_amount }}
                                     <p style="display: none">{{item.p_total=(item.p_price*item.p_quantity) - item.discount_amount | number : 2 || 0}}</p>
                                    <input type="hidden" name="item_total_price[]" id="total"  ng-model="item.p_total" value="{{item.p_total=(item.p_price*item.p_quantity) - item.discount_amount }}" class="form-control" ng-readonly="true">
                                    <p style="display: none">
                                        {{item.p_tax_amts= ((item.p_price*item.p_quantity) - item.p_disc_basic) * item.p_tax_per / 100}}
                                        {{item.p_total=(item.p_price*item.p_quantity) - item.p_disc_basic}}
                                    </p>
                                    <input type="hidden" name="item_id[]" id="item_id" ng-model="item.p_id" value="{{item.p_id}}">
                                    <input type="hidden" name="item_category_id[]" id="cat_id" ng-model="item.p_cat_id" value="{{item.p_cat_id}}">
                                    <input type="hidden" name="item_uom[]" id="uom" ng-model="item.p_uom" value="{{item.p_uom}}">
                                    <input type="hidden" name="item_hsncode[]" id="item_hsncode" ng-model="item.p_hsn" value="{{item.p_hsn}}">
                                    <input type="hidden" name="item_divide_gst[]" id="item_divide_gst"  ng-model="item.p_sgst_amt" value="{{item.p_sgst_amt}}">
                                    <input type="hidden" name="item_productno[]" id="uom" ng-model="item.p_no" value="{{item.p_no}}">
                                    <input type="hidden" name="item_mrp_price[]" ng-model="item.p_prices" class="form-control " value="{{item.p_prices=item.p_mrp}}" ng-readonly="true">
                                    <input type="hidden" name="item_tax_percentage[]" ng-model="item.p_tax_per" value="{{item.p_tax_per}}" class="form-control" ng-readonly="true">
                                    <input type="hidden" name="item_tax_amts[]" ng-model="item.p_tax_amts" value="{{item.p_tax_amts}}" class="form-control">
                                    <input type="hidden" name="item_sgst_tax[]" ng-model="item.p_sgst_tax" value="{{item.p_sgst_tax}}" class="form-control " ng-readonly="true">
                                    <input type="hidden" name="item_sgst_amt[]" ng-model="item.sgst_amt" value="{{item.sgst_amt=item.p_tax_amts / 2}}" class="form-control " ng-readonly="true">
                                </td>
                                <td class="text-center"><a ng-click="remove_cart(item)" class="btn btn-danger">X</a></td>
                                <td class="text-center"> <button ng-disabled="item.p_quantity<=1" ng-click="decrease(item)" class="btn btn-primary">-</button></td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="2" class="text-center"><strong>Total</strong></th>
                                <th><strong>{{totalQty()}}</strong></th>
                                <th><strong>{{cartSum() + cartTax() | number :  0 }}</strong></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                    <br />
                    <div class="row">
                       <div class="col-md-3">
                            <lable>Enter Remarks</lable>
                            <div class="form-group text-center">
                                <input type="text" class="form-control" id="remarks" name="remarks" ng-model="remarks" placeholder="Enter Remarks" required autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-3">
                             <lable>Order Taken By</lable>
                            <div class="form-group text-center">
                                <input type="text" class="form-control" id="order_by" name="order_by" onkeydown="return /[a-z]/i.test(event.key)"  ng-model="order_taken_by" placeholder="Order Taken By" required autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <lable>Delivery Date</lable>
                            <div class="form-group text-center">
                                
                                <input type="text" class="form-control" id="from_date" name="delivery_date" ng-model="delivery_date" placeholder="Delivery date" required autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-3">
                             <lable>Delivery Time</lable>
                            <div class="form-group text-center">
                                <input type="text" class="form-control timepicker" id="delivery_time" name="delivery_time"  ng-model="delivery_time" placeholder="Delivery Time" required autocomplete="off">
                                <input type="hidden" min="0" class="form-control" id="advance_amount" ng-change="advance_change(item)" name="advance_amount" step="0.01"  ng-model="item.advance_amount" placeholder="Advance" ng-disabled="((qtySum() == 0)  || (item.p_quantity.$invalid) || (isDisabled) )">
                                <input type="hidden" class="form-control" value="{{item.balance_amount=((cartSum() + cartTax()) - (item.advance_amount))  | number : 2 }}" />
                                <input type="hidden" class="form-control" ng-model="item.balance_amount" id="balance_amount" value="{{item.balance_amount=((cartSum() + cartTax()) - (item.advance_amount)) }}" readonly>
                                <input type="hidden" class="form-control" name="payment_mode" ng-model="payment_mode" id="payment_mode" value="CREDIT" readonly>
                            </div>
                        </div>
                        <!--<div class="col-md-4">-->
                        <!--     <lable>Payment Type </lable>-->
                        <!--    <div class="form-group text-center">-->
                        <!--        <select name="payment_mode" id="payment_mode" ng-model="payment_mode" ng-disabled="((qtySum() == 0)  || (item.p_quantity.$invalid) || (isDisabled))" required='required'>-->
                        <!--            <option value="">Select Payment Type</option>-->
                        <!--            <option value="NC">NC</option>-->
                        <!--            <option value="CREDIT">CREDIT</option>-->
                        <!--        </select>-->
                                
                                
                        <!--    </div>-->
                        <!--</div>-->
                    </div>
                    <input type="hidden" ng-model="item.basic_amount" id="total_basic_amt" value="{{item.basic_amount=basicsAmt()}}">
                    <input type="hidden" ng-model="item.basic_tax" id="total_tax_amt" value="{{item.basic_tax=cartTax()}}">
                    <input type="hidden" ng-model="item.grand_amount" id="final_bill_amount" value="{{item.grand_amount=cartSum() + cartTax() }}">
                    <input type="hidden" ng-model="item.discountamount" id="item_discount_amount" value="{{item.discountamount=discSum()}}">
                </div>
                <div class="box-footer">
                    <div class="row top-bottom">
                        <div class="col-md-10"> </div>
                        <div class="col-md-2">
                            <div class="form-group text-center">
                                <button type="submit" class="btn  btn-block btn-primary btn-sm" ng-click="insertdata(item); disableButton()" ng-disabled="((qtySum() == 0)  || (item.p_quantity.$invalid) || (isDisabled) )"  ng-click-options="{preventDoubleClick: false}">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>
        </form>
    </div>
</div>
</div>
<?php 
	$footer_file=APPPATH.'views/includes/footer.php';
	require($footer_file); 
?>
<script type="text/javascript">
var app = angular.module('myApp', []);

app.controller('mainController', function($scope, $http) {
    $scope.pageData = {};
    $scope.selIdx = -1;
    $scope.uom = '';
    $scope.qty = 0;
    $scope.price = 0;
    $scope.cust_id = 0;
    $scope.discount = 0;


    $http({
        method: 'get',
        dataType: 'json',
        url: '<?php echo site_url("User_section/get_all_customerdetails");?>'
    }).then(function successCallback(response) {
        $scope.people = response.data;
    });

    $http({
        method: 'get',
        dataType: 'json',
        url: '<?php echo site_url("User_section/get_splproduct_category");?>'
    }).then(function successCallback(response) {
        $scope.category = response.data;
    });

    $scope.gert_discount = function() {
        var discount_per = $scope.discount; // discount percentage
        var basic_amount = $scope.item.basic_amount; // total basic amount
        var total_discount = 0
        total_discount = basic_amount * discount_per / 100; // basic discount amount
        var final_basic_amount = 0;
        final_basic_amount = basic_amount - total_discount; // final basic total
        $scope.discountamount = final_basic_amount;
    }

    // get all products	
    $scope.getproduct = function() {
        //$scope.cust_id = $scope.userselected.splcust_id;
        console.log("called");
        var cat_id = $scope.catsselected.pr_cat_code;
        console.log(cat_id);
        if (cat_id > 0) {
            dataType: 'json',
            $http.get("<?php echo site_url("User_section/get_institutional_products/");?>" + cat_id)
            .then(function successCallback(response) {
                $scope.products = response.data;
            });
        }
    }

    $scope.getproductdetails = function() {
        var pro_id = $scope.productselected.spl_id;
        if (pro_id > 0) {
            dataType: 'json',
            $http.get("<?php echo site_url("User_section/get_allinstitution_productsdetails/");?>" + pro_id)
            .then(function successCallback(response) {
                $scope.productsdetails = response.data;
                console.log($scope.productsdetails);
            });
        }
    }
    
    $scope.checkdiscount = function(item) {
        var discount_percentage = this.item.p_disc;
        var cr_dicounts = this.item.pcr_disc;
        var result = parseFloat(cr_dicounts) + parseFloat(0.1);
        if(result  <=  discount_percentage)
        {
            alert("Please enter valid discount");
            this.item.p_disc = 0;
        }
    }
    
    // advance onchange - 
    $scope.advance_change = function(item) {
         var advance = item.advance_amount; 
         var balance = item.grand_amount; 
         var result = parseFloat(balance) + parseFloat(0.1);
         if(result   <=  advance)
         {
             alert("Please enter less then or equal to balance amount");
             item.advance_amount = '';
         }
    }
    
    

    // Data Insert 
    $scope.insertdata = function(item) {
        var item_name = $('input[name="item_name[]"]').map(function() { return this.value}).get();
        var product_uom = $('input[name="item_uom[]"]').map(function() {return this.value}).get();
        var item_quantity = $('input[name="item_quantity[]"]').map(function() { return this.value}).get();
        var ibase_price = $('input[name="item_basic[]"]').map(function() { return this.value}).get();
        var item_price = $('input[name="item_total_price[]"]').map(function() { return this.value }).get();
        var product_mrp = $('input[name="item_mrp_price[]"]').map(function() { return this.value}).get();
        var tax_percentage = $('input[name="item_tax_percentage[]"]').map(function() {return this.value}).get();
        var item_tax_amt = $('input[name="item_tax_amts[]"]').map(function() {return this.value}).get();
        var devide_tax_perc = $('input[name="item_sgst_tax[]"]').map(function() {return this.value}).get();
        var devide_tax_amount = $('input[name="item_sgst_amt[]"]').map(function() {return this.value }).get();
        var product_hsn = $('input[name="item_hsncode[]"]').map(function() { return this.value}).get();
        var product_code = $('input[name="item_productno[]"]').map(function() { return this.value }).get();
        var gst_divide = $('input[name="item_divide_gst[]"]').map(function() {return this.value }).get();

        var discount_amt = $('input[name="p_disc_basic[]"]').map(function() { return this.value}).get();
        var itmdiscount_per = $('input[name="discount_per[]"]').map(function() { return this.value}).get();
        var product_id = $('input[name="item_id[]"]').map(function() { return this.value}).get();
        var cat_id = $('input[name="item_category_id[]"]').map(function() { return this.value}).get();
        var total_basic = $("input#total_basic_amt").val(); // total basic
        var cart_tax = $("input#total_tax_amt").val(); // sum tax 
        var grand_amount = $("input#final_bill_amount").val(); // Final Sales Amount
        var total_discount = $("input#item_discount_amount").val()
        var remarks = $("input#remarks").val();
        var order_by = $("input#order_by").val();
        var user_id = $("input#customer_ids").val();
        var customername = $("input#customer_name").val();
        var order_qty = $("input#order_qty").val();
        var order_price = $("input#order_price").val();
        var order_type = "corporate";
        var delivery_date = $("input#from_date").val();
        var delivery_time = $("input#delivery_time").val();
        var customer_gst = $("input#customer_gst").val();
        var advance_amount = '0';
        var balance_amount = '0';
        var payment_mode = $("input#payment_mode").val();
        //alert(balance_amount);
        if(customername =='' || order_qty =='' || order_price == '' || payment_mode =='' || delivery_date =='' || delivery_time == '' || remarks =='' || order_by == '')
        {
            alert("Please fill the required fields");
        } else {
        var status = confirm("Click OK to continue?");
        
        if(status == true){
            
                event.preventDefault();
                $http({
                    url: "<?php echo site_url("User_section/corporate_data_insert/");?>",
                    method: 'POST',
                    data: "item_name=" +item_name+"&product_uom="+product_uom+"&item_quantity="+item_quantity+"&ibase_price="+ibase_price +"&item_price="+item_price+"&product_mrp="+product_mrp+"&tax_percentage="+tax_percentage+"&item_tax_amt="+item_tax_amt+"&user_id="+user_id+"&devide_tax_perc="+devide_tax_perc+"&product_hsn="+product_hsn+"&product_code="+product_code+"&gst_divide="+ gst_divide+"&devide_tax_amount="+devide_tax_amount+"&devide_tax_perc="+devide_tax_perc+"&product_id="+product_id+"&cat_id="+cat_id+"&remarks="+remarks+"&order_by="+order_by+"&total_basic="+total_basic+"&cart_tax="+cart_tax+"&grand_amount="+grand_amount+"&total_discount="+total_discount+"&discount_amt="+discount_amt+"&itmdiscount_per="+itmdiscount_per+"&order_type="+order_type+"&delivery_date="+delivery_date+"&delivery_time="+delivery_time+"&advance_amount="+advance_amount+"&balance_amount="+balance_amount+"&payment_mode="+payment_mode+"&customername="+customername+"&order_qty="+order_qty+"&order_price="+order_price+"&customer_gst="+customer_gst,
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    }
                })
                .then(function successCallback(response) {
                    $scope.insert_details = response.data;
                    window.location.href ="<?php echo site_url("User_section/credit_advance_list/106"); ?>";
                });
           
        } else {
             return false; 
        }
        }
    }
    $scope.carts = [];
    $scope.add_cart = function(pr) {
        var existingItem = getExistingCartItem(pr.pro_id);
        if (existingItem == null) {
            $scope.carts.push({
                p_id: pr.pro_id,
                // p_image: product.p_image,
                p_quantity: pr.p_quantity,
                p_name: pr.pro_name,
                p_uom: pr.pr_uom,
                p_hsn: pr.pro_hsn,
                p_no: pr.pro_no,
                p_price: pr.price,
                p_tax_per: pr.pro_tax_per,
                p_tax_amt: pr.pro_tax_amt,
                p_sgst_tax: pr.pro_sgst_tax,
                p_sgst_amt: pr.pro_sgst_amt,
                p_cgst_tax: pr.pro_cgst_tax,
                p_cgst_amt: pr.pro_cgst_amt,
                p_mrp: pr.pro_mrp,
                p_discount: pr.pro_discount,
                p_stock: pr.pro_stcok,
                p_statuc: pr.pro_status,
                p_cat_id: pr.cat_id,
                p_multi_pay: 0,
                p_min: 0,
                p_max: 0.750,
                p_disc: 0,
                pcr_disc: pr.disc,
            });
        } else {
            existingItem.p_quantity++;
            
        }
        $scope.carts.jojo = '';
        $scope.jojo.pro_name = $scope.carts.jojo;
        angular.element("#item_name").focus();
        
    }

    function getExistingCartItem(id) {
        for (var i = 0; i < $scope.carts.length; i++) {
            if ($scope.carts[i].p_id === id) {
                return $scope.carts[i];
            }
        }

        return null;
    }
    $scope.decrease = function(item) {
        $scope.discountamount = 0;
        this.item.p_quantity--;
        if (item.p_quantity === 0) {
            $scope.carts.splice($scope.carts.indexOf(item), 1);
        }

        angular.element("#item_name").focus();
        $scope.discount = "";
        $scope.cartSum();
        $scope.basicsAmt();
        $scope.reset_data();

    }
    
    $scope.totalQty = function () {
    	var qty = 0;
    	$scope.carts.forEach(function (item) {
    		qty += Number(item.p_quantity);
    	});
    	return qty;
    }
    // discount sum
    $scope.discSum = function() {
        var disc = 0;
        $scope.carts.forEach(function(item) {
            disc += item.p_disc_basic;
        });
        return disc;
    }

    // get cart total quantity 
    $scope.qtySum = function() {
        var qty = 0;
        $scope.carts.forEach(function(item) {
            qty += item.p_quantity;
        });
        return qty;
    }
    // Total Basic amount
    $scope.cartSum = function() {
        var sum = 0;
        var discount_per = "";
        discount_per = $scope.discount;
        console.log(discount_per);
        $scope.carts.forEach(function(item) {
            sum += ((item.p_price * item.p_quantity) - item.p_disc_basic)
        });
        return sum;
    }
    $scope.reset_data = function() {
        $scope.item.p_disc_basic = "";
        $scope.item.p_taxable_discount = "0";
        $scope.item.p_discount_tax = 0;
        $scope.item.p_discount_gst = 0;
        $scope.item.discount_per = 0;
    }
    // Total tax amount
    $scope.cartTax = function() {
        var tax = 0;
        $scope.carts.forEach(function(item) {
            tax += item.p_tax_amts;
        });
        return tax;
    }

    $scope.basicsAmt = function() {
        var basic = 0;
        $scope.carts.forEach(function(item) {
            basic += Number(item.p_price * item.p_quantity);
        });
        return basic;
    }


    //Cart Qty increase 
    $scope.increase = function(item) {
        $scope.discountamount = 0;
        this.item.p_quantity++;
        angular.element("#item_name").focus();
        $scope.discount = "";
        $scope.cartSum();
        $scope.basicsAmt();
        $scope.item.p_taxable_discount = "0";

    }

    $scope.cursorposition = function() {
        //console.log("cursor position");
        angular.element("#item_name").focus();

    }
    
    // Cart item Remove
    $scope.remove_cart = function(cart) {
        $scope.discountamount = 0;
        //console.log(cart);
        if (cart) {
            $scope.carts.splice($scope.carts.indexOf(cart), 1);
            $scope.total -= cart.p_price;
        }
        angular.element("#item_name").focus();
        $scope.discount = "";
        $scope.cartSum();
        $scope.basicsAmt();
        $scope.reset_data();
    }
    
});
app.directive('jsSelect2', function($timeout) {
    return {
        link: function(scope, element, attrs) {
            jQuery(element).select2();

            scope.$watch(attrs.ngModel, function() {
                $timeout(function() {
                    element.trigger('change.select2');
                }, 100);
            });

        }
    };
});
</script>
